/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.content.ComponentName;
import android.nfc.NdefMessage;
import android.nfc.OemLogItems;
import android.nfc.Tag;
import android.nfc.cardemulation.ApduServiceInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;
import java.util.ArrayList;
import java.util.List;

public interface INfcOemExtensionCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.nfc.INfcOemExtensionCallback";

    public void onTagConnected(boolean var1) throws RemoteException;

    public void onStateUpdated(int var1) throws RemoteException;

    public void onApplyRouting(ResultReceiver var1) throws RemoteException;

    public void onNdefRead(ResultReceiver var1) throws RemoteException;

    public void onEnable(ResultReceiver var1) throws RemoteException;

    public void onDisable(ResultReceiver var1) throws RemoteException;

    public void onBootStarted() throws RemoteException;

    public void onEnableStarted() throws RemoteException;

    public void onDisableStarted() throws RemoteException;

    public void onBootFinished(int var1) throws RemoteException;

    public void onEnableFinished(int var1) throws RemoteException;

    public void onDisableFinished(int var1) throws RemoteException;

    public void onTagDispatch(ResultReceiver var1) throws RemoteException;

    public void onRoutingChanged(ResultReceiver var1) throws RemoteException;

    public void onHceEventReceived(int var1) throws RemoteException;

    public void onReaderOptionChanged(boolean var1) throws RemoteException;

    public void onCardEmulationActivated(boolean var1) throws RemoteException;

    public void onRfFieldDetected(boolean var1) throws RemoteException;

    public void onRfDiscoveryStarted(boolean var1) throws RemoteException;

    public void onEeListenActivated(boolean var1) throws RemoteException;

    public void onEeUpdated() throws RemoteException;

    public void onGetOemAppSearchIntent(List<String> var1, ResultReceiver var2) throws RemoteException;

    public void onNdefMessage(Tag var1, NdefMessage var2, ResultReceiver var3) throws RemoteException;

    public void onLaunchHceAppChooserActivity(String var1, List<ApduServiceInfo> var2, ComponentName var3, String var4) throws RemoteException;

    public void onLaunchHceTapAgainActivity(ApduServiceInfo var1, String var2) throws RemoteException;

    public void onRoutingTableFull() throws RemoteException;

    public void onLogEventNotified(OemLogItems var1) throws RemoteException;

    public void onExtractOemPackages(NdefMessage var1, ResultReceiver var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INfcOemExtensionCallback {
        static final int TRANSACTION_onTagConnected = 1;
        static final int TRANSACTION_onStateUpdated = 2;
        static final int TRANSACTION_onApplyRouting = 3;
        static final int TRANSACTION_onNdefRead = 4;
        static final int TRANSACTION_onEnable = 5;
        static final int TRANSACTION_onDisable = 6;
        static final int TRANSACTION_onBootStarted = 7;
        static final int TRANSACTION_onEnableStarted = 8;
        static final int TRANSACTION_onDisableStarted = 9;
        static final int TRANSACTION_onBootFinished = 10;
        static final int TRANSACTION_onEnableFinished = 11;
        static final int TRANSACTION_onDisableFinished = 12;
        static final int TRANSACTION_onTagDispatch = 13;
        static final int TRANSACTION_onRoutingChanged = 14;
        static final int TRANSACTION_onHceEventReceived = 15;
        static final int TRANSACTION_onReaderOptionChanged = 16;
        static final int TRANSACTION_onCardEmulationActivated = 17;
        static final int TRANSACTION_onRfFieldDetected = 18;
        static final int TRANSACTION_onRfDiscoveryStarted = 19;
        static final int TRANSACTION_onEeListenActivated = 20;
        static final int TRANSACTION_onEeUpdated = 21;
        static final int TRANSACTION_onGetOemAppSearchIntent = 22;
        static final int TRANSACTION_onNdefMessage = 23;
        static final int TRANSACTION_onLaunchHceAppChooserActivity = 24;
        static final int TRANSACTION_onLaunchHceTapAgainActivity = 25;
        static final int TRANSACTION_onRoutingTableFull = 26;
        static final int TRANSACTION_onLogEventNotified = 27;
        static final int TRANSACTION_onExtractOemPackages = 28;

        public Stub() {
            this.attachInterface(this, INfcOemExtensionCallback.DESCRIPTOR);
        }

        public static INfcOemExtensionCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(INfcOemExtensionCallback.DESCRIPTOR);
            if (iin != null && iin instanceof INfcOemExtensionCallback) {
                return (INfcOemExtensionCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onTagConnected";
                }
                case 2: {
                    return "onStateUpdated";
                }
                case 3: {
                    return "onApplyRouting";
                }
                case 4: {
                    return "onNdefRead";
                }
                case 5: {
                    return "onEnable";
                }
                case 6: {
                    return "onDisable";
                }
                case 7: {
                    return "onBootStarted";
                }
                case 8: {
                    return "onEnableStarted";
                }
                case 9: {
                    return "onDisableStarted";
                }
                case 10: {
                    return "onBootFinished";
                }
                case 11: {
                    return "onEnableFinished";
                }
                case 12: {
                    return "onDisableFinished";
                }
                case 13: {
                    return "onTagDispatch";
                }
                case 14: {
                    return "onRoutingChanged";
                }
                case 15: {
                    return "onHceEventReceived";
                }
                case 16: {
                    return "onReaderOptionChanged";
                }
                case 17: {
                    return "onCardEmulationActivated";
                }
                case 18: {
                    return "onRfFieldDetected";
                }
                case 19: {
                    return "onRfDiscoveryStarted";
                }
                case 20: {
                    return "onEeListenActivated";
                }
                case 21: {
                    return "onEeUpdated";
                }
                case 22: {
                    return "onGetOemAppSearchIntent";
                }
                case 23: {
                    return "onNdefMessage";
                }
                case 24: {
                    return "onLaunchHceAppChooserActivity";
                }
                case 25: {
                    return "onLaunchHceTapAgainActivity";
                }
                case 26: {
                    return "onRoutingTableFull";
                }
                case 27: {
                    return "onLogEventNotified";
                }
                case 28: {
                    return "onExtractOemPackages";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = INfcOemExtensionCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onTagConnected(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onStateUpdated(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    ResultReceiver _arg0 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.onApplyRouting(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    ResultReceiver _arg0 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.onNdefRead(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    ResultReceiver _arg0 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.onEnable(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    ResultReceiver _arg0 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.onDisable(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    this.onBootStarted();
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    this.onEnableStarted();
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    this.onDisableStarted();
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onBootFinished(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onEnableFinished(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onDisableFinished(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    ResultReceiver _arg0 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.onTagDispatch(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    ResultReceiver _arg0 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.onRoutingChanged(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onHceEventReceived(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onReaderOptionChanged(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onCardEmulationActivated(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onRfFieldDetected(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onRfDiscoveryStarted(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onEeListenActivated(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    this.onEeUpdated();
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    ArrayList<String> _arg0 = data.createStringArrayList();
                    ResultReceiver _arg1 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.onGetOemAppSearchIntent(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    Tag _arg0 = data.readTypedObject(Tag.CREATOR);
                    NdefMessage _arg1 = data.readTypedObject(NdefMessage.CREATOR);
                    ResultReceiver _arg2 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.onNdefMessage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    String _arg0 = data.readString();
                    ArrayList<ApduServiceInfo> _arg1 = data.createTypedArrayList(ApduServiceInfo.CREATOR);
                    ComponentName _arg2 = data.readTypedObject(ComponentName.CREATOR);
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.onLaunchHceAppChooserActivity(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    ApduServiceInfo _arg0 = data.readTypedObject(ApduServiceInfo.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.onLaunchHceTapAgainActivity(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    this.onRoutingTableFull();
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    OemLogItems _arg0 = data.readTypedObject(OemLogItems.CREATOR);
                    data.enforceNoDataAvail();
                    this.onLogEventNotified(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    NdefMessage _arg0 = data.readTypedObject(NdefMessage.CREATOR);
                    ResultReceiver _arg1 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.onExtractOemPackages(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 27;
        }

        private static class Proxy
        implements INfcOemExtensionCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return INfcOemExtensionCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTagConnected(boolean connected) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    _data.writeBoolean(connected);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStateUpdated(int state) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    _data.writeInt(state);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onApplyRouting(ResultReceiver isSkipped) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    _data.writeTypedObject(isSkipped, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNdefRead(ResultReceiver isSkipped) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    _data.writeTypedObject(isSkipped, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEnable(ResultReceiver isAllowed) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    _data.writeTypedObject(isAllowed, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisable(ResultReceiver isAllowed) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    _data.writeTypedObject(isAllowed, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBootStarted() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEnableStarted() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisableStarted() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBootFinished(int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    _data.writeInt(status);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEnableFinished(int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    _data.writeInt(status);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisableFinished(int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    _data.writeInt(status);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTagDispatch(ResultReceiver isSkipped) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    _data.writeTypedObject(isSkipped, 0);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRoutingChanged(ResultReceiver isSkipped) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    _data.writeTypedObject(isSkipped, 0);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onHceEventReceived(int action) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    _data.writeInt(action);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReaderOptionChanged(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCardEmulationActivated(boolean isActivated) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    _data.writeBoolean(isActivated);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRfFieldDetected(boolean isActive) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    _data.writeBoolean(isActive);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRfDiscoveryStarted(boolean isDiscoveryStarted) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    _data.writeBoolean(isDiscoveryStarted);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEeListenActivated(boolean isActivated) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    _data.writeBoolean(isActivated);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEeUpdated() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onGetOemAppSearchIntent(List<String> firstPackage, ResultReceiver intentConsumer) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    _data.writeStringList(firstPackage);
                    _data.writeTypedObject(intentConsumer, 0);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNdefMessage(Tag tag, NdefMessage message, ResultReceiver hasOemExecutableContent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    _data.writeTypedObject(tag, 0);
                    _data.writeTypedObject(message, 0);
                    _data.writeTypedObject(hasOemExecutableContent, 0);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLaunchHceAppChooserActivity(String selectedAid, List<ApduServiceInfo> services, ComponentName failedComponent, String category) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    _data.writeString(selectedAid);
                    _data.writeTypedList(services, 0);
                    _data.writeTypedObject(failedComponent, 0);
                    _data.writeString(category);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLaunchHceTapAgainActivity(ApduServiceInfo service, String category) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    _data.writeTypedObject(service, 0);
                    _data.writeString(category);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRoutingTableFull() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLogEventNotified(OemLogItems item) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    _data.writeTypedObject(item, 0);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onExtractOemPackages(NdefMessage message, ResultReceiver packageReceiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INfcOemExtensionCallback.DESCRIPTOR);
                    _data.writeTypedObject(message, 0);
                    _data.writeTypedObject(packageReceiver, 0);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INfcOemExtensionCallback {
        @Override
        public void onTagConnected(boolean connected) throws RemoteException {
        }

        @Override
        public void onStateUpdated(int state) throws RemoteException {
        }

        @Override
        public void onApplyRouting(ResultReceiver isSkipped) throws RemoteException {
        }

        @Override
        public void onNdefRead(ResultReceiver isSkipped) throws RemoteException {
        }

        @Override
        public void onEnable(ResultReceiver isAllowed) throws RemoteException {
        }

        @Override
        public void onDisable(ResultReceiver isAllowed) throws RemoteException {
        }

        @Override
        public void onBootStarted() throws RemoteException {
        }

        @Override
        public void onEnableStarted() throws RemoteException {
        }

        @Override
        public void onDisableStarted() throws RemoteException {
        }

        @Override
        public void onBootFinished(int status) throws RemoteException {
        }

        @Override
        public void onEnableFinished(int status) throws RemoteException {
        }

        @Override
        public void onDisableFinished(int status) throws RemoteException {
        }

        @Override
        public void onTagDispatch(ResultReceiver isSkipped) throws RemoteException {
        }

        @Override
        public void onRoutingChanged(ResultReceiver isSkipped) throws RemoteException {
        }

        @Override
        public void onHceEventReceived(int action) throws RemoteException {
        }

        @Override
        public void onReaderOptionChanged(boolean enabled) throws RemoteException {
        }

        @Override
        public void onCardEmulationActivated(boolean isActivated) throws RemoteException {
        }

        @Override
        public void onRfFieldDetected(boolean isActive) throws RemoteException {
        }

        @Override
        public void onRfDiscoveryStarted(boolean isDiscoveryStarted) throws RemoteException {
        }

        @Override
        public void onEeListenActivated(boolean isActivated) throws RemoteException {
        }

        @Override
        public void onEeUpdated() throws RemoteException {
        }

        @Override
        public void onGetOemAppSearchIntent(List<String> firstPackage, ResultReceiver intentConsumer) throws RemoteException {
        }

        @Override
        public void onNdefMessage(Tag tag, NdefMessage message, ResultReceiver hasOemExecutableContent) throws RemoteException {
        }

        @Override
        public void onLaunchHceAppChooserActivity(String selectedAid, List<ApduServiceInfo> services, ComponentName failedComponent, String category) throws RemoteException {
        }

        @Override
        public void onLaunchHceTapAgainActivity(ApduServiceInfo service, String category) throws RemoteException {
        }

        @Override
        public void onRoutingTableFull() throws RemoteException {
        }

        @Override
        public void onLogEventNotified(OemLogItems item) throws RemoteException {
        }

        @Override
        public void onExtractOemPackages(NdefMessage message, ResultReceiver packageReceiver) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

