/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Intent;
import android.net.Uri;
import android.nfc.FormatException;
import android.nfc.NdefMessage;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.proto.ProtoOutputStream;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public class NdefRecord
implements Parcelable {
    public static final short TNF_EMPTY = 0;
    public static final short TNF_WELL_KNOWN = 1;
    public static final short TNF_MIME_MEDIA = 2;
    public static final short TNF_ABSOLUTE_URI = 3;
    public static final short TNF_EXTERNAL_TYPE = 4;
    public static final short TNF_UNKNOWN = 5;
    public static final short TNF_UNCHANGED = 6;
    public static final short TNF_RESERVED = 7;
    public static final byte[] RTD_TEXT = new byte[]{84};
    public static final byte[] RTD_URI = new byte[]{85};
    public static final byte[] RTD_SMART_POSTER = new byte[]{83, 112};
    public static final byte[] RTD_ALTERNATIVE_CARRIER = new byte[]{97, 99};
    public static final byte[] RTD_HANDOVER_CARRIER = new byte[]{72, 99};
    public static final byte[] RTD_HANDOVER_REQUEST = new byte[]{72, 114};
    public static final byte[] RTD_HANDOVER_SELECT = new byte[]{72, 115};
    public static final byte[] RTD_ANDROID_APP = "android.com:pkg".getBytes();
    private static final byte FLAG_MB = -128;
    private static final byte FLAG_ME = 64;
    private static final byte FLAG_CF = 32;
    private static final byte FLAG_SR = 16;
    private static final byte FLAG_IL = 8;
    private static final String[] URI_PREFIX_MAP = new String[]{"", "http://www.", "https://www.", "http://", "https://", "tel:", "mailto:", "ftp://anonymous:anonymous@", "ftp://ftp.", "ftps://", "sftp://", "smb://", "nfs://", "ftp://", "dav://", "news:", "telnet://", "imap:", "rtsp://", "urn:", "pop:", "sip:", "sips:", "tftp:", "btspp://", "btl2cap://", "btgoep://", "tcpobex://", "irdaobex://", "file://", "urn:epc:id:", "urn:epc:tag:", "urn:epc:pat:", "urn:epc:raw:", "urn:epc:", "urn:nfc:"};
    private static final int MAX_PAYLOAD_SIZE = 0xA00000;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final short mTnf;
    private final byte[] mType;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private final byte[] mId;
    private final byte[] mPayload;
    @NonNull
    public static final Parcelable.Creator<NdefRecord> CREATOR = new Parcelable.Creator<NdefRecord>(){

        @Override
        public NdefRecord createFromParcel(Parcel in) {
            short tnf = (short)in.readInt();
            int typeLength = in.readInt();
            byte[] type = new byte[typeLength];
            in.readByteArray(type);
            int idLength = in.readInt();
            byte[] id2 = new byte[idLength];
            in.readByteArray(id2);
            int payloadLength = in.readInt();
            byte[] payload = new byte[payloadLength];
            in.readByteArray(payload);
            return new NdefRecord(tnf, type, id2, payload);
        }

        public NdefRecord[] newArray(int size) {
            return new NdefRecord[size];
        }
    };

    public static NdefRecord createApplicationRecord(String packageName) {
        if (packageName == null) {
            throw new NullPointerException("packageName is null");
        }
        if (packageName.length() == 0) {
            throw new IllegalArgumentException("packageName is empty");
        }
        return new NdefRecord(4, RTD_ANDROID_APP, null, packageName.getBytes(StandardCharsets.UTF_8));
    }

    public static NdefRecord createUri(Uri uri) {
        if (uri == null) {
            throw new NullPointerException("uri is null");
        }
        String uriString = (uri = uri.normalizeScheme()).toString();
        if (uriString.length() == 0) {
            throw new IllegalArgumentException("uri is empty");
        }
        byte prefix = 0;
        for (int i = 1; i < URI_PREFIX_MAP.length; ++i) {
            if (!uriString.startsWith(URI_PREFIX_MAP[i])) continue;
            prefix = (byte)i;
            uriString = uriString.substring(URI_PREFIX_MAP[i].length());
            break;
        }
        byte[] uriBytes = uriString.getBytes(StandardCharsets.UTF_8);
        byte[] recordBytes = new byte[uriBytes.length + 1];
        recordBytes[0] = prefix;
        System.arraycopy(uriBytes, 0, recordBytes, 1, uriBytes.length);
        return new NdefRecord(1, RTD_URI, null, recordBytes);
    }

    public static NdefRecord createUri(String uriString) {
        return NdefRecord.createUri(Uri.parse(uriString));
    }

    public static NdefRecord createMime(String mimeType, byte[] mimeData) {
        if (mimeType == null) {
            throw new NullPointerException("mimeType is null");
        }
        if ((mimeType = Intent.normalizeMimeType(mimeType)).length() == 0) {
            throw new IllegalArgumentException("mimeType is empty");
        }
        int slashIndex = mimeType.indexOf(47);
        if (slashIndex == 0) {
            throw new IllegalArgumentException("mimeType must have major type");
        }
        if (slashIndex == mimeType.length() - 1) {
            throw new IllegalArgumentException("mimeType must have minor type");
        }
        byte[] typeBytes = mimeType.getBytes(StandardCharsets.US_ASCII);
        return new NdefRecord(2, typeBytes, null, mimeData);
    }

    public static NdefRecord createExternal(String domain, String type, byte[] data) {
        if (domain == null) {
            throw new NullPointerException("domain is null");
        }
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        domain = domain.trim().toLowerCase(Locale.ROOT);
        type = type.trim().toLowerCase(Locale.ROOT);
        if (domain.length() == 0) {
            throw new IllegalArgumentException("domain is empty");
        }
        if (type.length() == 0) {
            throw new IllegalArgumentException("type is empty");
        }
        byte[] byteDomain = domain.getBytes(StandardCharsets.UTF_8);
        byte[] byteType = type.getBytes(StandardCharsets.UTF_8);
        byte[] b = new byte[byteDomain.length + 1 + byteType.length];
        System.arraycopy(byteDomain, 0, b, 0, byteDomain.length);
        b[byteDomain.length] = 58;
        System.arraycopy(byteType, 0, b, byteDomain.length + 1, byteType.length);
        return new NdefRecord(4, b, null, data);
    }

    public static NdefRecord createTextRecord(String languageCode, String text) {
        if (text == null) {
            throw new NullPointerException("text is null");
        }
        byte[] textBytes = text.getBytes(StandardCharsets.UTF_8);
        byte[] languageCodeBytes = null;
        languageCodeBytes = languageCode != null && !languageCode.isEmpty() ? languageCode.getBytes(StandardCharsets.US_ASCII) : AndroidLocale.getDefault().getLanguage().getBytes(StandardCharsets.US_ASCII);
        if (languageCodeBytes.length >= 64) {
            throw new IllegalArgumentException("language code is too long, must be <64 bytes.");
        }
        ByteBuffer buffer = ByteBuffer.allocate(1 + languageCodeBytes.length + textBytes.length);
        byte status = (byte)(languageCodeBytes.length & 0xFF);
        buffer.put(status);
        buffer.put(languageCodeBytes);
        buffer.put(textBytes);
        return new NdefRecord(1, RTD_TEXT, null, buffer.array());
    }

    public NdefRecord(short tnf, byte[] type, byte[] id2, byte[] payload) {
        String message;
        if (type == null) {
            type = EMPTY_BYTE_ARRAY;
        }
        if (id2 == null) {
            id2 = EMPTY_BYTE_ARRAY;
        }
        if (payload == null) {
            payload = EMPTY_BYTE_ARRAY;
        }
        if ((message = NdefRecord.validateTnf(tnf, type, id2, payload)) != null) {
            throw new IllegalArgumentException(message);
        }
        this.mTnf = tnf;
        this.mType = type;
        this.mId = id2;
        this.mPayload = payload;
    }

    @Deprecated
    public NdefRecord(byte[] data) throws FormatException {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        NdefRecord[] rs = NdefRecord.parse(buffer, true);
        if (buffer.remaining() > 0) {
            throw new FormatException("data too long");
        }
        this.mTnf = rs[0].mTnf;
        this.mType = rs[0].mType;
        this.mId = rs[0].mId;
        this.mPayload = rs[0].mPayload;
    }

    public short getTnf() {
        return this.mTnf;
    }

    public byte[] getType() {
        return (byte[])this.mType.clone();
    }

    public byte[] getId() {
        return (byte[])this.mId.clone();
    }

    public byte[] getPayload() {
        return (byte[])this.mPayload.clone();
    }

    @Deprecated
    public byte[] toByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(this.getByteLength());
        this.writeToByteBuffer(buffer, true, true);
        return buffer.array();
    }

    public String toMimeType() {
        switch (this.mTnf) {
            case 1: {
                if (!Arrays.equals(this.mType, RTD_TEXT)) break;
                return "text/plain";
            }
            case 2: {
                String mimeType = new String(this.mType, StandardCharsets.US_ASCII);
                return Intent.normalizeMimeType(mimeType);
            }
        }
        return null;
    }

    public Uri toUri() {
        return this.toUri(false);
    }

    private Uri toUri(boolean inSmartPoster) {
        switch (this.mTnf) {
            case 1: {
                if (Arrays.equals(this.mType, RTD_SMART_POSTER) && !inSmartPoster) {
                    try {
                        NdefMessage nestedMessage = new NdefMessage(this.mPayload);
                        for (NdefRecord nestedRecord : nestedMessage.getRecords()) {
                            Uri uri = nestedRecord.toUri(true);
                            if (uri == null) continue;
                            return uri;
                        }
                        break;
                    }
                    catch (FormatException nestedMessage) {
                        break;
                    }
                }
                if (!Arrays.equals(this.mType, RTD_URI)) break;
                Uri wktUri = this.parseWktUri();
                return wktUri != null ? wktUri.normalizeScheme() : null;
            }
            case 3: {
                Uri uri = Uri.parse(new String(this.mType, StandardCharsets.UTF_8));
                return uri.normalizeScheme();
            }
            case 4: {
                if (inSmartPoster) break;
                return Uri.parse("vnd.android.nfc://ext/" + new String(this.mType, StandardCharsets.US_ASCII));
            }
        }
        return null;
    }

    private Uri parseWktUri() {
        if (this.mPayload.length < 2) {
            return null;
        }
        int prefixIndex = this.mPayload[0] & 0xFFFFFFFF;
        if (prefixIndex < 0 || prefixIndex >= URI_PREFIX_MAP.length) {
            return null;
        }
        String prefix = URI_PREFIX_MAP[prefixIndex];
        String suffix = new String(Arrays.copyOfRange(this.mPayload, 1, this.mPayload.length), StandardCharsets.UTF_8);
        return Uri.parse(prefix + suffix);
    }

    static NdefRecord[] parse(ByteBuffer buffer, boolean ignoreMbMe) throws FormatException {
        ArrayList<NdefRecord> records = new ArrayList<NdefRecord>();
        try {
            byte[] type = null;
            byte[] id2 = null;
            byte[] payload = null;
            ArrayList<byte[]> chunks = new ArrayList<byte[]>();
            boolean inChunk = false;
            int chunkTnf = -1;
            boolean me = false;
            while (!me) {
                int idLength;
                byte flag = buffer.get();
                boolean mb = (flag & 0xFFFFFF80) != 0;
                me = (flag & 0x40) != 0;
                boolean cf = (flag & 0x20) != 0;
                boolean sr = (flag & 0x10) != 0;
                boolean il = (flag & 8) != 0;
                int tnf = flag & 7;
                if (!(mb || records.size() != 0 || inChunk || ignoreMbMe)) {
                    throw new FormatException("expected MB flag");
                }
                if (mb && (records.size() != 0 || inChunk) && !ignoreMbMe) {
                    throw new FormatException("unexpected MB flag");
                }
                if (inChunk && il) {
                    throw new FormatException("unexpected IL flag in non-leading chunk");
                }
                if (cf && me) {
                    throw new FormatException("unexpected ME flag in non-trailing chunk");
                }
                if (inChunk && tnf != 6) {
                    throw new FormatException("expected TNF_UNCHANGED in non-leading chunk");
                }
                if (!inChunk && tnf == 6) {
                    throw new FormatException("unexpected TNF_UNCHANGED in first chunk or unchunked record");
                }
                int typeLength = buffer.get() & 0xFF;
                long payloadLength = sr ? (long)(buffer.get() & 0xFF) : (long)buffer.getInt() & 0xFFFFFFFFL;
                int n = idLength = il ? buffer.get() & 0xFF : 0;
                if (inChunk && typeLength != 0) {
                    throw new FormatException("expected zero-length type in non-leading chunk");
                }
                if (!inChunk) {
                    type = typeLength > 0 ? new byte[typeLength] : EMPTY_BYTE_ARRAY;
                    id2 = idLength > 0 ? new byte[idLength] : EMPTY_BYTE_ARRAY;
                    buffer.get(type);
                    buffer.get(id2);
                }
                NdefRecord.ensureSanePayloadSize(payloadLength);
                payload = payloadLength > 0L ? new byte[(int)payloadLength] : EMPTY_BYTE_ARRAY;
                buffer.get(payload);
                if (cf && !inChunk) {
                    if (typeLength == 0 && tnf != 5) {
                        throw new FormatException("expected non-zero type length in first chunk");
                    }
                    chunks.clear();
                    chunkTnf = tnf;
                }
                if (cf || inChunk) {
                    chunks.add(payload);
                }
                if (!cf && inChunk) {
                    payloadLength = 0L;
                    for (byte[] p : chunks) {
                        payloadLength += (long)p.length;
                    }
                    NdefRecord.ensureSanePayloadSize(payloadLength);
                    payload = new byte[(int)payloadLength];
                    int i = 0;
                    for (byte[] p : chunks) {
                        System.arraycopy(p, 0, payload, i, p.length);
                        i += p.length;
                    }
                    tnf = chunkTnf;
                }
                if (cf) {
                    inChunk = true;
                    continue;
                }
                inChunk = false;
                String error = NdefRecord.validateTnf((short)tnf, type, id2, payload);
                if (error != null) {
                    throw new FormatException(error);
                }
                records.add(new NdefRecord((short)tnf, type, id2, payload));
                if (!ignoreMbMe) continue;
                break;
            }
        }
        catch (BufferUnderflowException e) {
            throw new FormatException("expected more data", e);
        }
        return records.toArray(new NdefRecord[records.size()]);
    }

    private static void ensureSanePayloadSize(long size) throws FormatException {
        if (size > 0xA00000L) {
            throw new FormatException("payload above max limit: " + size + " > " + 0xA00000);
        }
    }

    static String validateTnf(short tnf, byte[] type, byte[] id2, byte[] payload) {
        switch (tnf) {
            case 0: {
                if (type.length != 0 || id2.length != 0 || payload.length != 0) {
                    return "unexpected data in TNF_EMPTY record";
                }
                return null;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return null;
            }
            case 5: 
            case 7: {
                if (type.length != 0) {
                    return "unexpected type field in TNF_UNKNOWN or TNF_RESERVEd record";
                }
                return null;
            }
            case 6: {
                return "unexpected TNF_UNCHANGED in first chunk or logical record";
            }
        }
        return String.format("unexpected tnf value=0x%02x", tnf);
    }

    void writeToByteBuffer(ByteBuffer buffer, boolean mb, boolean me) {
        boolean sr;
        boolean bl = sr = this.mPayload.length < 256;
        boolean il = this.mTnf == 0 ? true : this.mId.length > 0;
        byte flags = (byte)((mb ? -128 : 0) | (me ? 64 : 0) | (sr ? 16 : 0) | (il ? 8 : 0) | this.mTnf);
        buffer.put(flags);
        buffer.put((byte)this.mType.length);
        if (sr) {
            buffer.put((byte)this.mPayload.length);
        } else {
            buffer.putInt(this.mPayload.length);
        }
        if (il) {
            buffer.put((byte)this.mId.length);
        }
        buffer.put(this.mType);
        buffer.put(this.mId);
        buffer.put(this.mPayload);
    }

    int getByteLength() {
        boolean il;
        boolean sr;
        int length = 3 + this.mType.length + this.mId.length + this.mPayload.length;
        boolean bl = sr = this.mPayload.length < 256;
        boolean bl2 = this.mTnf == 0 ? true : (il = this.mId.length > 0);
        if (!sr) {
            length += 3;
        }
        if (il) {
            ++length;
        }
        return length;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mTnf);
        dest.writeInt(this.mType.length);
        dest.writeByteArray(this.mType);
        dest.writeInt(this.mId.length);
        dest.writeByteArray(this.mId);
        dest.writeInt(this.mPayload.length);
        dest.writeByteArray(this.mPayload);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.mId);
        result = 31 * result + Arrays.hashCode(this.mPayload);
        result = 31 * result + this.mTnf;
        result = 31 * result + Arrays.hashCode(this.mType);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NdefRecord other = (NdefRecord)obj;
        if (!Arrays.equals(this.mId, other.mId)) {
            return false;
        }
        if (!Arrays.equals(this.mPayload, other.mPayload)) {
            return false;
        }
        if (this.mTnf != other.mTnf) {
            return false;
        }
        return Arrays.equals(this.mType, other.mType);
    }

    public String toString() {
        StringBuilder b = new StringBuilder(String.format("NdefRecord tnf=%X", this.mTnf));
        if (this.mType.length > 0) {
            b.append(" type=").append((CharSequence)NdefRecord.bytesToString(this.mType));
        }
        if (this.mId.length > 0) {
            b.append(" id=").append((CharSequence)NdefRecord.bytesToString(this.mId));
        }
        if (this.mPayload.length > 0) {
            b.append(" payload=").append((CharSequence)NdefRecord.bytesToString(this.mPayload));
        }
        return b.toString();
    }

    public void dumpDebug(ProtoOutputStream proto) {
        proto.write(0x10C00000001L, this.mType);
        proto.write(1151051235330L, this.mId);
        proto.write(1120986464259L, this.mPayload.length);
    }

    private static StringBuilder bytesToString(byte[] bs) {
        StringBuilder s = new StringBuilder();
        for (byte b : bs) {
            s.append(String.format("%02X", b));
        }
        return s;
    }
}

