/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.cardemulation;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.nfc.Flags;
import android.nfc.cardemulation.AidGroup;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import android.util.proto.ProtoOutputStream;
import com.android.internal.R;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.xmlpull.v1.XmlPullParserException;

@SystemApi
@FlaggedApi(value="android.nfc.enable_nfc_mainline")
public class ApduServiceInfo
implements Parcelable {
    private static final String TAG = "ApduServiceInfo";
    private static final Pattern PLPF_PATTERN = Pattern.compile("[0-9A-Fa-f]{2,}[0-9A-Fa-f,\\?,\\*\\.]*");
    private static final Pattern PLF_PATTERN = Pattern.compile("[0-9A-Fa-f]{2,}");
    @SystemApi
    @FlaggedApi(value="android.permission.flags.wallet_role_icon_property_enabled")
    public static final String PROPERTY_WALLET_PREFERRED_BANNER_AND_LABEL = "android.nfc.cardemulation.PROPERTY_WALLET_PREFERRED_BANNER_AND_LABEL";
    private final ResolveInfo mService;
    private final String mDescription;
    private final boolean mOnHost;
    private String mOffHostName;
    private final String mStaticOffHostName;
    private final HashMap<String, AidGroup> mStaticAidGroups;
    private final HashMap<String, AidGroup> mDynamicAidGroups;
    private final Map<String, Boolean> mAutoTransact;
    private final Map<Pattern, Boolean> mAutoTransactPatterns;
    private final boolean mRequiresDeviceUnlock;
    private final boolean mRequiresDeviceScreenOn;
    private final int mBannerResourceId;
    private final int mUid;
    private final String mSettingsActivityName;
    private boolean mCategoryOtherServiceEnabled;
    private boolean mShouldDefaultToObserveMode;
    private boolean mWantsRoleHolderPriority;
    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @NonNull
    public static final Parcelable.Creator<ApduServiceInfo> CREATOR = new Parcelable.Creator<ApduServiceInfo>(){

        @Override
        public ApduServiceInfo createFromParcel(Parcel source) {
            ResolveInfo info = ResolveInfo.CREATOR.createFromParcel(source);
            String description = source.readString();
            boolean onHost = source.readInt() != 0;
            String offHostName = source.readString();
            String staticOffHostName = source.readString();
            ArrayList<AidGroup> staticAidGroups = new ArrayList<AidGroup>();
            int numStaticGroups = source.readInt();
            if (numStaticGroups > 0) {
                source.readTypedList(staticAidGroups, AidGroup.CREATOR);
            }
            ArrayList<AidGroup> dynamicAidGroups = new ArrayList<AidGroup>();
            int numDynamicGroups = source.readInt();
            if (numDynamicGroups > 0) {
                source.readTypedList(dynamicAidGroups, AidGroup.CREATOR);
            }
            boolean requiresUnlock = source.readInt() != 0;
            boolean requiresScreenOn = source.readInt() != 0;
            int bannerResource = source.readInt();
            int uid = source.readInt();
            String settingsActivityName = source.readString();
            boolean isEnabled = source.readInt() != 0;
            int autoTransactSize = source.readInt();
            HashMap<String, Boolean> autoTransact = new HashMap<String, Boolean>(autoTransactSize);
            source.readMap(autoTransact, this.getClass().getClassLoader(), String.class, Boolean.class);
            int autoTransactPatternSize = source.readInt();
            HashMap<Pattern, Boolean> autoTransactPatterns = new HashMap<Pattern, Boolean>(autoTransactSize);
            source.readMap(autoTransactPatterns, this.getClass().getClassLoader(), Pattern.class, Boolean.class);
            return new ApduServiceInfo(info, onHost, description, staticAidGroups, dynamicAidGroups, requiresUnlock, requiresScreenOn, bannerResource, uid, settingsActivityName, offHostName, staticOffHostName, isEnabled, autoTransact, autoTransactPatterns);
        }

        public ApduServiceInfo[] newArray(int size) {
            return new ApduServiceInfo[size];
        }
    };
    private static final Pattern AID_PATTERN = Pattern.compile("[0-9A-Fa-f]{10,32}\\*?\\#?");

    @SystemApi
    @UnsupportedAppUsage
    @FlaggedApi(value="android.nfc.nfc_apdu_service_info_constructor")
    public ApduServiceInfo(@NonNull ResolveInfo info, boolean onHost, @NonNull String description, @NonNull List<AidGroup> staticAidGroups, @NonNull List<AidGroup> dynamicAidGroups, boolean requiresUnlock, int bannerResource, int uid, @NonNull String settingsActivityName, @NonNull String offHost, @NonNull String staticOffHost) {
        this(info, onHost, description, staticAidGroups, dynamicAidGroups, requiresUnlock, bannerResource, uid, settingsActivityName, offHost, staticOffHost, false);
    }

    public ApduServiceInfo(ResolveInfo info, boolean onHost, String description, List<AidGroup> staticAidGroups, List<AidGroup> dynamicAidGroups, boolean requiresUnlock, int bannerResource, int uid, String settingsActivityName, String offHost, String staticOffHost, boolean isEnabled) {
        this(info, onHost, description, staticAidGroups, dynamicAidGroups, requiresUnlock, onHost, bannerResource, uid, settingsActivityName, offHost, staticOffHost, isEnabled);
    }

    public ApduServiceInfo(ResolveInfo info, boolean onHost, String description, List<AidGroup> staticAidGroups, List<AidGroup> dynamicAidGroups, boolean requiresUnlock, boolean requiresScreenOn, int bannerResource, int uid, String settingsActivityName, String offHost, String staticOffHost, boolean isEnabled) {
        this(info, onHost, description, staticAidGroups, dynamicAidGroups, requiresUnlock, requiresScreenOn, bannerResource, uid, settingsActivityName, offHost, staticOffHost, isEnabled, new HashMap<String, Boolean>(), new TreeMap<Pattern, Boolean>(Comparator.comparing(Object::toString)));
    }

    public ApduServiceInfo(ResolveInfo info, boolean onHost, String description, List<AidGroup> staticAidGroups, List<AidGroup> dynamicAidGroups, boolean requiresUnlock, boolean requiresScreenOn, int bannerResource, int uid, String settingsActivityName, String offHost, String staticOffHost, boolean isEnabled, Map<String, Boolean> autoTransact, Map<Pattern, Boolean> autoTransactPatterns) {
        this.mService = info;
        this.mDescription = description;
        this.mStaticAidGroups = new HashMap();
        this.mDynamicAidGroups = new HashMap();
        this.mAutoTransact = autoTransact;
        this.mAutoTransactPatterns = autoTransactPatterns;
        this.mOffHostName = offHost;
        this.mStaticOffHostName = staticOffHost;
        this.mOnHost = onHost;
        this.mRequiresDeviceUnlock = requiresUnlock;
        this.mRequiresDeviceScreenOn = requiresScreenOn;
        for (AidGroup aidGroup : staticAidGroups) {
            this.mStaticAidGroups.put(aidGroup.getCategory(), aidGroup);
        }
        for (AidGroup aidGroup : dynamicAidGroups) {
            this.mDynamicAidGroups.put(aidGroup.getCategory(), aidGroup);
        }
        this.mBannerResourceId = bannerResource;
        this.mUid = uid;
        this.mSettingsActivityName = settingsActivityName;
        this.mCategoryOtherServiceEnabled = isEnabled;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public ApduServiceInfo(@NonNull PackageManager pm, @NonNull ResolveInfo info, boolean onHost) throws XmlPullParserException, IOException {
        ServiceInfo si = info.serviceInfo;
        try (XmlResourceParser parser = null;){
            TypedArray sa;
            if (onHost) {
                parser = si.loadXmlMetaData(pm, "android.nfc.cardemulation.host_apdu_service");
                if (parser == null) {
                    throw new XmlPullParserException("No android.nfc.cardemulation.host_apdu_service meta-data");
                }
            } else {
                parser = si.loadXmlMetaData(pm, "android.nfc.cardemulation.off_host_apdu_service");
                if (parser == null) {
                    throw new XmlPullParserException("No android.nfc.cardemulation.off_host_apdu_service meta-data");
                }
            }
            int eventType = parser.getEventType();
            while (eventType != 2 && eventType != 1) {
                eventType = parser.next();
            }
            String tagName = parser.getName();
            if (onHost && !"host-apdu-service".equals(tagName)) {
                throw new XmlPullParserException("Meta-data does not start with <host-apdu-service> tag");
            }
            if (!onHost && !"offhost-apdu-service".equals(tagName)) {
                throw new XmlPullParserException("Meta-data does not start with <offhost-apdu-service> tag");
            }
            Resources res = pm.getResourcesForApplication(si.applicationInfo);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            if (onHost) {
                sa = res.obtainAttributes(attrs, R.styleable.HostApduService);
                this.mService = info;
                this.mDescription = sa.getString(0);
                this.mRequiresDeviceUnlock = sa.getBoolean(2, false);
                this.mRequiresDeviceScreenOn = sa.getBoolean(4, true);
                this.mBannerResourceId = sa.getResourceId(3, -1);
                this.mSettingsActivityName = sa.getString(1);
                this.mStaticOffHostName = this.mOffHostName = null;
                this.mShouldDefaultToObserveMode = sa.getBoolean(5, false);
                if (Flags.nfcAssociatedRoleServices()) {
                    this.mWantsRoleHolderPriority = sa.getBoolean(6, false);
                }
                sa.recycle();
            } else {
                sa = res.obtainAttributes(attrs, R.styleable.OffHostApduService);
                this.mService = info;
                this.mDescription = sa.getString(0);
                this.mRequiresDeviceUnlock = sa.getBoolean(2, false);
                this.mRequiresDeviceScreenOn = sa.getBoolean(5, false);
                this.mBannerResourceId = sa.getResourceId(3, -1);
                this.mSettingsActivityName = sa.getString(1);
                this.mOffHostName = sa.getString(4);
                this.mShouldDefaultToObserveMode = sa.getBoolean(6, false);
                if (this.mOffHostName != null) {
                    if (this.mOffHostName.equals("eSE")) {
                        this.mOffHostName = "eSE1";
                    } else if (this.mOffHostName.equals("SIM")) {
                        this.mOffHostName = "SIM1";
                    }
                }
                this.mStaticOffHostName = this.mOffHostName;
                if (Flags.nfcAssociatedRoleServices()) {
                    this.mWantsRoleHolderPriority = sa.getBoolean(7, false);
                }
                sa.recycle();
            }
            this.mStaticAidGroups = new HashMap();
            this.mDynamicAidGroups = new HashMap();
            this.mAutoTransact = new HashMap<String, Boolean>();
            this.mAutoTransactPatterns = new TreeMap<Pattern, Boolean>(Comparator.comparing(Object::toString));
            this.mOnHost = onHost;
            int depth = parser.getDepth();
            AidGroup currentGroup = null;
            while (((eventType = parser.next()) != 3 || parser.getDepth() > depth) && eventType != 1) {
                boolean isValidFilter;
                String plf;
                String aid;
                TypedArray a;
                tagName = parser.getName();
                if (eventType == 2 && "aid-group".equals(tagName) && currentGroup == null) {
                    TypedArray groupAttrs = res.obtainAttributes(attrs, R.styleable.AidGroup);
                    String groupCategory = groupAttrs.getString(1);
                    String groupDescription = groupAttrs.getString(0);
                    if (!"payment".equals(groupCategory)) {
                        groupCategory = "other";
                    }
                    if ((currentGroup = this.mStaticAidGroups.get(groupCategory)) != null) {
                        if (!"other".equals(groupCategory)) {
                            Log.e(TAG, "Not allowing multiple aid-groups in the " + groupCategory + " category");
                            currentGroup = null;
                        }
                    } else {
                        currentGroup = new AidGroup(groupCategory, groupDescription);
                    }
                    groupAttrs.recycle();
                    continue;
                }
                if (eventType == 3 && "aid-group".equals(tagName) && currentGroup != null) {
                    if (currentGroup.getAids().size() > 0) {
                        if (!this.mStaticAidGroups.containsKey(currentGroup.getCategory())) {
                            this.mStaticAidGroups.put(currentGroup.getCategory(), currentGroup);
                        }
                    } else {
                        Log.e(TAG, "Not adding <aid-group> with empty or invalid AIDs");
                    }
                    currentGroup = null;
                    continue;
                }
                if (eventType == 2 && "aid-filter".equals(tagName) && currentGroup != null) {
                    a = res.obtainAttributes(attrs, R.styleable.AidFilter);
                    aid = a.getString(0).toUpperCase();
                    if (ApduServiceInfo.isValidAid(aid) && !currentGroup.getAids().contains(aid)) {
                        currentGroup.getAids().add(aid);
                    } else {
                        Log.e(TAG, "Ignoring invalid or duplicate aid: " + aid);
                    }
                    a.recycle();
                    continue;
                }
                if (eventType == 2 && "aid-prefix-filter".equals(tagName) && currentGroup != null) {
                    a = res.obtainAttributes(attrs, R.styleable.AidFilter);
                    aid = a.getString(0).toUpperCase();
                    if (ApduServiceInfo.isValidAid(aid = aid.concat("*")) && !currentGroup.getAids().contains(aid)) {
                        currentGroup.getAids().add(aid);
                    } else {
                        Log.e(TAG, "Ignoring invalid or duplicate aid: " + aid);
                    }
                    a.recycle();
                    continue;
                }
                if (eventType == 2 && tagName.equals("aid-suffix-filter") && currentGroup != null) {
                    a = res.obtainAttributes(attrs, R.styleable.AidFilter);
                    aid = a.getString(0).toUpperCase();
                    if (ApduServiceInfo.isValidAid(aid = aid.concat("#")) && !currentGroup.getAids().contains(aid)) {
                        currentGroup.getAids().add(aid);
                    } else {
                        Log.e(TAG, "Ignoring invalid or duplicate aid: " + aid);
                    }
                    a.recycle();
                    continue;
                }
                if (eventType == 2 && "polling-loop-filter".equals(tagName) && currentGroup == null) {
                    a = res.obtainAttributes(attrs, R.styleable.PollingLoopFilter);
                    plf = a.getString(0).toUpperCase(Locale.ROOT);
                    boolean autoTransact = a.getBoolean(1, false);
                    boolean bl = isValidFilter = PLF_PATTERN.matcher(plf).matches() && plf.length() % 2 == 0;
                    if (!isValidFilter) {
                        Log.e(TAG, "Ignoring polling-loop-filter " + plf + " it is not a valid filter");
                    } else if (!this.mOnHost && !autoTransact) {
                        Log.e(TAG, "Ignoring polling-loop-filter " + plf + " for offhost service that isn't autoTransact");
                    } else {
                        this.mAutoTransact.put(plf, autoTransact);
                    }
                    a.recycle();
                    continue;
                }
                if (eventType != 2 || !"polling-loop-pattern-filter".equals(tagName) || currentGroup != null) continue;
                a = res.obtainAttributes(attrs, R.styleable.PollingLoopPatternFilter);
                plf = a.getString(0).toUpperCase(Locale.ROOT);
                boolean autoTransact = a.getBoolean(1, false);
                isValidFilter = PLPF_PATTERN.matcher(plf).matches();
                if (!isValidFilter) {
                    Log.e(TAG, "Ignoring polling-loop-pattern-filter " + plf + " it is not a valid pattern filter");
                } else if (!this.mOnHost && !autoTransact) {
                    Log.e(TAG, "Ignoring polling-loop-pattern-filter " + plf + " for offhost service that isn't autoTransact");
                } else {
                    this.mAutoTransactPatterns.put(Pattern.compile(plf), autoTransact);
                }
                a.recycle();
            }
        }
        this.mUid = si.applicationInfo.uid;
        this.mCategoryOtherServiceEnabled = true;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @NonNull
    public ComponentName getComponent() {
        return new ComponentName(this.mService.serviceInfo.packageName, this.mService.serviceInfo.name);
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @Nullable
    public String getOffHostSecureElement() {
        return this.mOffHostName;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @NonNull
    public List<String> getAids() {
        ArrayList<String> aids = new ArrayList<String>();
        for (AidGroup group : this.getAidGroups()) {
            aids.addAll(group.getAids());
        }
        return aids;
    }

    @FlaggedApi(value="android.nfc.nfc_read_polling_loop")
    @NonNull
    public List<String> getPollingLoopFilters() {
        return new ArrayList<String>(this.mAutoTransact.keySet());
    }

    @FlaggedApi(value="android.nfc.nfc_read_polling_loop")
    public boolean getShouldAutoTransact(@NonNull String plf) {
        if (this.mAutoTransact.getOrDefault(plf.toUpperCase(Locale.ROOT), false).booleanValue()) {
            return true;
        }
        boolean isPattern = plf.contains("?") || plf.contains("*");
        List<Pattern> patternMatches = this.mAutoTransactPatterns.keySet().stream().filter(p -> isPattern ? ((Object)p).toString().equals(plf) : p.matcher(plf).matches()).toList();
        if (patternMatches == null || patternMatches.size() == 0) {
            return false;
        }
        for (Pattern patternMatch : patternMatches) {
            if (!this.mAutoTransactPatterns.get(patternMatch).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @FlaggedApi(value="android.nfc.nfc_read_polling_loop")
    @NonNull
    public List<Pattern> getPollingLoopPatternFilters() {
        return new ArrayList<Pattern>(this.mAutoTransactPatterns.keySet());
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @NonNull
    public List<String> getPrefixAids() {
        ArrayList<String> prefixAids = new ArrayList<String>();
        for (AidGroup group : this.getAidGroups()) {
            for (String aid : group.getAids()) {
                if (!aid.endsWith("*")) continue;
                prefixAids.add(aid);
            }
        }
        return prefixAids;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @NonNull
    public List<String> getSubsetAids() {
        ArrayList<String> subsetAids = new ArrayList<String>();
        for (AidGroup group : this.getAidGroups()) {
            for (String aid : group.getAids()) {
                if (!aid.endsWith("#")) continue;
                subsetAids.add(aid);
            }
        }
        return subsetAids;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @NonNull
    public AidGroup getDynamicAidGroupForCategory(@NonNull String category) {
        return this.mDynamicAidGroups.get(category);
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @NonNull
    public boolean removeDynamicAidGroupForCategory(@NonNull String category) {
        return this.mDynamicAidGroups.remove(category) != null;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @NonNull
    public List<AidGroup> getAidGroups() {
        ArrayList<AidGroup> groups = new ArrayList<AidGroup>();
        for (Map.Entry<String, AidGroup> entry : this.mDynamicAidGroups.entrySet()) {
            groups.add(entry.getValue());
        }
        for (Map.Entry<String, AidGroup> entry : this.mStaticAidGroups.entrySet()) {
            if (this.mDynamicAidGroups.containsKey(entry.getKey())) continue;
            groups.add(entry.getValue());
        }
        return groups;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @NonNull
    public String getCategoryForAid(@NonNull String aid) {
        List<AidGroup> groups = this.getAidGroups();
        for (AidGroup group : groups) {
            if (!group.getAids().contains(aid.toUpperCase())) continue;
            return group.getCategory();
        }
        return null;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public boolean hasCategory(@NonNull String category) {
        return this.mStaticAidGroups.containsKey(category) || this.mDynamicAidGroups.containsKey(category);
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public boolean isOnHost() {
        return this.mOnHost;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public boolean requiresUnlock() {
        return this.mRequiresDeviceUnlock;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public boolean requiresScreenOn() {
        return this.mRequiresDeviceScreenOn;
    }

    @FlaggedApi(value="android.nfc.nfc_observe_mode")
    public boolean shouldDefaultToObserveMode() {
        return this.mShouldDefaultToObserveMode;
    }

    @FlaggedApi(value="android.nfc.nfc_observe_mode")
    public void setShouldDefaultToObserveMode(boolean shouldDefaultToObserveMode) {
        this.mShouldDefaultToObserveMode = shouldDefaultToObserveMode;
    }

    @FlaggedApi(value="android.nfc.nfc_associated_role_services")
    public boolean wantsRoleHolderPriority() {
        return this.mWantsRoleHolderPriority;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @NonNull
    public String getDescription() {
        return this.mDescription;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public int getUid() {
        return this.mUid;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public void setDynamicAidGroup(@NonNull AidGroup aidGroup) {
        this.mDynamicAidGroups.put(aidGroup.getCategory(), aidGroup);
    }

    @FlaggedApi(value="android.nfc.nfc_read_polling_loop")
    public void addPollingLoopFilter(@NonNull String pollingLoopFilter, boolean autoTransact) {
        if (!PLF_PATTERN.matcher(pollingLoopFilter).matches() || pollingLoopFilter.length() % 2 != 0) {
            throw new IllegalArgumentException("Polling loop filter must contain an even number of characters 0-9 or A-F");
        }
        if (!this.mOnHost && !autoTransact) {
            return;
        }
        this.mAutoTransact.put(pollingLoopFilter.toUpperCase(Locale.ROOT), autoTransact);
    }

    @FlaggedApi(value="android.nfc.nfc_read_polling_loop")
    public void removePollingLoopFilter(@NonNull String pollingLoopFilter) {
        this.mAutoTransact.remove(pollingLoopFilter.toUpperCase(Locale.ROOT));
    }

    @FlaggedApi(value="android.nfc.nfc_read_polling_loop")
    public void addPollingLoopPatternFilter(@NonNull String pollingLoopPatternFilter, boolean autoTransact) {
        if (!PLPF_PATTERN.matcher(pollingLoopPatternFilter).matches()) {
            throw new IllegalArgumentException("Polling loop pattern filter is invalid");
        }
        if (!this.mOnHost && !autoTransact) {
            return;
        }
        this.mAutoTransactPatterns.put(Pattern.compile(pollingLoopPatternFilter.toUpperCase(Locale.ROOT)), autoTransact);
    }

    @FlaggedApi(value="android.nfc.nfc_read_polling_loop")
    public void removePollingLoopPatternFilter(@NonNull String pollingLoopPatternFilter) {
        this.mAutoTransactPatterns.remove(Pattern.compile(pollingLoopPatternFilter.toUpperCase(Locale.ROOT)));
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public void setOffHostSecureElement(@NonNull String offHost) {
        this.mOffHostName = offHost;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public void resetOffHostSecureElement() {
        this.mOffHostName = this.mStaticOffHostName;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @NonNull
    public CharSequence loadLabel(@NonNull PackageManager pm) {
        return this.mService.loadLabel(pm);
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @NonNull
    public CharSequence loadAppLabel(@NonNull PackageManager pm) {
        try {
            return pm.getApplicationLabel(pm.getApplicationInfo(this.mService.resolvePackageName, 128));
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @NonNull
    public Drawable loadIcon(@NonNull PackageManager pm) {
        return this.mService.loadIcon(pm);
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @NonNull
    public Drawable loadBanner(@NonNull PackageManager pm) {
        try {
            Resources res = pm.getResourcesForApplication(this.mService.serviceInfo.packageName);
            Drawable banner = res.getDrawable(this.mBannerResourceId);
            return banner;
        }
        catch (Resources.NotFoundException e) {
            Log.e(TAG, "Could not load banner.");
            return null;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(TAG, "Could not load banner.");
            return null;
        }
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    @NonNull
    public String getSettingsActivityName() {
        return this.mSettingsActivityName;
    }

    public String toString() {
        StringBuilder out = new StringBuilder("ApduService: ");
        out.append(this.getComponent());
        out.append(", UID: " + this.mUid);
        out.append(", description: " + this.mDescription);
        out.append(", Static AID Groups: ");
        for (AidGroup aidGroup : this.mStaticAidGroups.values()) {
            out.append(aidGroup.toString());
        }
        out.append(", Dynamic AID Groups: ");
        for (AidGroup aidGroup : this.mDynamicAidGroups.values()) {
            out.append(aidGroup.toString());
        }
        return out.toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApduServiceInfo)) {
            return false;
        }
        ApduServiceInfo thatService = (ApduServiceInfo)o;
        return thatService.getComponent().equals(this.getComponent()) && thatService.getUid() == this.getUid();
    }

    public int hashCode() {
        return this.getComponent().hashCode();
    }

    @Override
    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public int describeContents() {
        return 0;
    }

    @Override
    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        this.mService.writeToParcel(dest, flags);
        dest.writeString(this.mDescription);
        dest.writeInt(this.mOnHost ? 1 : 0);
        dest.writeString(this.mOffHostName);
        dest.writeString(this.mStaticOffHostName);
        dest.writeInt(this.mStaticAidGroups.size());
        if (this.mStaticAidGroups.size() > 0) {
            dest.writeTypedList(new ArrayList<AidGroup>(this.mStaticAidGroups.values()));
        }
        dest.writeInt(this.mDynamicAidGroups.size());
        if (this.mDynamicAidGroups.size() > 0) {
            dest.writeTypedList(new ArrayList<AidGroup>(this.mDynamicAidGroups.values()));
        }
        dest.writeInt(this.mRequiresDeviceUnlock ? 1 : 0);
        dest.writeInt(this.mRequiresDeviceScreenOn ? 1 : 0);
        dest.writeInt(this.mBannerResourceId);
        dest.writeInt(this.mUid);
        dest.writeString(this.mSettingsActivityName);
        dest.writeInt(this.mCategoryOtherServiceEnabled ? 1 : 0);
        dest.writeInt(this.mAutoTransact.size());
        dest.writeMap(this.mAutoTransact);
        dest.writeInt(this.mAutoTransactPatterns.size());
        dest.writeMap(this.mAutoTransactPatterns);
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public void dump(@NonNull ParcelFileDescriptor fd, @NonNull PrintWriter pw, @NonNull String[] args) {
        pw.println("    " + this.getComponent() + " (Description: " + this.getDescription() + ") (UID: " + this.getUid() + ")");
        if (this.mOnHost) {
            pw.println("    On Host Service");
        } else {
            pw.println("    Off-host Service");
            pw.println("        Current off-host SE:" + this.mOffHostName + " static off-host SE:" + this.mStaticOffHostName);
        }
        pw.println("    Static AID groups:");
        for (AidGroup group : this.mStaticAidGroups.values()) {
            pw.println("        Category: " + group.getCategory() + "(enabled: " + this.mCategoryOtherServiceEnabled + ")");
            for (String aid : group.getAids()) {
                pw.println("            AID: " + aid);
            }
        }
        pw.println("    Dynamic AID groups:");
        for (AidGroup group : this.mDynamicAidGroups.values()) {
            pw.println("        Category: " + group.getCategory() + "(enabled: " + this.mCategoryOtherServiceEnabled + ")");
            for (String aid : group.getAids()) {
                pw.println("            AID: " + aid);
            }
        }
        pw.println("    Settings Activity: " + this.mSettingsActivityName);
        pw.println("    Requires Device Unlock: " + this.mRequiresDeviceUnlock);
        pw.println("    Requires Device ScreenOn: " + this.mRequiresDeviceScreenOn);
        pw.println("    Should Default to Observe Mode: " + this.mShouldDefaultToObserveMode);
        pw.println("    Auto-Transact Mapping: " + this.mAutoTransact);
        pw.println("    Auto-Transact Patterns: " + this.mAutoTransactPatterns);
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public void setCategoryOtherServiceEnabled(boolean enabled) {
        this.mCategoryOtherServiceEnabled = enabled;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public boolean isCategoryOtherServiceEnabled() {
        return this.mCategoryOtherServiceEnabled;
    }

    @FlaggedApi(value="android.nfc.enable_nfc_mainline")
    public void dumpDebug(@NonNull ProtoOutputStream proto) {
        long token;
        this.getComponent().dumpDebug(proto, 0x10B00000001L);
        proto.write(1138166333442L, this.getDescription());
        proto.write(1133871366147L, this.mOnHost);
        if (!this.mOnHost) {
            proto.write(1138166333444L, this.mOffHostName);
            proto.write(1138166333445L, this.mStaticOffHostName);
        }
        for (AidGroup group : this.mStaticAidGroups.values()) {
            token = proto.start(2246267895814L);
            group.dump(proto);
            proto.end(token);
        }
        for (AidGroup group : this.mDynamicAidGroups.values()) {
            token = proto.start(2246267895814L);
            group.dump(proto);
            proto.end(token);
        }
        proto.write(1138166333448L, this.mSettingsActivityName);
        proto.write(1133871366153L, this.mShouldDefaultToObserveMode);
        long token2 = proto.start(2246267895818L);
        for (Map.Entry<String, Boolean> entry : this.mAutoTransact.entrySet()) {
            proto.write(0x10900000001L, entry.getKey());
            proto.write(1133871366146L, entry.getValue());
        }
        proto.end(token2);
        long token3 = proto.start(0x20B0000000BL);
        for (Map.Entry<Object, Boolean> entry : this.mAutoTransactPatterns.entrySet()) {
            proto.write(0x10900000001L, ((Pattern)entry.getKey()).pattern());
            proto.write(1133871366146L, entry.getValue());
        }
        proto.end(token3);
    }

    private static boolean isValidAid(String aid) {
        if (aid == null) {
            return false;
        }
        if ((aid.endsWith("*") || aid.endsWith("#")) && aid.length() % 2 == 0) {
            Log.e(TAG, "AID " + aid + " is not a valid AID.");
            return false;
        }
        if (!aid.endsWith("*") && !aid.endsWith("#") && aid.length() % 2 != 0) {
            Log.e(TAG, "AID " + aid + " is not a valid AID.");
            return false;
        }
        if (!AID_PATTERN.matcher(aid).matches()) {
            Log.e(TAG, "AID " + aid + " is not a valid AID.");
            return false;
        }
        return true;
    }
}

