/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.pm.ApplicationInfo;
import android.content.pm.ProcessInfo;
import android.os.ChildZygoteProcess;
import android.os.Process;
import android.os.UserHandle;
import android.os.ZygoteProcess;
import android.os._Original_Build;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.hidden_from_bootclasspath.android.os.Flags;
import com.android.internal.os.Zygote;
import dalvik.system.VMRuntime;
import java.util.Map;

public class AppZygote {
    private static final String LOG_TAG = "AppZygote";
    private final int mZygoteUid;
    private final int mZygoteUidGidMin;
    private final int mZygoteUidGidMax;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private ChildZygoteProcess mZygote;
    private final ApplicationInfo mAppInfo;
    private final ProcessInfo mProcessInfo;

    public AppZygote(ApplicationInfo appInfo, ProcessInfo processInfo, int zygoteUid, int uidGidMin, int uidGidMax) {
        this.mAppInfo = appInfo;
        this.mProcessInfo = processInfo;
        this.mZygoteUid = zygoteUid;
        this.mZygoteUidGidMin = uidGidMin;
        this.mZygoteUidGidMax = uidGidMax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChildZygoteProcess getProcess() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mZygote != null) {
                return this.mZygote;
            }
            this.connectToZygoteIfNeededLocked();
            return this.mZygote;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopZygote() {
        Object object = this.mLock;
        synchronized (object) {
            this.stopZygoteLocked();
        }
    }

    public ApplicationInfo getAppInfo() {
        return this.mAppInfo;
    }

    public Process.ProcessStartResult startProcess(@NonNull String processClass, String niceName, int uid, @Nullable int[] gids, int runtimeFlags, int mountExternal, int targetSdkVersion, @Nullable String seInfo, @NonNull String abi, @Nullable String instructionSet, @Nullable String appDataDir, @Nullable String packageName, boolean isTopApp, @Nullable long[] disabledCompatChanges, @Nullable Map<String, Pair<String, Long>> pkgDataInfoMap, @Nullable Map<String, Pair<String, Long>> allowlistedDataInfoList, @Nullable String[] zygoteArgs) {
        try {
            return this.getProcess().start(processClass, niceName, uid, uid, gids, runtimeFlags, mountExternal, targetSdkVersion, seInfo, abi, instructionSet, appDataDir, null, packageName, 0, isTopApp, disabledCompatChanges, pkgDataInfoMap, allowlistedDataInfoList, false, false, false, zygoteArgs);
        }
        catch (RuntimeException e) {
            if (!Flags.appZygoteRetryStart()) {
                throw e;
            }
            boolean zygote_dead = this.getProcess().isDead();
            if (!zygote_dead) {
                throw e;
            }
            Log.w(LOG_TAG, "retry starting process " + niceName);
            this.stopZygote();
            return this.getProcess().start(processClass, niceName, uid, uid, gids, runtimeFlags, mountExternal, targetSdkVersion, seInfo, abi, instructionSet, appDataDir, null, packageName, 0, isTopApp, disabledCompatChanges, pkgDataInfoMap, allowlistedDataInfoList, false, false, false, zygoteArgs);
        }
    }

    @GuardedBy(value={"mLock"})
    private void stopZygoteLocked() {
        if (this.mZygote != null) {
            this.mZygote.close();
            if (!this.mZygote.isDead()) {
                Process.killProcessGroup(this.mZygoteUid, this.mZygote.getPid());
            }
            this.mZygote = null;
        }
    }

    @GuardedBy(value={"mLock"})
    private void connectToZygoteIfNeededLocked() {
        String abi = this.mAppInfo.primaryCpuAbi != null ? this.mAppInfo.primaryCpuAbi : _Original_Build.SUPPORTED_ABIS[0];
        try {
            int runtimeFlags = Zygote.getMemorySafetyRuntimeFlagsForSecondaryZygote(this.mAppInfo, this.mProcessInfo);
            int[] sharedAppGid = new int[]{UserHandle.getSharedAppGid(UserHandle.getAppId(this.mAppInfo.uid))};
            this.mZygote = Process.ZYGOTE_PROCESS.startChildZygote("com.android.internal.os.AppZygoteInit", this.mAppInfo.processName + "_zygote", this.mZygoteUid, this.mZygoteUid, sharedAppGid, runtimeFlags, "app_zygote", abi, abi, VMRuntime.getInstructionSet(abi), this.mZygoteUidGidMin, this.mZygoteUidGidMax);
            ZygoteProcess.waitForConnectionToZygote(this.mZygote.getPrimarySocketAddress());
            Log.i(LOG_TAG, "Starting application preload.");
            this.mZygote.preloadApp(this.mAppInfo, abi);
            Log.i(LOG_TAG, "Application preload done.");
        }
        catch (Exception e) {
            Log.e(LOG_TAG, "Error connecting to app zygote", e);
            this.stopZygoteLocked();
        }
    }
}

