/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.hardware.power.ChannelConfig;
import android.hardware.power.CpuHeadroomResult;
import android.hardware.power.GpuHeadroomResult;
import android.hardware.power.SessionConfig;
import android.hardware.power.SupportInfo;
import android.os.BadParcelableException;
import android.os.Binder;
import android.os.CpuHeadroomParamsInternal;
import android.os.GpuHeadroomParamsInternal;
import android.os.IBinder;
import android.os.IHintSession;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.SessionCreationConfig;

public interface IHintManager
extends IInterface {
    public static final String DESCRIPTOR = "android.os.IHintManager";

    public SessionCreationReturn createHintSessionWithConfig(IBinder var1, int var2, SessionCreationConfig var3, SessionConfig var4) throws RemoteException;

    public void setHintSessionThreads(IHintSession var1, int[] var2) throws RemoteException;

    public int[] getHintSessionThreadIds(IHintSession var1) throws RemoteException;

    public ChannelConfig getSessionChannel(IBinder var1) throws RemoteException;

    public void closeSessionChannel() throws RemoteException;

    public CpuHeadroomResult getCpuHeadroom(CpuHeadroomParamsInternal var1) throws RemoteException;

    public long getCpuHeadroomMinIntervalMillis() throws RemoteException;

    public GpuHeadroomResult getGpuHeadroom(GpuHeadroomParamsInternal var1) throws RemoteException;

    public long getGpuHeadroomMinIntervalMillis() throws RemoteException;

    public void passSessionManagerBinder(IBinder var1) throws RemoteException;

    public HintManagerClientData registerClient(IHintManagerClient var1) throws RemoteException;

    public HintManagerClientData getClientData() throws RemoteException;

    public static interface IHintManagerClient
    extends IInterface {
        public static final String DESCRIPTOR = "android.os.IHintManager.IHintManagerClient";

        public void receiveChannelConfig(ChannelConfig var1) throws RemoteException;

        public static abstract class Stub
        extends Binder
        implements IHintManagerClient {
            static final int TRANSACTION_receiveChannelConfig = 1;

            public Stub() {
                this.attachInterface(this, IHintManagerClient.DESCRIPTOR);
            }

            public static IHintManagerClient asInterface(IBinder obj) {
                if (obj == null) {
                    return null;
                }
                IInterface iin = obj.queryLocalInterface(IHintManagerClient.DESCRIPTOR);
                if (iin != null && iin instanceof IHintManagerClient) {
                    return (IHintManagerClient)iin;
                }
                return new Proxy(obj);
            }

            @Override
            public IBinder asBinder() {
                return this;
            }

            public static String getDefaultTransactionName(int transactionCode) {
                switch (transactionCode) {
                    case 1: {
                        return "receiveChannelConfig";
                    }
                }
                return null;
            }

            @Override
            public String getTransactionName(int transactionCode) {
                return Stub.getDefaultTransactionName(transactionCode);
            }

            @Override
            public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
                String descriptor = IHintManagerClient.DESCRIPTOR;
                if (code >= 1 && code <= 0xFFFFFF) {
                    data.enforceInterface(descriptor);
                }
                if (code == 1598968902) {
                    reply.writeString(descriptor);
                    return true;
                }
                switch (code) {
                    case 1: {
                        ChannelConfig _arg0 = data.readTypedObject(ChannelConfig.CREATOR);
                        data.enforceNoDataAvail();
                        this.receiveChannelConfig(_arg0);
                        break;
                    }
                    default: {
                        return super.onTransact(code, data, reply, flags);
                    }
                }
                return true;
            }

            @Override
            public int getMaxTransactionId() {
                return 0;
            }

            private static class Proxy
            implements IHintManagerClient {
                private IBinder mRemote;

                Proxy(IBinder remote) {
                    this.mRemote = remote;
                }

                @Override
                public IBinder asBinder() {
                    return this.mRemote;
                }

                public String getInterfaceDescriptor() {
                    return IHintManagerClient.DESCRIPTOR;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void receiveChannelConfig(ChannelConfig config) throws RemoteException {
                    Parcel _data = Parcel.obtain(this.asBinder());
                    try {
                        _data.writeInterfaceToken(IHintManagerClient.DESCRIPTOR);
                        _data.writeTypedObject(config, 0);
                        boolean bl = this.mRemote.transact(1, _data, null, 1);
                    }
                    finally {
                        _data.recycle();
                    }
                }
            }
        }

        public static class Default
        implements IHintManagerClient {
            @Override
            public void receiveChannelConfig(ChannelConfig config) throws RemoteException {
            }

            @Override
            public IBinder asBinder() {
                return null;
            }
        }
    }

    public static class HintManagerClientData
    implements Parcelable {
        public int powerHalVersion = 0;
        public int maxGraphicsPipelineThreads = 0;
        public int maxCpuHeadroomThreads = 0;
        public long preferredRateNanos = 0L;
        public SupportInfo supportInfo;
        public static final Parcelable.Creator<HintManagerClientData> CREATOR = new Parcelable.Creator<HintManagerClientData>(){

            @Override
            public HintManagerClientData createFromParcel(Parcel _aidl_source) {
                HintManagerClientData _aidl_out = new HintManagerClientData();
                _aidl_out.readFromParcel(_aidl_source);
                return _aidl_out;
            }

            public HintManagerClientData[] newArray(int _aidl_size) {
                return new HintManagerClientData[_aidl_size];
            }
        };

        @Override
        public void writeToParcel(Parcel _aidl_parcel, int _aidl_flag) {
            int _aidl_start_pos = _aidl_parcel.dataPosition();
            _aidl_parcel.writeInt(0);
            _aidl_parcel.writeInt(this.powerHalVersion);
            _aidl_parcel.writeInt(this.maxGraphicsPipelineThreads);
            _aidl_parcel.writeInt(this.maxCpuHeadroomThreads);
            _aidl_parcel.writeLong(this.preferredRateNanos);
            _aidl_parcel.writeTypedObject(this.supportInfo, _aidl_flag);
            int _aidl_end_pos = _aidl_parcel.dataPosition();
            _aidl_parcel.setDataPosition(_aidl_start_pos);
            _aidl_parcel.writeInt(_aidl_end_pos - _aidl_start_pos);
            _aidl_parcel.setDataPosition(_aidl_end_pos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFromParcel(Parcel _aidl_parcel) {
            int _aidl_start_pos = _aidl_parcel.dataPosition();
            int _aidl_parcelable_size = _aidl_parcel.readInt();
            try {
                if (_aidl_parcelable_size < 4) {
                    throw new BadParcelableException("Parcelable too small");
                }
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.powerHalVersion = _aidl_parcel.readInt();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.maxGraphicsPipelineThreads = _aidl_parcel.readInt();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.maxCpuHeadroomThreads = _aidl_parcel.readInt();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.preferredRateNanos = _aidl_parcel.readLong();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.supportInfo = _aidl_parcel.readTypedObject(SupportInfo.CREATOR);
            }
            finally {
                if (_aidl_start_pos > Integer.MAX_VALUE - _aidl_parcelable_size) {
                    throw new BadParcelableException("Overflow in the size of parcelable");
                }
                _aidl_parcel.setDataPosition(_aidl_start_pos + _aidl_parcelable_size);
            }
        }

        @Override
        public int describeContents() {
            int _mask = 0;
            return _mask |= this.describeContents(this.supportInfo);
        }

        private int describeContents(Object _v) {
            if (_v == null) {
                return 0;
            }
            if (_v instanceof Parcelable) {
                return ((Parcelable)_v).describeContents();
            }
            return 0;
        }
    }

    public static class SessionCreationReturn
    implements Parcelable {
        public IHintSession session;
        public boolean pipelineThreadLimitExceeded = false;
        public static final Parcelable.Creator<SessionCreationReturn> CREATOR = new Parcelable.Creator<SessionCreationReturn>(){

            @Override
            public SessionCreationReturn createFromParcel(Parcel _aidl_source) {
                SessionCreationReturn _aidl_out = new SessionCreationReturn();
                _aidl_out.readFromParcel(_aidl_source);
                return _aidl_out;
            }

            public SessionCreationReturn[] newArray(int _aidl_size) {
                return new SessionCreationReturn[_aidl_size];
            }
        };

        @Override
        public void writeToParcel(Parcel _aidl_parcel, int _aidl_flag) {
            int _aidl_start_pos = _aidl_parcel.dataPosition();
            _aidl_parcel.writeInt(0);
            _aidl_parcel.writeStrongInterface(this.session);
            _aidl_parcel.writeBoolean(this.pipelineThreadLimitExceeded);
            int _aidl_end_pos = _aidl_parcel.dataPosition();
            _aidl_parcel.setDataPosition(_aidl_start_pos);
            _aidl_parcel.writeInt(_aidl_end_pos - _aidl_start_pos);
            _aidl_parcel.setDataPosition(_aidl_end_pos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFromParcel(Parcel _aidl_parcel) {
            int _aidl_start_pos = _aidl_parcel.dataPosition();
            int _aidl_parcelable_size = _aidl_parcel.readInt();
            try {
                if (_aidl_parcelable_size < 4) {
                    throw new BadParcelableException("Parcelable too small");
                }
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.session = IHintSession.Stub.asInterface(_aidl_parcel.readStrongBinder());
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.pipelineThreadLimitExceeded = _aidl_parcel.readBoolean();
            }
            finally {
                if (_aidl_start_pos > Integer.MAX_VALUE - _aidl_parcelable_size) {
                    throw new BadParcelableException("Overflow in the size of parcelable");
                }
                _aidl_parcel.setDataPosition(_aidl_start_pos + _aidl_parcelable_size);
            }
        }

        @Override
        public int describeContents() {
            int _mask = 0;
            return _mask;
        }
    }

    public static abstract class Stub
    extends Binder
    implements IHintManager {
        static final int TRANSACTION_createHintSessionWithConfig = 1;
        static final int TRANSACTION_setHintSessionThreads = 2;
        static final int TRANSACTION_getHintSessionThreadIds = 3;
        static final int TRANSACTION_getSessionChannel = 4;
        static final int TRANSACTION_closeSessionChannel = 5;
        static final int TRANSACTION_getCpuHeadroom = 6;
        static final int TRANSACTION_getCpuHeadroomMinIntervalMillis = 7;
        static final int TRANSACTION_getGpuHeadroom = 8;
        static final int TRANSACTION_getGpuHeadroomMinIntervalMillis = 9;
        static final int TRANSACTION_passSessionManagerBinder = 10;
        static final int TRANSACTION_registerClient = 11;
        static final int TRANSACTION_getClientData = 12;

        public Stub() {
            this.attachInterface(this, IHintManager.DESCRIPTOR);
        }

        public static IHintManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IHintManager.DESCRIPTOR);
            if (iin != null && iin instanceof IHintManager) {
                return (IHintManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "createHintSessionWithConfig";
                }
                case 2: {
                    return "setHintSessionThreads";
                }
                case 3: {
                    return "getHintSessionThreadIds";
                }
                case 4: {
                    return "getSessionChannel";
                }
                case 5: {
                    return "closeSessionChannel";
                }
                case 6: {
                    return "getCpuHeadroom";
                }
                case 7: {
                    return "getCpuHeadroomMinIntervalMillis";
                }
                case 8: {
                    return "getGpuHeadroom";
                }
                case 9: {
                    return "getGpuHeadroomMinIntervalMillis";
                }
                case 10: {
                    return "passSessionManagerBinder";
                }
                case 11: {
                    return "registerClient";
                }
                case 12: {
                    return "getClientData";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IHintManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    SessionCreationConfig _arg2 = data.readTypedObject(SessionCreationConfig.CREATOR);
                    SessionConfig _arg3 = new SessionConfig();
                    data.enforceNoDataAvail();
                    SessionCreationReturn _result = this.createHintSessionWithConfig(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    reply.writeTypedObject(_arg3, 1);
                    break;
                }
                case 2: {
                    IHintSession _arg0 = IHintSession.Stub.asInterface(data.readStrongBinder());
                    int[] _arg1 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.setHintSessionThreads(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    IHintSession _arg0 = IHintSession.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int[] _result = this.getHintSessionThreadIds(_arg0);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 4: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    ChannelConfig _result = this.getSessionChannel(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 5: {
                    this.closeSessionChannel();
                    break;
                }
                case 6: {
                    CpuHeadroomParamsInternal _arg0 = data.readTypedObject(CpuHeadroomParamsInternal.CREATOR);
                    data.enforceNoDataAvail();
                    CpuHeadroomResult _result = this.getCpuHeadroom(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 7: {
                    long _result = this.getCpuHeadroomMinIntervalMillis();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 8: {
                    GpuHeadroomParamsInternal _arg0 = data.readTypedObject(GpuHeadroomParamsInternal.CREATOR);
                    data.enforceNoDataAvail();
                    GpuHeadroomResult _result = this.getGpuHeadroom(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 9: {
                    long _result = this.getGpuHeadroomMinIntervalMillis();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 10: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.passSessionManagerBinder(_arg0);
                    break;
                }
                case 11: {
                    IHintManagerClient _arg0 = IHintManagerClient.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    HintManagerClientData _result = this.registerClient(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 12: {
                    HintManagerClientData _result = this.getClientData();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 11;
        }

        private static class Proxy
        implements IHintManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IHintManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SessionCreationReturn createHintSessionWithConfig(IBinder token, int tag, SessionCreationConfig creationConfig, SessionConfig config) throws RemoteException {
                SessionCreationReturn _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHintManager.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(tag);
                    _data.writeTypedObject(creationConfig, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SessionCreationReturn.CREATOR);
                    if (0 != _reply.readInt()) {
                        config.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setHintSessionThreads(IHintSession hintSession, int[] tids) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHintManager.DESCRIPTOR);
                    _data.writeStrongInterface(hintSession);
                    _data.writeIntArray(tids);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getHintSessionThreadIds(IHintSession hintSession) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHintManager.DESCRIPTOR);
                    _data.writeStrongInterface(hintSession);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ChannelConfig getSessionChannel(IBinder token) throws RemoteException {
                ChannelConfig _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHintManager.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ChannelConfig.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public void closeSessionChannel() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IHintManager.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CpuHeadroomResult getCpuHeadroom(CpuHeadroomParamsInternal params) throws RemoteException {
                CpuHeadroomResult _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHintManager.DESCRIPTOR);
                    _data.writeTypedObject(params, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(CpuHeadroomResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getCpuHeadroomMinIntervalMillis() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHintManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public GpuHeadroomResult getGpuHeadroom(GpuHeadroomParamsInternal params) throws RemoteException {
                GpuHeadroomResult _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHintManager.DESCRIPTOR);
                    _data.writeTypedObject(params, 0);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(GpuHeadroomResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getGpuHeadroomMinIntervalMillis() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHintManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void passSessionManagerBinder(IBinder sessionManager) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IHintManager.DESCRIPTOR);
                    _data.writeStrongBinder(sessionManager);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public HintManagerClientData registerClient(IHintManagerClient client) throws RemoteException {
                HintManagerClientData _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHintManager.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(HintManagerClientData.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public HintManagerClientData getClientData() throws RemoteException {
                HintManagerClientData _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHintManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(HintManagerClientData.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IHintManager {
        @Override
        public SessionCreationReturn createHintSessionWithConfig(IBinder token, int tag, SessionCreationConfig creationConfig, SessionConfig config) throws RemoteException {
            return null;
        }

        @Override
        public void setHintSessionThreads(IHintSession hintSession, int[] tids) throws RemoteException {
        }

        @Override
        public int[] getHintSessionThreadIds(IHintSession hintSession) throws RemoteException {
            return null;
        }

        @Override
        public ChannelConfig getSessionChannel(IBinder token) throws RemoteException {
            return null;
        }

        @Override
        public void closeSessionChannel() throws RemoteException {
        }

        @Override
        public CpuHeadroomResult getCpuHeadroom(CpuHeadroomParamsInternal params) throws RemoteException {
            return null;
        }

        @Override
        public long getCpuHeadroomMinIntervalMillis() throws RemoteException {
            return 0L;
        }

        @Override
        public GpuHeadroomResult getGpuHeadroom(GpuHeadroomParamsInternal params) throws RemoteException {
            return null;
        }

        @Override
        public long getGpuHeadroomMinIntervalMillis() throws RemoteException {
            return 0L;
        }

        @Override
        public void passSessionManagerBinder(IBinder sessionManager) throws RemoteException {
        }

        @Override
        public HintManagerClientData registerClient(IHintManagerClient client) throws RemoteException {
            return null;
        }

        @Override
        public HintManagerClientData getClientData() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

