/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.ConnectionInfo;
import android.os.IBinder;
import android.os.IClientCallback;
import android.os.IInterface;
import android.os.IServiceCallback;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.Service;
import android.os.ServiceDebugInfo;

public interface IServiceManager
extends IInterface {
    public static final String DESCRIPTOR = "android.os.IServiceManager";
    public static final int DUMP_FLAG_PRIORITY_CRITICAL = 1;
    public static final int DUMP_FLAG_PRIORITY_HIGH = 2;
    public static final int DUMP_FLAG_PRIORITY_NORMAL = 4;
    public static final int DUMP_FLAG_PRIORITY_DEFAULT = 8;
    public static final int DUMP_FLAG_PRIORITY_ALL = 15;
    public static final int FLAG_IS_LAZY_SERVICE = 0x40000000;
    public static final int DUMP_FLAG_PROTO = 16;

    @Deprecated
    @UnsupportedAppUsage(overrideSourcePosition="frameworks/native/libs/binder/aidl/android/os/IServiceManager.aidl:69:1:69:25")
    public IBinder getService(String var1) throws RemoteException;

    public Service getService2(String var1) throws RemoteException;

    @Deprecated
    @UnsupportedAppUsage(overrideSourcePosition="frameworks/native/libs/binder/aidl/android/os/IServiceManager.aidl:91:1:91:25")
    public IBinder checkService(String var1) throws RemoteException;

    public Service checkService2(String var1) throws RemoteException;

    public void addService(String var1, IBinder var2, boolean var3, int var4) throws RemoteException;

    public String[] listServices(int var1) throws RemoteException;

    public void registerForNotifications(String var1, IServiceCallback var2) throws RemoteException;

    public void unregisterForNotifications(String var1, IServiceCallback var2) throws RemoteException;

    public boolean isDeclared(String var1) throws RemoteException;

    public String[] getDeclaredInstances(String var1) throws RemoteException;

    public String updatableViaApex(String var1) throws RemoteException;

    public String[] getUpdatableNames(String var1) throws RemoteException;

    public ConnectionInfo getConnectionInfo(String var1) throws RemoteException;

    public void registerClientCallback(String var1, IBinder var2, IClientCallback var3) throws RemoteException;

    public void tryUnregisterService(String var1, IBinder var2) throws RemoteException;

    public ServiceDebugInfo[] getServiceDebugInfo() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IServiceManager {
        static final int TRANSACTION_getService = 1;
        static final int TRANSACTION_getService2 = 2;
        static final int TRANSACTION_checkService = 3;
        static final int TRANSACTION_checkService2 = 4;
        static final int TRANSACTION_addService = 5;
        static final int TRANSACTION_listServices = 6;
        static final int TRANSACTION_registerForNotifications = 7;
        static final int TRANSACTION_unregisterForNotifications = 8;
        static final int TRANSACTION_isDeclared = 9;
        static final int TRANSACTION_getDeclaredInstances = 10;
        static final int TRANSACTION_updatableViaApex = 11;
        static final int TRANSACTION_getUpdatableNames = 12;
        static final int TRANSACTION_getConnectionInfo = 13;
        static final int TRANSACTION_registerClientCallback = 14;
        static final int TRANSACTION_tryUnregisterService = 15;
        static final int TRANSACTION_getServiceDebugInfo = 16;

        public Stub() {
            this.attachInterface(this, IServiceManager.DESCRIPTOR);
        }

        public static IServiceManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IServiceManager.DESCRIPTOR);
            if (iin != null && iin instanceof IServiceManager) {
                return (IServiceManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getService";
                }
                case 2: {
                    return "getService2";
                }
                case 3: {
                    return "checkService";
                }
                case 4: {
                    return "checkService2";
                }
                case 5: {
                    return "addService";
                }
                case 6: {
                    return "listServices";
                }
                case 7: {
                    return "registerForNotifications";
                }
                case 8: {
                    return "unregisterForNotifications";
                }
                case 9: {
                    return "isDeclared";
                }
                case 10: {
                    return "getDeclaredInstances";
                }
                case 11: {
                    return "updatableViaApex";
                }
                case 12: {
                    return "getUpdatableNames";
                }
                case 13: {
                    return "getConnectionInfo";
                }
                case 14: {
                    return "registerClientCallback";
                }
                case 15: {
                    return "tryUnregisterService";
                }
                case 16: {
                    return "getServiceDebugInfo";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IServiceManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    IBinder _result = this.getService(_arg0);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    Service _result = this.getService2(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    IBinder _result = this.checkService(_arg0);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    Service _result = this.checkService2(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    IBinder _arg1 = data.readStrongBinder();
                    boolean _arg2 = data.readBoolean();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.addService(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    String[] _result = this.listServices(_arg0);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    IServiceCallback _arg1 = IServiceCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerForNotifications(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    IServiceCallback _arg1 = IServiceCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterForNotifications(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isDeclared(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    String[] _result = this.getDeclaredInstances(_arg0);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    String _result = this.updatableViaApex(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 12: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    String[] _result = this.getUpdatableNames(_arg0);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 13: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    ConnectionInfo _result = this.getConnectionInfo(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 14: {
                    String _arg0 = data.readString();
                    IBinder _arg1 = data.readStrongBinder();
                    IClientCallback _arg2 = IClientCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerClientCallback(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    String _arg0 = data.readString();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.tryUnregisterService(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    Parcelable[] _result = this.getServiceDebugInfo();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 15;
        }

        private static class Proxy
        implements IServiceManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IServiceManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IBinder getService(String name) throws RemoteException {
                IBinder _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readStrongBinder();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Service getService2(String name) throws RemoteException {
                Service _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Service.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IBinder checkService(String name) throws RemoteException {
                IBinder _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readStrongBinder();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Service checkService2(String name) throws RemoteException {
                Service _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Service.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addService(String name, IBinder service, boolean allowIsolated, int dumpPriority) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeStrongBinder(service);
                    _data.writeBoolean(allowIsolated);
                    _data.writeInt(dumpPriority);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] listServices(int dumpPriority) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    _data.writeInt(dumpPriority);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerForNotifications(String name, IServiceCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterForNotifications(String name, IServiceCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDeclared(String name) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getDeclaredInstances(String iface) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    _data.writeString(iface);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String updatableViaApex(String name) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getUpdatableNames(String apexName) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    _data.writeString(apexName);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ConnectionInfo getConnectionInfo(String name) throws RemoteException {
                ConnectionInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ConnectionInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerClientCallback(String name, IBinder service, IClientCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeStrongBinder(service);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void tryUnregisterService(String name, IBinder service) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeStrongBinder(service);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ServiceDebugInfo[] getServiceDebugInfo() throws RemoteException {
                ServiceDebugInfo[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IServiceManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(ServiceDebugInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IServiceManager {
        @Override
        public IBinder getService(String name) throws RemoteException {
            return null;
        }

        @Override
        public Service getService2(String name) throws RemoteException {
            return null;
        }

        @Override
        public IBinder checkService(String name) throws RemoteException {
            return null;
        }

        @Override
        public Service checkService2(String name) throws RemoteException {
            return null;
        }

        @Override
        public void addService(String name, IBinder service, boolean allowIsolated, int dumpPriority) throws RemoteException {
        }

        @Override
        public String[] listServices(int dumpPriority) throws RemoteException {
            return null;
        }

        @Override
        public void registerForNotifications(String name, IServiceCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterForNotifications(String name, IServiceCallback callback) throws RemoteException {
        }

        @Override
        public boolean isDeclared(String name) throws RemoteException {
            return false;
        }

        @Override
        public String[] getDeclaredInstances(String iface) throws RemoteException {
            return null;
        }

        @Override
        public String updatableViaApex(String name) throws RemoteException {
            return null;
        }

        @Override
        public String[] getUpdatableNames(String apexName) throws RemoteException {
            return null;
        }

        @Override
        public ConnectionInfo getConnectionInfo(String name) throws RemoteException {
            return null;
        }

        @Override
        public void registerClientCallback(String name, IBinder service, IClientCallback callback) throws RemoteException {
        }

        @Override
        public void tryUnregisterService(String name, IBinder service) throws RemoteException {
        }

        @Override
        public ServiceDebugInfo[] getServiceDebugInfo() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

