/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IStatsCompanionService
extends IInterface {
    public void statsdReady() throws RemoteException;

    public void setAnomalyAlarm(long var1) throws RemoteException;

    public void cancelAnomalyAlarm() throws RemoteException;

    public void setPullingAlarm(long var1) throws RemoteException;

    public void cancelPullingAlarm() throws RemoteException;

    public void setAlarmForSubscriberTriggering(long var1) throws RemoteException;

    public void cancelAlarmForSubscriberTriggering() throws RemoteException;

    public boolean checkPermission(String var1, int var2, int var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IStatsCompanionService {
        public static final String DESCRIPTOR = "android.os.IStatsCompanionService";
        static final int TRANSACTION_statsdReady = 1;
        static final int TRANSACTION_setAnomalyAlarm = 2;
        static final int TRANSACTION_cancelAnomalyAlarm = 3;
        static final int TRANSACTION_setPullingAlarm = 4;
        static final int TRANSACTION_cancelPullingAlarm = 5;
        static final int TRANSACTION_setAlarmForSubscriberTriggering = 6;
        static final int TRANSACTION_cancelAlarmForSubscriberTriggering = 7;
        static final int TRANSACTION_checkPermission = 8;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IStatsCompanionService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IStatsCompanionService) {
                return (IStatsCompanionService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "statsdReady";
                }
                case 2: {
                    return "setAnomalyAlarm";
                }
                case 3: {
                    return "cancelAnomalyAlarm";
                }
                case 4: {
                    return "setPullingAlarm";
                }
                case 5: {
                    return "cancelPullingAlarm";
                }
                case 6: {
                    return "setAlarmForSubscriberTriggering";
                }
                case 7: {
                    return "cancelAlarmForSubscriberTriggering";
                }
                case 8: {
                    return "checkPermission";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    this.statsdReady();
                    break;
                }
                case 2: {
                    long _arg0 = data.readLong();
                    this.setAnomalyAlarm(_arg0);
                    break;
                }
                case 3: {
                    this.cancelAnomalyAlarm();
                    break;
                }
                case 4: {
                    long _arg0 = data.readLong();
                    this.setPullingAlarm(_arg0);
                    break;
                }
                case 5: {
                    this.cancelPullingAlarm();
                    break;
                }
                case 6: {
                    long _arg0 = data.readLong();
                    this.setAlarmForSubscriberTriggering(_arg0);
                    break;
                }
                case 7: {
                    this.cancelAlarmForSubscriberTriggering();
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    boolean _result = this.checkPermission(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 7;
        }

        private static class Proxy
        implements IStatsCompanionService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void statsdReady() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAnomalyAlarm(long timestampMs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(timestampMs);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void cancelAnomalyAlarm() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPullingAlarm(long nextPullTimeMs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(nextPullTimeMs);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void cancelPullingAlarm() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAlarmForSubscriberTriggering(long timestampMs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(timestampMs);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void cancelAlarmForSubscriberTriggering() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean checkPermission(String permission2, int pid, int uid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(permission2);
                    _data.writeInt(pid);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IStatsCompanionService {
        @Override
        public void statsdReady() throws RemoteException {
        }

        @Override
        public void setAnomalyAlarm(long timestampMs) throws RemoteException {
        }

        @Override
        public void cancelAnomalyAlarm() throws RemoteException {
        }

        @Override
        public void setPullingAlarm(long nextPullTimeMs) throws RemoteException {
        }

        @Override
        public void cancelPullingAlarm() throws RemoteException {
        }

        @Override
        public void setAlarmForSubscriberTriggering(long timestampMs) throws RemoteException {
        }

        @Override
        public void cancelAlarmForSubscriberTriggering() throws RemoteException {
        }

        @Override
        public boolean checkPermission(String permission2, int pid, int uid) throws RemoteException {
            return false;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

