/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.app.ActivityThread;
import android.app.Instrumentation;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.PerfettoTrace;
import android.os.Process;
import android.os.SystemClock;
import android.os.UserHandle;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodRedirect;
import android.ravenwood.annotation.RavenwoodRedirectionClass;
import android.ravenwood.annotation.RavenwoodReplace;
import android.ravenwood.annotation.RavenwoodThrow;
import android.util.Log;
import android.util.Printer;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import com.android.internal.hidden_from_bootclasspath.android.os.Flags;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.NeverCompile;
import java.io.FileDescriptor;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

@RavenwoodKeepWholeClass
@RavenwoodRedirectionClass(value="MessageQueue_ravenwood")
public class MessageQueue {
    private static final String TAG_L = "LegacyMessageQueue";
    private static final String TAG_C = "ConcurrentMessageQueue";
    private static final boolean DEBUG = false;
    private static final boolean TRACE = false;
    @UnsupportedAppUsage
    private final boolean mQuitAllowed;
    @UnsupportedAppUsage
    private long mPtr;
    @UnsupportedAppUsage(maxTargetSdk=36, publicAlternatives="To manipulate the queue in Instrumentation tests, use {@link android.os.TestLooperManager}")
    Message mMessages;
    private Message mLast;
    @UnsupportedAppUsage
    private final ArrayList<IdleHandler> mIdleHandlers = new ArrayList();
    private SparseArray<FileDescriptorRecord> mFileDescriptorRecords;
    private IdleHandler[] mPendingIdleHandlers;
    private boolean mQuitting;
    private boolean mBlocked;
    private int mAsyncMessageCount;
    private final AtomicLong mMessageCount = new AtomicLong();
    private final String mThreadName;
    private final long mTid;
    private final boolean mUseConcurrent;
    private static Boolean sIsProcessAllowedToUseConcurrent;
    private final MatchDeliverableMessages mMatchDeliverableMessages = new MatchDeliverableMessages();
    private static final AtomicLong mMessagesDelivered;
    private int mNextPollTimeoutMillis;
    private boolean mMessageDirectlyQueued;
    private final MatchHandlerWhatAndObject mMatchHandlerWhatAndObject = new MatchHandlerWhatAndObject();
    private final MatchHandlerWhatAndObjectEquals mMatchHandlerWhatAndObjectEquals = new MatchHandlerWhatAndObjectEquals();
    private final MatchHandlerRunnableAndObject mMatchHandlerRunnableAndObject = new MatchHandlerRunnableAndObject();
    private final MatchHandler mMatchHandler = new MatchHandler();
    private final MatchHandlerRunnableAndObjectEquals mMatchHandlerRunnableAndObjectEquals = new MatchHandlerRunnableAndObjectEquals();
    private final MatchHandlerAndObject mMatchHandlerAndObject = new MatchHandlerAndObject();
    private final MatchHandlerAndObjectEquals mMatchHandlerAndObjectEquals = new MatchHandlerAndObjectEquals();
    private final MatchAllMessages mMatchAllMessages = new MatchAllMessages();
    private final MatchAllFutureMessages mMatchAllFutureMessages = new MatchAllFutureMessages();
    private static final int STACK_NODE_MESSAGE = 0;
    private static final int STACK_NODE_ACTIVE = 1;
    private static final int STACK_NODE_PARKED = 2;
    private static final int STACK_NODE_TIMEDPARK = 3;
    private static final StateNode sStackStateActive;
    private static final StateNode sStackStateParked;
    private final TimedParkStateNode mStackStateTimedPark = new TimedParkStateNode();
    private static final VarHandle sState;
    private volatile StackNode mStateValue = sStackStateParked;
    private final ConcurrentSkipListSet<MessageNode> mPriorityQueue = new ConcurrentSkipListSet();
    private final ConcurrentSkipListSet<MessageNode> mAsyncPriorityQueue = new ConcurrentSkipListSet();
    private static final VarHandle sNextInsertSeq;
    private volatile long mNextInsertSeqValue = 0L;
    private static final VarHandle sNextFrontInsertSeq;
    private volatile long mNextFrontInsertSeqValue = -1L;
    private final MessageCounts mMessageCounts = new MessageCounts();
    private final Object mIdleHandlersLock = new Object();
    private final Object mFileDescriptorRecordsLock = new Object();
    private static final VarHandle sQuitting;
    private boolean mQuittingValue = false;
    private final AtomicInteger mNextBarrierTokenAtomic = new AtomicInteger(1);
    @UnsupportedAppUsage
    private int mNextBarrierToken;
    private final ReentrantLock mDrainingLock = new ReentrantLock();
    private boolean mNextIsDrainingStack = false;
    private final Condition mDrainCompleted = this.mDrainingLock.newCondition();

    @RavenwoodRedirect
    private static long nativeInit() {
        return OverrideMethod.invokeL("android.os.MessageQueue#nativeInit()J", true, null);
    }

    @RavenwoodRedirect
    private static void nativeDestroy(long l) {
        OverrideMethod.invokeV("android.os.MessageQueue#nativeDestroy(J)V", true, null);
    }

    @UnsupportedAppUsage
    @RavenwoodRedirect
    private void nativePollOnce(long l, int n) {
        OverrideMethod.invokeV("android.os.MessageQueue#nativePollOnce(JI)V", true, this);
    }

    @RavenwoodRedirect
    private static void nativeWake(long l) {
        OverrideMethod.invokeV("android.os.MessageQueue#nativeWake(J)V", true, null);
    }

    @RavenwoodRedirect
    private static boolean nativeIsPolling(long l) {
        return OverrideMethod.invokeI("android.os.MessageQueue#nativeIsPolling(J)Z", true, null) != 0;
    }

    @RavenwoodRedirect
    private static void nativeSetFileDescriptorEvents(long l, int n, int n2) {
        OverrideMethod.invokeV("android.os.MessageQueue#nativeSetFileDescriptorEvents(JII)V", true, null);
    }

    MessageQueue(boolean quitAllowed) {
        MessageQueue.initIsProcessAllowedToUseConcurrent();
        this.mUseConcurrent = sIsProcessAllowedToUseConcurrent;
        this.mQuitAllowed = quitAllowed;
        this.mPtr = MessageQueue.nativeInit();
        this.mThreadName = Thread.currentThread().getName();
        this.mTid = Process.myTid();
    }

    private static void initIsProcessAllowedToUseConcurrent() {
        String processName;
        if (sIsProcessAllowedToUseConcurrent != null) {
            return;
        }
        if (Flags.messageQueueForceLegacy()) {
            sIsProcessAllowedToUseConcurrent = false;
            return;
        }
        if (Flags.forceConcurrentMessageQueue()) {
            try {
                Class.forName("org.robolectric.Robolectric");
            }
            catch (ClassNotFoundException e) {
                sIsProcessAllowedToUseConcurrent = true;
                return;
            }
        }
        if ((processName = Process.myProcessName()) == null) {
            sIsProcessAllowedToUseConcurrent = false;
            return;
        }
        sIsProcessAllowedToUseConcurrent = UserHandle.isCore(Process.myUid());
        if (sIsProcessAllowedToUseConcurrent.booleanValue()) {
            if (processName.contains("test") || processName.contains("Test")) {
                sIsProcessAllowedToUseConcurrent = false;
            }
        } else {
            sIsProcessAllowedToUseConcurrent = processName.equals("com.android.systemui") || processName.startsWith("com.android.systemui:");
        }
    }

    @RavenwoodReplace
    private static void throwIfNotTest() {
        ActivityThread activityThread = ActivityThread.currentActivityThread();
        if (activityThread == null) {
            return;
        }
        Instrumentation instrumentation = activityThread.getInstrumentation();
        if (instrumentation == null) {
            return;
        }
        if (instrumentation.isInstrumenting()) {
            return;
        }
        throw new IllegalStateException("Test-only API called not from a test!");
    }

    private static void throwIfNotTest$ravenwood() {
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    private void decAndTraceMessageCount() {
        this.mMessageCount.decrementAndGet();
        this.traceMessageCount();
    }

    private void incAndTraceMessageCount(Message msg, long when) {
        this.mMessageCount.incrementAndGet();
        msg.mSendingThreadName = Thread.currentThread().getName();
        msg.mEventId.set(PerfettoTrace.getFlowId());
        this.traceMessageCount();
        PerfettoTrace.instant(PerfettoTrace.MQ_CATEGORY, "message_queue_send").setFlow(msg.mEventId.get()).beginProto().beginNested(2004L).addField(2L, this.mThreadName).addField(3L, msg.what).addField(4L, when - SystemClock.uptimeMillis()).endNested().endProto().emit();
    }

    private void traceMessageCount() {
        PerfettoTrace.counter(PerfettoTrace.MQ_CATEGORY, this.mMessageCount.get()).usingThreadCounterTrack(this.mTid, this.mThreadName).emit();
    }

    private void dispose() {
        if (this.mPtr != 0L) {
            MessageQueue.nativeDestroy(this.mPtr);
            this.mPtr = 0L;
        }
    }

    private boolean isIdleConcurrent() {
        long now = SystemClock.uptimeMillis();
        if (this.stackHasMessages(null, 0, null, null, now, this.mMatchDeliverableMessages, false)) {
            return false;
        }
        MessageNode msgNode = null;
        MessageNode asyncMsgNode = null;
        if (!this.mPriorityQueue.isEmpty()) {
            try {
                msgNode = this.mPriorityQueue.first();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        if (!this.mAsyncPriorityQueue.isEmpty()) {
            try {
                asyncMsgNode = this.mAsyncPriorityQueue.first();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return (msgNode == null || msgNode.getWhen() > now) && (asyncMsgNode == null || asyncMsgNode.getWhen() > now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isIdleLegacy() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            long now = SystemClock.uptimeMillis();
            return this.mMessages == null || now < this.mMessages.when;
        }
    }

    public boolean isIdle() {
        if (this.mUseConcurrent) {
            return this.isIdleConcurrent();
        }
        return this.isIdleLegacy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIdleHandlerConcurrent(@NonNull IdleHandler handler) {
        Object object = this.mIdleHandlersLock;
        synchronized (object) {
            this.mIdleHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIdleHandlerLegacy(@NonNull IdleHandler handler) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.mIdleHandlers.add(handler);
        }
    }

    public void addIdleHandler(@NonNull IdleHandler handler) {
        if (handler == null) {
            throw new NullPointerException("Can't add a null IdleHandler");
        }
        if (this.mUseConcurrent) {
            this.addIdleHandlerConcurrent(handler);
        } else {
            this.addIdleHandlerLegacy(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeIdleHandlerConcurrent(@NonNull IdleHandler handler) {
        Object object = this.mIdleHandlersLock;
        synchronized (object) {
            this.mIdleHandlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeIdleHandlerLegacy(@NonNull IdleHandler handler) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.mIdleHandlers.remove(handler);
        }
    }

    public void removeIdleHandler(@NonNull IdleHandler handler) {
        if (this.mUseConcurrent) {
            this.removeIdleHandlerConcurrent(handler);
        } else {
            this.removeIdleHandlerLegacy(handler);
        }
    }

    private boolean isPollingConcurrent() {
        return !sQuitting.getVolatile(this) && MessageQueue.nativeIsPolling(this.mPtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPollingLegacy() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            return this.isPollingLocked();
        }
    }

    public boolean isPolling() {
        if (this.mUseConcurrent) {
            return this.isPollingConcurrent();
        }
        return this.isPollingLegacy();
    }

    private boolean isPollingLocked() {
        return !this.mQuitting && MessageQueue.nativeIsPolling(this.mPtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOnFileDescriptorEventListenerConcurrent(@NonNull FileDescriptor fd, int events, @NonNull OnFileDescriptorEventListener listener) {
        Object object = this.mFileDescriptorRecordsLock;
        synchronized (object) {
            this.updateOnFileDescriptorEventListenerLocked(fd, events, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOnFileDescriptorEventListenerLegacy(@NonNull FileDescriptor fd, int events, @NonNull OnFileDescriptorEventListener listener) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.updateOnFileDescriptorEventListenerLocked(fd, events, listener);
        }
    }

    @RavenwoodThrow(blockedBy={ParcelFileDescriptor.class})
    public void addOnFileDescriptorEventListener(@NonNull FileDescriptor fd, int events, @NonNull OnFileDescriptorEventListener listener) {
        if (fd == null) {
            throw new IllegalArgumentException("fd must not be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.mUseConcurrent) {
            this.addOnFileDescriptorEventListenerConcurrent(fd, events, listener);
        } else {
            this.addOnFileDescriptorEventListenerLegacy(fd, events, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOnFileDescriptorEventListenerConcurrent(@NonNull FileDescriptor fd) {
        Object object = this.mFileDescriptorRecordsLock;
        synchronized (object) {
            this.updateOnFileDescriptorEventListenerLocked(fd, 0, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOnFileDescriptorEventListenerLegacy(@NonNull FileDescriptor fd) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.updateOnFileDescriptorEventListenerLocked(fd, 0, null);
        }
    }

    @RavenwoodThrow(blockedBy={ParcelFileDescriptor.class})
    public void removeOnFileDescriptorEventListener(@NonNull FileDescriptor fd) {
        if (fd == null) {
            throw new IllegalArgumentException("fd must not be null");
        }
        if (this.mUseConcurrent) {
            this.removeOnFileDescriptorEventListenerConcurrent(fd);
        } else {
            this.removeOnFileDescriptorEventListenerLegacy(fd);
        }
    }

    @RavenwoodThrow(blockedBy={ParcelFileDescriptor.class})
    private void updateOnFileDescriptorEventListenerLocked(FileDescriptor fd, int events, OnFileDescriptorEventListener listener) {
        int fdNum = fd.getInt$();
        int index = -1;
        FileDescriptorRecord record = null;
        if (this.mFileDescriptorRecords != null && (index = this.mFileDescriptorRecords.indexOfKey(fdNum)) >= 0 && (record = this.mFileDescriptorRecords.valueAt(index)) != null && record.mEvents == events) {
            return;
        }
        if (events != 0) {
            events |= 4;
            if (record == null) {
                if (this.mFileDescriptorRecords == null) {
                    this.mFileDescriptorRecords = new SparseArray();
                }
                record = new FileDescriptorRecord(fd, events, listener);
                this.mFileDescriptorRecords.put(fdNum, record);
            } else {
                record.mListener = listener;
                record.mEvents = events;
                ++record.mSeq;
            }
            MessageQueue.nativeSetFileDescriptorEvents(this.mPtr, fdNum, events);
        } else if (record != null) {
            record.mEvents = 0;
            this.mFileDescriptorRecords.removeAt(index);
            MessageQueue.nativeSetFileDescriptorEvents(this.mPtr, fdNum, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int dispatchEvents(int fd, int events) {
        int seq;
        OnFileDescriptorEventListener listener;
        int oldWatchedEvents;
        FileDescriptorRecord record;
        Object object;
        if (this.mUseConcurrent) {
            object = this.mFileDescriptorRecordsLock;
            synchronized (object) {
                record = this.mFileDescriptorRecords.get(fd);
                if (record == null) {
                    return 0;
                }
                oldWatchedEvents = record.mEvents;
                if ((events &= oldWatchedEvents) == 0) {
                    return oldWatchedEvents;
                }
                listener = record.mListener;
                seq = record.mSeq;
            }
        }
        object = this;
        synchronized (object) {
            record = this.mFileDescriptorRecords.get(fd);
            if (record == null) {
                return 0;
            }
            oldWatchedEvents = record.mEvents;
            if ((events &= oldWatchedEvents) == 0) {
                return oldWatchedEvents;
            }
            listener = record.mListener;
            seq = record.mSeq;
        }
        int newWatchedEvents = listener.onFileDescriptorEvents(record.mDescriptor, events);
        if (newWatchedEvents != 0) {
            newWatchedEvents |= 4;
        }
        if (newWatchedEvents != oldWatchedEvents) {
            if (this.mUseConcurrent) {
                Object object2 = this.mFileDescriptorRecordsLock;
                synchronized (object2) {
                    int index = this.mFileDescriptorRecords.indexOfKey(fd);
                    if (index >= 0 && this.mFileDescriptorRecords.valueAt(index) == record && record.mSeq == seq) {
                        record.mEvents = newWatchedEvents;
                        if (newWatchedEvents == 0) {
                            this.mFileDescriptorRecords.removeAt(index);
                        }
                    }
                }
            }
            MessageQueue messageQueue = this;
            synchronized (messageQueue) {
                int index = this.mFileDescriptorRecords.indexOfKey(fd);
                if (index >= 0 && this.mFileDescriptorRecords.valueAt(index) == record && record.mSeq == seq) {
                    record.mEvents = newWatchedEvents;
                    if (newWatchedEvents == 0) {
                        this.mFileDescriptorRecords.removeAt(index);
                    }
                }
            }
        }
        return newWatchedEvents;
    }

    private Message nextMessage(boolean peek, boolean returnEarliest) {
        block11: {
            MessageNode found;
            boolean i = false;
            while (true) {
                this.mDrainingLock.lock();
                this.mNextIsDrainingStack = true;
                this.mDrainingLock.unlock();
                StackNode oldTop = this.swapAndSetStackStateActive();
                this.drainStack(oldTop);
                this.mDrainingLock.lock();
                this.mNextIsDrainingStack = false;
                this.mDrainCompleted.signalAll();
                this.mDrainingLock.unlock();
                Iterator<MessageNode> queueIter = this.mPriorityQueue.iterator();
                MessageNode msgNode = this.iterateNext(queueIter);
                Iterator<MessageNode> asyncQueueIter = this.mAsyncPriorityQueue.iterator();
                MessageNode asyncMsgNode = this.iterateNext(asyncQueueIter);
                found = null;
                MessageNode next = null;
                long now = SystemClock.uptimeMillis();
                if (msgNode != null && msgNode.isBarrier()) {
                    if (asyncMsgNode != null && (returnEarliest || now >= asyncMsgNode.getWhen())) {
                        found = asyncMsgNode;
                    } else {
                        next = asyncMsgNode;
                    }
                } else {
                    MessageNode earliest = this.pickEarliestNode(msgNode, asyncMsgNode);
                    if (earliest != null) {
                        if (returnEarliest || now >= earliest.getWhen()) {
                            found = earliest;
                        } else {
                            next = earliest;
                        }
                    }
                }
                StateNode nextOp = sStackStateActive;
                if (found == null) {
                    if (next == null) {
                        this.mNextPollTimeoutMillis = -1;
                        nextOp = sStackStateParked;
                    } else {
                        long nextMessageWhen = next.getWhen();
                        this.mNextPollTimeoutMillis = nextMessageWhen > now ? (int)Math.min(nextMessageWhen - now, Integer.MAX_VALUE) : 0;
                        this.mStackStateTimedPark.mWhenToWake = now + (long)this.mNextPollTimeoutMillis;
                        nextOp = this.mStackStateTimedPark;
                    }
                }
                if (!sState.compareAndSet(this, sStackStateActive, nextOp)) continue;
                this.mMessageCounts.clearCounts();
                if (found == null) break block11;
                if (peek || this.removeFromPriorityQueue(found)) break;
            }
            return found.mMessage;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message nextConcurrent() {
        long ptr = this.mPtr;
        if (ptr == 0L) {
            return null;
        }
        this.mNextPollTimeoutMillis = 0;
        int pendingIdleHandlerCount = -1;
        while (true) {
            if (this.mNextPollTimeoutMillis != 0) {
                Binder.flushPendingCommands();
            }
            this.mMessageDirectlyQueued = false;
            this.nativePollOnce(ptr, this.mNextPollTimeoutMillis);
            Message msg = this.nextMessage(false, false);
            if (msg != null) {
                msg.markInUse();
                this.decAndTraceMessageCount();
                return msg;
            }
            if (sQuitting.getVolatile(this)) {
                return null;
            }
            Object object = this.mIdleHandlersLock;
            synchronized (object) {
                if (pendingIdleHandlerCount < 0 && this.isIdle()) {
                    pendingIdleHandlerCount = this.mIdleHandlers.size();
                }
                if (pendingIdleHandlerCount <= 0) {
                    continue;
                }
                if (this.mPendingIdleHandlers == null) {
                    this.mPendingIdleHandlers = new IdleHandler[Math.max(pendingIdleHandlerCount, 4)];
                }
                this.mPendingIdleHandlers = this.mIdleHandlers.toArray(this.mPendingIdleHandlers);
            }
            for (int i = 0; i < pendingIdleHandlerCount; ++i) {
                IdleHandler idler = this.mPendingIdleHandlers[i];
                this.mPendingIdleHandlers[i] = null;
                boolean keep = false;
                try {
                    keep = idler.queueIdle();
                }
                catch (Throwable t) {
                    Log.wtf(TAG_C, "IdleHandler threw exception", t);
                }
                if (keep) continue;
                Object object2 = this.mIdleHandlersLock;
                synchronized (object2) {
                    this.mIdleHandlers.remove(idler);
                    continue;
                }
            }
            pendingIdleHandlerCount = 0;
            this.mNextPollTimeoutMillis = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Message nextLegacy() {
        long ptr = this.mPtr;
        if (ptr == 0L) {
            return null;
        }
        int pendingIdleHandlerCount = -1;
        int nextPollTimeoutMillis = 0;
        while (true) {
            if (nextPollTimeoutMillis != 0) {
                Binder.flushPendingCommands();
            }
            this.nativePollOnce(ptr, nextPollTimeoutMillis);
            MessageQueue messageQueue = this;
            synchronized (messageQueue) {
                long now;
                block24: {
                    block23: {
                        now = SystemClock.uptimeMillis();
                        Message prevMsg = null;
                        Message msg = this.mMessages;
                        if (msg != null && msg.target == null) {
                            do {
                                prevMsg = msg;
                            } while ((msg = msg.next) != null && !msg.isAsynchronous());
                        }
                        if (msg == null) break block23;
                        if (now < msg.when) {
                            nextPollTimeoutMillis = (int)Math.min(msg.when - now, Integer.MAX_VALUE);
                            break block24;
                        } else {
                            this.mBlocked = false;
                            if (prevMsg != null) {
                                prevMsg.next = msg.next;
                                if (prevMsg.next == null) {
                                    this.mLast = prevMsg;
                                }
                            } else {
                                this.mMessages = msg.next;
                                if (msg.next == null) {
                                    this.mLast = null;
                                }
                            }
                            msg.next = null;
                            msg.markInUse();
                            if (msg.isAsynchronous()) {
                                --this.mAsyncMessageCount;
                            }
                            this.decAndTraceMessageCount();
                            return msg;
                        }
                    }
                    nextPollTimeoutMillis = -1;
                }
                if (this.mQuitting) {
                    this.dispose();
                    return null;
                }
                if (pendingIdleHandlerCount < 0 && (this.mMessages == null || now < this.mMessages.when)) {
                    pendingIdleHandlerCount = this.mIdleHandlers.size();
                }
                if (pendingIdleHandlerCount <= 0) {
                    this.mBlocked = true;
                    continue;
                }
                if (this.mPendingIdleHandlers == null) {
                    this.mPendingIdleHandlers = new IdleHandler[Math.max(pendingIdleHandlerCount, 4)];
                }
                this.mPendingIdleHandlers = this.mIdleHandlers.toArray(this.mPendingIdleHandlers);
            }
            for (int i = 0; i < pendingIdleHandlerCount; ++i) {
                IdleHandler idler = this.mPendingIdleHandlers[i];
                this.mPendingIdleHandlers[i] = null;
                boolean keep = false;
                try {
                    keep = idler.queueIdle();
                }
                catch (Throwable t) {
                    Log.wtf(TAG_L, "IdleHandler threw exception", t);
                }
                if (keep) continue;
                MessageQueue messageQueue2 = this;
                synchronized (messageQueue2) {
                    this.mIdleHandlers.remove(idler);
                    continue;
                }
            }
            pendingIdleHandlerCount = 0;
            nextPollTimeoutMillis = 0;
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=36, publicAlternatives="To manipulate the queue in Instrumentation tests, use {@link android.os.TestLooperManager}")
    Message next() {
        if (this.mUseConcurrent) {
            return this.nextConcurrent();
        }
        return this.nextLegacy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void quit(boolean safe) {
        if (!this.mQuitAllowed) {
            throw new IllegalStateException("Main thread not allowed to quit.");
        }
        if (this.mUseConcurrent) {
            Object object = this.mIdleHandlersLock;
            synchronized (object) {
                if (sQuitting.compareAndSet(this, false, true)) {
                    if (safe) {
                        this.removeAllFutureMessages();
                    } else {
                        this.removeAllMessages();
                    }
                    MessageQueue.nativeWake(this.mPtr);
                }
            }
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            if (this.mQuitting) {
                return;
            }
            this.mQuitting = true;
            if (safe) {
                this.removeAllFutureMessagesLocked();
            } else {
                this.removeAllMessagesLocked();
            }
            MessageQueue.nativeWake(this.mPtr);
        }
    }

    private int postSyncBarrierConcurrent() {
        return this.postSyncBarrier(SystemClock.uptimeMillis());
    }

    private int postSyncBarrierLegacy() {
        return this.postSyncBarrier(SystemClock.uptimeMillis());
    }

    @UnsupportedAppUsage
    public int postSyncBarrier() {
        if (this.mUseConcurrent) {
            return this.postSyncBarrierConcurrent();
        }
        return this.postSyncBarrierLegacy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int postSyncBarrier(long when) {
        if (this.mUseConcurrent) {
            int token = this.mNextBarrierTokenAtomic.getAndIncrement();
            this.mNextBarrierToken = token + 1;
            Message msg = Message.obtain();
            msg.markInUse();
            msg.arg1 = token;
            if (!this.enqueueMessageUnchecked(msg, when)) {
                Log.wtf(TAG_C, "Unexpected error while adding sync barrier!");
                return -1;
            }
            return token;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            int token = this.mNextBarrierToken++;
            Message msg = Message.obtain();
            msg.markInUse();
            msg.when = when;
            msg.arg1 = token;
            if (Flags.messageQueueTailTracking() && this.mLast != null && this.mLast.when <= when) {
                this.mLast.next = msg;
                this.mLast = msg;
                msg.next = null;
                return token;
            }
            Message prev = null;
            Message p = this.mMessages;
            if (when != 0L) {
                while (p != null && p.when <= when) {
                    prev = p;
                    p = p.next;
                }
            }
            if (p == null) {
                this.mLast = msg;
            }
            if (prev != null) {
                msg.next = p;
                prev.next = msg;
            } else {
                msg.next = p;
                this.mMessages = msg;
            }
            return token;
        }
    }

    private void removeSyncBarrierConcurrent(int token) {
        MessageNode first;
        MatchBarrierToken matchBarrierToken = new MatchBarrierToken(token);
        try {
            first = this.mPriorityQueue.first();
        }
        catch (NoSuchElementException e) {
            first = null;
        }
        boolean removed = this.findOrRemoveMessages(null, 0, null, null, 0L, matchBarrierToken, true);
        if (removed && first != null) {
            Message m = first.mMessage;
            if (m.target == null && m.arg1 == token) {
                MessageQueue.nativeWake(this.mPtr);
            }
        } else if (!removed) {
            throw new IllegalStateException("The specified message queue synchronization  barrier token has not been posted or has already been removed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSyncBarrierLegacy(int token) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            boolean needWake;
            Message prev = null;
            Message p = this.mMessages;
            while (p != null && (p.target != null || p.arg1 != token)) {
                prev = p;
                p = p.next;
            }
            if (p == null) {
                throw new IllegalStateException("The specified message queue synchronization  barrier token has not been posted or has already been removed.");
            }
            if (prev != null) {
                prev.next = p.next;
                if (prev.next == null) {
                    this.mLast = prev;
                }
                needWake = false;
            } else {
                this.mMessages = p.next;
                if (this.mMessages == null) {
                    this.mLast = null;
                }
                needWake = this.mMessages == null || this.mMessages.target != null;
            }
            p.recycleUnchecked();
            this.decAndTraceMessageCount();
            if (needWake && !this.mQuitting) {
                MessageQueue.nativeWake(this.mPtr);
            }
        }
    }

    @UnsupportedAppUsage
    public void removeSyncBarrier(int token) {
        if (this.mUseConcurrent) {
            this.removeSyncBarrierConcurrent(token);
        } else {
            this.removeSyncBarrierLegacy(token);
        }
    }

    private boolean enqueueMessageConcurrent(Message msg, long when) {
        if (msg.isInUse()) {
            throw new IllegalStateException(msg + " This message is already in use.");
        }
        return this.enqueueMessageUnchecked(msg, when);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enqueueMessageLegacy(Message msg, long when) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            boolean needWake;
            if (msg.isInUse()) {
                throw new IllegalStateException(msg + " This message is already in use.");
            }
            if (this.mQuitting) {
                IllegalStateException e = new IllegalStateException(msg.target + " sending message to a Handler on a dead thread");
                Log.w(TAG_L, e.getMessage(), e);
                msg.recycle();
                return false;
            }
            msg.markInUse();
            msg.when = when;
            this.incAndTraceMessageCount(msg, when);
            Message p = this.mMessages;
            if (p == null || when == 0L || when < p.when) {
                msg.next = p;
                this.mMessages = msg;
                needWake = this.mBlocked;
                if (p == null) {
                    this.mLast = this.mMessages;
                }
            } else {
                boolean bl = needWake = this.mBlocked && p.target == null && msg.isAsynchronous();
                if (Flags.messageQueueTailTracking()) {
                    if (when >= this.mLast.when) {
                        needWake = needWake && this.mAsyncMessageCount == 0;
                        msg.next = null;
                        this.mLast.next = msg;
                        this.mLast = msg;
                    } else {
                        while (true) {
                            Message prev = p;
                            p = p.next;
                            if (p == null || when < p.when) break;
                            if (!needWake || !p.isAsynchronous()) continue;
                            needWake = false;
                        }
                        if (p == null) {
                            this.mLast = msg;
                        }
                        msg.next = p;
                        prev.next = msg;
                    }
                } else {
                    while (true) {
                        Message prev = p;
                        p = p.next;
                        if (p == null || when < p.when) break;
                        if (!needWake || !p.isAsynchronous()) continue;
                        needWake = false;
                    }
                    msg.next = p;
                    prev.next = msg;
                    this.mLast = null;
                }
            }
            if (msg.isAsynchronous()) {
                ++this.mAsyncMessageCount;
            }
            if (needWake) {
                MessageQueue.nativeWake(this.mPtr);
            }
        }
        return true;
    }

    boolean enqueueMessage(Message msg, long when) {
        if (msg.target == null) {
            throw new IllegalArgumentException("Message must have a target.");
        }
        if (this.mUseConcurrent) {
            return this.enqueueMessageConcurrent(msg, when);
        }
        return this.enqueueMessageLegacy(msg, when);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message legacyPeekOrPoll(boolean peek) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            long now = SystemClock.uptimeMillis();
            Message prevMsg = null;
            Message msg = this.mMessages;
            if (msg != null && msg.target == null) {
                do {
                    prevMsg = msg;
                } while ((msg = msg.next) != null && !msg.isAsynchronous());
            }
            if (msg != null) {
                if (peek) {
                    return msg;
                }
                if (now >= msg.when) {
                    this.mBlocked = false;
                }
                if (prevMsg != null) {
                    prevMsg.next = msg.next;
                    if (prevMsg.next == null) {
                        this.mLast = prevMsg;
                    }
                } else {
                    this.mMessages = msg.next;
                    if (msg.next == null) {
                        this.mLast = null;
                    }
                }
                msg.next = null;
                msg.markInUse();
                if (msg.isAsynchronous()) {
                    --this.mAsyncMessageCount;
                }
                this.decAndTraceMessageCount();
                return msg;
            }
        }
        return null;
    }

    @SuppressLint(value={"VisiblySynchronized"})
    Long peekWhenForTest() {
        MessageQueue.throwIfNotTest();
        Message ret = this.mUseConcurrent ? this.nextMessage(true, true) : this.legacyPeekOrPoll(true);
        return ret != null ? Long.valueOf(ret.when) : null;
    }

    @SuppressLint(value={"VisiblySynchronized"})
    @Nullable
    Message pollForTest() {
        MessageQueue.throwIfNotTest();
        if (this.mUseConcurrent) {
            return this.nextMessage(false, true);
        }
        return this.legacyPeekOrPoll(false);
    }

    boolean isBlockedOnSyncBarrier() {
        MessageQueue.throwIfNotTest();
        if (this.mUseConcurrent) {
            this.nextMessage(true, false);
            Iterator<MessageNode> queueIter = this.mPriorityQueue.iterator();
            MessageNode queueNode = this.iterateNext(queueIter);
            return queueNode != null && queueNode.isBarrier();
        }
        Message msg = this.mMessages;
        return msg != null && msg.target == null;
    }

    private boolean hasMessagesConcurrent(Handler h, int what, Object object) {
        return this.findOrRemoveMessages(h, what, object, null, 0L, this.mMatchHandlerWhatAndObject, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasMessagesLegacy(Handler h, int what, Object object) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message p = this.mMessages;
            while (p != null) {
                if (p.target == h && p.what == what && (object == null || p.obj == object)) {
                    return true;
                }
                p = p.next;
            }
            return false;
        }
    }

    boolean hasMessages(Handler h, int what, Object object) {
        if (h == null) {
            return false;
        }
        if (this.mUseConcurrent) {
            return this.hasMessagesConcurrent(h, what, object);
        }
        return this.hasMessagesLegacy(h, what, object);
    }

    private boolean hasEqualMessagesConcurrent(Handler h, int what, Object object) {
        return this.findOrRemoveMessages(h, what, object, null, 0L, this.mMatchHandlerWhatAndObjectEquals, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasEqualMessagesLegacy(Handler h, int what, Object object) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message p = this.mMessages;
            while (p != null) {
                if (p.target == h && p.what == what && (object == null || object.equals(p.obj))) {
                    return true;
                }
                p = p.next;
            }
            return false;
        }
    }

    boolean hasEqualMessages(Handler h, int what, Object object) {
        if (h == null) {
            return false;
        }
        if (this.mUseConcurrent) {
            return this.hasEqualMessagesConcurrent(h, what, object);
        }
        return this.hasEqualMessagesLegacy(h, what, object);
    }

    private boolean hasMessagesConcurrent(Handler h, Runnable r, Object object) {
        return this.findOrRemoveMessages(h, -1, object, r, 0L, this.mMatchHandlerRunnableAndObject, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasMessagesLegacy(Handler h, Runnable r, Object object) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message p = this.mMessages;
            while (p != null) {
                if (p.target == h && p.callback == r && (object == null || p.obj == object)) {
                    return true;
                }
                p = p.next;
            }
            return false;
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    boolean hasMessages(Handler h, Runnable r, Object object) {
        if (h == null) {
            return false;
        }
        if (this.mUseConcurrent) {
            return this.hasMessagesConcurrent(h, r, object);
        }
        return this.hasMessagesLegacy(h, r, object);
    }

    private boolean hasMessagesConcurrent(Handler h) {
        return this.findOrRemoveMessages(h, -1, null, null, 0L, this.mMatchHandler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasMessagesLegacy(Handler h) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message p = this.mMessages;
            while (p != null) {
                if (p.target == h) {
                    return true;
                }
                p = p.next;
            }
            return false;
        }
    }

    boolean hasMessages(Handler h) {
        if (h == null) {
            return false;
        }
        if (this.mUseConcurrent) {
            return this.hasMessagesConcurrent(h);
        }
        return this.hasMessagesLegacy(h);
    }

    private void removeMessagesConcurrent(Handler h, int what, Object object) {
        this.findOrRemoveMessages(h, what, object, null, 0L, this.mMatchHandlerWhatAndObject, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMessagesLegacy(Handler h, int what, Object object) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && p.what == what && (object == null || p.obj == object)) {
                this.mMessages = n = p.next;
                if (p.isAsynchronous()) {
                    --this.mAsyncMessageCount;
                }
                p.recycleUnchecked();
                this.decAndTraceMessageCount();
                p = n;
            }
            if (p == null) {
                this.mLast = this.mMessages;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && n.what == what && (object == null || n.obj == object)) {
                    Message nn = n.next;
                    if (n.isAsynchronous()) {
                        --this.mAsyncMessageCount;
                    }
                    n.recycleUnchecked();
                    this.decAndTraceMessageCount();
                    p.next = nn;
                    if (p.next != null) continue;
                    this.mLast = p;
                    continue;
                }
                p = n;
            }
        }
    }

    void removeMessages(Handler h, int what, Object object) {
        if (h == null) {
            return;
        }
        if (this.mUseConcurrent) {
            this.removeMessagesConcurrent(h, what, object);
        } else {
            this.removeMessagesLegacy(h, what, object);
        }
    }

    private void removeEqualMessagesConcurrent(Handler h, int what, Object object) {
        this.findOrRemoveMessages(h, what, object, null, 0L, this.mMatchHandlerWhatAndObjectEquals, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEqualMessagesLegacy(Handler h, int what, Object object) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && p.what == what && (object == null || object.equals(p.obj))) {
                this.mMessages = n = p.next;
                if (p.isAsynchronous()) {
                    --this.mAsyncMessageCount;
                }
                p.recycleUnchecked();
                p = n;
            }
            if (p == null) {
                this.mLast = this.mMessages;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && n.what == what && (object == null || object.equals(n.obj))) {
                    Message nn = n.next;
                    if (n.isAsynchronous()) {
                        --this.mAsyncMessageCount;
                    }
                    n.recycleUnchecked();
                    this.decAndTraceMessageCount();
                    p.next = nn;
                    if (p.next != null) continue;
                    this.mLast = p;
                    continue;
                }
                p = n;
            }
        }
    }

    void removeEqualMessages(Handler h, int what, Object object) {
        if (h == null) {
            return;
        }
        if (this.mUseConcurrent) {
            this.removeEqualMessagesConcurrent(h, what, object);
        } else {
            this.removeEqualMessagesLegacy(h, what, object);
        }
    }

    private void removeMessagesConcurrent(Handler h, Runnable r, Object object) {
        this.findOrRemoveMessages(h, -1, object, r, 0L, this.mMatchHandlerRunnableAndObject, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMessagesLegacy(Handler h, Runnable r, Object object) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && p.callback == r && (object == null || p.obj == object)) {
                this.mMessages = n = p.next;
                if (p.isAsynchronous()) {
                    --this.mAsyncMessageCount;
                }
                p.recycleUnchecked();
                this.decAndTraceMessageCount();
                p = n;
            }
            if (p == null) {
                this.mLast = this.mMessages;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && n.callback == r && (object == null || n.obj == object)) {
                    Message nn = n.next;
                    if (n.isAsynchronous()) {
                        --this.mAsyncMessageCount;
                    }
                    n.recycleUnchecked();
                    this.decAndTraceMessageCount();
                    p.next = nn;
                    if (p.next != null) continue;
                    this.mLast = p;
                    continue;
                }
                p = n;
            }
        }
    }

    void removeMessages(Handler h, Runnable r, Object object) {
        if (h == null || r == null) {
            return;
        }
        if (this.mUseConcurrent) {
            this.removeMessagesConcurrent(h, r, object);
        } else {
            this.removeMessagesLegacy(h, r, object);
        }
    }

    private void removeEqualMessagesConcurrent(Handler h, Runnable r, Object object) {
        this.findOrRemoveMessages(h, -1, object, r, 0L, this.mMatchHandlerRunnableAndObjectEquals, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEqualMessagesLegacy(Handler h, Runnable r, Object object) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && p.callback == r && (object == null || object.equals(p.obj))) {
                this.mMessages = n = p.next;
                if (p.isAsynchronous()) {
                    --this.mAsyncMessageCount;
                }
                p.recycleUnchecked();
                this.decAndTraceMessageCount();
                p = n;
            }
            if (p == null) {
                this.mLast = this.mMessages;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && n.callback == r && (object == null || object.equals(n.obj))) {
                    Message nn = n.next;
                    if (n.isAsynchronous()) {
                        --this.mAsyncMessageCount;
                    }
                    n.recycleUnchecked();
                    this.decAndTraceMessageCount();
                    p.next = nn;
                    if (p.next != null) continue;
                    this.mLast = p;
                    continue;
                }
                p = n;
            }
        }
    }

    void removeEqualMessages(Handler h, Runnable r, Object object) {
        if (h == null || r == null) {
            return;
        }
        if (this.mUseConcurrent) {
            this.removeEqualMessagesConcurrent(h, r, object);
        } else {
            this.removeEqualMessagesLegacy(h, r, object);
        }
    }

    private void removeCallbacksAndMessagesConcurrent(Handler h, Object object) {
        this.findOrRemoveMessages(h, -1, object, null, 0L, this.mMatchHandlerAndObject, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCallbacksAndMessagesLegacy(Handler h, Object object) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && (object == null || p.obj == object)) {
                this.mMessages = n = p.next;
                if (p.isAsynchronous()) {
                    --this.mAsyncMessageCount;
                }
                p.recycleUnchecked();
                this.decAndTraceMessageCount();
                p = n;
            }
            if (p == null) {
                this.mLast = this.mMessages;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && (object == null || n.obj == object)) {
                    Message nn = n.next;
                    if (n.isAsynchronous()) {
                        --this.mAsyncMessageCount;
                    }
                    n.recycleUnchecked();
                    this.decAndTraceMessageCount();
                    p.next = nn;
                    if (p.next != null) continue;
                    this.mLast = p;
                    continue;
                }
                p = n;
            }
        }
    }

    void removeCallbacksAndMessages(Handler h, Object object) {
        if (h == null) {
            return;
        }
        if (this.mUseConcurrent) {
            this.removeCallbacksAndMessagesConcurrent(h, object);
        } else {
            this.removeCallbacksAndMessagesLegacy(h, object);
        }
    }

    void removeCallbacksAndEqualMessagesConcurrent(Handler h, Object object) {
        this.findOrRemoveMessages(h, -1, object, null, 0L, this.mMatchHandlerAndObjectEquals, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCallbacksAndEqualMessagesLegacy(Handler h, Object object) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && (object == null || object.equals(p.obj))) {
                this.mMessages = n = p.next;
                if (p.isAsynchronous()) {
                    --this.mAsyncMessageCount;
                }
                p.recycleUnchecked();
                this.decAndTraceMessageCount();
                p = n;
            }
            if (p == null) {
                this.mLast = this.mMessages;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && (object == null || object.equals(n.obj))) {
                    Message nn = n.next;
                    if (n.isAsynchronous()) {
                        --this.mAsyncMessageCount;
                    }
                    n.recycleUnchecked();
                    this.decAndTraceMessageCount();
                    p.next = nn;
                    if (p.next != null) continue;
                    this.mLast = p;
                    continue;
                }
                p = n;
            }
        }
    }

    void removeCallbacksAndEqualMessages(Handler h, Object object) {
        if (h == null) {
            return;
        }
        if (this.mUseConcurrent) {
            this.removeCallbacksAndEqualMessagesConcurrent(h, object);
        } else {
            this.removeCallbacksAndEqualMessagesLegacy(h, object);
        }
    }

    private void removeAllMessagesLocked() {
        Message p = this.mMessages;
        while (p != null) {
            Message n = p.next;
            p.recycleUnchecked();
            p = n;
        }
        this.mMessages = null;
        this.mLast = null;
        this.mAsyncMessageCount = 0;
        this.mMessageCount.set(0L);
        this.traceMessageCount();
    }

    private void removeAllFutureMessagesLocked() {
        long now = SystemClock.uptimeMillis();
        Message p = this.mMessages;
        if (p != null) {
            if (p.when > now) {
                this.removeAllMessagesLocked();
            } else {
                Message n;
                while (true) {
                    if ((n = p.next) == null) {
                        return;
                    }
                    if (n.when > now) break;
                    p = n;
                }
                p.next = null;
                this.mLast = p;
                do {
                    p = n;
                    n = p.next;
                    if (p.isAsynchronous()) {
                        --this.mAsyncMessageCount;
                    }
                    p.recycleUnchecked();
                    this.decAndTraceMessageCount();
                } while (n != null);
            }
        }
    }

    private void removeAllMessages() {
        this.findOrRemoveMessages(null, -1, null, null, 0L, this.mMatchAllMessages, true);
    }

    private void removeAllFutureMessages() {
        this.findOrRemoveMessages(null, -1, null, null, SystemClock.uptimeMillis(), this.mMatchAllFutureMessages, true);
    }

    @NeverCompile
    private void printPriorityQueueNodes() {
        Iterator<MessageNode> iterator = this.mPriorityQueue.iterator();
        Log.d(TAG_C, "* Dump priority queue");
        while (iterator.hasNext()) {
            MessageNode msgNode = iterator.next();
            Log.d(TAG_C, "** MessageNode what: " + msgNode.mMessage.what + " when " + msgNode.mMessage.when + " seq: " + msgNode.mInsertSeq);
        }
    }

    @NeverCompile
    private int dumpPriorityQueue(ConcurrentSkipListSet<MessageNode> queue, Printer pw, String prefix, Handler h, int n) {
        int count = 0;
        long now = SystemClock.uptimeMillis();
        for (MessageNode msgNode : queue) {
            Message msg = msgNode.mMessage;
            if (h == null || h == msg.target) {
                pw.println(prefix + "Message " + (n + count) + ": " + msg.toString(now));
            }
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NeverCompile
    void dump(Printer pw, String prefix, Handler h) {
        if (this.mUseConcurrent) {
            long now = SystemClock.uptimeMillis();
            int n = 0;
            pw.println(prefix + "(MessageQueue is using Concurrent implementation)");
            StackNode node = sState.getVolatile(this);
            while (node != null) {
                if (node.isMessageNode()) {
                    Message msg = ((MessageNode)node).mMessage;
                    if (h == null || h == msg.target) {
                        pw.println(prefix + "Message " + n + ": " + msg.toString(now));
                    }
                    node = ((MessageNode)node).mNext;
                } else {
                    pw.println(prefix + "State: " + node);
                    node = null;
                }
                ++n;
            }
            pw.println(prefix + "PriorityQueue Messages: ");
            n += this.dumpPriorityQueue(this.mPriorityQueue, pw, prefix, h, n);
            pw.println(prefix + "AsyncPriorityQueue Messages: ");
            n += this.dumpPriorityQueue(this.mAsyncPriorityQueue, pw, prefix, h, n);
            pw.println(prefix + "(Total messages: " + n + ", polling=" + this.isPolling() + ", quitting=" + sQuitting.getVolatile(this) + ")");
            return;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            pw.println(prefix + "(MessageQueue is using Legacy implementation)");
            long now = SystemClock.uptimeMillis();
            int n = 0;
            Message msg = this.mMessages;
            while (msg != null) {
                if (h == null || h == msg.target) {
                    pw.println(prefix + "Message " + n + ": " + msg.toString(now));
                }
                ++n;
                msg = msg.next;
            }
            pw.println(prefix + "(Total messages: " + n + ", polling=" + this.isPollingLocked() + ", quitting=" + this.mQuitting + ")");
        }
    }

    @NeverCompile
    private int dumpPriorityQueue(ConcurrentSkipListSet<MessageNode> queue, ProtoOutputStream proto) {
        int count = 0;
        for (MessageNode msgNode : queue) {
            Message msg = msgNode.mMessage;
            msg.dumpDebug(proto, 2246267895809L);
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NeverCompile
    void dumpDebug(ProtoOutputStream proto, long fieldId) {
        if (this.mUseConcurrent) {
            long messageQueueToken = proto.start(fieldId);
            StackNode node = sState.getVolatile(this);
            while (node.isMessageNode()) {
                Message msg = ((MessageNode)node).mMessage;
                msg.dumpDebug(proto, 2246267895809L);
                node = ((MessageNode)node).mNext;
            }
            this.dumpPriorityQueue(this.mPriorityQueue, proto);
            this.dumpPriorityQueue(this.mAsyncPriorityQueue, proto);
            proto.write(1133871366146L, this.isPolling());
            proto.write(1133871366147L, sQuitting.getVolatile(this));
            proto.end(messageQueueToken);
            return;
        }
        long messageQueueToken = proto.start(fieldId);
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message msg = this.mMessages;
            while (msg != null) {
                msg.dumpDebug(proto, 2246267895809L);
                msg = msg.next;
            }
            proto.write(1133871366146L, this.isPollingLocked());
            proto.write(1133871366147L, this.mQuitting);
        }
        proto.end(messageQueueToken);
    }

    private void insertIntoPriorityQueue(MessageNode msgNode) {
        if (msgNode.isAsync()) {
            this.mAsyncPriorityQueue.add(msgNode);
        } else {
            this.mPriorityQueue.add(msgNode);
        }
    }

    private boolean removeFromPriorityQueue(MessageNode msgNode) {
        if (msgNode.isAsync()) {
            return this.mAsyncPriorityQueue.remove(msgNode);
        }
        return this.mPriorityQueue.remove(msgNode);
    }

    private MessageNode pickEarliestNode(MessageNode nodeA, MessageNode nodeB) {
        if (nodeA != null && nodeB != null) {
            if (nodeA.compareTo(nodeB) < 0) {
                return nodeA;
            }
            return nodeB;
        }
        return nodeA != null ? nodeA : nodeB;
    }

    private MessageNode iterateNext(Iterator<MessageNode> iter) {
        if (iter.hasNext()) {
            try {
                return iter.next();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return null;
    }

    private void drainStack(StackNode oldTop) {
        while (oldTop.isMessageNode()) {
            MessageNode oldTopMessageNode = (MessageNode)oldTop;
            if (oldTopMessageNode.removeFromStack()) {
                this.insertIntoPriorityQueue(oldTopMessageNode);
            }
            MessageNode inserted = oldTopMessageNode;
            oldTop = oldTopMessageNode.mNext;
            inserted.mNext = null;
        }
    }

    private StackNode swapAndSetStackStateActive() {
        StackNode current;
        while ((current = sState.getVolatile(this)) != sStackStateActive && !sState.compareAndSet(this, current, sStackStateActive)) {
        }
        return current;
    }

    private StateNode getStateNode(StackNode node) {
        if (node.isMessageNode()) {
            return ((MessageNode)node).mBottomOfStack;
        }
        return (StateNode)node;
    }

    private void waitForDrainCompleted() {
        this.mDrainingLock.lock();
        while (this.mNextIsDrainingStack) {
            this.mDrainCompleted.awaitUninterruptibly();
        }
        this.mDrainingLock.unlock();
    }

    private boolean enqueueMessageUnchecked(@NonNull Message msg, long when) {
        boolean wakeNeeded;
        boolean inactive;
        StackNode old;
        if (sQuitting.getVolatile(this)) {
            IllegalStateException e = new IllegalStateException(msg.target + " sending message to a Handler on a dead thread");
            Log.w(TAG_C, e.getMessage(), e);
            msg.recycleUnchecked();
            return false;
        }
        long seq = when != 0L ? sNextInsertSeq.getAndAdd(this, 1L) + 1L : sNextFrontInsertSeq.getAndAdd(this, -1L) - 1L;
        MessageNode node = new MessageNode(msg, seq);
        msg.when = when;
        msg.markInUse();
        this.incAndTraceMessageCount(msg, when);
        Looper myLooper = Looper.myLooper();
        if (myLooper != null && myLooper.getQueue() == this) {
            node.removeFromStack();
            this.insertIntoPriorityQueue(node);
            if (!this.mMessageDirectlyQueued) {
                this.mMessageDirectlyQueued = true;
                MessageQueue.nativeWake(this.mPtr);
            }
            return true;
        }
        do {
            node.mNext = old = sState.getVolatile(this);
            switch (old.getNodeType()) {
                case 1: {
                    node.mBottomOfStack = (StateNode)old;
                    inactive = false;
                    node.mWokeUp = true;
                    wakeNeeded = false;
                    break;
                }
                case 2: {
                    node.mBottomOfStack = (StateNode)old;
                    inactive = true;
                    node.mWokeUp = true;
                    wakeNeeded = true;
                    break;
                }
                case 3: {
                    node.mBottomOfStack = (StateNode)old;
                    inactive = true;
                    node.mWokeUp = wakeNeeded = this.mStackStateTimedPark.mWhenToWake >= node.getWhen();
                    break;
                }
                default: {
                    MessageNode oldMessage = (MessageNode)old;
                    node.mBottomOfStack = oldMessage.mBottomOfStack;
                    int bottomType = node.mBottomOfStack.getNodeType();
                    inactive = bottomType >= 2;
                    wakeNeeded = bottomType == 3 && this.mStackStateTimedPark.mWhenToWake >= node.getWhen() && !oldMessage.mWokeUp;
                    boolean bl = node.mWokeUp = oldMessage.mWokeUp || wakeNeeded;
                }
            }
        } while (!sState.compareAndSet(this, old, node));
        if (inactive) {
            if (wakeNeeded) {
                MessageQueue.nativeWake(this.mPtr);
            } else {
                this.mMessageCounts.incrementQueued();
            }
        }
        return true;
    }

    private boolean stackHasMessages(Handler h, int what, Object object, Runnable r, long when, MessageCompare compare, boolean removeMatches) {
        StateNode bottom;
        boolean found = false;
        StackNode top = sState.getVolatile(this);
        if (top == (bottom = this.getStateNode(top))) {
            this.waitForDrainCompleted();
            return false;
        }
        MessageNode p = (MessageNode)top;
        while (true) {
            StackNode n;
            if (compare.compareMessage(p, h, what, object, r, when)) {
                found = true;
                if (!removeMatches) break;
                if (p.removeFromStack()) {
                    p.mMessage.recycleUnchecked();
                    this.decAndTraceMessageCount();
                    if (this.mMessageCounts.incrementCancelled()) {
                        MessageQueue.nativeWake(this.mPtr);
                    }
                }
            }
            if ((n = p.mNext) == null || !n.isMessageNode()) break;
            p = (MessageNode)n;
        }
        this.waitForDrainCompleted();
        return found;
    }

    private boolean priorityQueueHasMessage(ConcurrentSkipListSet<MessageNode> queue, Handler h, int what, Object object, Runnable r, long when, MessageCompare compare, boolean removeMatches) {
        Iterator<MessageNode> iterator = queue.iterator();
        boolean found = false;
        while (iterator.hasNext()) {
            MessageNode msg = iterator.next();
            if (!compare.compareMessage(msg, h, what, object, r, when)) continue;
            if (removeMatches) {
                found = true;
                if (!queue.remove(msg)) continue;
                msg.mMessage.recycleUnchecked();
                this.decAndTraceMessageCount();
                continue;
            }
            return true;
        }
        return found;
    }

    private boolean findOrRemoveMessages(Handler h, int what, Object object, Runnable r, long when, MessageCompare compare, boolean removeMatches) {
        boolean foundInStack = this.stackHasMessages(h, what, object, r, when, compare, removeMatches);
        boolean foundInQueue = this.priorityQueueHasMessage(this.mPriorityQueue, h, what, object, r, when, compare, removeMatches);
        return foundInStack || (foundInQueue |= this.priorityQueueHasMessage(this.mAsyncPriorityQueue, h, what, object, r, when, compare, removeMatches));
    }

    static {
        MethodHandles.Lookup l;
        sIsProcessAllowedToUseConcurrent = null;
        mMessagesDelivered = new AtomicLong();
        sStackStateActive = new StateNode(1);
        sStackStateParked = new StateNode(2);
        try {
            l = MethodHandles.lookup();
            sState = l.findVarHandle(MessageQueue.class, "mStateValue", StackNode.class);
        }
        catch (Exception e) {
            Log.wtf(TAG_C, "VarHandle lookup failed with exception: " + e);
            throw new ExceptionInInitializerError(e);
        }
        try {
            l = MethodHandles.lookup();
            sNextInsertSeq = l.findVarHandle(MessageQueue.class, "mNextInsertSeqValue", Long.TYPE);
            sNextFrontInsertSeq = l.findVarHandle(MessageQueue.class, "mNextFrontInsertSeqValue", Long.TYPE);
        }
        catch (Exception e) {
            Log.wtf(TAG_C, "VarHandle lookup failed with exception: " + e);
            throw new ExceptionInInitializerError(e);
        }
        try {
            l = MethodHandles.lookup();
            sQuitting = l.findVarHandle(MessageQueue.class, "mQuittingValue", Boolean.TYPE);
        }
        catch (Exception e) {
            Log.wtf(TAG_C, "VarHandle lookup failed with exception: " + e);
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class MatchDeliverableMessages
    extends MessageCompare {
        private MatchDeliverableMessages() {
        }

        @Override
        public boolean compareMessage(MessageNode n, Handler h, int what, Object object, Runnable r, long when) {
            return n.mMessage.when <= when;
        }
    }

    private static class MatchHandlerWhatAndObject
    extends MessageCompare {
        private MatchHandlerWhatAndObject() {
        }

        @Override
        public boolean compareMessage(MessageNode n, Handler h, int what, Object object, Runnable r, long when) {
            Message m = n.mMessage;
            return m.target == h && m.what == what && (object == null || m.obj == object);
        }
    }

    private static class MatchHandlerWhatAndObjectEquals
    extends MessageCompare {
        private MatchHandlerWhatAndObjectEquals() {
        }

        @Override
        public boolean compareMessage(MessageNode n, Handler h, int what, Object object, Runnable r, long when) {
            Message m = n.mMessage;
            return m.target == h && m.what == what && (object == null || object.equals(m.obj));
        }
    }

    private static class MatchHandlerRunnableAndObject
    extends MessageCompare {
        private MatchHandlerRunnableAndObject() {
        }

        @Override
        public boolean compareMessage(MessageNode n, Handler h, int what, Object object, Runnable r, long when) {
            Message m = n.mMessage;
            return m.target == h && m.callback == r && (object == null || m.obj == object);
        }
    }

    private static class MatchHandler
    extends MessageCompare {
        private MatchHandler() {
        }

        @Override
        public boolean compareMessage(MessageNode n, Handler h, int what, Object object, Runnable r, long when) {
            return n.mMessage.target == h;
        }
    }

    private static class MatchHandlerRunnableAndObjectEquals
    extends MessageCompare {
        private MatchHandlerRunnableAndObjectEquals() {
        }

        @Override
        public boolean compareMessage(MessageNode n, Handler h, int what, Object object, Runnable r, long when) {
            Message m = n.mMessage;
            return m.target == h && m.callback == r && (object == null || object.equals(m.obj));
        }
    }

    private static class MatchHandlerAndObject
    extends MessageCompare {
        private MatchHandlerAndObject() {
        }

        @Override
        public boolean compareMessage(MessageNode n, Handler h, int what, Object object, Runnable r, long when) {
            Message m = n.mMessage;
            return m.target == h && (object == null || m.obj == object);
        }
    }

    private static class MatchHandlerAndObjectEquals
    extends MessageCompare {
        private MatchHandlerAndObjectEquals() {
        }

        @Override
        public boolean compareMessage(MessageNode n, Handler h, int what, Object object, Runnable r, long when) {
            Message m = n.mMessage;
            return m.target == h && (object == null || object.equals(m.obj));
        }
    }

    private static class MatchAllMessages
    extends MessageCompare {
        private MatchAllMessages() {
        }

        @Override
        public boolean compareMessage(MessageNode n, Handler h, int what, Object object, Runnable r, long when) {
            return true;
        }
    }

    private static class MatchAllFutureMessages
    extends MessageCompare {
        private MatchAllFutureMessages() {
        }

        @Override
        public boolean compareMessage(MessageNode n, Handler h, int what, Object object, Runnable r, long when) {
            Message m = n.mMessage;
            return m.when > when;
        }
    }

    static class TimedParkStateNode
    extends StateNode {
        long mWhenToWake;

        TimedParkStateNode() {
            super(3);
        }
    }

    static class StateNode
    extends StackNode {
        StateNode(int type) {
            super(type);
        }
    }

    static class StackNode {
        private final int mType;

        StackNode(int type) {
            this.mType = type;
        }

        int getNodeType() {
            return this.mType;
        }

        boolean isMessageNode() {
            return this.mType == 0;
        }
    }

    private static class MessageCounts {
        private static VarHandle sCounts;
        private volatile long mCountsValue = 0L;
        private static final long AWAKE = Long.MAX_VALUE;
        private static final int MESSAGE_FLUSH_THRESHOLD = 10;

        private MessageCounts() {
        }

        private static int numQueued(long val) {
            return (int)(val >>> 32);
        }

        private static int numCancelled(long val) {
            return (int)val;
        }

        private static long combineCounts(int queued, int cancelled) {
            return (long)queued << 32 | (long)cancelled;
        }

        public void incrementQueued() {
            long newVal;
            long oldVal;
            do {
                oldVal = this.mCountsValue;
                int queued = MessageCounts.numQueued(oldVal);
                int cancelled = MessageCounts.numCancelled(oldVal);
                newVal = MessageCounts.combineCounts(Math.max(queued + 1, queued), cancelled);
            } while (oldVal != Long.MAX_VALUE && !sCounts.compareAndSet(this, oldVal, newVal));
        }

        public boolean incrementCancelled() {
            int cancelled;
            int queued;
            boolean needsPurge;
            long newVal;
            long oldVal;
            do {
                if ((oldVal = this.mCountsValue) == Long.MAX_VALUE) {
                    return false;
                }
                queued = MessageCounts.numQueued(oldVal);
                cancelled = MessageCounts.numCancelled(oldVal);
            } while (!sCounts.compareAndSet(this, oldVal, newVal = (needsPurge = queued > 10 && queued >> 1 < cancelled) ? Long.MAX_VALUE : MessageCounts.combineCounts(queued, Math.max(cancelled + 1, cancelled))));
            return needsPurge;
        }

        public void clearCounts() {
            this.mCountsValue = 0L;
        }

        static {
            try {
                MethodHandles.Lookup l = MethodHandles.lookup();
                sCounts = l.findVarHandle(MessageCounts.class, "mCountsValue", Long.TYPE);
            }
            catch (Exception e) {
                Log.wtf(MessageQueue.TAG_C, "VarHandle lookup failed with exception: " + e);
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    private static abstract class MessageCompare {
        private MessageCompare() {
        }

        public abstract boolean compareMessage(MessageNode var1, Handler var2, int var3, Object var4, Runnable var5, long var6);
    }

    static class MessageNode
    extends StackNode
    implements Comparable<MessageNode> {
        private final Message mMessage;
        volatile StackNode mNext;
        StateNode mBottomOfStack;
        boolean mWokeUp;
        final long mInsertSeq;
        private static final VarHandle sRemovedFromStack;
        private volatile boolean mRemovedFromStackValue;

        MessageNode(@NonNull Message message, long insertSeq) {
            super(0);
            this.mMessage = message;
            this.mInsertSeq = insertSeq;
        }

        long getWhen() {
            return this.mMessage.when;
        }

        boolean removeFromStack() {
            return sRemovedFromStack.compareAndSet(this, false, true);
        }

        boolean isAsync() {
            return this.mMessage.isAsynchronous();
        }

        boolean isBarrier() {
            return this.mMessage.target == null;
        }

        @Override
        public int compareTo(@NonNull MessageNode messageNode) {
            Message other = messageNode.mMessage;
            int compared = Long.compare(this.mMessage.when, other.when);
            if (compared == 0) {
                compared = Long.compare(this.mInsertSeq, messageNode.mInsertSeq);
            }
            return compared;
        }

        static {
            try {
                MethodHandles.Lookup l = MethodHandles.lookup();
                sRemovedFromStack = l.findVarHandle(MessageNode.class, "mRemovedFromStackValue", Boolean.TYPE);
            }
            catch (Exception e) {
                Log.wtf(MessageQueue.TAG_C, "VarHandle lookup failed with exception: " + e);
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    public static interface IdleHandler {
        public boolean queueIdle();
    }

    public static interface OnFileDescriptorEventListener {
        public static final int EVENT_INPUT = 1;
        public static final int EVENT_OUTPUT = 2;
        public static final int EVENT_ERROR = 4;

        public int onFileDescriptorEvents(@NonNull FileDescriptor var1, int var2);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Events {
        }
    }

    private static class FileDescriptorRecord {
        public final FileDescriptor mDescriptor;
        public int mEvents;
        public OnFileDescriptorEventListener mListener;
        public int mSeq;

        public FileDescriptorRecord(FileDescriptor descriptor, int events, OnFileDescriptorEventListener listener) {
            this.mDescriptor = descriptor;
            this.mEvents = events;
            this.mListener = listener;
        }
    }

    private static class MatchBarrierToken
    extends MessageCompare {
        int mBarrierToken;

        MatchBarrierToken(int token) {
            this.mBarrierToken = token;
        }

        @Override
        public boolean compareMessage(MessageNode n, Handler h, int what, Object object, Runnable r, long when) {
            Message m = n.mMessage;
            return m.target == null && m.arg1 == this.mBarrierToken;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface StackNodeType {
    }
}

