/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.os.CancellationSignal;
import android.os.CombinedVibration;
import android.os.NullVibrator;
import android.os.VibrationAttributes;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.os.VibratorInfo;
import android.os.VibratorManager;
import android.os.vibrator.VendorVibrationSession;
import android.os.vibrator.VibratorInfoFactory;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.Executor;

public class SystemVibrator
extends Vibrator {
    private static final String TAG = "Vibrator";
    private final VibratorManager mVibratorManager;
    private final Context mContext;
    @GuardedBy(value={"mBrokenListeners"})
    private final ArrayList<MultiVibratorStateListener> mBrokenListeners = new ArrayList();
    @GuardedBy(value={"mRegisteredListeners"})
    private final ArrayMap<Vibrator.OnVibratorStateChangedListener, MultiVibratorStateListener> mRegisteredListeners = new ArrayMap();
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private VibratorInfo mVibratorInfo;
    private int[] mVibratorIds;

    @UnsupportedAppUsage
    public SystemVibrator(Context context) {
        super(context);
        this.mContext = context;
        this.mVibratorManager = this.mContext.getSystemService(VibratorManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VibratorInfo getInfo() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mVibratorInfo != null) {
                return this.mVibratorInfo;
            }
            if (this.mVibratorManager == null) {
                Log.w(TAG, "Failed to retrieve vibrator info; no vibrator manager.");
                return VibratorInfo.EMPTY_VIBRATOR_INFO;
            }
            int[] vibratorIds = this.getVibratorIds();
            if (vibratorIds == null) {
                Log.w(TAG, "Failed to retrieve vibrator info; error retrieving vibrator ids.");
                return VibratorInfo.EMPTY_VIBRATOR_INFO;
            }
            if (vibratorIds.length == 0) {
                this.mVibratorInfo = VibratorInfo.EMPTY_VIBRATOR_INFO;
                return this.mVibratorInfo;
            }
            VibratorInfo[] vibratorInfos = new VibratorInfo[vibratorIds.length];
            for (int i = 0; i < vibratorIds.length; ++i) {
                Vibrator vibrator = this.mVibratorManager.getVibrator(vibratorIds[i]);
                if (vibrator instanceof NullVibrator) {
                    Log.w(TAG, "Vibrator manager service not ready; Info not yet available for vibrator: " + vibratorIds[i]);
                    return VibratorInfo.EMPTY_VIBRATOR_INFO;
                }
                vibratorInfos[i] = vibrator.getInfo();
            }
            this.mVibratorInfo = VibratorInfoFactory.create(-1, vibratorInfos);
            return this.mVibratorInfo;
        }
    }

    @Override
    public boolean hasVibrator() {
        int[] vibratorIds = this.getVibratorIds();
        if (vibratorIds == null) {
            Log.w(TAG, "Failed to check if vibrator exists; no vibrator manager.");
            return false;
        }
        return vibratorIds.length > 0;
    }

    @Override
    public boolean isVibrating() {
        int[] vibratorIds = this.getVibratorIds();
        if (vibratorIds == null) {
            Log.w(TAG, "Failed to vibrate; no vibrator manager.");
            return false;
        }
        for (int vibratorId : vibratorIds) {
            if (!this.mVibratorManager.getVibrator(vibratorId).isVibrating()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addVibratorStateListener(@NonNull Vibrator.OnVibratorStateChangedListener listener) {
        Objects.requireNonNull(listener);
        if (this.mContext == null) {
            Log.w(TAG, "Failed to add vibrate state listener; no vibrator context.");
            return;
        }
        this.addVibratorStateListener(this.mContext.getMainExecutor(), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVibratorStateListener(@NonNull Executor executor, @NonNull Vibrator.OnVibratorStateChangedListener listener) {
        Objects.requireNonNull(listener);
        Objects.requireNonNull(executor);
        if (this.mVibratorManager == null) {
            Log.w(TAG, "Failed to add vibrate state listener; no vibrator manager.");
            return;
        }
        int[] vibratorIds = this.getVibratorIds();
        if (vibratorIds == null) {
            Log.w(TAG, "Failed to add vibrate state listener; error retrieving vibrator ids.");
            return;
        }
        MultiVibratorStateListener delegate = null;
        try {
            ArrayMap<Vibrator.OnVibratorStateChangedListener, MultiVibratorStateListener> arrayMap = this.mRegisteredListeners;
            synchronized (arrayMap) {
                block20: {
                    if (!this.mRegisteredListeners.containsKey(listener)) break block20;
                    Log.w(TAG, "Listener already registered.");
                    return;
                }
                delegate = new MultiVibratorStateListener(executor, listener);
                delegate.register(this.mVibratorManager, vibratorIds);
                this.mRegisteredListeners.put(listener, delegate);
                delegate = null;
            }
        }
        finally {
            if (delegate != null && delegate.hasRegisteredListeners()) {
                ArrayList<MultiVibratorStateListener> arrayList = this.mBrokenListeners;
                synchronized (arrayList) {
                    this.mBrokenListeners.add(delegate);
                }
            }
            this.tryUnregisterBrokenListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeVibratorStateListener(@NonNull Vibrator.OnVibratorStateChangedListener listener) {
        Objects.requireNonNull(listener);
        if (this.mVibratorManager == null) {
            Log.w(TAG, "Failed to remove vibrate state listener; no vibrator manager.");
            return;
        }
        ArrayMap<Vibrator.OnVibratorStateChangedListener, MultiVibratorStateListener> arrayMap = this.mRegisteredListeners;
        synchronized (arrayMap) {
            if (this.mRegisteredListeners.containsKey(listener)) {
                MultiVibratorStateListener delegate = this.mRegisteredListeners.get(listener);
                delegate.unregister(this.mVibratorManager);
                this.mRegisteredListeners.remove(listener);
            }
        }
        this.tryUnregisterBrokenListeners();
    }

    @Override
    public boolean hasAmplitudeControl() {
        return this.getInfo().hasAmplitudeControl();
    }

    @Override
    public boolean areVendorSessionsSupported() {
        return this.mVibratorManager.hasCapabilities(256);
    }

    @Override
    public boolean setAlwaysOnEffect(int uid, String opPkg, int alwaysOnId, VibrationEffect effect, VibrationAttributes attrs) {
        if (this.mVibratorManager == null) {
            Log.w(TAG, "Failed to set always-on effect; no vibrator manager.");
            return false;
        }
        CombinedVibration combinedEffect = CombinedVibration.createParallel(effect);
        return this.mVibratorManager.setAlwaysOnEffect(uid, opPkg, alwaysOnId, combinedEffect, attrs);
    }

    @Override
    public void vibrate(int uid, String opPkg, @NonNull VibrationEffect effect, String reason, @NonNull VibrationAttributes attributes) {
        if (this.mVibratorManager == null) {
            Log.w(TAG, "Failed to vibrate; no vibrator manager.");
            return;
        }
        CombinedVibration combinedEffect = CombinedVibration.createParallel(effect);
        this.mVibratorManager.vibrate(uid, opPkg, combinedEffect, reason, attributes);
    }

    @Override
    public void performHapticFeedback(int constant, String reason, int flags, int privFlags) {
        if (this.mVibratorManager == null) {
            Log.w(TAG, "Failed to perform haptic feedback; no vibrator manager.");
            return;
        }
        this.mVibratorManager.performHapticFeedback(constant, reason, flags, privFlags);
    }

    @Override
    public void performHapticFeedbackForInputDevice(int constant, int inputDeviceId, int inputSource, String reason, int flags, int privFlags) {
        if (this.mVibratorManager == null) {
            Log.w(TAG, "Failed to perform haptic feedback for input device; no vibrator manager.");
            return;
        }
        this.mVibratorManager.performHapticFeedbackForInputDevice(constant, inputDeviceId, inputSource, reason, flags, privFlags);
    }

    @Override
    public void cancel() {
        if (this.mVibratorManager == null) {
            Log.w(TAG, "Failed to cancel vibrate; no vibrator manager.");
            return;
        }
        this.mVibratorManager.cancel();
    }

    @Override
    public void cancel(int usageFilter) {
        if (this.mVibratorManager == null) {
            Log.w(TAG, "Failed to cancel vibrate; no vibrator manager.");
            return;
        }
        this.mVibratorManager.cancel(usageFilter);
    }

    @Override
    public void startVendorSession(@NonNull VibrationAttributes attrs, @Nullable String reason, @Nullable CancellationSignal cancellationSignal, @NonNull Executor executor, @NonNull VendorVibrationSession.Callback callback) {
        if (this.mVibratorManager == null) {
            Log.w(TAG, "Failed to start vibration session; no vibrator manager.");
            executor.execute(() -> callback.onFinished(5));
            return;
        }
        int[] vibratorIds = this.getVibratorIds();
        if (vibratorIds == null) {
            Log.w(TAG, "Failed to start vibration session; error retrieving vibrator ids.");
            executor.execute(() -> callback.onFinished(5));
            return;
        }
        this.mVibratorManager.startVendorSession(vibratorIds, attrs, reason, cancellationSignal, executor, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private int[] getVibratorIds() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mVibratorIds != null) {
                return this.mVibratorIds;
            }
            if (this.mVibratorManager == null) {
                Log.w(TAG, "Failed to retrieve vibrator ids; no vibrator manager.");
                return null;
            }
            this.mVibratorIds = this.mVibratorManager.getVibratorIds();
            return this.mVibratorIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryUnregisterBrokenListeners() {
        ArrayList<MultiVibratorStateListener> arrayList = this.mBrokenListeners;
        synchronized (arrayList) {
            try {
                int i = this.mBrokenListeners.size();
                while (--i >= 0) {
                    this.mBrokenListeners.get(i).unregister(this.mVibratorManager);
                    this.mBrokenListeners.remove(i);
                }
            }
            catch (RuntimeException e) {
                Log.w(TAG, "Failed to unregister broken listener", e);
            }
        }
    }

    @VisibleForTesting
    public static class MultiVibratorStateListener {
        private final Object mLock = new Object();
        private final Executor mExecutor;
        private final Vibrator.OnVibratorStateChangedListener mDelegate;
        @GuardedBy(value={"mLock"})
        private final SparseArray<SingleVibratorStateListener> mVibratorListeners = new SparseArray();
        @GuardedBy(value={"mLock"})
        private int mInitializedMask;
        @GuardedBy(value={"mLock"})
        private int mVibratingMask;

        public MultiVibratorStateListener(@NonNull Executor executor, @NonNull Vibrator.OnVibratorStateChangedListener listener) {
            this.mExecutor = executor;
            this.mDelegate = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasRegisteredListeners() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mVibratorListeners.size() > 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(VibratorManager vibratorManager, @NonNull int[] vibratorIds) {
            Object object = this.mLock;
            synchronized (object) {
                for (int i = 0; i < vibratorIds.length; ++i) {
                    int vibratorId = vibratorIds[i];
                    SingleVibratorStateListener listener = new SingleVibratorStateListener(this, i);
                    try {
                        vibratorManager.getVibrator(vibratorId).addVibratorStateListener(this.mExecutor, listener);
                        this.mVibratorListeners.put(vibratorId, listener);
                        continue;
                    }
                    catch (RuntimeException e) {
                        try {
                            this.unregister(vibratorManager);
                        }
                        catch (RuntimeException e1) {
                            Log.w(SystemVibrator.TAG, "Failed to unregister listener while recovering from a failed register call", e1);
                        }
                        throw e;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister(VibratorManager vibratorManager) {
            Object object = this.mLock;
            synchronized (object) {
                int i = this.mVibratorListeners.size();
                while (--i >= 0) {
                    int vibratorId = this.mVibratorListeners.keyAt(i);
                    SingleVibratorStateListener listener = this.mVibratorListeners.valueAt(i);
                    vibratorManager.getVibrator(vibratorId).removeVibratorStateListener(listener);
                    this.mVibratorListeners.removeAt(i);
                }
            }
        }

        public void onVibrating(int vibratorIdx, boolean vibrating) {
            this.mExecutor.execute(() -> {
                boolean shouldNotifyStateChange;
                boolean isAnyVibrating;
                Object object = this.mLock;
                synchronized (object) {
                    boolean previousVibrating;
                    int allInitializedMask = (1 << this.mVibratorListeners.size()) - 1;
                    boolean previousIsAnyVibrating = this.mVibratingMask != 0;
                    boolean previousAreAllInitialized = this.mInitializedMask == allInitializedMask;
                    int vibratorMask = 1 << vibratorIdx;
                    this.mInitializedMask |= vibratorMask;
                    boolean bl = previousVibrating = (this.mVibratingMask & vibratorMask) != 0;
                    if (previousVibrating != vibrating) {
                        this.mVibratingMask ^= vibratorMask;
                    }
                    isAnyVibrating = this.mVibratingMask != 0;
                    boolean areAllInitialized = this.mInitializedMask == allInitializedMask;
                    boolean isStateChanging = previousIsAnyVibrating != isAnyVibrating;
                    shouldNotifyStateChange = areAllInitialized && (!previousAreAllInitialized || isStateChanging);
                }
                if (shouldNotifyStateChange) {
                    this.mDelegate.onVibratorStateChanged(isAnyVibrating);
                }
            });
        }
    }

    private static class SingleVibratorStateListener
    implements Vibrator.OnVibratorStateChangedListener {
        private final MultiVibratorStateListener mAllVibratorsListener;
        private final int mVibratorIdx;

        SingleVibratorStateListener(MultiVibratorStateListener listener, int vibratorIdx) {
            this.mAllVibratorsListener = listener;
            this.mVibratorIdx = vibratorIdx;
        }

        @Override
        public void onVibratorStateChanged(boolean isVibrating) {
            this.mAllVibratorsListener.onVibrating(this.mVibratorIdx, isVibrating);
        }
    }
}

