/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.PerfettoTrace;
import android.os.Trace_Delegate;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodReplace;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;

@RavenwoodKeepWholeClass
public class Trace {
    private static final String TAG = "Trace";
    public static final long TRACE_TAG_NEVER = 0L;
    public static final long TRACE_TAG_ALWAYS = 1L;
    public static final long TRACE_TAG_GRAPHICS = 2L;
    public static final long TRACE_TAG_INPUT = 4L;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final long TRACE_TAG_VIEW = 8L;
    public static final long TRACE_TAG_WEBVIEW = 16L;
    public static final long TRACE_TAG_WINDOW_MANAGER = 32L;
    public static final long TRACE_TAG_ACTIVITY_MANAGER = 64L;
    public static final long TRACE_TAG_SYNC_MANAGER = 128L;
    public static final long TRACE_TAG_AUDIO = 256L;
    public static final long TRACE_TAG_VIDEO = 512L;
    public static final long TRACE_TAG_CAMERA = 1024L;
    public static final long TRACE_TAG_HAL = 2048L;
    @UnsupportedAppUsage
    public static final long TRACE_TAG_APP = 4096L;
    public static final long TRACE_TAG_RESOURCES = 8192L;
    public static final long TRACE_TAG_DALVIK = 16384L;
    public static final long TRACE_TAG_RS = 32768L;
    public static final long TRACE_TAG_BIONIC = 65536L;
    public static final long TRACE_TAG_POWER = 131072L;
    public static final long TRACE_TAG_PACKAGE_MANAGER = 262144L;
    public static final long TRACE_TAG_SYSTEM_SERVER = 524288L;
    public static final long TRACE_TAG_DATABASE = 0x100000L;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final long TRACE_TAG_NETWORK = 0x200000L;
    public static final long TRACE_TAG_ADB = 0x400000L;
    public static final long TRACE_TAG_VIBRATOR = 0x800000L;
    @SystemApi
    public static final long TRACE_TAG_AIDL = 0x1000000L;
    public static final long TRACE_TAG_NNAPI = 0x2000000L;
    public static final long TRACE_TAG_RRO = 0x4000000L;
    public static final long TRACE_TAG_THERMAL = 0x8000000L;
    private static final long TRACE_TAG_NOT_READY = Long.MIN_VALUE;
    public static final int MAX_SECTION_NAME_LEN = 127;
    @UnsupportedAppUsage
    private static volatile long sEnabledTags = Long.MIN_VALUE;
    private static int sZygoteDebugFlags = 0;

    @UnsupportedAppUsage
    @CriticalNative
    @RavenwoodReplace
    private static boolean nativeIsTagEnabled(long l) {
        return OverrideMethod.invokeI("android.os.Trace#nativeIsTagEnabled(J)Z", true, null) != 0;
    }

    @RavenwoodReplace
    private static void nativeSetAppTracingAllowed(boolean bl) {
        OverrideMethod.invokeV("android.os.Trace#nativeSetAppTracingAllowed(Z)V", true, null);
    }

    @RavenwoodReplace
    private static void nativeSetTracingEnabled(boolean bl) {
        OverrideMethod.invokeV("android.os.Trace#nativeSetTracingEnabled(Z)V", true, null);
    }

    private static boolean nativeIsTagEnabled$ravenwood(long traceTag) {
        return false;
    }

    private static void nativeSetAppTracingAllowed$ravenwood(boolean allowed) {
    }

    private static void nativeSetTracingEnabled$ravenwood(boolean allowed) {
    }

    @FastNative
    private static void nativeTraceCounter(long l, String string2, long l2) {
        OverrideMethod.invokeV("android.os.Trace#nativeTraceCounter(JLjava/lang/String;J)V", true, null);
    }

    @FastNative
    private static void nativeTraceBegin(long l, String string2) {
        OverrideMethod.invokeV("android.os.Trace#nativeTraceBegin(JLjava/lang/String;)V", true, null);
    }

    @FastNative
    private static void nativeTraceEnd(long l) {
        OverrideMethod.invokeV("android.os.Trace#nativeTraceEnd(J)V", true, null);
    }

    @FastNative
    private static void nativeAsyncTraceBegin(long l, String string2, int n) {
        OverrideMethod.invokeV("android.os.Trace#nativeAsyncTraceBegin(JLjava/lang/String;I)V", true, null);
    }

    @FastNative
    private static void nativeAsyncTraceEnd(long l, String string2, int n) {
        OverrideMethod.invokeV("android.os.Trace#nativeAsyncTraceEnd(JLjava/lang/String;I)V", true, null);
    }

    @FastNative
    private static void nativeAsyncTraceForTrackBegin(long l, String string2, String string3, int n) {
        OverrideMethod.invokeV("android.os.Trace#nativeAsyncTraceForTrackBegin(JLjava/lang/String;Ljava/lang/String;I)V", true, null);
    }

    @FastNative
    private static void nativeAsyncTraceForTrackEnd(long l, String string2, int n) {
        OverrideMethod.invokeV("android.os.Trace#nativeAsyncTraceForTrackEnd(JLjava/lang/String;I)V", true, null);
    }

    @FastNative
    private static void nativeInstant(long l, String string2) {
        OverrideMethod.invokeV("android.os.Trace#nativeInstant(JLjava/lang/String;)V", true, null);
    }

    @FastNative
    private static void nativeInstantForTrack(long l, String string2, String string3) {
        OverrideMethod.invokeV("android.os.Trace#nativeInstantForTrack(JLjava/lang/String;Ljava/lang/String;)V", true, null);
    }

    private Trace() {
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public static boolean isTagEnabled_Original(long traceTag) {
        return Trace.nativeIsTagEnabled(traceTag);
    }

    @LayoutlibDelegate
    public static boolean isTagEnabled(long l) {
        return Trace_Delegate.isTagEnabled(l);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public static void traceCounter_Original(long traceTag, @NonNull String counterName, int counterValue) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeTraceCounter(traceTag, counterName, counterValue);
        }
    }

    @LayoutlibDelegate
    public static void traceCounter(long l, String string2, int n) {
        Trace_Delegate.traceCounter(l, string2, n);
    }

    @UnsupportedAppUsage
    public static void setAppTracingAllowed_Original(boolean allowed) {
        Trace.nativeSetAppTracingAllowed(allowed);
    }

    @LayoutlibDelegate
    public static void setAppTracingAllowed(boolean bl) {
        Trace_Delegate.setAppTracingAllowed(bl);
    }

    public static void setTracingEnabled_Original(boolean enabled, int debugFlags) {
        Trace.nativeSetTracingEnabled(enabled);
        sZygoteDebugFlags = debugFlags;
    }

    @LayoutlibDelegate
    public static void setTracingEnabled(boolean bl, int n) {
        Trace_Delegate.setTracingEnabled(bl, n);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public static void traceBegin_Original(long traceTag, @NonNull String methodName) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeTraceBegin(traceTag, methodName);
        }
    }

    @LayoutlibDelegate
    public static void traceBegin(long l, String string2) {
        Trace_Delegate.traceBegin(l, string2);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public static void traceEnd_Original(long traceTag) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeTraceEnd(traceTag);
        }
    }

    @LayoutlibDelegate
    public static void traceEnd(long l) {
        Trace_Delegate.traceEnd(l);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public static void asyncTraceBegin_Original(long traceTag, @NonNull String methodName, int cookie) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeAsyncTraceBegin(traceTag, methodName, cookie);
        }
    }

    @LayoutlibDelegate
    public static void asyncTraceBegin(long l, String string2, int n) {
        Trace_Delegate.asyncTraceBegin(l, string2, n);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public static void asyncTraceEnd_Original(long traceTag, @NonNull String methodName, int cookie) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeAsyncTraceEnd(traceTag, methodName, cookie);
        }
    }

    @LayoutlibDelegate
    public static void asyncTraceEnd(long l, String string2, int n) {
        Trace_Delegate.asyncTraceEnd(l, string2, n);
    }

    public static void asyncTraceForTrackBegin_Original(long traceTag, @NonNull String trackName, @NonNull String methodName, int cookie) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeAsyncTraceForTrackBegin(traceTag, trackName, methodName, cookie);
        }
    }

    @LayoutlibDelegate
    public static void asyncTraceForTrackBegin(long l, String string2, String string3, int n) {
        Trace_Delegate.asyncTraceForTrackBegin(l, string2, string3, n);
    }

    public static void asyncTraceForTrackEnd_Original(long traceTag, @NonNull String trackName, int cookie) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeAsyncTraceForTrackEnd(traceTag, trackName, cookie);
        }
    }

    @LayoutlibDelegate
    public static void asyncTraceForTrackEnd(long l, String string2, int n) {
        Trace_Delegate.asyncTraceForTrackEnd(l, string2, n);
    }

    public static void instant_Original(long traceTag, String methodName) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeInstant(traceTag, methodName);
        }
    }

    @LayoutlibDelegate
    public static void instant(long l, String string2) {
        Trace_Delegate.instant(l, string2);
    }

    public static void instantForTrack_Original(long traceTag, String trackName, String methodName) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeInstantForTrack(traceTag, trackName, methodName);
        }
    }

    @LayoutlibDelegate
    public static void instantForTrack(long l, String string2, String string3) {
        Trace_Delegate.instantForTrack(l, string2, string3);
    }

    public static boolean isEnabled_Original() {
        return Trace.isTagEnabled(4096L);
    }

    @LayoutlibDelegate
    public static boolean isEnabled() {
        return Trace_Delegate.isEnabled();
    }

    public static void beginSection(@NonNull String sectionName) {
        if (Trace.isTagEnabled(4096L)) {
            if (sectionName.length() > 127) {
                throw new IllegalArgumentException("sectionName is too long");
            }
            Trace.nativeTraceBegin(4096L, sectionName);
        }
    }

    public static void endSection() {
        if (Trace.isTagEnabled(4096L)) {
            Trace.nativeTraceEnd(4096L);
        }
    }

    public static void beginAsyncSection(@NonNull String methodName, int cookie) {
        Trace.asyncTraceBegin(4096L, methodName, cookie);
    }

    public static void endAsyncSection(@NonNull String methodName, int cookie) {
        Trace.asyncTraceEnd(4096L, methodName, cookie);
    }

    public static void setCounter(@NonNull String counterName, long counterValue) {
        Trace.setCounter(4096L, counterName, counterValue);
    }

    public static void setCounter(long traceTag, @NonNull String counterName, long counterValue) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeTraceCounter(traceTag, counterName, counterValue);
        }
    }

    public static void registerWithPerfetto() {
        PerfettoTrace.register(false);
        PerfettoTrace.registerCategories();
    }
}

