/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Handler;
import android.os.IUpdateEngineStable;
import android.os.IUpdateEngineStableCallback;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UpdateEngineStableCallback;

public class UpdateEngineStable {
    private static final String TAG = "UpdateEngineStable";
    private static final String UPDATE_ENGINE_STABLE_SERVICE = "android.os.UpdateEngineStableService";
    private final IUpdateEngineStable mUpdateEngineStable;
    private IUpdateEngineStableCallback mUpdateEngineStableCallback = null;
    private final Object mUpdateEngineStableCallbackLock = new Object();

    public UpdateEngineStable() {
        this.mUpdateEngineStable = IUpdateEngineStable.Stub.asInterface(ServiceManager.getService(UPDATE_ENGINE_STABLE_SERVICE));
        if (this.mUpdateEngineStable == null) {
            throw new IllegalStateException("Failed to find android.os.UpdateEngineStableService");
        }
    }

    public boolean bind(final UpdateEngineStableCallback callback, final Handler handler) {
        Object object = this.mUpdateEngineStableCallbackLock;
        synchronized (object) {
            this.mUpdateEngineStableCallback = new IUpdateEngineStableCallback.Stub(this){

                @Override
                public void onStatusUpdate(final int status, final float percent) {
                    if (handler != null) {
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                callback.onStatusUpdate(status, percent);
                            }
                        });
                    } else {
                        callback.onStatusUpdate(status, percent);
                    }
                }

                @Override
                public void onPayloadApplicationComplete(final int errorCode) {
                    if (handler != null) {
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                callback.onPayloadApplicationComplete(errorCode);
                            }
                        });
                    } else {
                        callback.onPayloadApplicationComplete(errorCode);
                    }
                }

                @Override
                public int getInterfaceVersion() {
                    return 2;
                }

                @Override
                public String getInterfaceHash() {
                    return "ee2e6f0bd51391955f79f4d5eeeafc37c668cd40";
                }
            };
            try {
                return this.mUpdateEngineStable.bind(this.mUpdateEngineStableCallback);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public boolean bind(UpdateEngineStableCallback callback) {
        return this.bind(callback, null);
    }

    public void applyPayloadFd(ParcelFileDescriptor fd, long offset, long size, String[] headerKeyValuePairs) {
        try {
            this.mUpdateEngineStable.applyPayloadFd(fd, offset, size, headerKeyValuePairs);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean unbind() {
        Object object = this.mUpdateEngineStableCallbackLock;
        synchronized (object) {
            if (this.mUpdateEngineStableCallback == null) {
                return true;
            }
            try {
                boolean result = this.mUpdateEngineStable.unbind(this.mUpdateEngineStableCallback);
                this.mUpdateEngineStableCallback = null;
                return result;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public static @interface ErrorCode {
    }
}

