/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.hardware.vibrator.Braking;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.VibrationEffect;
import android.os.vibrator.Flags;
import android.util.IndentingPrintWriter;
import android.util.MathUtils;
import android.util.Pair;
import android.util.Range;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class VibratorInfo
implements Parcelable {
    private static final String TAG = "VibratorInfo";
    public static final VibratorInfo EMPTY_VIBRATOR_INFO = new Builder(-1).build();
    private final int mId;
    private final long mCapabilities;
    @Nullable
    private final SparseBooleanArray mSupportedEffects;
    @Nullable
    private final SparseBooleanArray mSupportedBraking;
    private final SparseIntArray mSupportedPrimitives;
    private final int mPrimitiveDelayMax;
    private final int mCompositionSizeMax;
    private final int mPwlePrimitiveDurationMax;
    private final int mPwleSizeMax;
    private final float mQFactor;
    private final FrequencyProfileLegacy mFrequencyProfileLegacy;
    private final FrequencyProfile mFrequencyProfile;
    private final int mMaxEnvelopeEffectSize;
    private final int mMinEnvelopeEffectControlPointDurationMillis;
    private final int mMaxEnvelopeEffectControlPointDurationMillis;
    @NonNull
    public static final Parcelable.Creator<VibratorInfo> CREATOR = new Parcelable.Creator<VibratorInfo>(){

        @Override
        public VibratorInfo createFromParcel(Parcel in) {
            return new VibratorInfo(in);
        }

        public VibratorInfo[] newArray(int size) {
            return new VibratorInfo[size];
        }
    };

    VibratorInfo(Parcel in) {
        this.mId = in.readInt();
        this.mCapabilities = in.readLong();
        this.mSupportedEffects = in.readSparseBooleanArray();
        this.mSupportedBraking = in.readSparseBooleanArray();
        this.mSupportedPrimitives = in.readSparseIntArray();
        this.mPrimitiveDelayMax = in.readInt();
        this.mCompositionSizeMax = in.readInt();
        this.mPwlePrimitiveDurationMax = in.readInt();
        this.mPwleSizeMax = in.readInt();
        this.mQFactor = in.readFloat();
        this.mFrequencyProfileLegacy = FrequencyProfileLegacy.CREATOR.createFromParcel(in);
        this.mFrequencyProfile = FrequencyProfile.CREATOR.createFromParcel(in);
        this.mMaxEnvelopeEffectSize = in.readInt();
        this.mMinEnvelopeEffectControlPointDurationMillis = in.readInt();
        this.mMaxEnvelopeEffectControlPointDurationMillis = in.readInt();
    }

    public VibratorInfo(int id2, @NonNull VibratorInfo baseVibratorInfo) {
        this(id2, baseVibratorInfo.mCapabilities, baseVibratorInfo.mSupportedEffects, baseVibratorInfo.mSupportedBraking, baseVibratorInfo.mSupportedPrimitives, baseVibratorInfo.mPrimitiveDelayMax, baseVibratorInfo.mCompositionSizeMax, baseVibratorInfo.mPwlePrimitiveDurationMax, baseVibratorInfo.mPwleSizeMax, baseVibratorInfo.mQFactor, baseVibratorInfo.mFrequencyProfileLegacy, baseVibratorInfo.mFrequencyProfile, baseVibratorInfo.mMaxEnvelopeEffectSize, baseVibratorInfo.mMinEnvelopeEffectControlPointDurationMillis, baseVibratorInfo.mMaxEnvelopeEffectControlPointDurationMillis);
    }

    public VibratorInfo(int id2, long capabilities, @Nullable SparseBooleanArray supportedEffects, @Nullable SparseBooleanArray supportedBraking, @NonNull SparseIntArray supportedPrimitives, int primitiveDelayMax, int compositionSizeMax, int pwlePrimitiveDurationMax, int pwleSizeMax, float qFactor, @NonNull FrequencyProfileLegacy frequencyProfileLegacy, @NonNull FrequencyProfile frequencyProfile, int maxEnvelopeEffectSize, int minEnvelopeEffectControlPointDurationMillis, int maxEnvelopeEffectControlPointDurationMillis) {
        Preconditions.checkNotNull(supportedPrimitives);
        Preconditions.checkNotNull(frequencyProfileLegacy);
        Preconditions.checkNotNull(frequencyProfile);
        this.mId = id2;
        this.mCapabilities = capabilities;
        this.mSupportedEffects = supportedEffects == null ? null : supportedEffects.clone();
        this.mSupportedBraking = supportedBraking == null ? null : supportedBraking.clone();
        this.mSupportedPrimitives = supportedPrimitives.clone();
        this.mPrimitiveDelayMax = primitiveDelayMax;
        this.mCompositionSizeMax = compositionSizeMax;
        this.mPwlePrimitiveDurationMax = pwlePrimitiveDurationMax;
        this.mPwleSizeMax = pwleSizeMax;
        this.mQFactor = qFactor;
        this.mFrequencyProfileLegacy = frequencyProfileLegacy;
        this.mFrequencyProfile = frequencyProfile;
        this.mMaxEnvelopeEffectSize = maxEnvelopeEffectSize;
        this.mMinEnvelopeEffectControlPointDurationMillis = minEnvelopeEffectControlPointDurationMillis;
        this.mMaxEnvelopeEffectControlPointDurationMillis = maxEnvelopeEffectControlPointDurationMillis;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mId);
        dest.writeLong(this.mCapabilities);
        dest.writeSparseBooleanArray(this.mSupportedEffects);
        dest.writeSparseBooleanArray(this.mSupportedBraking);
        dest.writeSparseIntArray(this.mSupportedPrimitives);
        dest.writeInt(this.mPrimitiveDelayMax);
        dest.writeInt(this.mCompositionSizeMax);
        dest.writeInt(this.mPwlePrimitiveDurationMax);
        dest.writeInt(this.mPwleSizeMax);
        dest.writeFloat(this.mQFactor);
        this.mFrequencyProfileLegacy.writeToParcel(dest, flags);
        this.mFrequencyProfile.writeToParcel(dest, flags);
        dest.writeInt(this.mMaxEnvelopeEffectSize);
        dest.writeInt(this.mMinEnvelopeEffectControlPointDurationMillis);
        dest.writeInt(this.mMaxEnvelopeEffectControlPointDurationMillis);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VibratorInfo)) {
            return false;
        }
        VibratorInfo that = (VibratorInfo)o;
        return this.mId == that.mId && this.equalContent(that);
    }

    public boolean equalContent(VibratorInfo that) {
        int supportedPrimitivesCount = this.mSupportedPrimitives.size();
        if (supportedPrimitivesCount != that.mSupportedPrimitives.size()) {
            return false;
        }
        for (int i = 0; i < supportedPrimitivesCount; ++i) {
            if (this.mSupportedPrimitives.keyAt(i) != that.mSupportedPrimitives.keyAt(i)) {
                return false;
            }
            if (this.mSupportedPrimitives.valueAt(i) == that.mSupportedPrimitives.valueAt(i)) continue;
            return false;
        }
        return this.mCapabilities == that.mCapabilities && this.mPrimitiveDelayMax == that.mPrimitiveDelayMax && this.mCompositionSizeMax == that.mCompositionSizeMax && this.mPwlePrimitiveDurationMax == that.mPwlePrimitiveDurationMax && this.mPwleSizeMax == that.mPwleSizeMax && Objects.equals(this.mSupportedEffects, that.mSupportedEffects) && Objects.equals(this.mSupportedBraking, that.mSupportedBraking) && Objects.equals(Float.valueOf(this.mQFactor), Float.valueOf(that.mQFactor)) && Objects.equals(this.mFrequencyProfileLegacy, that.mFrequencyProfileLegacy) && Objects.equals(this.mFrequencyProfile, that.mFrequencyProfile) && this.mMaxEnvelopeEffectSize == that.mMaxEnvelopeEffectSize && this.mMinEnvelopeEffectControlPointDurationMillis == that.mMinEnvelopeEffectControlPointDurationMillis && this.mMaxEnvelopeEffectControlPointDurationMillis == that.mMaxEnvelopeEffectControlPointDurationMillis;
    }

    public int hashCode() {
        int hashCode = Objects.hash(this.mId, this.mCapabilities, this.mSupportedEffects, this.mSupportedBraking, Float.valueOf(this.mQFactor), this.mFrequencyProfileLegacy, this.mFrequencyProfile);
        for (int i = 0; i < this.mSupportedPrimitives.size(); ++i) {
            hashCode = 31 * hashCode + this.mSupportedPrimitives.keyAt(i);
            hashCode = 31 * hashCode + this.mSupportedPrimitives.valueAt(i);
        }
        return hashCode;
    }

    public String toString() {
        return "VibratorInfo{mId=" + this.mId + ", mCapabilities=" + Arrays.toString(this.getCapabilitiesNames()) + ", mCapabilities flags=" + Long.toBinaryString(this.mCapabilities) + ", mSupportedEffects=" + Arrays.toString(this.getSupportedEffectsNames()) + ", mSupportedBraking=" + Arrays.toString(this.getSupportedBrakingNames()) + ", mSupportedPrimitives=" + Arrays.toString(this.getSupportedPrimitivesNames()) + ", mPrimitiveDelayMax=" + this.mPrimitiveDelayMax + ", mCompositionSizeMax=" + this.mCompositionSizeMax + ", mPwlePrimitiveDurationMax=" + this.mPwlePrimitiveDurationMax + ", mPwleSizeMax=" + this.mPwleSizeMax + ", mQFactor=" + this.mQFactor + ", mFrequencyProfileLegacy=" + this.mFrequencyProfileLegacy + ", mFrequencyProfile=" + this.mFrequencyProfile + ", mMaxEnvelopeEffectSize=" + this.mMaxEnvelopeEffectSize + ", mMinEnvelopeEffectControlPointDurationMillis=" + this.mMinEnvelopeEffectControlPointDurationMillis + ", mMaxEnvelopeEffectControlPointDurationMillis=" + this.mMaxEnvelopeEffectControlPointDurationMillis + '}';
    }

    public void dump(IndentingPrintWriter pw) {
        pw.println("VibratorInfo:");
        pw.increaseIndent();
        pw.println("id = " + this.mId);
        pw.println("capabilities = " + Arrays.toString(this.getCapabilitiesNames()));
        pw.println("capabilitiesFlags = " + Long.toBinaryString(this.mCapabilities));
        pw.println("supportedEffects = " + Arrays.toString(this.getSupportedEffectsNames()));
        pw.println("supportedPrimitives = " + Arrays.toString(this.getSupportedPrimitivesNames()));
        pw.println("supportedBraking = " + Arrays.toString(this.getSupportedBrakingNames()));
        pw.println("primitiveDelayMax = " + this.mPrimitiveDelayMax);
        pw.println("compositionSizeMax = " + this.mCompositionSizeMax);
        pw.println("pwlePrimitiveDurationMax = " + this.mPwlePrimitiveDurationMax);
        pw.println("pwleSizeMax = " + this.mPwleSizeMax);
        pw.println("q-factor = " + this.mQFactor);
        pw.println("frequencyProfileLegacy = " + this.mFrequencyProfileLegacy);
        pw.println("frequencyProfile = " + this.mFrequencyProfile);
        pw.println("mMaxEnvelopeEffectSize = " + this.mMaxEnvelopeEffectSize);
        pw.println("mMinEnvelopeEffectControlPointDurationMillis = " + this.mMinEnvelopeEffectControlPointDurationMillis);
        pw.println("mMaxEnvelopeEffectControlPointDurationMillis = " + this.mMaxEnvelopeEffectControlPointDurationMillis);
        pw.decreaseIndent();
    }

    public int getId() {
        return this.mId;
    }

    public boolean hasAmplitudeControl() {
        return this.hasCapability(4L);
    }

    public boolean hasFrequencyControl() {
        return this.hasCapability(512L);
    }

    public int getDefaultBraking() {
        if (this.mSupportedBraking != null) {
            int size = this.mSupportedBraking.size();
            for (int i = 0; i < size; ++i) {
                if (this.mSupportedBraking.keyAt(i) == 0) continue;
                return this.mSupportedBraking.keyAt(i);
            }
        }
        return 0;
    }

    @Nullable
    public SparseBooleanArray getSupportedBraking() {
        if (this.mSupportedBraking == null) {
            return null;
        }
        return this.mSupportedBraking.clone();
    }

    public boolean isBrakingSupportKnown() {
        return this.mSupportedBraking != null;
    }

    public boolean hasBrakingSupport(@Braking int braking) {
        return this.mSupportedBraking != null && this.mSupportedBraking.get(braking);
    }

    public boolean isEffectSupportKnown() {
        return this.mSupportedEffects != null;
    }

    public int isEffectSupported(int effectId) {
        if (this.mSupportedEffects == null) {
            return 0;
        }
        return this.mSupportedEffects.get(effectId) ? 1 : 2;
    }

    @Nullable
    public SparseBooleanArray getSupportedEffects() {
        if (this.mSupportedEffects == null) {
            return null;
        }
        return this.mSupportedEffects.clone();
    }

    public boolean isPrimitiveSupported(int primitiveId) {
        return this.hasCapability(32L) && this.mSupportedPrimitives.indexOfKey(primitiveId) >= 0;
    }

    public boolean areVibrationFeaturesSupported(@NonNull VibrationEffect effect) {
        return effect.areVibrationFeaturesSupported(this);
    }

    public int getPrimitiveDuration(int primitiveId) {
        return this.mSupportedPrimitives.get(primitiveId);
    }

    public SparseIntArray getSupportedPrimitives() {
        return this.mSupportedPrimitives.clone();
    }

    public int getPrimitiveDelayMax() {
        return this.mPrimitiveDelayMax;
    }

    public int getCompositionSizeMax() {
        return this.mCompositionSizeMax;
    }

    public int getPwlePrimitiveDurationMax() {
        return this.mPwlePrimitiveDurationMax;
    }

    public int getPwleSizeMax() {
        return this.mPwleSizeMax;
    }

    public boolean areEnvelopeEffectsSupported() {
        return this.hasCapability(4608L);
    }

    public int getMaxEnvelopeEffectDurationMillis() {
        return this.mMaxEnvelopeEffectSize * this.mMaxEnvelopeEffectControlPointDurationMillis;
    }

    public int getMaxEnvelopeEffectSize() {
        return this.mMaxEnvelopeEffectSize;
    }

    public int getMinEnvelopeEffectControlPointDurationMillis() {
        return this.mMinEnvelopeEffectControlPointDurationMillis;
    }

    public int getMaxEnvelopeEffectControlPointDurationMillis() {
        return this.mMaxEnvelopeEffectControlPointDurationMillis;
    }

    public boolean hasCapability(long capability) {
        return (this.mCapabilities & capability) == capability;
    }

    public float getResonantFrequencyHz() {
        if (Flags.normalizedPwleEffects()) {
            return this.mFrequencyProfile.mResonantFrequencyHz;
        }
        return this.mFrequencyProfileLegacy.mResonantFrequencyHz;
    }

    public float getQFactor() {
        return this.mQFactor;
    }

    @NonNull
    public FrequencyProfileLegacy getFrequencyProfileLegacy() {
        return this.mFrequencyProfileLegacy;
    }

    @NonNull
    public FrequencyProfile getFrequencyProfile() {
        return this.mFrequencyProfile;
    }

    public long getCapabilities() {
        return this.mCapabilities;
    }

    private String[] getCapabilitiesNames() {
        ArrayList<String> names = new ArrayList<String>();
        if (this.hasCapability(1L)) {
            names.add("ON_CALLBACK");
        }
        if (this.hasCapability(2L)) {
            names.add("PERFORM_CALLBACK");
        }
        if (this.hasCapability(32L)) {
            names.add("COMPOSE_EFFECTS");
        }
        if (this.hasCapability(1024L)) {
            names.add("COMPOSE_PWLE_EFFECTS");
        }
        if (this.hasCapability(64L)) {
            names.add("ALWAYS_ON_CONTROL");
        }
        if (this.hasCapability(4L)) {
            names.add("AMPLITUDE_CONTROL");
        }
        if (this.hasCapability(512L)) {
            names.add("FREQUENCY_CONTROL");
        }
        if (this.hasCapability(8L)) {
            names.add("EXTERNAL_CONTROL");
        }
        if (this.hasCapability(16L)) {
            names.add("EXTERNAL_AMPLITUDE_CONTROL");
        }
        if (this.hasCapability(4096L)) {
            names.add("CAP_COMPOSE_PWLE_EFFECTS_V2");
        }
        return names.toArray(new String[names.size()]);
    }

    private String[] getSupportedEffectsNames() {
        if (this.mSupportedEffects == null) {
            return new String[0];
        }
        String[] names = new String[this.mSupportedEffects.size()];
        for (int i = 0; i < this.mSupportedEffects.size(); ++i) {
            names[i] = VibrationEffect.effectIdToString(this.mSupportedEffects.keyAt(i));
        }
        return names;
    }

    private String[] getSupportedBrakingNames() {
        if (this.mSupportedBraking == null) {
            return new String[0];
        }
        String[] names = new String[this.mSupportedBraking.size()];
        block4: for (int i = 0; i < this.mSupportedBraking.size(); ++i) {
            switch (this.mSupportedBraking.keyAt(i)) {
                case 0: {
                    names[i] = "NONE";
                    continue block4;
                }
                case 1: {
                    names[i] = "CLAB";
                    continue block4;
                }
                default: {
                    names[i] = Integer.toString(this.mSupportedBraking.keyAt(i));
                }
            }
        }
        return names;
    }

    private String[] getSupportedPrimitivesNames() {
        int supportedPrimitivesCount = this.mSupportedPrimitives.size();
        String[] names = new String[supportedPrimitivesCount];
        for (int i = 0; i < supportedPrimitivesCount; ++i) {
            names[i] = VibrationEffect.Composition.primitiveToString(this.mSupportedPrimitives.keyAt(i)) + "(" + this.mSupportedPrimitives.valueAt(i) + "ms)";
        }
        return names;
    }

    public static class FrequencyProfileLegacy
    implements Parcelable {
        @Nullable
        private final Range<Float> mFrequencyRangeHz;
        private final float mMinFrequencyHz;
        private final float mResonantFrequencyHz;
        private final float mFrequencyResolutionHz;
        private final float[] mMaxAmplitudes;
        @NonNull
        public static final Parcelable.Creator<FrequencyProfileLegacy> CREATOR = new Parcelable.Creator<FrequencyProfileLegacy>(){

            @Override
            public FrequencyProfileLegacy createFromParcel(Parcel in) {
                return new FrequencyProfileLegacy(in);
            }

            public FrequencyProfileLegacy[] newArray(int size) {
                return new FrequencyProfileLegacy[size];
            }
        };

        FrequencyProfileLegacy(Parcel in) {
            this(in.readFloat(), in.readFloat(), in.readFloat(), in.createFloatArray());
        }

        public FrequencyProfileLegacy(float resonantFrequencyHz, float minFrequencyHz, float frequencyResolutionHz, float[] maxAmplitudes) {
            this.mMinFrequencyHz = minFrequencyHz;
            this.mResonantFrequencyHz = resonantFrequencyHz;
            this.mFrequencyResolutionHz = frequencyResolutionHz;
            this.mMaxAmplitudes = new float[maxAmplitudes == null ? 0 : maxAmplitudes.length];
            if (maxAmplitudes != null) {
                System.arraycopy(maxAmplitudes, 0, this.mMaxAmplitudes, 0, maxAmplitudes.length);
            }
            boolean isValid = !Float.isNaN(resonantFrequencyHz) && resonantFrequencyHz > 0.0f && !Float.isNaN(minFrequencyHz) && minFrequencyHz > 0.0f && !Float.isNaN(frequencyResolutionHz) && frequencyResolutionHz > 0.0f && this.mMaxAmplitudes.length > 0;
            for (int i = 0; i < this.mMaxAmplitudes.length; ++i) {
                isValid &= this.mMaxAmplitudes[i] >= 0.0f && this.mMaxAmplitudes[i] <= 1.0f;
            }
            float maxFrequencyHz = isValid ? minFrequencyHz + frequencyResolutionHz * (float)(this.mMaxAmplitudes.length - 1) : Float.NaN;
            this.mFrequencyRangeHz = (isValid &= !Float.isNaN(maxFrequencyHz) && resonantFrequencyHz >= minFrequencyHz && resonantFrequencyHz <= maxFrequencyHz && minFrequencyHz < maxFrequencyHz) ? Range.create(Float.valueOf(minFrequencyHz), Float.valueOf(maxFrequencyHz)) : null;
        }

        public boolean isEmpty() {
            return this.mFrequencyRangeHz == null;
        }

        @Nullable
        public Range<Float> getFrequencyRangeHz() {
            return this.mFrequencyRangeHz;
        }

        public float getMaxAmplitude(float frequencyHz) {
            if (this.isEmpty() || Float.isNaN(frequencyHz) || !this.mFrequencyRangeHz.contains(Float.valueOf(frequencyHz))) {
                return 0.0f;
            }
            float mappingFreq = frequencyHz - this.mMinFrequencyHz;
            int startIdx = MathUtils.constrain((int)Math.floor(mappingFreq / this.mFrequencyResolutionHz), 0, this.mMaxAmplitudes.length - 1);
            int nextIdx = MathUtils.constrain(startIdx + 1, 0, this.mMaxAmplitudes.length - 1);
            return MathUtils.constrainedMap(this.mMaxAmplitudes[startIdx], this.mMaxAmplitudes[nextIdx], (float)startIdx * this.mFrequencyResolutionHz, (float)nextIdx * this.mFrequencyResolutionHz, mappingFreq);
        }

        @NonNull
        public float[] getMaxAmplitudes() {
            return Arrays.copyOf(this.mMaxAmplitudes, this.mMaxAmplitudes.length);
        }

        public float getFrequencyResolutionHz() {
            return this.mFrequencyResolutionHz;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeFloat(this.mResonantFrequencyHz);
            dest.writeFloat(this.mMinFrequencyHz);
            dest.writeFloat(this.mFrequencyResolutionHz);
            dest.writeFloatArray(this.mMaxAmplitudes);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FrequencyProfileLegacy)) {
                return false;
            }
            FrequencyProfileLegacy that = (FrequencyProfileLegacy)o;
            return Float.compare(this.mMinFrequencyHz, that.mMinFrequencyHz) == 0 && Float.compare(this.mResonantFrequencyHz, that.mResonantFrequencyHz) == 0 && Float.compare(this.mFrequencyResolutionHz, that.mFrequencyResolutionHz) == 0 && Arrays.equals(this.mMaxAmplitudes, that.mMaxAmplitudes);
        }

        public int hashCode() {
            int hashCode = Objects.hash(Float.valueOf(this.mMinFrequencyHz), Float.valueOf(this.mFrequencyResolutionHz), Float.valueOf(this.mFrequencyResolutionHz));
            hashCode = 31 * hashCode + Arrays.hashCode(this.mMaxAmplitudes);
            return hashCode;
        }

        public String toString() {
            return "FrequencyProfileLegacy{mFrequencyRange=" + this.mFrequencyRangeHz + ", mMinFrequency=" + this.mMinFrequencyHz + ", mResonantFrequency=" + this.mResonantFrequencyHz + ", mFrequencyResolution=" + this.mFrequencyResolutionHz + ", mMaxAmplitudes count=" + this.mMaxAmplitudes.length + '}';
        }
    }

    public static class FrequencyProfile
    implements Parcelable {
        private final float[] mFrequenciesHz;
        private final float[] mOutputAccelerationsGs;
        private final float mResonantFrequencyHz;
        private final float mMaxOutputAccelerationGs;
        private final float mMinFrequencyHz;
        private final float mMaxFrequencyHz;
        @NonNull
        public static final Parcelable.Creator<FrequencyProfile> CREATOR = new Parcelable.Creator<FrequencyProfile>(){

            @Override
            public FrequencyProfile createFromParcel(Parcel in) {
                return new FrequencyProfile(in);
            }

            public FrequencyProfile[] newArray(int size) {
                return new FrequencyProfile[size];
            }
        };

        public FrequencyProfile(Parcel in) {
            this(in.readFloat(), in.createFloatArray(), in.createFloatArray());
        }

        public FrequencyProfile(float resonantFrequencyHz, float[] frequenciesHz, float[] outputAccelerationsGs) {
            boolean isValid;
            this.mResonantFrequencyHz = resonantFrequencyHz;
            boolean bl = isValid = !Float.isNaN(resonantFrequencyHz) && resonantFrequencyHz > 0.0f && frequenciesHz != null && outputAccelerationsGs != null && frequenciesHz.length == outputAccelerationsGs.length && frequenciesHz.length > 0;
            if (!isValid) {
                this.mFrequenciesHz = null;
                this.mOutputAccelerationsGs = null;
                this.mMinFrequencyHz = Float.NaN;
                this.mMaxFrequencyHz = Float.NaN;
                this.mMaxOutputAccelerationGs = Float.NaN;
                return;
            }
            TreeMap<Float, Float> frequencyToOutputAccelerationMap = new TreeMap<Float, Float>();
            for (int i = 0; i < frequenciesHz.length; ++i) {
                frequencyToOutputAccelerationMap.putIfAbsent(Float.valueOf(frequenciesHz[i]), Float.valueOf(outputAccelerationsGs[i]));
            }
            float[] frequencies = new float[frequencyToOutputAccelerationMap.size()];
            float[] accelerations = new float[frequencyToOutputAccelerationMap.size()];
            float maxOutputAccelerationGs = 0.0f;
            int i = 0;
            for (Map.Entry entry : frequencyToOutputAccelerationMap.entrySet()) {
                frequencies[i] = ((Float)entry.getKey()).floatValue();
                accelerations[i] = ((Float)entry.getValue()).floatValue();
                maxOutputAccelerationGs = Math.max(maxOutputAccelerationGs, ((Float)entry.getValue()).floatValue());
                ++i;
            }
            this.mFrequenciesHz = frequencies;
            this.mOutputAccelerationsGs = accelerations;
            this.mMinFrequencyHz = this.mFrequenciesHz[0];
            this.mMaxFrequencyHz = this.mFrequenciesHz[this.mFrequenciesHz.length - 1];
            this.mMaxOutputAccelerationGs = maxOutputAccelerationGs;
        }

        public boolean isEmpty() {
            return this.mFrequenciesHz == null;
        }

        @Nullable
        public float[] getFrequenciesHz() {
            return this.mFrequenciesHz;
        }

        @Nullable
        public float[] getOutputAccelerationsGs() {
            return this.mOutputAccelerationsGs;
        }

        public float getMaxOutputAccelerationGs() {
            return this.mMaxOutputAccelerationGs;
        }

        public float getOutputAccelerationGs(float frequencyHz) {
            if (this.mFrequenciesHz == null) {
                return Float.NaN;
            }
            if (frequencyHz < this.mMinFrequencyHz || frequencyHz > this.mMaxFrequencyHz) {
                return 0.0f;
            }
            int idx = Arrays.binarySearch(this.mFrequenciesHz, frequencyHz);
            if (idx >= 0) {
                return this.mOutputAccelerationsGs[idx];
            }
            idx = -idx - 2;
            return MathUtils.constrainedMap(this.mOutputAccelerationsGs[idx], this.mOutputAccelerationsGs[idx + 1], this.mFrequenciesHz[idx], this.mFrequenciesHz[idx + 1], frequencyHz);
        }

        public float getMinFrequencyHz() {
            return this.mMinFrequencyHz;
        }

        public float getMaxFrequencyHz() {
            return this.mMaxFrequencyHz;
        }

        @Nullable
        public Range<Float> getFrequencyRangeHz(float minOutputAcceleration) {
            int i;
            if (this.mFrequenciesHz == null || this.mOutputAccelerationsGs == null || minOutputAcceleration > this.mMaxOutputAccelerationGs) {
                return null;
            }
            if (minOutputAcceleration <= 0.0f) {
                return new Range<Float>(Float.valueOf(this.mMinFrequencyHz), Float.valueOf(this.mMaxFrequencyHz));
            }
            float minFrequency = Float.NaN;
            float maxFrequency = Float.NaN;
            int lowerFrequencyBoundIndex = 0;
            for (i = 0; i < this.mOutputAccelerationsGs.length; ++i) {
                if (!(this.mOutputAccelerationsGs[i] >= minOutputAcceleration)) continue;
                minFrequency = i == 0 ? this.mMinFrequencyHz : MathUtils.constrainedMap(this.mFrequenciesHz[i - 1], this.mFrequenciesHz[i], this.mOutputAccelerationsGs[i - 1], this.mOutputAccelerationsGs[i], minOutputAcceleration);
                lowerFrequencyBoundIndex = i;
                break;
            }
            if (Float.isNaN(minFrequency)) {
                return null;
            }
            for (i = lowerFrequencyBoundIndex; i < this.mOutputAccelerationsGs.length; ++i) {
                if (!(this.mOutputAccelerationsGs[i] <= minOutputAcceleration)) continue;
                maxFrequency = MathUtils.constrainedMap(this.mFrequenciesHz[i - 1], this.mFrequenciesHz[i], this.mOutputAccelerationsGs[i - 1], this.mOutputAccelerationsGs[i], minOutputAcceleration);
                break;
            }
            if (Float.isNaN(maxFrequency)) {
                maxFrequency = this.mMaxFrequencyHz;
            }
            return new Range<Float>(Float.valueOf(minFrequency), Float.valueOf(maxFrequency));
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeFloat(this.mResonantFrequencyHz);
            dest.writeFloatArray(this.mFrequenciesHz);
            dest.writeFloatArray(this.mOutputAccelerationsGs);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FrequencyProfile)) {
                return false;
            }
            FrequencyProfile that = (FrequencyProfile)o;
            return Float.compare(this.mResonantFrequencyHz, that.mResonantFrequencyHz) == 0 && Arrays.equals(this.mFrequenciesHz, that.mFrequenciesHz) && Arrays.equals(this.mOutputAccelerationsGs, that.mOutputAccelerationsGs);
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.mResonantFrequencyHz), Arrays.hashCode(this.mFrequenciesHz), Arrays.hashCode(this.mOutputAccelerationsGs));
        }

        public String toString() {
            return "FrequencyProfile{mResonantFrequency=" + this.mResonantFrequencyHz + ", mFrequenciesHz=" + Arrays.toString(this.mFrequenciesHz) + ", mOutputAccelerationsGs=" + Arrays.toString(this.mOutputAccelerationsGs) + ", mMinFrequencyHz=" + this.mMinFrequencyHz + ", mMaxFrequencyHz=" + this.mMaxFrequencyHz + ", mMaxOutputAccelerationGs=" + this.mMaxOutputAccelerationGs + '}';
        }

        private static void deduplicateAndSortList(List<Pair<Float, Float>> list) {
            if (list == null || list.size() < 2) {
                return;
            }
            list.sort(Comparator.comparing(pair -> (Float)pair.first));
            int writeIndex = 1;
            for (int i = 1; i < list.size(); ++i) {
                Pair<Float, Float> currentPair = list.get(i);
                Pair<Float, Float> previousPair = list.get(writeIndex - 1);
                if (((Float)currentPair.first).compareTo((Float)previousPair.first) == 0) continue;
                list.set(writeIndex++, currentPair);
            }
            list.subList(writeIndex, list.size()).clear();
        }

        private static ArrayList<Pair<Float, Float>> extractFrequencyToOutputAccelerationData(float[] frequencies, float[] outputAccelerations) {
            if (frequencies == null || outputAccelerations == null || frequencies.length == 0 || frequencies.length != outputAccelerations.length) {
                return new ArrayList<Pair<Float, Float>>();
            }
            ArrayList<Pair<Float, Float>> frequencyToOutputAccelerationList = new ArrayList<Pair<Float, Float>>(frequencies.length);
            for (int i = 0; i < frequencies.length; ++i) {
                frequencyToOutputAccelerationList.add(new Pair<Float, Float>(Float.valueOf(frequencies[i]), Float.valueOf(outputAccelerations[i])));
            }
            return frequencyToOutputAccelerationList;
        }
    }

    public static class Builder {
        private final int mId;
        private long mCapabilities;
        private SparseBooleanArray mSupportedEffects;
        private SparseBooleanArray mSupportedBraking;
        private SparseIntArray mSupportedPrimitives = new SparseIntArray();
        private int mPrimitiveDelayMax;
        private int mCompositionSizeMax;
        private int mPwlePrimitiveDurationMax;
        private int mPwleSizeMax;
        private float mQFactor = Float.NaN;
        private FrequencyProfileLegacy mFrequencyProfileLegacy = new FrequencyProfileLegacy(Float.NaN, Float.NaN, Float.NaN, null);
        private FrequencyProfile mFrequencyProfile = new FrequencyProfile(Float.NaN, null, null);
        private int mMaxEnvelopeEffectSize;
        private int mMinEnvelopeEffectControlPointDurationMillis;
        private int mMaxEnvelopeEffectControlPointDurationMillis;

        public Builder(int id2) {
            this.mId = id2;
        }

        @NonNull
        public Builder setCapabilities(long capabilities) {
            this.mCapabilities = capabilities;
            return this;
        }

        @NonNull
        public Builder setSupportedEffects(int ... supportedEffects) {
            this.mSupportedEffects = Builder.toSparseBooleanArray(supportedEffects);
            return this;
        }

        @NonNull
        public Builder setSupportedBraking(int ... supportedBraking) {
            this.mSupportedBraking = Builder.toSparseBooleanArray(supportedBraking);
            return this;
        }

        @NonNull
        public Builder setPwlePrimitiveDurationMax(int pwlePrimitiveDurationMax) {
            this.mPwlePrimitiveDurationMax = pwlePrimitiveDurationMax;
            return this;
        }

        @NonNull
        public Builder setPwleSizeMax(int pwleSizeMax) {
            this.mPwleSizeMax = pwleSizeMax;
            return this;
        }

        @NonNull
        public Builder setSupportedPrimitive(int primitiveId, int duration) {
            this.mSupportedPrimitives.put(primitiveId, duration);
            return this;
        }

        @NonNull
        public Builder setPrimitiveDelayMax(int primitiveDelayMax) {
            this.mPrimitiveDelayMax = primitiveDelayMax;
            return this;
        }

        @NonNull
        public Builder setCompositionSizeMax(int compositionSizeMax) {
            this.mCompositionSizeMax = compositionSizeMax;
            return this;
        }

        @NonNull
        public Builder setQFactor(float qFactor) {
            this.mQFactor = qFactor;
            return this;
        }

        @NonNull
        public Builder setFrequencyProfileLegacy(@NonNull FrequencyProfileLegacy frequencyProfile) {
            this.mFrequencyProfileLegacy = frequencyProfile;
            return this;
        }

        @NonNull
        public Builder setFrequencyProfile(@NonNull FrequencyProfile frequencyProfile) {
            this.mFrequencyProfile = frequencyProfile;
            return this;
        }

        @NonNull
        public Builder setMaxEnvelopeEffectSize(int maxEnvelopeEffectSize) {
            this.mMaxEnvelopeEffectSize = maxEnvelopeEffectSize;
            return this;
        }

        @NonNull
        public Builder setMinEnvelopeEffectControlPointDurationMillis(int minEnvelopeEffectControlPointDuration) {
            this.mMinEnvelopeEffectControlPointDurationMillis = minEnvelopeEffectControlPointDuration;
            return this;
        }

        @NonNull
        public Builder setMaxEnvelopeEffectControlPointDurationMillis(int maxEnvelopeEffectControlPointDuration) {
            this.mMaxEnvelopeEffectControlPointDurationMillis = maxEnvelopeEffectControlPointDuration;
            return this;
        }

        @NonNull
        public VibratorInfo build() {
            return new VibratorInfo(this.mId, this.mCapabilities, this.mSupportedEffects, this.mSupportedBraking, this.mSupportedPrimitives, this.mPrimitiveDelayMax, this.mCompositionSizeMax, this.mPwlePrimitiveDurationMax, this.mPwleSizeMax, this.mQFactor, this.mFrequencyProfileLegacy, this.mFrequencyProfile, this.mMaxEnvelopeEffectSize, this.mMinEnvelopeEffectControlPointDurationMillis, this.mMaxEnvelopeEffectControlPointDurationMillis);
        }

        @Nullable
        private static SparseBooleanArray toSparseBooleanArray(int[] supportedKeys) {
            if (supportedKeys == null) {
                return null;
            }
            SparseBooleanArray array2 = new SparseBooleanArray();
            for (int key : supportedKeys) {
                array2.put(key, true);
            }
            return array2;
        }
    }
}

