/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.app.ActivityThread;
import android.content.Context;
import android.os.CancellationSignal;
import android.os.CombinedVibration;
import android.os.Process;
import android.os.VibrationAttributes;
import android.os.Vibrator;
import android.os.vibrator.VendorVibrationSession;
import android.util.Log;
import java.util.concurrent.Executor;

public abstract class VibratorManager {
    private static final String TAG = "VibratorManager";
    protected final String mPackageName;

    public VibratorManager() {
        this.mPackageName = ActivityThread.currentPackageName();
    }

    protected VibratorManager(Context context) {
        this.mPackageName = context.getOpPackageName();
    }

    @NonNull
    public abstract int[] getVibratorIds();

    public boolean hasCapabilities(int capabilities) {
        return false;
    }

    @NonNull
    public abstract Vibrator getVibrator(int var1);

    @NonNull
    public abstract Vibrator getDefaultVibrator();

    @RequiresPermission(value="android.permission.VIBRATE_ALWAYS_ON")
    public boolean setAlwaysOnEffect(int uid, String opPkg, int alwaysOnId, @Nullable CombinedVibration effect, @Nullable VibrationAttributes attributes) {
        Log.w(TAG, "Always-on effects aren't supported");
        return false;
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    public void vibrate(@NonNull CombinedVibration effect) {
        this.vibrate(effect, null);
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    public void vibrate(@NonNull CombinedVibration effect, @Nullable VibrationAttributes attributes) {
        this.vibrate(Process.myUid(), this.mPackageName, effect, null, attributes);
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    public abstract void vibrate(int var1, String var2, @NonNull CombinedVibration var3, String var4, @Nullable VibrationAttributes var5);

    public void performHapticFeedback(int constant, String reason, int flags, int privFlags) {
        Log.w(TAG, "performHapticFeedback is not supported");
    }

    public void performHapticFeedbackForInputDevice(int constant, int inputDeviceId, int inputSource, String reason, int flags, int privFlags) {
        Log.w(TAG, "performHapticFeedbackForInputDevice is not supported");
    }

    @RequiresPermission(value="android.permission.VIBRATE")
    public abstract void cancel();

    @RequiresPermission(value="android.permission.VIBRATE")
    public abstract void cancel(int var1);

    @RequiresPermission(allOf={"android.permission.VIBRATE", "android.permission.VIBRATE_VENDOR_EFFECTS", "android.permission.START_VIBRATION_SESSIONS"})
    public void startVendorSession(@NonNull int[] vibratorIds, @NonNull VibrationAttributes attrs, @Nullable String reason, @Nullable CancellationSignal cancellationSignal, @NonNull Executor executor, @NonNull VendorVibrationSession.Callback callback) {
        Log.w(TAG, "startVendorSession is not supported");
    }
}

