/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.app.Application;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.IDeviceIdentifiersPolicyService;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.VintfObject;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.sysprop.BackportedFixesProperties;
import android.sysprop.DeviceProperties;
import android.sysprop.SocProperties;
import android.sysprop.TelephonyProperties;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.Slog;
import com.android.internal.util.FrameworkStatsLog;
import dalvik.system.VMRuntime;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@RavenwoodKeepWholeClass
public class _Original_Build {
    private static final String TAG = "Build";
    public static final String UNKNOWN = "unknown";
    public static final String ID = _Original_Build.getString("ro.build.id");
    public static final String DISPLAY = _Original_Build.getString("ro.build.display.id");
    public static final String PRODUCT = _Original_Build.getString("ro.product.name");
    @Nullable
    public static final String PRODUCT_FOR_ATTESTATION = _Original_Build.getVendorDeviceIdProperty("name");
    public static final String DEVICE = _Original_Build.getString("ro.product.device");
    @Nullable
    public static final String DEVICE_FOR_ATTESTATION = _Original_Build.getVendorDeviceIdProperty("device");
    public static final String BOARD = _Original_Build.getString("ro.product.board");
    @Deprecated
    public static final String CPU_ABI;
    @Deprecated
    public static final String CPU_ABI2;
    public static final String MANUFACTURER;
    @Nullable
    public static final String MANUFACTURER_FOR_ATTESTATION;
    public static final String BRAND;
    @Nullable
    public static final String BRAND_FOR_ATTESTATION;
    public static final String MODEL;
    @Nullable
    public static final String MODEL_FOR_ATTESTATION;
    @NonNull
    public static final String SOC_MANUFACTURER;
    @NonNull
    public static final String SOC_MODEL;
    public static final String BOOTLOADER;
    @Deprecated
    public static final String RADIO;
    public static final String HARDWARE;
    @NonNull
    public static final String SKU;
    @NonNull
    public static final String ODM_SKU;
    @UnsupportedAppUsage
    public static final boolean IS_EMULATOR;
    @Deprecated
    public static final String SERIAL;
    public static final String[] SUPPORTED_ABIS;
    public static final String[] SUPPORTED_32_BIT_ABIS;
    public static final String[] SUPPORTED_64_BIT_ABIS;
    public static final int VENDOR_API_2024_Q2 = 202404;
    public static final String TYPE;
    public static final String TAGS;
    public static final String FINGERPRINT;
    @FlaggedApi(value="android.os.api_for_backported_fixes")
    public static final int BACKPORTED_FIX_STATUS_UNKNOWN = 0;
    @FlaggedApi(value="android.os.api_for_backported_fixes")
    public static final int BACKPORTED_FIX_STATUS_FIXED = 1;
    @FlaggedApi(value="android.os.api_for_backported_fixes")
    public static final int BACKPORTED_FIX_STATUS_NOT_APPLICABLE = 2;
    @FlaggedApi(value="android.os.api_for_backported_fixes")
    public static final int BACKPORTED_FIX_STATUS_NOT_FIXED = 3;
    public static final int HW_TIMEOUT_MULTIPLIER;
    public static final boolean IS_TREBLE_ENABLED;
    public static final long TIME;
    public static final String USER;
    public static final String HOST;
    @UnsupportedAppUsage
    public static final boolean IS_DEBUGGABLE;
    public static final boolean IS_ENG;
    public static final boolean IS_USERDEBUG;
    public static final boolean IS_USER;
    public static final boolean IS_ARC;
    @SystemApi
    public static final boolean PERMISSIONS_REVIEW_REQUIRED = true;

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public static String getSerial() {
        IDeviceIdentifiersPolicyService service = IDeviceIdentifiersPolicyService.Stub.asInterface(ServiceManager.getService("device_identifiers"));
        try {
            Application application = ActivityThread.currentApplication();
            String callingPackage = application != null ? application.getPackageName() : null;
            return service.getSerialForPackage(callingPackage, null);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return UNKNOWN;
        }
    }

    public static boolean is64BitAbi(String abi) {
        return VMRuntime.is64BitAbi(abi);
    }

    @FlaggedApi(value="android.sdk.major_minor_versioning_scheme")
    public static int getMajorSdkVersion(int sdkIntFull) {
        return sdkIntFull / 100000;
    }

    @FlaggedApi(value="android.sdk.major_minor_versioning_scheme")
    public static int getMinorSdkVersion(int sdkIntFull) {
        return sdkIntFull % 100000;
    }

    @SuppressLint(value={"InlinedApi"})
    public static int parseFullVersion(@NonNull String version) {
        int major;
        int index = version.indexOf(46);
        int minor = 0;
        try {
            if (index == -1) {
                major = Integer.parseInt(version);
            } else {
                major = Integer.parseInt(version.substring(0, index));
                minor = Integer.parseInt(version.substring(index + 1));
            }
            if (major < 0) {
                throw new NumberFormatException("negative major version");
            }
            if (major >= 21474) {
                throw new NumberFormatException("major version too large, must be less than 21474");
            }
            if (minor < 0) {
                throw new NumberFormatException("negative minor version");
            }
            if (minor >= 100000) {
                throw new NumberFormatException("minor version too large, must be less than 100000");
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("failed to parse '" + version + "' as a major.minor version code", e);
        }
        return major * 100000 + minor;
    }

    public static String fullVersionToString(int version) {
        if (version < 0) {
            throw new IllegalArgumentException("failed to convert '" + version + "' to string: not a valid major.minor version code");
        }
        return String.format("%d.%d", _Original_Build.getMajorSdkVersion(version), _Original_Build.getMinorSdkVersion(version));
    }

    @FlaggedApi(value="android.os.api_for_backported_fixes")
    public static int getBackportedFixStatus(long id2) {
        int status = 0;
        int uid = Binder.getCallingUid();
        if (id2 > 0L && id2 <= 1023L) {
            status = _Original_Build.isBitSet(BackportedFixesProperties.alias_bitset(), (int)id2) ? 1 : 0;
        }
        FrameworkStatsLog.write(987, uid, id2, status);
        return status;
    }

    private static boolean isBitSet(List<Long> bitsetLongArray, int bitIndex) {
        if (bitIndex < 0) {
            return false;
        }
        int arrayIndex = bitIndex >> 6;
        if (bitsetLongArray.size() <= arrayIndex) {
            return false;
        }
        return (bitsetLongArray.get(arrayIndex) & 1L << bitIndex) != 0L;
    }

    private static String deriveFingerprint() {
        String finger = SystemProperties.get("ro.build.fingerprint");
        if (TextUtils.isEmpty(finger)) {
            finger = _Original_Build.getString("ro.product.brand") + '/' + _Original_Build.getString("ro.product.name") + '/' + _Original_Build.getString("ro.product.device") + ':' + _Original_Build.getString("ro.build.version.release") + '/' + _Original_Build.getString("ro.build.id") + '/' + _Original_Build.getString("ro.build.version.incremental") + ':' + _Original_Build.getString("ro.build.type") + '/' + _Original_Build.getString("ro.build.tags");
        }
        return finger;
    }

    public static void ensureFingerprintProperty() {
        if (TextUtils.isEmpty(SystemProperties.get("ro.build.fingerprint"))) {
            try {
                SystemProperties.set("ro.build.fingerprint", FINGERPRINT);
            }
            catch (IllegalArgumentException e) {
                Slog.e(TAG, "Failed to set fingerprint property", e);
            }
        }
    }

    public static boolean isBuildConsistent() {
        if (IS_ENG) {
            return true;
        }
        if (IS_TREBLE_ENABLED) {
            int result = VintfObject.verifyBuildAtBoot();
            if (result != 0) {
                Slog.e(TAG, "Vendor interface is incompatible, error=" + String.valueOf(result));
            }
            return result == 0;
        }
        String system = SystemProperties.get("ro.system.build.fingerprint");
        String vendor = SystemProperties.get("ro.vendor.build.fingerprint");
        String bootimage = SystemProperties.get("ro.bootimage.build.fingerprint");
        String requiredBootloader = SystemProperties.get("ro.build.expect.bootloader");
        String currentBootloader = SystemProperties.get("ro.bootloader");
        String requiredRadio = SystemProperties.get("ro.build.expect.baseband");
        String currentRadio = _Original_Build.joinListOrElse(TelephonyProperties.baseband_version(), "");
        if (TextUtils.isEmpty(system)) {
            Slog.e(TAG, "Required ro.system.build.fingerprint is empty!");
            return false;
        }
        if (!TextUtils.isEmpty(vendor) && !Objects.equals(system, vendor)) {
            Slog.e(TAG, "Mismatched fingerprints; system reported " + system + " but vendor reported " + vendor);
            return false;
        }
        return true;
    }

    @NonNull
    public static List<Partition> getFingerprintedPartitions() {
        String[] names;
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        for (String name : names = new String[]{"bootimage", "odm", "product", "system_ext", "system", "vendor"}) {
            String fingerprint = SystemProperties.get("ro." + name + ".build.fingerprint");
            if (TextUtils.isEmpty(fingerprint)) continue;
            long time = _Original_Build.getLong("ro." + name + ".build.date.utc") * 1000L;
            partitions.add(new Partition(name, fingerprint, time));
        }
        return partitions;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static boolean isDebuggable() {
        return IS_DEBUGGABLE;
    }

    public static String getRadioVersion() {
        return _Original_Build.joinListOrElse(TelephonyProperties.baseband_version(), null);
    }

    @UnsupportedAppUsage
    private static String getString(String property) {
        return SystemProperties.get(property, UNKNOWN);
    }

    private static String getVendorDeviceIdProperty(String property) {
        String attestProp = _Original_Build.getString(TextUtils.formatSimple("ro.product.%s_for_attestation", property));
        return attestProp.equals(UNKNOWN) ? _Original_Build.getString(TextUtils.formatSimple("ro.product.vendor.%s", property)) : attestProp;
    }

    private static String[] getStringList(String property, String separator) {
        String value = SystemProperties.get(property);
        if (value.isEmpty()) {
            return new String[0];
        }
        return value.split(separator);
    }

    @UnsupportedAppUsage
    private static long getLong(String property) {
        try {
            return Long.parseLong(SystemProperties.get(property));
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private static <T> String joinListOrElse(List<T> list, String defaultValue) {
        String ret = list.stream().map(elem -> elem == null ? "" : elem.toString()).collect(Collectors.joining(","));
        return ret.isEmpty() ? defaultValue : ret;
    }

    static {
        MANUFACTURER = _Original_Build.getString("ro.product.manufacturer");
        MANUFACTURER_FOR_ATTESTATION = _Original_Build.getVendorDeviceIdProperty("manufacturer");
        BRAND = _Original_Build.getString("ro.product.brand");
        BRAND_FOR_ATTESTATION = _Original_Build.getVendorDeviceIdProperty("brand");
        MODEL = _Original_Build.getString("ro.product.model");
        MODEL_FOR_ATTESTATION = _Original_Build.getVendorDeviceIdProperty("model");
        SOC_MANUFACTURER = SocProperties.soc_manufacturer().orElse(UNKNOWN);
        SOC_MODEL = SocProperties.soc_model().orElse(UNKNOWN);
        BOOTLOADER = _Original_Build.getString("ro.bootloader");
        RADIO = _Original_Build.joinListOrElse(TelephonyProperties.baseband_version(), UNKNOWN);
        HARDWARE = _Original_Build.getString("ro.hardware");
        SKU = _Original_Build.getString("ro.boot.hardware.sku");
        ODM_SKU = _Original_Build.getString("ro.boot.product.hardware.sku");
        IS_EMULATOR = _Original_Build.getString("ro.boot.qemu").equals("1");
        SERIAL = _Original_Build.getString("no.such.thing");
        SUPPORTED_ABIS = _Original_Build.getStringList("ro.product.cpu.abilist", ",");
        SUPPORTED_32_BIT_ABIS = _Original_Build.getStringList("ro.product.cpu.abilist32", ",");
        SUPPORTED_64_BIT_ABIS = _Original_Build.getStringList("ro.product.cpu.abilist64", ",");
        String[] abiList = Process.is64Bit() ? SUPPORTED_64_BIT_ABIS : SUPPORTED_32_BIT_ABIS;
        CPU_ABI = abiList[0];
        CPU_ABI2 = abiList.length > 1 ? abiList[1] : "";
        TYPE = _Original_Build.getString("ro.build.type");
        TAGS = _Original_Build.getString("ro.build.tags");
        FINGERPRINT = _Original_Build.deriveFingerprint();
        HW_TIMEOUT_MULTIPLIER = SystemProperties.getInt("ro.hw_timeout_multiplier", 1);
        IS_TREBLE_ENABLED = SystemProperties.getBoolean("ro.treble.enabled", false);
        TIME = _Original_Build.getLong("ro.build.date.utc") * 1000L;
        USER = _Original_Build.getString("ro.build.user");
        HOST = _Original_Build.getString("ro.build.host");
        IS_DEBUGGABLE = SystemProperties.getInt("ro.debuggable", 0) == 1;
        IS_ENG = "eng".equals(TYPE);
        IS_USERDEBUG = "userdebug".equals(TYPE);
        IS_USER = "user".equals(TYPE);
        IS_ARC = SystemProperties.getBoolean("ro.boot.container", false);
    }

    @FlaggedApi(value="android.sdk.major_minor_versioning_scheme")
    @SuppressLint(value={"AcronymName"})
    public static class VERSION_CODES_FULL {
        private static final int SDK_INT_MULTIPLIER = 100000;
        public static final int BASE = 100000;
        public static final int BASE_1_1 = 200000;
        public static final int CUPCAKE = 300000;
        public static final int DONUT = 400000;
        public static final int ECLAIR = 500000;
        public static final int ECLAIR_0_1 = 600000;
        public static final int ECLAIR_MR1 = 700000;
        public static final int FROYO = 800000;
        public static final int GINGERBREAD = 900000;
        public static final int GINGERBREAD_MR1 = 1000000;
        public static final int HONEYCOMB = 1100000;
        public static final int HONEYCOMB_MR1 = 1200000;
        public static final int HONEYCOMB_MR2 = 1300000;
        public static final int ICE_CREAM_SANDWICH = 1400000;
        public static final int ICE_CREAM_SANDWICH_MR1 = 1500000;
        public static final int JELLY_BEAN = 1600000;
        public static final int JELLY_BEAN_MR1 = 1700000;
        public static final int JELLY_BEAN_MR2 = 1800000;
        public static final int KITKAT = 1900000;
        public static final int KITKAT_WATCH = 2000000;
        public static final int LOLLIPOP = 0x200B20;
        public static final int LOLLIPOP_MR1 = 2200000;
        public static final int M = 2300000;
        public static final int N = 2400000;
        public static final int N_MR1 = 2500000;
        public static final int O = 2600000;
        public static final int O_MR1 = 2700000;
        public static final int P = 2800000;
        public static final int Q = 2900000;
        public static final int R = 3000000;
        public static final int S = 3100000;
        public static final int S_V2 = 3200000;
        public static final int TIRAMISU = 3300000;
        public static final int UPSIDE_DOWN_CAKE = 3400000;
        public static final int VANILLA_ICE_CREAM = 3500000;
        public static final int BAKLAVA = 3600000;

        private VERSION_CODES_FULL() {
        }
    }

    public static class Partition {
        public static final String PARTITION_NAME_SYSTEM = "system";
        public static final String PARTITION_NAME_BOOTIMAGE = "bootimage";
        public static final String PARTITION_NAME_ODM = "odm";
        public static final String PARTITION_NAME_OEM = "oem";
        public static final String PARTITION_NAME_PRODUCT = "product";
        public static final String PARTITION_NAME_SYSTEM_EXT = "system_ext";
        public static final String PARTITION_NAME_VENDOR = "vendor";
        private final String mName;
        private final String mFingerprint;
        private final long mTimeMs;

        private Partition(String name, String fingerprint, long timeMs) {
            this.mName = name;
            this.mFingerprint = fingerprint;
            this.mTimeMs = timeMs;
        }

        @NonNull
        public String getName() {
            return this.mName;
        }

        @NonNull
        public String getFingerprint() {
            return this.mFingerprint;
        }

        public long getBuildTimeMillis() {
            return this.mTimeMs;
        }

        public boolean equals(@Nullable Object o) {
            if (!(o instanceof Partition)) {
                return false;
            }
            Partition op = (Partition)o;
            return this.mName.equals(op.mName) && this.mFingerprint.equals(op.mFingerprint) && this.mTimeMs == op.mTimeMs;
        }

        public int hashCode() {
            return Objects.hash(this.mName, this.mFingerprint, this.mTimeMs);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BackportedFixStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SdkIntFull {
    }

    public static class VERSION_CODES {
        public static final int CUR_DEVELOPMENT = 10000;
        public static final int BASE = 1;
        public static final int BASE_1_1 = 2;
        public static final int CUPCAKE = 3;
        public static final int DONUT = 4;
        public static final int ECLAIR = 5;
        public static final int ECLAIR_0_1 = 6;
        public static final int ECLAIR_MR1 = 7;
        public static final int FROYO = 8;
        public static final int GINGERBREAD = 9;
        public static final int GINGERBREAD_MR1 = 10;
        public static final int HONEYCOMB = 11;
        public static final int HONEYCOMB_MR1 = 12;
        public static final int HONEYCOMB_MR2 = 13;
        public static final int ICE_CREAM_SANDWICH = 14;
        public static final int ICE_CREAM_SANDWICH_MR1 = 15;
        public static final int JELLY_BEAN = 16;
        public static final int JELLY_BEAN_MR1 = 17;
        public static final int JELLY_BEAN_MR2 = 18;
        public static final int KITKAT = 19;
        public static final int KITKAT_WATCH = 20;
        public static final int L = 21;
        public static final int LOLLIPOP = 21;
        public static final int LOLLIPOP_MR1 = 22;
        public static final int M = 23;
        public static final int N = 24;
        public static final int N_MR1 = 25;
        public static final int O = 26;
        public static final int O_MR1 = 27;
        public static final int P = 28;
        public static final int Q = 29;
        public static final int R = 30;
        public static final int S = 31;
        public static final int S_V2 = 32;
        public static final int TIRAMISU = 33;
        public static final int UPSIDE_DOWN_CAKE = 34;
        public static final int VANILLA_ICE_CREAM = 35;
        @FlaggedApi(value="android.sdk.major_minor_versioning_scheme")
        public static final int BAKLAVA = 36;
    }

    public static class VERSION {
        public static final String INCREMENTAL = _Original_Build.getString("ro.build.version.incremental");
        public static final String RELEASE = _Original_Build.getString("ro.build.version.release");
        @NonNull
        public static final String RELEASE_OR_CODENAME = _Original_Build.getString("ro.build.version.release_or_codename");
        @NonNull
        public static final String RELEASE_OR_PREVIEW_DISPLAY = _Original_Build.getString("ro.build.version.release_or_preview_display");
        public static final String BASE_OS = SystemProperties.get("ro.build.version.base_os", "");
        public static final String SECURITY_PATCH = SystemProperties.get("ro.build.version.security_patch", "");
        public static final int MEDIA_PERFORMANCE_CLASS = DeviceProperties.media_performance_class().orElse(0);
        @Deprecated
        public static final String SDK = _Original_Build.getString("ro.build.version.sdk");
        public static final int SDK_INT = SystemProperties.getInt("ro.build.version.sdk", 0);
        @FlaggedApi(value="android.sdk.major_minor_versioning_scheme")
        public static final int SDK_INT_FULL = _Original_Build.parseFullVersion(SystemProperties.get("ro.build.version.sdk_full", ""));
        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        public static final int DEVICE_INITIAL_SDK_INT = SystemProperties.getInt("ro.product.first_api_level", 0);
        public static final int PREVIEW_SDK_INT = SystemProperties.getInt("ro.build.version.preview_sdk", 0);
        @SystemApi
        @NonNull
        public static final String PREVIEW_SDK_FINGERPRINT = SystemProperties.get("ro.build.version.preview_sdk_fingerprint", "REL");
        public static final String CODENAME = _Original_Build.getString("ro.build.version.codename");
        @SystemApi
        @NonNull
        public static final Set<String> KNOWN_CODENAMES = new ArraySet<String>(_Original_Build.getStringList("ro.build.version.known_codenames", ","));
        private static final String[] ALL_CODENAMES = _Original_Build.getStringList("ro.build.version.all_codenames", ",");
        @UnsupportedAppUsage
        public static final String[] ACTIVE_CODENAMES = "REL".equals(ALL_CODENAMES[0]) ? new String[]{} : ALL_CODENAMES;
        public static final int RESOURCES_SDK_INT = SDK_INT + ACTIVE_CODENAMES.length;
        public static final int MIN_SUPPORTED_TARGET_SDK_INT = SystemProperties.getInt("ro.build.version.min_supported_target_sdk", 0);
    }
}

