/*
 * Decompiled with CFR 0.152.
 */
package android.os.flagging;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.compat.annotation.UnsupportedAppUsage;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@FlaggedApi(value="android.provider.flags.new_storage_public_api")
public class AconfigStorageReadException
extends RuntimeException {
    @FlaggedApi(value="android.provider.flags.new_storage_public_api")
    public static final int ERROR_GENERIC = 0;
    @FlaggedApi(value="android.provider.flags.new_storage_public_api")
    public static final int ERROR_STORAGE_SYSTEM_NOT_FOUND = 1;
    @FlaggedApi(value="android.provider.flags.new_storage_public_api")
    public static final int ERROR_PACKAGE_NOT_FOUND = 2;
    @FlaggedApi(value="android.provider.flags.new_storage_public_api")
    public static final int ERROR_CONTAINER_NOT_FOUND = 3;
    @FlaggedApi(value="android.provider.flags.new_storage_public_api")
    public static final int ERROR_CANNOT_READ_STORAGE_FILE = 4;
    @UnsupportedAppUsage
    public static final int ERROR_FILE_FINGERPRINT_MISMATCH = 5;
    private final int mErrorCode;

    @FlaggedApi(value="android.provider.flags.new_storage_public_api")
    public AconfigStorageReadException(int errorCode, @NonNull String msg) {
        super(msg);
        this.mErrorCode = errorCode;
    }

    @FlaggedApi(value="android.provider.flags.new_storage_public_api")
    public AconfigStorageReadException(int errorCode, @NonNull String msg, @NonNull Throwable cause) {
        super(msg, cause);
        this.mErrorCode = errorCode;
    }

    @FlaggedApi(value="android.provider.flags.new_storage_public_api")
    public AconfigStorageReadException(int errorCode, @NonNull Throwable cause) {
        super(cause);
        this.mErrorCode = errorCode;
    }

    @FlaggedApi(value="android.provider.flags.new_storage_public_api")
    public int getErrorCode() {
        return this.mErrorCode;
    }

    @Override
    @NonNull
    @FlaggedApi(value="android.provider.flags.new_storage_public_api")
    public String getMessage() {
        return this.errorString() + ": " + super.getMessage();
    }

    @NonNull
    private String errorString() {
        switch (this.mErrorCode) {
            case 0: {
                return "ERROR_GENERIC";
            }
            case 1: {
                return "ERROR_STORAGE_SYSTEM_NOT_FOUND";
            }
            case 2: {
                return "ERROR_PACKAGE_NOT_FOUND";
            }
            case 3: {
                return "ERROR_CONTAINER_NOT_FOUND";
            }
            case 4: {
                return "ERROR_CANNOT_READ_STORAGE_FILE";
            }
            case 5: {
                return "ERROR_FILE_FINGERPRINT_MISMATCH";
            }
        }
        return "<Unknown error code " + this.mErrorCode + ">";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ErrorCode {
    }
}

