/*
 * Decompiled with CFR 0.152.
 */
package android.os.vibrator;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.VibrationEffect;
import android.os.VibratorInfo;
import android.os.vibrator.VibrationEffectSegment;
import com.android.internal.util.Preconditions;
import java.util.Locale;
import java.util.Objects;

@FlaggedApi(value="android.os.vibrator.normalized_pwle_effects")
public class BasicPwleSegment
extends VibrationEffectSegment {
    private final float mStartIntensity;
    private final float mEndIntensity;
    private final float mStartSharpness;
    private final float mEndSharpness;
    private final long mDuration;
    @NonNull
    public static final Parcelable.Creator<BasicPwleSegment> CREATOR = new Parcelable.Creator<BasicPwleSegment>(){

        @Override
        public BasicPwleSegment createFromParcel(Parcel in) {
            in.readInt();
            return new BasicPwleSegment(in);
        }

        public BasicPwleSegment[] newArray(int size) {
            return new BasicPwleSegment[size];
        }
    };

    BasicPwleSegment(@NonNull Parcel in) {
        this(in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readLong());
    }

    @FlaggedApi(value="android.os.vibrator.normalized_pwle_effects")
    public BasicPwleSegment(float startIntensity, float endIntensity, float startSharpness, float endSharpness, long duration) {
        this.mStartIntensity = startIntensity;
        this.mEndIntensity = endIntensity;
        this.mStartSharpness = startSharpness;
        this.mEndSharpness = endSharpness;
        this.mDuration = duration;
    }

    public float getStartIntensity() {
        return this.mStartIntensity;
    }

    public float getEndIntensity() {
        return this.mEndIntensity;
    }

    public float getStartSharpness() {
        return this.mStartSharpness;
    }

    public float getEndSharpness() {
        return this.mEndSharpness;
    }

    @Override
    public long getDuration() {
        return this.mDuration;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BasicPwleSegment)) {
            return false;
        }
        BasicPwleSegment other = (BasicPwleSegment)o;
        return Float.compare(this.mStartIntensity, other.mStartIntensity) == 0 && Float.compare(this.mEndIntensity, other.mEndIntensity) == 0 && Float.compare(this.mStartSharpness, other.mStartSharpness) == 0 && Float.compare(this.mEndSharpness, other.mEndSharpness) == 0 && this.mDuration == other.mDuration;
    }

    @Override
    public boolean areVibrationFeaturesSupported(@NonNull VibratorInfo vibratorInfo) {
        return vibratorInfo.areEnvelopeEffectsSupported();
    }

    @Override
    public boolean isHapticFeedbackCandidate() {
        return true;
    }

    @Override
    public void validate() {
        Preconditions.checkArgumentInRange(this.mStartSharpness, 0.0f, 1.0f, "startSharpness");
        Preconditions.checkArgumentInRange(this.mEndSharpness, 0.0f, 1.0f, "endSharpness");
        Preconditions.checkArgumentInRange(this.mStartIntensity, 0.0f, 1.0f, "startIntensity");
        Preconditions.checkArgumentInRange(this.mEndIntensity, 0.0f, 1.0f, "endIntensity");
        Preconditions.checkArgumentPositive(this.mDuration, "Time must be greater than zero.");
    }

    @NonNull
    public BasicPwleSegment resolve(int defaultAmplitude) {
        return this;
    }

    @NonNull
    public BasicPwleSegment scale(float scaleFactor) {
        float newStartIntensity = VibrationEffect.scale(this.mStartIntensity, scaleFactor);
        float newEndIntensity = VibrationEffect.scale(this.mEndIntensity, scaleFactor);
        if (Float.compare(this.mStartIntensity, newStartIntensity) == 0 && Float.compare(this.mEndIntensity, newEndIntensity) == 0) {
            return this;
        }
        return new BasicPwleSegment(newStartIntensity, newEndIntensity, this.mStartSharpness, this.mEndSharpness, this.mDuration);
    }

    @NonNull
    public BasicPwleSegment scaleLinearly(float scaleFactor) {
        float newStartIntensity = VibrationEffect.scaleLinearly(this.mStartIntensity, scaleFactor);
        float newEndIntensity = VibrationEffect.scaleLinearly(this.mEndIntensity, scaleFactor);
        if (Float.compare(this.mStartIntensity, newStartIntensity) == 0 && Float.compare(this.mEndIntensity, newEndIntensity) == 0) {
            return this;
        }
        return new BasicPwleSegment(newStartIntensity, newEndIntensity, this.mStartSharpness, this.mEndSharpness, this.mDuration);
    }

    @NonNull
    public BasicPwleSegment applyEffectStrength(int effectStrength) {
        return this;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.mStartIntensity), Float.valueOf(this.mEndIntensity), Float.valueOf(this.mStartSharpness), Float.valueOf(this.mEndSharpness), this.mDuration);
    }

    public String toString() {
        return "BasicPwle{startIntensity=" + this.mStartIntensity + ", endIntensity=" + this.mEndIntensity + ", startSharpness=" + this.mStartSharpness + ", endSharpness=" + this.mEndSharpness + ", duration=" + this.mDuration + "}";
    }

    @Override
    public String toDebugString() {
        return String.format(Locale.US, "Pwle=%dms(intensity=%.2f @ %.2f to %.2f @ %.2f)", this.mDuration, Float.valueOf(this.mStartIntensity), Float.valueOf(this.mStartSharpness), Float.valueOf(this.mEndIntensity), Float.valueOf(this.mEndSharpness));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(5);
        dest.writeFloat(this.mStartIntensity);
        dest.writeFloat(this.mEndIntensity);
        dest.writeFloat(this.mStartSharpness);
        dest.writeFloat(this.mEndSharpness);
        dest.writeLong(this.mDuration);
    }
}

