/*
 * Decompiled with CFR 0.152.
 */
package android.os.vibrator;

import android.os.Binder;
import android.os.CombinedVibration;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IVibrationSession
extends IInterface {
    public static final String DESCRIPTOR = "android.os.vibrator.IVibrationSession";
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_SUCCESS = 1;
    public static final int STATUS_IGNORED = 2;
    public static final int STATUS_UNSUPPORTED = 3;
    public static final int STATUS_CANCELED = 4;
    public static final int STATUS_UNKNOWN_ERROR = 5;

    public void vibrate(CombinedVibration var1, String var2) throws RemoteException;

    public void finishSession() throws RemoteException;

    public void cancelSession() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IVibrationSession {
        static final int TRANSACTION_vibrate = 1;
        static final int TRANSACTION_finishSession = 2;
        static final int TRANSACTION_cancelSession = 3;

        public Stub() {
            this.attachInterface(this, IVibrationSession.DESCRIPTOR);
        }

        public static IVibrationSession asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IVibrationSession.DESCRIPTOR);
            if (iin != null && iin instanceof IVibrationSession) {
                return (IVibrationSession)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "vibrate";
                }
                case 2: {
                    return "finishSession";
                }
                case 3: {
                    return "cancelSession";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IVibrationSession.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    CombinedVibration _arg0 = data.readTypedObject(CombinedVibration.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.vibrate(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    this.finishSession();
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    this.cancelSession();
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IVibrationSession {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IVibrationSession.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void vibrate(CombinedVibration vibration, String reason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVibrationSession.DESCRIPTOR);
                    _data.writeTypedObject(vibration, 0);
                    _data.writeString(reason);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finishSession() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVibrationSession.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelSession() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVibrationSession.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IVibrationSession {
        @Override
        public void vibrate(CombinedVibration vibration, String reason) throws RemoteException {
        }

        @Override
        public void finishSession() throws RemoteException {
        }

        @Override
        public void cancelSession() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

