/*
 * Decompiled with CFR 0.152.
 */
package android.permission;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.ActivityManager;
import android.app.ActivityThread;
import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.app.IActivityManager;
import android.app.PropertyInvalidatedCache;
import android.companion.virtual.VirtualDevice;
import android.companion.virtual.VirtualDeviceManager;
import android.content.AttributionSource;
import android.content.Context;
import android.content.PermissionChecker;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.permission.SplitPermissionInfoParcelable;
import android.internal.modules.utils.build.SdkLevel;
import android.media.AudioManager;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.permission.IOnPermissionsChangeListener;
import android.permission.IPermissionManager;
import android.permission.LegacyPermissionManager;
import android.permission.PermissionGroupUsage;
import android.permission.PermissionManager_Delegate;
import android.permission.PermissionUsageHelper;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import com.android.internal.annotations.Immutable;
import com.android.internal.hidden_from_bootclasspath.android.permission.flags.Flags;
import com.android.internal.util.CollectionUtils;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@SystemApi
public class PermissionManager {
    private static final String LOG_TAG = PermissionManager.class.getName();
    public static final int PERMISSION_GRANTED = 0;
    public static final int PERMISSION_SOFT_DENIED = 1;
    public static final int PERMISSION_HARD_DENIED = 2;
    public static final int EXPLICIT_SET_FLAGS = 32823;
    @RequiresPermission(value="android.permission.START_REVIEW_PERMISSION_DECISIONS")
    public static final String ACTION_REVIEW_PERMISSION_DECISIONS = "android.permission.action.REVIEW_PERMISSION_DECISIONS";
    public static final String LOG_TAG_TRACE_GRANTS = "PermissionGrantTrace";
    public static final String KILL_APP_REASON_PERMISSIONS_REVOKED = "permissions revoked";
    public static final String KILL_APP_REASON_GIDS_CHANGED = "permission grant or revoke changed gids";
    private static final String SYSTEM_PKG = "android";
    public static final long CANNOT_INSTALL_WITH_BAD_PERMISSION_GROUPS = 146211400L;
    public static final boolean USE_ACCESS_CHECKING_SERVICE = SdkLevel.isAtLeastV();
    private static final long EXEMPTED_INDICATOR_ROLE_UPDATE_FREQUENCY_MS = 15000L;
    private static long sLastIndicatorUpdateTime = -1L;
    private static final int[] EXEMPTED_ROLES = new int[]{17039411, 17039410, 17039412, 17039413, 17039414, 17039415};
    private static final String[] INDICATOR_EXEMPTED_PACKAGES = new String[EXEMPTED_ROLES.length];
    public static final boolean DEBUG_TRACE_GRANTS = false;
    public static final boolean DEBUG_TRACE_PERMISSION_UPDATES = false;
    public static final boolean DEBUG_DEVICE_PERMISSIONS = false;
    @SystemApi
    public static final String EXTRA_PERMISSION_USAGES = "android.permission.extra.PERMISSION_USAGES";
    public static final Set<String> DEVICE_AWARE_PERMISSIONS = Flags.deviceAwarePermissionsEnabled() ? Set.of("android.permission.CAMERA", "android.permission.RECORD_AUDIO") : Collections.emptySet();
    @NonNull
    private final Context mContext;
    private final IPackageManager mPackageManager;
    private final IPermissionManager mPermissionManager;
    private final LegacyPermissionManager mLegacyPermissionManager;
    private final ArrayMap<PackageManager.OnPermissionsChangedListener, IOnPermissionsChangeListener> mPermissionListeners = new ArrayMap();
    private PermissionUsageHelper mUsageHelper;
    private List<SplitPermissionInfo> mSplitPermissionInfos;
    private static volatile boolean sShouldWarnMissingActivityManager = true;
    public static final String CACHE_KEY_PACKAGE_INFO_NOTIFY = PropertyInvalidatedCache.createSystemCacheKey("package_info");
    public static final String CACHE_KEY_PACKAGE_INFO_CACHE = PermissionManager.getPackageInfoCacheKey();
    private static final PropertyInvalidatedCache<PermissionQuery, Integer> sPermissionCache = new PropertyInvalidatedCache<PermissionQuery, Integer>(2048, CACHE_KEY_PACKAGE_INFO_CACHE, "checkPermission"){

        @Override
        public Integer recompute(PermissionQuery query) {
            return PermissionManager.checkPermissionUncached(query.permission, query.pid, query.uid, query.deviceId);
        }
    };
    private static final PropertyInvalidatedCache<PermissionRequestStateQuery, Integer> sPermissionRequestStateCache = new PropertyInvalidatedCache<PermissionRequestStateQuery, Integer>(512, CACHE_KEY_PACKAGE_INFO_CACHE, "getPermissionRequestState"){

        @Override
        public Integer recompute(PermissionRequestStateQuery query) {
            return PermissionManager.getPermissionRequestStateUncached(query.mPackageName, query.mPermission, query.mDeviceId);
        }
    };
    private static PropertyInvalidatedCache<PackageNamePermissionQuery, Integer> sPackageNamePermissionCache = new PropertyInvalidatedCache<PackageNamePermissionQuery, Integer>(16, CACHE_KEY_PACKAGE_INFO_CACHE, "checkPackageNamePermission"){

        @Override
        public Integer recompute(PackageNamePermissionQuery query) {
            return PermissionManager.checkPackageNamePermissionUncached(query.permName, query.pkgName, query.persistentDeviceId, query.userId);
        }

        @Override
        public boolean bypass(PackageNamePermissionQuery query) {
            return query.userId < 0;
        }
    };

    public PermissionManager(@NonNull Context context) throws ServiceManager.ServiceNotFoundException {
        this.mContext = context;
        this.mPackageManager = AppGlobals.getPackageManager();
        this.mPermissionManager = IPermissionManager.Stub.asInterface(ServiceManager.getServiceOrThrow("permissionmgr"));
        this.mLegacyPermissionManager = context.getSystemService(LegacyPermissionManager.class);
    }

    @RequiresPermission(value="android.permission.UPDATE_APP_OPS_STATS", conditional=true)
    public int checkPermissionForDataDelivery(@NonNull String permission2, @NonNull AttributionSource attributionSource, @Nullable String message) {
        return PermissionChecker.checkPermissionForDataDelivery(this.mContext, permission2, -1, attributionSource, message);
    }

    @RequiresPermission(value="android.permission.UPDATE_APP_OPS_STATS", conditional=true)
    public int checkPermissionForStartDataDelivery(@NonNull String permission2, @NonNull AttributionSource attributionSource, @Nullable String message) {
        return PermissionChecker.checkPermissionForDataDelivery(this.mContext, permission2, -1, attributionSource, message, true);
    }

    public void finishDataDelivery(@NonNull String permission2, @NonNull AttributionSource attributionSource) {
        PermissionChecker.finishDataDelivery(this.mContext, AppOpsManager.permissionToOp(permission2), attributionSource);
    }

    @RequiresPermission(value="android.permission.UPDATE_APP_OPS_STATS", conditional=true)
    public int checkPermissionForDataDeliveryFromDataSource(@NonNull String permission2, @NonNull AttributionSource attributionSource, @Nullable String message) {
        return PermissionChecker.checkPermissionForDataDeliveryFromDataSource(this.mContext, permission2, -1, attributionSource, message);
    }

    public int checkPermissionForPreflight(@NonNull String permission2, @NonNull AttributionSource attributionSource) {
        return PermissionChecker.checkPermissionForPreflight(this.mContext, permission2, attributionSource);
    }

    @Nullable
    public PermissionInfo getPermissionInfo(@NonNull String permissionName, int flags) {
        try {
            String packageName = this.mContext.getOpPackageName();
            return this.mPermissionManager.getPermissionInfo(permissionName, packageName, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Nullable
    public List<PermissionInfo> queryPermissionsByGroup(@Nullable String groupName, int flags) {
        try {
            ParceledListSlice parceledList = this.mPermissionManager.queryPermissionsByGroup(groupName, flags);
            if (parceledList == null) {
                return null;
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean addPermission(@NonNull PermissionInfo permissionInfo, boolean async) {
        try {
            return this.mPermissionManager.addPermission(permissionInfo, async);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removePermission(@NonNull String permissionName) {
        try {
            this.mPermissionManager.removePermission(permissionName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Nullable
    public PermissionGroupInfo getPermissionGroupInfo(@NonNull String groupName, int flags) {
        try {
            return this.mPermissionManager.getPermissionGroupInfo(groupName, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public List<PermissionGroupInfo> getAllPermissionGroups(int flags) {
        try {
            ParceledListSlice parceledList = this.mPermissionManager.getAllPermissionGroups(flags);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isPermissionRevokedByPolicy(@NonNull String packageName, @NonNull String permissionName) {
        try {
            return this.mPermissionManager.isPermissionRevokedByPolicy(packageName, permissionName, this.mContext.getDeviceId(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static boolean shouldTraceGrant(@NonNull String packageName, @NonNull String permissionName, int userId) {
        return false;
    }

    @RequiresPermission(value="android.permission.GRANT_RUNTIME_PERMISSIONS")
    public void grantRuntimePermission(@NonNull String packageName, @NonNull String permissionName, @NonNull UserHandle user) {
        String persistentDeviceId = this.getPersistentDeviceId(this.mContext.getDeviceId());
        if (persistentDeviceId == null) {
            return;
        }
        this.grantRuntimePermissionInternal(packageName, permissionName, persistentDeviceId, user);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.GRANT_RUNTIME_PERMISSIONS")
    @FlaggedApi(value="android.permission.flags.device_aware_permission_apis_enabled")
    public void grantRuntimePermission(@NonNull String packageName, @NonNull String permissionName, @NonNull String persistentDeviceId) {
        this.grantRuntimePermissionInternal(packageName, permissionName, persistentDeviceId, this.mContext.getUser());
    }

    private void grantRuntimePermissionInternal(@NonNull String packageName, @NonNull String permissionName, @NonNull String persistentDeviceId, @NonNull UserHandle user) {
        try {
            this.mPermissionManager.grantRuntimePermission(packageName, permissionName, persistentDeviceId, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.REVOKE_RUNTIME_PERMISSIONS")
    public void revokeRuntimePermission(@NonNull String packageName, @NonNull String permissionName, @NonNull UserHandle user, @Nullable String reason) {
        String persistentDeviceId = this.getPersistentDeviceId(this.mContext.getDeviceId());
        if (persistentDeviceId == null) {
            return;
        }
        this.revokeRuntimePermissionInternal(packageName, permissionName, persistentDeviceId, user, reason);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.REVOKE_RUNTIME_PERMISSIONS")
    @FlaggedApi(value="android.permission.flags.device_aware_permission_apis_enabled")
    public void revokeRuntimePermission(@NonNull String packageName, @NonNull String permissionName, @NonNull String persistentDeviceId, @Nullable String reason) {
        this.revokeRuntimePermissionInternal(packageName, permissionName, persistentDeviceId, this.mContext.getUser(), reason);
    }

    private void revokeRuntimePermissionInternal(@NonNull String packageName, @NonNull String permissionName, @NonNull String persistentDeviceId, @NonNull UserHandle user, @Nullable String reason) {
        try {
            this.mPermissionManager.revokeRuntimePermission(packageName, permissionName, persistentDeviceId, user.getIdentifier(), reason);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.GRANT_RUNTIME_PERMISSIONS", "android.permission.REVOKE_RUNTIME_PERMISSIONS", "android.permission.GET_RUNTIME_PERMISSIONS"})
    public int getPermissionFlags(@NonNull String packageName, @NonNull String permissionName, @NonNull UserHandle user) {
        String persistentDeviceId = this.getPersistentDeviceId(this.mContext.getDeviceId());
        if (persistentDeviceId == null) {
            return 0;
        }
        return this.getPermissionFlagsInternal(packageName, permissionName, persistentDeviceId, user);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.GRANT_RUNTIME_PERMISSIONS", "android.permission.REVOKE_RUNTIME_PERMISSIONS", "android.permission.GET_RUNTIME_PERMISSIONS"})
    @FlaggedApi(value="android.permission.flags.device_aware_permission_apis_enabled")
    public int getPermissionFlags(@NonNull String packageName, @NonNull String permissionName, @NonNull String persistentDeviceId) {
        return this.getPermissionFlagsInternal(packageName, permissionName, persistentDeviceId, this.mContext.getUser());
    }

    private int getPermissionFlagsInternal(@NonNull String packageName, @NonNull String permissionName, @NonNull String persistentDeviceId, @NonNull UserHandle user) {
        try {
            return this.mPermissionManager.getPermissionFlags(packageName, permissionName, persistentDeviceId, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.GRANT_RUNTIME_PERMISSIONS", "android.permission.REVOKE_RUNTIME_PERMISSIONS"})
    public void updatePermissionFlags(@NonNull String packageName, @NonNull String permissionName, int flagMask, int flagValues, @NonNull UserHandle user) {
        String persistentDeviceId = this.getPersistentDeviceId(this.mContext.getDeviceId());
        if (persistentDeviceId == null) {
            return;
        }
        this.updatePermissionFlagsInternal(packageName, permissionName, flagMask, flagValues, persistentDeviceId, user);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.GRANT_RUNTIME_PERMISSIONS", "android.permission.REVOKE_RUNTIME_PERMISSIONS"})
    @FlaggedApi(value="android.permission.flags.device_aware_permission_apis_enabled")
    public void updatePermissionFlags(@NonNull String packageName, @NonNull String permissionName, @NonNull String persistentDeviceId, int flagMask, int flagValues) {
        this.updatePermissionFlagsInternal(packageName, permissionName, flagMask, flagValues, persistentDeviceId, this.mContext.getUser());
    }

    private void updatePermissionFlagsInternal(@NonNull String packageName, @NonNull String permissionName, int flagMask, int flagValues, @NonNull String persistentDeviceId, @NonNull UserHandle user) {
        try {
            boolean checkAdjustPolicyFlagPermission = this.mContext.getApplicationInfo().targetSdkVersion >= 29;
            this.mPermissionManager.updatePermissionFlags(packageName, permissionName, flagMask, flagValues, checkAdjustPolicyFlagPermission, persistentDeviceId, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    @RequiresPermission(value="android.permission.WHITELIST_RESTRICTED_PERMISSIONS", conditional=true)
    public Set<String> getAllowlistedRestrictedPermissions(@NonNull String packageName, int allowlistFlag) {
        try {
            List<String> allowlist = this.mPermissionManager.getAllowlistedRestrictedPermissions(packageName, allowlistFlag, this.mContext.getUserId());
            if (allowlist == null) {
                return Collections.emptySet();
            }
            return new ArraySet<String>(allowlist);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.WHITELIST_RESTRICTED_PERMISSIONS", conditional=true)
    public boolean addAllowlistedRestrictedPermission(@NonNull String packageName, @NonNull String permissionName, int allowlistFlags) {
        try {
            return this.mPermissionManager.addAllowlistedRestrictedPermission(packageName, permissionName, allowlistFlags, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.WHITELIST_RESTRICTED_PERMISSIONS", conditional=true)
    public boolean removeAllowlistedRestrictedPermission(@NonNull String packageName, @NonNull String permissionName, int allowlistFlags) {
        try {
            return this.mPermissionManager.removeAllowlistedRestrictedPermission(packageName, permissionName, allowlistFlags, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.WHITELIST_AUTO_REVOKE_PERMISSIONS", conditional=true)
    public boolean isAutoRevokeExempted(@NonNull String packageName) {
        try {
            return this.mPermissionManager.isAutoRevokeExempted(packageName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.WHITELIST_AUTO_REVOKE_PERMISSIONS", conditional=true)
    public boolean setAutoRevokeExempted(@NonNull String packageName, boolean exempted) {
        try {
            return this.mPermissionManager.setAutoRevokeExempted(packageName, exempted, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean shouldShowRequestPermissionRationale(@NonNull String permissionName) {
        try {
            String packageName = this.mContext.getPackageName();
            return this.mPermissionManager.shouldShowRequestPermissionRationale(packageName, permissionName, this.mContext.getDeviceId(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.OBSERVE_GRANT_REVOKE_PERMISSIONS")
    public void addOnPermissionsChangeListener(@NonNull PackageManager.OnPermissionsChangedListener listener) {
        ArrayMap<PackageManager.OnPermissionsChangedListener, IOnPermissionsChangeListener> arrayMap = this.mPermissionListeners;
        synchronized (arrayMap) {
            if (this.mPermissionListeners.get(listener) != null) {
                return;
            }
            OnPermissionsChangeListenerDelegate delegate = new OnPermissionsChangeListenerDelegate(this, listener, Looper.getMainLooper());
            try {
                this.mPermissionManager.addOnPermissionsChangeListener(delegate);
                this.mPermissionListeners.put(listener, delegate);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.OBSERVE_GRANT_REVOKE_PERMISSIONS")
    public void removeOnPermissionsChangeListener(@NonNull PackageManager.OnPermissionsChangedListener listener) {
        ArrayMap<PackageManager.OnPermissionsChangedListener, IOnPermissionsChangeListener> arrayMap = this.mPermissionListeners;
        synchronized (arrayMap) {
            IOnPermissionsChangeListener delegate = this.mPermissionListeners.get(listener);
            if (delegate != null) {
                try {
                    this.mPermissionManager.removeOnPermissionsChangeListener(delegate);
                    this.mPermissionListeners.remove(listener);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.ADJUST_RUNTIME_PERMISSIONS_POLICY", "android.permission.UPGRADE_RUNTIME_PERMISSIONS"})
    public int getRuntimePermissionsVersion() {
        try {
            return this.mPackageManager.getRuntimePermissionsVersion(this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.ADJUST_RUNTIME_PERMISSIONS_POLICY", "android.permission.UPGRADE_RUNTIME_PERMISSIONS"})
    public void setRuntimePermissionsVersion(int version) {
        try {
            this.mPackageManager.setRuntimePermissionsVersion(version, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public List<SplitPermissionInfo> getSplitPermissions() {
        List<SplitPermissionInfoParcelable> parcelableList;
        if (this.mSplitPermissionInfos != null) {
            return this.mSplitPermissionInfos;
        }
        try {
            parcelableList = ActivityThread.getPermissionManager().getSplitPermissions();
        }
        catch (RemoteException e) {
            Slog.e(LOG_TAG, "Error getting split permissions", e);
            return Collections.emptyList();
        }
        this.mSplitPermissionInfos = this.splitPermissionInfoListToNonParcelableList(parcelableList);
        return this.mSplitPermissionInfos;
    }

    public void initializeUsageHelper() {
        if (this.mUsageHelper == null) {
            this.mUsageHelper = new PermissionUsageHelper(this.mContext);
        }
    }

    public void tearDownUsageHelper() {
        if (this.mUsageHelper != null) {
            this.mUsageHelper.tearDown();
            this.mUsageHelper = null;
        }
    }

    @NonNull
    @RequiresPermission(value="android.permission.GET_APP_OPS_STATS")
    public List<PermissionGroupUsage> getIndicatorAppOpUsageData() {
        return this.getIndicatorAppOpUsageData(new AudioManager().isMicrophoneMute());
    }

    @NonNull
    @RequiresPermission(value="android.permission.GET_APP_OPS_STATS")
    public List<PermissionGroupUsage> getIndicatorAppOpUsageData(boolean micMuted) {
        this.initializeUsageHelper();
        boolean includeMicrophoneUsage = !micMuted;
        return this.mUsageHelper.getOpUsageDataByDevice(includeMicrophoneUsage, "default:0");
    }

    public static boolean shouldShowPackageForIndicatorCached(@NonNull Context context, @NonNull String packageName) {
        return !PermissionManager.getIndicatorExemptedPackages(context).contains(packageName);
    }

    public static Set<String> getIndicatorExemptedPackages(@NonNull Context context) {
        PermissionManager.updateIndicatorExemptedPackages(context);
        ArraySet<String> pkgNames = new ArraySet<String>();
        pkgNames.add(SYSTEM_PKG);
        for (int i = 0; i < INDICATOR_EXEMPTED_PACKAGES.length; ++i) {
            String exemptedPackage = INDICATOR_EXEMPTED_PACKAGES[i];
            if (exemptedPackage == null) continue;
            pkgNames.add(exemptedPackage);
        }
        return pkgNames;
    }

    public static void updateIndicatorExemptedPackages(@NonNull Context context) {
        long now = SystemClock.elapsedRealtime();
        if (sLastIndicatorUpdateTime == -1L || now - sLastIndicatorUpdateTime > 15000L) {
            sLastIndicatorUpdateTime = now;
            for (int i = 0; i < EXEMPTED_ROLES.length; ++i) {
                PermissionManager.INDICATOR_EXEMPTED_PACKAGES[i] = context.getString(EXEMPTED_ROLES[i]);
            }
        }
    }

    @SystemApi
    @NonNull
    @RequiresPermission(value="android.permission.ADJUST_RUNTIME_PERMISSIONS_POLICY")
    public Set<String> getAutoRevokeExemptionRequestedPackages() {
        try {
            return CollectionUtils.toSet(this.mPermissionManager.getAutoRevokeExemptionRequestedPackages(this.mContext.getUser().getIdentifier()));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @NonNull
    @RequiresPermission(value="android.permission.ADJUST_RUNTIME_PERMISSIONS_POLICY")
    public Set<String> getAutoRevokeExemptionGrantedPackages() {
        try {
            return CollectionUtils.toSet(this.mPermissionManager.getAutoRevokeExemptionGrantedPackages(this.mContext.getUser().getIdentifier()));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private List<SplitPermissionInfo> splitPermissionInfoListToNonParcelableList(List<SplitPermissionInfoParcelable> parcelableList) {
        int size = parcelableList.size();
        ArrayList<SplitPermissionInfo> list = new ArrayList<SplitPermissionInfo>(size);
        for (int i = 0; i < size; ++i) {
            list.add(new SplitPermissionInfo(parcelableList.get(i)));
        }
        return list;
    }

    public static List<SplitPermissionInfoParcelable> splitPermissionInfoListToParcelableList(List<SplitPermissionInfo> splitPermissionsList) {
        int size = splitPermissionsList.size();
        ArrayList<SplitPermissionInfoParcelable> outList = new ArrayList<SplitPermissionInfoParcelable>(size);
        for (int i = 0; i < size; ++i) {
            SplitPermissionInfo info = splitPermissionsList.get(i);
            outList.add(new SplitPermissionInfoParcelable(info.getSplitPermission(), info.getNewPermissions(), info.getTargetSdk()));
        }
        return outList;
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_ONE_TIME_PERMISSION_SESSIONS")
    public void startOneTimePermissionSession(@NonNull String packageName, long timeoutMillis, int importanceToResetTimer, int importanceToKeepSessionAlive) {
        this.startOneTimePermissionSession(packageName, timeoutMillis, -1L, importanceToResetTimer, importanceToKeepSessionAlive);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_ONE_TIME_PERMISSION_SESSIONS")
    public void startOneTimePermissionSession(@NonNull String packageName, long timeoutMillis, long revokeAfterKilledDelayMillis, int importanceToResetTimer, int importanceToKeepSessionAlive) {
        try {
            this.mPermissionManager.startOneTimePermissionSession(packageName, this.mContext.getDeviceId(), this.mContext.getUserId(), timeoutMillis, revokeAfterKilledDelayMillis);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_ONE_TIME_PERMISSION_SESSIONS")
    public void stopOneTimePermissionSession(@NonNull String packageName) {
        try {
            this.mPermissionManager.stopOneTimePermissionSession(packageName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public int checkDeviceIdentifierAccess(@Nullable String packageName, @Nullable String message, @Nullable String callingFeatureId, int pid, int uid) {
        return this.mLegacyPermissionManager.checkDeviceIdentifierAccess(packageName, message, callingFeatureId, pid, uid);
    }

    @NonNull
    public AttributionSource registerAttributionSource(@NonNull AttributionSource source) {
        try {
            if (Flags.serverSideAttributionRegistration()) {
                IBinder newToken = this.mPermissionManager.registerAttributionSource(source.asState());
                return source.withToken(newToken);
            }
            AttributionSource registeredSource = source.withToken(new Binder());
            this.mPermissionManager.registerAttributionSource(registeredSource.asState());
            return registeredSource;
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return source;
        }
    }

    @FlaggedApi(value="android.permission.flags.should_register_attribution_source")
    public boolean isRegisteredAttributionSource(@NonNull AttributionSource source) {
        try {
            return this.mPermissionManager.isRegisteredAttributionSource(source.asState());
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    @RequiresPermission(value="android.permission.UPDATE_APP_OPS_STATS")
    public int getRegisteredAttributionSourceCountForTest(int uid) {
        try {
            return this.mPermissionManager.getRegisteredAttributionSourceCount(uid);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return -1;
        }
    }

    @RequiresPermission(value="android.permission.REVOKE_POST_NOTIFICATIONS_WITHOUT_KILL")
    public void revokePostNotificationPermissionWithoutKillForTest(@NonNull String packageName, int userId) {
        try {
            this.mPermissionManager.revokePostNotificationPermissionWithoutKillForTest(packageName, userId);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    private static int checkPermissionUncached(@Nullable String permission2, int pid, int uid, int deviceId) {
        int appId = UserHandle.getAppId(uid);
        if (appId == 0 || appId == 1000) {
            return 0;
        }
        IActivityManager am = ActivityManager.getService();
        if (am == null) {
            Slog.w(LOG_TAG, "Missing ActivityManager; assuming " + uid + " does not hold " + permission2);
            return -1;
        }
        try {
            sShouldWarnMissingActivityManager = true;
            return am.checkPermissionForDevice(permission2, pid, uid, deviceId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static int getPermissionRequestStateUncached(String packageName, String permission2, int deviceId) {
        try {
            return AppGlobals.getPermissionManager().getPermissionRequestState(packageName, permission2, deviceId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static String getPackageInfoCacheKey() {
        if (PropertyInvalidatedCache.separatePermissionNotificationsEnabled()) {
            return PropertyInvalidatedCache.createSystemCacheKey("package_info_cache");
        }
        return CACHE_KEY_PACKAGE_INFO_NOTIFY;
    }

    public static int checkPermission_Original(@Nullable String permission2, int pid, int uid, int deviceId) {
        return sPermissionCache.query(new PermissionQuery(permission2, pid, uid, deviceId));
    }

    @LayoutlibDelegate
    public static int checkPermission(String string2, int n, int n2, int n3) {
        return PermissionManager_Delegate.checkPermission(string2, n, n2, n3);
    }

    public int getPermissionRequestState(@NonNull String packageName, @NonNull String permission2, int deviceId) {
        int resolvedDeviceId = PermissionManager.resolveDeviceIdForPermissionCheck(this.mContext, deviceId, permission2);
        return sPermissionRequestStateCache.query(new PermissionRequestStateQuery(packageName, permission2, resolvedDeviceId));
    }

    @SystemApi
    @NonNull
    @RequiresPermission(anyOf={"android.permission.GRANT_RUNTIME_PERMISSIONS", "android.permission.REVOKE_RUNTIME_PERMISSIONS", "android.permission.GET_RUNTIME_PERMISSIONS"})
    @FlaggedApi(value="android.permission.flags.device_aware_permission_apis_enabled")
    public Map<String, PermissionState> getAllPermissionStates(@NonNull String packageName, @NonNull String persistentDeviceId) {
        try {
            return this.mPermissionManager.getAllPermissionStates(packageName, persistentDeviceId, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static void disablePermissionCache() {
        sPermissionCache.disableLocal();
    }

    private static int checkPackageNamePermissionUncached(String permName, String pkgName, String persistentDeviceId, int userId) {
        try {
            return ActivityThread.getPermissionManager().checkPermission(pkgName, permName, persistentDeviceId, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int checkPackageNamePermission(String permName, String pkgName, int deviceId, int userId) {
        int resolvedDeviceId = PermissionManager.resolveDeviceIdForPermissionCheck(this.mContext, deviceId, permName);
        String persistentDeviceId = this.getPersistentDeviceId(resolvedDeviceId);
        return sPackageNamePermissionCache.query(new PackageNamePermissionQuery(permName, pkgName, persistentDeviceId, userId));
    }

    public static int resolveDeviceIdForPermissionCheck(@NonNull Context context, int deviceId, @Nullable String permission2) {
        if (deviceId == 0 || !DEVICE_AWARE_PERMISSIONS.contains(permission2)) {
            return 0;
        }
        VirtualDeviceManager virtualDeviceManager = context.getSystemService(VirtualDeviceManager.class);
        if (virtualDeviceManager == null) {
            Slog.e(LOG_TAG, "VDM is not enabled when device id is not default. deviceId = " + deviceId);
        } else {
            VirtualDevice virtualDevice = virtualDeviceManager.getVirtualDevice(deviceId);
            if (virtualDevice != null) {
                if (Objects.equals(permission2, "android.permission.RECORD_AUDIO") && !virtualDevice.hasCustomAudioInputSupport() || Objects.equals(permission2, "android.permission.CAMERA") && !virtualDevice.hasCustomCameraSupport()) {
                    deviceId = 0;
                }
            } else {
                Slog.e(LOG_TAG, "virtualDevice is not found when device id is not default. deviceId = " + deviceId);
            }
        }
        return deviceId;
    }

    @Nullable
    private String getPersistentDeviceId(int deviceId) {
        String persistentDeviceId = null;
        if (deviceId == 0) {
            persistentDeviceId = "default:0";
        } else {
            VirtualDeviceManager virtualDeviceManager = this.mContext.getSystemService(VirtualDeviceManager.class);
            if (virtualDeviceManager != null) {
                VirtualDevice virtualDevice = virtualDeviceManager.getVirtualDevice(deviceId);
                if (virtualDevice == null) {
                    Slog.e(LOG_TAG, "Virtual device is not found with device Id " + deviceId);
                    return null;
                }
                persistentDeviceId = virtualDevice.getPersistentDeviceId();
                if (persistentDeviceId == null) {
                    Slog.e(LOG_TAG, "Cannot find persistent device Id for " + deviceId);
                }
            }
        }
        return persistentDeviceId;
    }

    @SystemApi
    @FlaggedApi(value="android.permission.flags.device_aware_permission_apis_enabled")
    public int checkPermission_Original(@NonNull String permissionName, @NonNull String packageName, @NonNull String persistentDeviceId) {
        return sPackageNamePermissionCache.query(new PackageNamePermissionQuery(permissionName, packageName, persistentDeviceId, this.mContext.getUserId()));
    }

    @LayoutlibDelegate
    public int checkPermission(String string2, String string3, String string4) {
        return PermissionManager_Delegate.checkPermission(this, string2, string3, string4);
    }

    public static void disablePackageNamePermissionCache() {
        sPackageNamePermissionCache.disableLocal();
    }

    private class OnPermissionsChangeListenerDelegate
    extends IOnPermissionsChangeListener.Stub
    implements Handler.Callback {
        private static final int MSG_PERMISSIONS_CHANGED = 1;
        private final PackageManager.OnPermissionsChangedListener mListener;
        private final Handler mHandler;

        public OnPermissionsChangeListenerDelegate(PermissionManager permissionManager, PackageManager.OnPermissionsChangedListener listener, Looper looper) {
            this.mListener = listener;
            this.mHandler = new Handler(looper, this);
        }

        @Override
        public void onPermissionsChanged(int uid, String persistentDeviceId) {
            this.mHandler.obtainMessage(1, uid, 0, persistentDeviceId).sendToTarget();
        }

        @Override
        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    int uid = msg.arg1;
                    String persistentDeviceId = msg.obj.toString();
                    this.mListener.onPermissionsChanged(uid, persistentDeviceId);
                    return true;
                }
            }
            return false;
        }
    }

    @Immutable
    public static class SplitPermissionInfo {
        @NonNull
        private final SplitPermissionInfoParcelable mSplitPermissionInfoParcelable;

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SplitPermissionInfo that = (SplitPermissionInfo)o;
            return this.mSplitPermissionInfoParcelable.equals(that.mSplitPermissionInfoParcelable);
        }

        public int hashCode() {
            return this.mSplitPermissionInfoParcelable.hashCode();
        }

        @NonNull
        public String getSplitPermission() {
            return this.mSplitPermissionInfoParcelable.getSplitPermission();
        }

        @NonNull
        public List<String> getNewPermissions() {
            return this.mSplitPermissionInfoParcelable.getNewPermissions();
        }

        public int getTargetSdk() {
            return this.mSplitPermissionInfoParcelable.getTargetSdk();
        }

        public SplitPermissionInfo(@NonNull String splitPerm, @NonNull List<String> newPerms, int targetSdk) {
            this(new SplitPermissionInfoParcelable(splitPerm, newPerms, targetSdk));
        }

        private SplitPermissionInfo(@NonNull SplitPermissionInfoParcelable parcelable) {
            this.mSplitPermissionInfoParcelable = parcelable;
        }
    }

    @Immutable
    private static class PermissionQuery {
        final String permission;
        final int pid;
        final int uid;
        final int deviceId;

        PermissionQuery(@Nullable String permission2, int pid, int uid, int deviceId) {
            this.permission = permission2;
            this.pid = pid;
            this.uid = uid;
            this.deviceId = deviceId;
        }

        public String toString() {
            return TextUtils.formatSimple("PermissionQuery(permission=\"%s\", pid=%d, uid=%d, deviceId=%d)", this.permission, this.pid, this.uid, this.deviceId);
        }

        public int hashCode() {
            return Objects.hash(this.permission, this.uid, this.deviceId);
        }

        public boolean equals(@Nullable Object rval) {
            PermissionQuery other;
            if (rval == null) {
                return false;
            }
            try {
                other = (PermissionQuery)rval;
            }
            catch (ClassCastException ex) {
                return false;
            }
            return this.uid == other.uid && this.deviceId == other.deviceId && Objects.equals(this.permission, other.permission);
        }
    }

    private static class PermissionRequestStateQuery {
        final String mPackageName;
        final String mPermission;
        final int mDeviceId;

        PermissionRequestStateQuery(@NonNull String packageName, @NonNull String permission2, int deviceId) {
            this.mPackageName = packageName;
            this.mPermission = permission2;
            this.mDeviceId = deviceId;
        }

        public String toString() {
            return TextUtils.formatSimple("PermissionRequestStateQuery(package=\"%s\", permission=\"%s\", deviceId=%d)", this.mPackageName, this.mPermission, this.mDeviceId);
        }

        public int hashCode() {
            return Objects.hash(this.mPackageName, this.mPermission, this.mDeviceId);
        }

        public boolean equals(@Nullable Object rval) {
            PermissionRequestStateQuery other;
            if (rval == null) {
                return false;
            }
            try {
                other = (PermissionRequestStateQuery)rval;
            }
            catch (ClassCastException ex) {
                return false;
            }
            return this.mDeviceId == other.mDeviceId && Objects.equals(this.mPackageName, other.mPackageName) && Objects.equals(this.mPermission, other.mPermission);
        }
    }

    @Immutable
    private static class PackageNamePermissionQuery {
        final String permName;
        final String pkgName;
        final String persistentDeviceId;
        final int userId;

        PackageNamePermissionQuery(@Nullable String permName, @Nullable String pkgName, @Nullable String persistentDeviceId, int userId) {
            this.permName = permName;
            this.pkgName = pkgName;
            this.persistentDeviceId = persistentDeviceId;
            this.userId = userId;
        }

        public String toString() {
            return TextUtils.formatSimple("PackageNamePermissionQuery(pkgName=\"%s\", permName=\"%s\", persistentDeviceId=%s, userId=%s\")", this.pkgName, this.permName, this.persistentDeviceId, this.userId);
        }

        public int hashCode() {
            return Objects.hash(this.permName, this.pkgName, this.persistentDeviceId, this.userId);
        }

        public boolean equals(@Nullable Object rval) {
            PackageNamePermissionQuery other;
            if (rval == null) {
                return false;
            }
            try {
                other = (PackageNamePermissionQuery)rval;
            }
            catch (ClassCastException ex) {
                return false;
            }
            return Objects.equals(this.permName, other.permName) && Objects.equals(this.pkgName, other.pkgName) && Objects.equals(this.persistentDeviceId, other.persistentDeviceId) && this.userId == other.userId;
        }
    }

    @SystemApi
    @FlaggedApi(value="android.permission.flags.device_aware_permission_apis_enabled")
    public static class PermissionState
    implements Parcelable {
        private final boolean mGranted;
        private final int mFlags;
        @FlaggedApi(value="android.permission.flags.device_aware_permission_apis_enabled")
        @NonNull
        public static final Parcelable.Creator<PermissionState> CREATOR = new Parcelable.Creator<PermissionState>(){

            @Override
            public PermissionState createFromParcel(Parcel source) {
                return new PermissionState(source);
            }

            public PermissionState[] newArray(int size) {
                return new PermissionState[size];
            }
        };

        @FlaggedApi(value="android.permission.flags.device_aware_permission_apis_enabled")
        public PermissionState(boolean granted, int flags) {
            this.mGranted = granted;
            this.mFlags = flags;
        }

        @FlaggedApi(value="android.permission.flags.device_aware_permission_apis_enabled")
        public boolean isGranted() {
            return this.mGranted;
        }

        @FlaggedApi(value="android.permission.flags.device_aware_permission_apis_enabled")
        public int getFlags() {
            return this.mFlags;
        }

        @Override
        @FlaggedApi(value="android.permission.flags.device_aware_permission_apis_enabled")
        public int describeContents() {
            return 0;
        }

        @Override
        @FlaggedApi(value="android.permission.flags.device_aware_permission_apis_enabled")
        public void writeToParcel(@NonNull Parcel parcel, int flags) {
            parcel.writeBoolean(this.mGranted);
            parcel.writeInt(this.mFlags);
        }

        private PermissionState(Parcel parcel) {
            this(parcel.readBoolean(), parcel.readInt());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PermissionState that = (PermissionState)o;
            return this.mGranted == that.mGranted && this.mFlags == that.mFlags;
        }

        public int hashCode() {
            return Objects.hash(this.mGranted, this.mFlags);
        }

        public String toString() {
            return "PermissionState{mGranted=" + this.mGranted + ", mFlags=" + this.mFlags + '}';
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PermissionResult {
    }
}

