/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;

public class PrintAttributes
implements Parcelable {
    public static final int COLOR_MODE_MONOCHROME = 1;
    public static final int COLOR_MODE_COLOR = 2;
    private static final int VALID_COLOR_MODES = 3;
    public static final int DUPLEX_MODE_NONE = 1;
    public static final int DUPLEX_MODE_LONG_EDGE = 2;
    public static final int DUPLEX_MODE_SHORT_EDGE = 4;
    private static final int VALID_DUPLEX_MODES = 7;
    @Nullable
    private MediaSize mMediaSize;
    @Nullable
    private Resolution mResolution;
    @Nullable
    private Margins mMinMargins;
    private int mColorMode;
    private int mDuplexMode;
    @NonNull
    public static final Parcelable.Creator<PrintAttributes> CREATOR = new Parcelable.Creator<PrintAttributes>(){

        @Override
        public PrintAttributes createFromParcel(Parcel parcel) {
            return new PrintAttributes(parcel);
        }

        public PrintAttributes[] newArray(int size) {
            return new PrintAttributes[size];
        }
    };

    PrintAttributes() {
    }

    private PrintAttributes(@NonNull Parcel parcel) {
        this.mMediaSize = parcel.readInt() == 1 ? MediaSize.createFromParcel(parcel) : null;
        this.mResolution = parcel.readInt() == 1 ? Resolution.createFromParcel(parcel) : null;
        this.mMinMargins = parcel.readInt() == 1 ? Margins.createFromParcel(parcel) : null;
        this.mColorMode = parcel.readInt();
        if (this.mColorMode != 0) {
            PrintAttributes.enforceValidColorMode(this.mColorMode);
        }
        this.mDuplexMode = parcel.readInt();
        if (this.mDuplexMode != 0) {
            PrintAttributes.enforceValidDuplexMode(this.mDuplexMode);
        }
    }

    @Nullable
    public MediaSize getMediaSize() {
        return this.mMediaSize;
    }

    public void setMediaSize(MediaSize mediaSize) {
        this.mMediaSize = mediaSize;
    }

    @Nullable
    public Resolution getResolution() {
        return this.mResolution;
    }

    public void setResolution(Resolution resolution) {
        this.mResolution = resolution;
    }

    @Nullable
    public Margins getMinMargins() {
        return this.mMinMargins;
    }

    public void setMinMargins(Margins margins) {
        this.mMinMargins = margins;
    }

    public int getColorMode() {
        return this.mColorMode;
    }

    public void setColorMode(int colorMode) {
        PrintAttributes.enforceValidColorMode(colorMode);
        this.mColorMode = colorMode;
    }

    public boolean isPortrait() {
        return this.mMediaSize.isPortrait();
    }

    public int getDuplexMode() {
        return this.mDuplexMode;
    }

    public void setDuplexMode(int duplexMode) {
        PrintAttributes.enforceValidDuplexMode(duplexMode);
        this.mDuplexMode = duplexMode;
    }

    public PrintAttributes asPortrait() {
        if (this.isPortrait()) {
            return this;
        }
        PrintAttributes attributes = new PrintAttributes();
        attributes.setMediaSize(this.getMediaSize().asPortrait());
        Resolution oldResolution = this.getResolution();
        Resolution newResolution = new Resolution(oldResolution.getId(), oldResolution.getLabel(), oldResolution.getVerticalDpi(), oldResolution.getHorizontalDpi());
        attributes.setResolution(newResolution);
        attributes.setMinMargins(this.getMinMargins());
        attributes.setColorMode(this.getColorMode());
        attributes.setDuplexMode(this.getDuplexMode());
        return attributes;
    }

    public PrintAttributes asLandscape() {
        if (!this.isPortrait()) {
            return this;
        }
        PrintAttributes attributes = new PrintAttributes();
        attributes.setMediaSize(this.getMediaSize().asLandscape());
        Resolution oldResolution = this.getResolution();
        Resolution newResolution = new Resolution(oldResolution.getId(), oldResolution.getLabel(), oldResolution.getVerticalDpi(), oldResolution.getHorizontalDpi());
        attributes.setResolution(newResolution);
        attributes.setMinMargins(this.getMinMargins());
        attributes.setColorMode(this.getColorMode());
        attributes.setDuplexMode(this.getDuplexMode());
        return attributes;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        if (this.mMediaSize != null) {
            parcel.writeInt(1);
            this.mMediaSize.writeToParcel(parcel);
        } else {
            parcel.writeInt(0);
        }
        if (this.mResolution != null) {
            parcel.writeInt(1);
            this.mResolution.writeToParcel(parcel);
        } else {
            parcel.writeInt(0);
        }
        if (this.mMinMargins != null) {
            parcel.writeInt(1);
            this.mMinMargins.writeToParcel(parcel);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.mColorMode);
        parcel.writeInt(this.mDuplexMode);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mColorMode;
        result = 31 * result + this.mDuplexMode;
        result = 31 * result + (this.mMinMargins == null ? 0 : this.mMinMargins.hashCode());
        result = 31 * result + (this.mMediaSize == null ? 0 : this.mMediaSize.hashCode());
        result = 31 * result + (this.mResolution == null ? 0 : this.mResolution.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrintAttributes other = (PrintAttributes)obj;
        if (this.mColorMode != other.mColorMode) {
            return false;
        }
        if (this.mDuplexMode != other.mDuplexMode) {
            return false;
        }
        if (this.mMinMargins == null ? other.mMinMargins != null : !this.mMinMargins.equals(other.mMinMargins)) {
            return false;
        }
        if (this.mMediaSize == null ? other.mMediaSize != null : !this.mMediaSize.equals(other.mMediaSize)) {
            return false;
        }
        return !(this.mResolution == null ? other.mResolution != null : !this.mResolution.equals(other.mResolution));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PrintAttributes{");
        builder.append("mediaSize: ").append(this.mMediaSize);
        if (this.mMediaSize != null) {
            builder.append(", orientation: ").append(this.mMediaSize.isPortrait() ? "portrait" : "landscape");
        } else {
            builder.append(", orientation: ").append("null");
        }
        builder.append(", resolution: ").append(this.mResolution);
        builder.append(", minMargins: ").append(this.mMinMargins);
        builder.append(", colorMode: ").append(PrintAttributes.colorModeToString(this.mColorMode));
        builder.append(", duplexMode: ").append(PrintAttributes.duplexModeToString(this.mDuplexMode));
        builder.append("}");
        return builder.toString();
    }

    public void clear() {
        this.mMediaSize = null;
        this.mResolution = null;
        this.mMinMargins = null;
        this.mColorMode = 0;
        this.mDuplexMode = 0;
    }

    public void copyFrom(PrintAttributes other) {
        this.mMediaSize = other.mMediaSize;
        this.mResolution = other.mResolution;
        this.mMinMargins = other.mMinMargins;
        this.mColorMode = other.mColorMode;
        this.mDuplexMode = other.mDuplexMode;
    }

    static String colorModeToString(int colorMode) {
        switch (colorMode) {
            case 1: {
                return "COLOR_MODE_MONOCHROME";
            }
            case 2: {
                return "COLOR_MODE_COLOR";
            }
        }
        return "COLOR_MODE_UNKNOWN";
    }

    static String duplexModeToString(int duplexMode) {
        switch (duplexMode) {
            case 1: {
                return "DUPLEX_MODE_NONE";
            }
            case 2: {
                return "DUPLEX_MODE_LONG_EDGE";
            }
            case 4: {
                return "DUPLEX_MODE_SHORT_EDGE";
            }
        }
        return "DUPLEX_MODE_UNKNOWN";
    }

    static void enforceValidColorMode(int colorMode) {
        if ((colorMode & 3) == 0 || Integer.bitCount(colorMode) != 1) {
            throw new IllegalArgumentException("invalid color mode: " + colorMode);
        }
    }

    static void enforceValidDuplexMode(int duplexMode) {
        if ((duplexMode & 7) == 0 || Integer.bitCount(duplexMode) != 1) {
            throw new IllegalArgumentException("invalid duplex mode: " + duplexMode);
        }
    }

    public static class MediaSize {
        private static final String LOG_TAG = "MediaSize";
        private static final Map<String, MediaSize> sIdToMediaSizeMap = new ArrayMap<String, MediaSize>();
        public static final MediaSize UNKNOWN_PORTRAIT = new MediaSize("UNKNOWN_PORTRAIT", "android", 17040970, 1, Integer.MAX_VALUE);
        public static final MediaSize UNKNOWN_LANDSCAPE = new MediaSize("UNKNOWN_LANDSCAPE", "android", 17040969, Integer.MAX_VALUE, 1);
        public static final MediaSize ISO_A0 = new MediaSize("ISO_A0", "android", 17040892, 33110, 46810);
        public static final MediaSize ISO_A1 = new MediaSize("ISO_A1", "android", 17040893, 23390, 33110);
        public static final MediaSize ISO_A2 = new MediaSize("ISO_A2", "android", 17040895, 16540, 23390);
        public static final MediaSize ISO_A3 = new MediaSize("ISO_A3", "android", 17040896, 11690, 16540);
        public static final MediaSize ISO_A4 = new MediaSize("ISO_A4", "android", 17040897, 8270, 11690);
        public static final MediaSize ISO_A5 = new MediaSize("ISO_A5", "android", 17040898, 5830, 8270);
        public static final MediaSize ISO_A6 = new MediaSize("ISO_A6", "android", 17040899, 4130, 5830);
        public static final MediaSize ISO_A7 = new MediaSize("ISO_A7", "android", 17040900, 2910, 4130);
        public static final MediaSize ISO_A8 = new MediaSize("ISO_A8", "android", 17040901, 2050, 2910);
        public static final MediaSize ISO_A9 = new MediaSize("ISO_A9", "android", 17040902, 1460, 2050);
        public static final MediaSize ISO_A10 = new MediaSize("ISO_A10", "android", 17040894, 1020, 1460);
        public static final MediaSize ISO_B0 = new MediaSize("ISO_B0", "android", 17040903, 39370, 55670);
        public static final MediaSize ISO_B1 = new MediaSize("ISO_B1", "android", 17040904, 27830, 39370);
        public static final MediaSize ISO_B2 = new MediaSize("ISO_B2", "android", 17040906, 19690, 27830);
        public static final MediaSize ISO_B3 = new MediaSize("ISO_B3", "android", 17040907, 13900, 19690);
        public static final MediaSize ISO_B4 = new MediaSize("ISO_B4", "android", 17040908, 9840, 13900);
        public static final MediaSize ISO_B5 = new MediaSize("ISO_B5", "android", 17040909, 6930, 9840);
        public static final MediaSize ISO_B6 = new MediaSize("ISO_B6", "android", 17040910, 4920, 6930);
        public static final MediaSize ISO_B7 = new MediaSize("ISO_B7", "android", 17040911, 3460, 4920);
        public static final MediaSize ISO_B8 = new MediaSize("ISO_B8", "android", 17040912, 2440, 3460);
        public static final MediaSize ISO_B9 = new MediaSize("ISO_B9", "android", 17040913, 1730, 2440);
        public static final MediaSize ISO_B10 = new MediaSize("ISO_B10", "android", 17040905, 1220, 1730);
        public static final MediaSize ISO_C0 = new MediaSize("ISO_C0", "android", 17040914, 36100, 51060);
        public static final MediaSize ISO_C1 = new MediaSize("ISO_C1", "android", 17040915, 25510, 36100);
        public static final MediaSize ISO_C2 = new MediaSize("ISO_C2", "android", 17040917, 18030, 25510);
        public static final MediaSize ISO_C3 = new MediaSize("ISO_C3", "android", 17040918, 12760, 18030);
        public static final MediaSize ISO_C4 = new MediaSize("ISO_C4", "android", 17040919, 9020, 12760);
        public static final MediaSize ISO_C5 = new MediaSize("ISO_C5", "android", 17040920, 6380, 9020);
        public static final MediaSize ISO_C6 = new MediaSize("ISO_C6", "android", 17040921, 4490, 6380);
        public static final MediaSize ISO_C7 = new MediaSize("ISO_C7", "android", 17040922, 3190, 4490);
        public static final MediaSize ISO_C8 = new MediaSize("ISO_C8", "android", 17040923, 2240, 3190);
        public static final MediaSize ISO_C9 = new MediaSize("ISO_C9", "android", 17040924, 1570, 2240);
        public static final MediaSize ISO_C10 = new MediaSize("ISO_C10", "android", 17040916, 1100, 1570);
        public static final MediaSize NA_LETTER = new MediaSize("NA_LETTER", "android", 17040964, 8500, 11000);
        public static final MediaSize NA_GOVT_LETTER = new MediaSize("NA_GOVT_LETTER", "android", 17040957, 8000, 10500);
        public static final MediaSize NA_LEGAL = new MediaSize("NA_LEGAL", "android", 17040963, 8500, 14000);
        public static final MediaSize NA_JUNIOR_LEGAL = new MediaSize("NA_JUNIOR_LEGAL", "android", 17040961, 8000, 5000);
        public static final MediaSize NA_LEDGER = new MediaSize("NA_LEDGER", "android", 17040962, 17000, 11000);
        public static final MediaSize NA_TABLOID = new MediaSize("NA_TABLOID", "android", 17040968, 11000, 17000);
        public static final MediaSize NA_INDEX_3X5 = new MediaSize("NA_INDEX_3X5", "android", 17040958, 3000, 5000);
        public static final MediaSize NA_INDEX_4X6 = new MediaSize("NA_INDEX_4X6", "android", 17040959, 4000, 6000);
        public static final MediaSize NA_INDEX_5X8 = new MediaSize("NA_INDEX_5X8", "android", 17040960, 5000, 8000);
        public static final MediaSize NA_MONARCH = new MediaSize("NA_MONARCH", "android", 17040965, 7250, 10500);
        public static final MediaSize NA_QUARTO = new MediaSize("NA_QUARTO", "android", 17040966, 8000, 10000);
        public static final MediaSize NA_FOOLSCAP = new MediaSize("NA_FOOLSCAP", "android", 17040956, 8000, 13000);
        @NonNull
        public static final MediaSize ANSI_C = new MediaSize("ANSI_C", "android", 17040946, 17000, 22000);
        @NonNull
        public static final MediaSize ANSI_D = new MediaSize("ANSI_D", "android", 17040947, 22000, 34000);
        @NonNull
        public static final MediaSize ANSI_E = new MediaSize("ANSI_E", "android", 17040948, 34000, 44000);
        @NonNull
        public static final MediaSize ANSI_F = new MediaSize("ANSI_F", "android", 17040949, 28000, 40000);
        @NonNull
        public static final MediaSize NA_ARCH_A = new MediaSize("NA_ARCH_A", "android", 17040950, 9000, 12000);
        @NonNull
        public static final MediaSize NA_ARCH_B = new MediaSize("NA_ARCH_B", "android", 17040951, 12000, 18000);
        @NonNull
        public static final MediaSize NA_ARCH_C = new MediaSize("NA_ARCH_C", "android", 17040952, 18000, 24000);
        @NonNull
        public static final MediaSize NA_ARCH_D = new MediaSize("NA_ARCH_D", "android", 17040953, 24000, 36000);
        @NonNull
        public static final MediaSize NA_ARCH_E = new MediaSize("NA_ARCH_E", "android", 17040954, 36000, 48000);
        @NonNull
        public static final MediaSize NA_ARCH_E1 = new MediaSize("NA_ARCH_E1", "android", 17040955, 30000, 42000);
        @NonNull
        public static final MediaSize NA_SUPER_B = new MediaSize("NA_SUPER_B", "android", 17040967, 13000, 19000);
        public static final MediaSize ROC_8K = new MediaSize("ROC_8K", "android", 17040891, 10629, 15354);
        public static final MediaSize ROC_16K = new MediaSize("ROC_16K", "android", 17040890, 7677, 10629);
        public static final MediaSize PRC_1 = new MediaSize("PRC_1", "android", 17040879, 4015, 6496);
        public static final MediaSize PRC_2 = new MediaSize("PRC_2", "android", 17040882, 4015, 6929);
        public static final MediaSize PRC_3 = new MediaSize("PRC_3", "android", 17040883, 4921, 6929);
        public static final MediaSize PRC_4 = new MediaSize("PRC_4", "android", 17040884, 4330, 8189);
        public static final MediaSize PRC_5 = new MediaSize("PRC_5", "android", 17040885, 4330, 8661);
        public static final MediaSize PRC_6 = new MediaSize("PRC_6", "android", 17040886, 4724, 12599);
        public static final MediaSize PRC_7 = new MediaSize("PRC_7", "android", 17040887, 6299, 9055);
        public static final MediaSize PRC_8 = new MediaSize("PRC_8", "android", 17040888, 4724, 12165);
        public static final MediaSize PRC_9 = new MediaSize("PRC_9", "android", 17040889, 9016, 12756);
        public static final MediaSize PRC_10 = new MediaSize("PRC_10", "android", 17040880, 12756, 18032);
        public static final MediaSize PRC_16K = new MediaSize("PRC_16K", "android", 17040881, 5749, 8465);
        public static final MediaSize OM_PA_KAI = new MediaSize("OM_PA_KAI", "android", 17040878, 10512, 15315);
        public static final MediaSize OM_DAI_PA_KAI = new MediaSize("OM_DAI_PA_KAI", "android", 17040876, 10827, 15551);
        public static final MediaSize OM_JUURO_KU_KAI = new MediaSize("OM_JUURO_KU_KAI", "android", 17040877, 7796, 10827);
        public static final MediaSize JIS_B10 = new MediaSize("JIS_B10", "android", 17040931, 1259, 1772);
        public static final MediaSize JIS_B9 = new MediaSize("JIS_B9", "android", 17040939, 1772, 2520);
        public static final MediaSize JIS_B8 = new MediaSize("JIS_B8", "android", 17040938, 2520, 3583);
        public static final MediaSize JIS_B7 = new MediaSize("JIS_B7", "android", 17040937, 3583, 5049);
        public static final MediaSize JIS_B6 = new MediaSize("JIS_B6", "android", 17040936, 5049, 7165);
        public static final MediaSize JIS_B5 = new MediaSize("JIS_B5", "android", 17040935, 7165, 10118);
        public static final MediaSize JIS_B4 = new MediaSize("JIS_B4", "android", 17040934, 10118, 14331);
        public static final MediaSize JIS_B3 = new MediaSize("JIS_B3", "android", 17040933, 14331, 20276);
        public static final MediaSize JIS_B2 = new MediaSize("JIS_B2", "android", 17040932, 20276, 28661);
        public static final MediaSize JIS_B1 = new MediaSize("JIS_B1", "android", 17040930, 28661, 40551);
        public static final MediaSize JIS_B0 = new MediaSize("JIS_B0", "android", 17040929, 40551, 57323);
        public static final MediaSize JIS_EXEC = new MediaSize("JIS_EXEC", "android", 17040940, 8504, 12992);
        public static final MediaSize JPN_CHOU4 = new MediaSize("JPN_CHOU4", "android", 17040927, 3543, 8071);
        public static final MediaSize JPN_CHOU3 = new MediaSize("JPN_CHOU3", "android", 17040926, 4724, 9252);
        public static final MediaSize JPN_CHOU2 = new MediaSize("JPN_CHOU2", "android", 17040925, 4374, 5748);
        public static final MediaSize JPN_HAGAKI = new MediaSize("JPN_HAGAKI", "android", 17040928, 3937, 5827);
        public static final MediaSize JPN_OUFUKU = new MediaSize("JPN_OUFUKU", "android", 17040944, 5827, 7874);
        public static final MediaSize JPN_KAHU = new MediaSize("JPN_KAHU", "android", 17040941, 9449, 12681);
        public static final MediaSize JPN_KAKU2 = new MediaSize("JPN_KAKU2", "android", 17040942, 9449, 13071);
        public static final MediaSize JPN_YOU4 = new MediaSize("JPN_YOU4", "android", 17040945, 4134, 9252);
        @NonNull
        public static final MediaSize JPN_OE_PHOTO_L = new MediaSize("JPN_OE_PHOTO_L", "android", 17040943, 3500, 5000);
        @NonNull
        private final String mId;
        @NonNull
        public final String mLabel;
        @Nullable
        public final String mPackageName;
        public final int mLabelResId;
        private final int mWidthMils;
        private final int mHeightMils;

        public MediaSize(String id2, String packageName, int labelResId, int widthMils, int heightMils) {
            this(id2, null, packageName, widthMils, heightMils, labelResId);
            sIdToMediaSizeMap.put(this.mId, this);
        }

        public MediaSize(@NonNull String id2, @NonNull String label, int widthMils, int heightMils) {
            this(id2, label, null, widthMils, heightMils, 0);
        }

        @NonNull
        public static ArraySet<MediaSize> getAllPredefinedSizes() {
            ArraySet<MediaSize> definedMediaSizes = new ArraySet<MediaSize>(sIdToMediaSizeMap.values());
            definedMediaSizes.remove(UNKNOWN_PORTRAIT);
            definedMediaSizes.remove(UNKNOWN_LANDSCAPE);
            return definedMediaSizes;
        }

        public MediaSize(String id2, String label, String packageName, int widthMils, int heightMils, int labelResId) {
            this.mPackageName = packageName;
            this.mId = Preconditions.checkStringNotEmpty(id2, "id cannot be empty.");
            this.mLabelResId = labelResId;
            this.mWidthMils = Preconditions.checkArgumentPositive(widthMils, "widthMils cannot be less than or equal to zero.");
            this.mHeightMils = Preconditions.checkArgumentPositive(heightMils, "heightMils cannot be less than or equal to zero.");
            this.mLabel = label;
            Preconditions.checkArgument(!TextUtils.isEmpty(label) != (!TextUtils.isEmpty(packageName) && labelResId != 0), "label cannot be empty.");
        }

        @NonNull
        public String getId() {
            return this.mId;
        }

        @NonNull
        public String getLabel(@NonNull PackageManager packageManager) {
            if (!TextUtils.isEmpty(this.mPackageName) && this.mLabelResId > 0) {
                try {
                    return packageManager.getResourcesForApplication(this.mPackageName).getString(this.mLabelResId);
                }
                catch (PackageManager.NameNotFoundException | Resources.NotFoundException e) {
                    Log.w(LOG_TAG, "Could not load resouce" + this.mLabelResId + " from package " + this.mPackageName);
                }
            }
            return this.mLabel;
        }

        public int getWidthMils() {
            return this.mWidthMils;
        }

        public int getHeightMils() {
            return this.mHeightMils;
        }

        public boolean isPortrait() {
            return this.mHeightMils >= this.mWidthMils;
        }

        @NonNull
        public MediaSize asPortrait() {
            if (this.isPortrait()) {
                return this;
            }
            return new MediaSize(this.mId, this.mLabel, this.mPackageName, Math.min(this.mWidthMils, this.mHeightMils), Math.max(this.mWidthMils, this.mHeightMils), this.mLabelResId);
        }

        @NonNull
        public MediaSize asLandscape() {
            if (!this.isPortrait()) {
                return this;
            }
            return new MediaSize(this.mId, this.mLabel, this.mPackageName, Math.max(this.mWidthMils, this.mHeightMils), Math.min(this.mWidthMils, this.mHeightMils), this.mLabelResId);
        }

        void writeToParcel(Parcel parcel) {
            parcel.writeString(this.mId);
            parcel.writeString(this.mLabel);
            parcel.writeString(this.mPackageName);
            parcel.writeInt(this.mWidthMils);
            parcel.writeInt(this.mHeightMils);
            parcel.writeInt(this.mLabelResId);
        }

        static MediaSize createFromParcel(Parcel parcel) {
            return new MediaSize(parcel.readString(), parcel.readString(), parcel.readString(), parcel.readInt(), parcel.readInt(), parcel.readInt());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.mWidthMils;
            result = 31 * result + this.mHeightMils;
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MediaSize other = (MediaSize)obj;
            if (this.mWidthMils != other.mWidthMils) {
                return false;
            }
            return this.mHeightMils == other.mHeightMils;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MediaSize{");
            builder.append("id: ").append(this.mId);
            builder.append(", label: ").append(this.mLabel);
            builder.append(", packageName: ").append(this.mPackageName);
            builder.append(", heightMils: ").append(this.mHeightMils);
            builder.append(", widthMils: ").append(this.mWidthMils);
            builder.append(", labelResId: ").append(this.mLabelResId);
            builder.append("}");
            return builder.toString();
        }

        public static MediaSize getStandardMediaSizeById(String id2) {
            return sIdToMediaSizeMap.get(id2);
        }
    }

    public static class Resolution {
        @NonNull
        private final String mId;
        @NonNull
        private final String mLabel;
        private final int mHorizontalDpi;
        private final int mVerticalDpi;

        public Resolution(@NonNull String id2, @NonNull String label, int horizontalDpi, int verticalDpi) {
            if (TextUtils.isEmpty(id2)) {
                throw new IllegalArgumentException("id cannot be empty.");
            }
            if (TextUtils.isEmpty(label)) {
                throw new IllegalArgumentException("label cannot be empty.");
            }
            if (horizontalDpi <= 0) {
                throw new IllegalArgumentException("horizontalDpi cannot be less than or equal to zero.");
            }
            if (verticalDpi <= 0) {
                throw new IllegalArgumentException("verticalDpi cannot be less than or equal to zero.");
            }
            this.mId = id2;
            this.mLabel = label;
            this.mHorizontalDpi = horizontalDpi;
            this.mVerticalDpi = verticalDpi;
        }

        @NonNull
        public String getId() {
            return this.mId;
        }

        @NonNull
        public String getLabel() {
            return this.mLabel;
        }

        public int getHorizontalDpi() {
            return this.mHorizontalDpi;
        }

        public int getVerticalDpi() {
            return this.mVerticalDpi;
        }

        void writeToParcel(Parcel parcel) {
            parcel.writeString(this.mId);
            parcel.writeString(this.mLabel);
            parcel.writeInt(this.mHorizontalDpi);
            parcel.writeInt(this.mVerticalDpi);
        }

        static Resolution createFromParcel(Parcel parcel) {
            return new Resolution(parcel.readString(), parcel.readString(), parcel.readInt(), parcel.readInt());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.mHorizontalDpi;
            result = 31 * result + this.mVerticalDpi;
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Resolution other = (Resolution)obj;
            if (this.mHorizontalDpi != other.mHorizontalDpi) {
                return false;
            }
            return this.mVerticalDpi == other.mVerticalDpi;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Resolution{");
            builder.append("id: ").append(this.mId);
            builder.append(", label: ").append(this.mLabel);
            builder.append(", horizontalDpi: ").append(this.mHorizontalDpi);
            builder.append(", verticalDpi: ").append(this.mVerticalDpi);
            builder.append("}");
            return builder.toString();
        }
    }

    public static class Margins {
        public static final Margins NO_MARGINS = new Margins(0, 0, 0, 0);
        private final int mLeftMils;
        private final int mTopMils;
        private final int mRightMils;
        private final int mBottomMils;

        public Margins(int leftMils, int topMils, int rightMils, int bottomMils) {
            this.mTopMils = topMils;
            this.mLeftMils = leftMils;
            this.mRightMils = rightMils;
            this.mBottomMils = bottomMils;
        }

        public int getLeftMils() {
            return this.mLeftMils;
        }

        public int getTopMils() {
            return this.mTopMils;
        }

        public int getRightMils() {
            return this.mRightMils;
        }

        public int getBottomMils() {
            return this.mBottomMils;
        }

        void writeToParcel(Parcel parcel) {
            parcel.writeInt(this.mLeftMils);
            parcel.writeInt(this.mTopMils);
            parcel.writeInt(this.mRightMils);
            parcel.writeInt(this.mBottomMils);
        }

        static Margins createFromParcel(Parcel parcel) {
            return new Margins(parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.mBottomMils;
            result = 31 * result + this.mLeftMils;
            result = 31 * result + this.mRightMils;
            result = 31 * result + this.mTopMils;
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Margins other = (Margins)obj;
            if (this.mBottomMils != other.mBottomMils) {
                return false;
            }
            if (this.mLeftMils != other.mLeftMils) {
                return false;
            }
            if (this.mRightMils != other.mRightMils) {
                return false;
            }
            return this.mTopMils == other.mTopMils;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Margins{");
            builder.append("leftMils: ").append(this.mLeftMils);
            builder.append(", topMils: ").append(this.mTopMils);
            builder.append(", rightMils: ").append(this.mRightMils);
            builder.append(", bottomMils: ").append(this.mBottomMils);
            builder.append("}");
            return builder.toString();
        }
    }

    public static class Builder {
        private final PrintAttributes mAttributes = new PrintAttributes();

        @NonNull
        public Builder setMediaSize(@NonNull MediaSize mediaSize) {
            this.mAttributes.setMediaSize(mediaSize);
            return this;
        }

        @NonNull
        public Builder setResolution(@NonNull Resolution resolution) {
            this.mAttributes.setResolution(resolution);
            return this;
        }

        @NonNull
        public Builder setMinMargins(@NonNull Margins margins) {
            this.mAttributes.setMinMargins(margins);
            return this;
        }

        @NonNull
        public Builder setColorMode(int colorMode) {
            this.mAttributes.setColorMode(colorMode);
            return this;
        }

        @NonNull
        public Builder setDuplexMode(int duplexMode) {
            this.mAttributes.setDuplexMode(duplexMode);
            return this;
        }

        @NonNull
        public PrintAttributes build() {
            return this.mAttributes;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface DuplexMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface ColorMode {
    }
}

