/*
 * Decompiled with CFR 0.152.
 */
package android.provider.internal.aconfig.storage;

public class SipHasher13 {
    public static long hash(byte[] data) {
        int index;
        State state = new State(0L, 0L);
        int len = data.length;
        int left = len & 7;
        for (index = 0; index < len - left; index += 8) {
            long mi = SipHasher13.loadLe(data, index, 8);
            state.compress(mi);
        }
        long m = 255L << left * 8 | SipHasher13.loadLe(data, index, left);
        if (left == 7) {
            state.compress(m);
            m = 0L;
        }
        state.compress(m |= ((long)(len + 1) & 0xFFL) << 56);
        return state.finish();
    }

    private static long loadLe(byte[] data, int offset, int size) {
        long m = 0L;
        for (int i = 0; i < size; ++i) {
            m |= ((long)data[i + offset] & 0xFFL) << i * 8;
        }
        return m;
    }

    static class State {
        private long v0;
        private long v2;
        private long v1;
        private long v3;

        public State(long k0, long k1) {
            this.v0 = k0 ^ 0x736F6D6570736575L;
            this.v1 = k1 ^ 0x646F72616E646F6DL;
            this.v2 = k0 ^ 0x6C7967656E657261L;
            this.v3 = k1 ^ 0x7465646279746573L;
        }

        public void compress(long m) {
            this.v3 ^= m;
            this.cRounds();
            this.v0 ^= m;
        }

        public long finish() {
            this.v2 ^= 0xFFL;
            this.dRounds();
            return this.v0 ^ this.v1 ^ this.v2 ^ this.v3;
        }

        private void cRounds() {
            this.v0 += this.v1;
            this.v1 = Long.rotateLeft(this.v1, 13);
            this.v1 ^= this.v0;
            this.v0 = Long.rotateLeft(this.v0, 32);
            this.v2 += this.v3;
            this.v3 = Long.rotateLeft(this.v3, 16);
            this.v3 ^= this.v2;
            this.v0 += this.v3;
            this.v3 = Long.rotateLeft(this.v3, 21);
            this.v3 ^= this.v0;
            this.v2 += this.v1;
            this.v1 = Long.rotateLeft(this.v1, 17);
            this.v1 ^= this.v2;
            this.v2 = Long.rotateLeft(this.v2, 32);
        }

        private void dRounds() {
            for (int i = 0; i < 3; ++i) {
                this.v0 += this.v1;
                this.v1 = Long.rotateLeft(this.v1, 13);
                this.v1 ^= this.v0;
                this.v0 = Long.rotateLeft(this.v0, 32);
                this.v2 += this.v3;
                this.v3 = Long.rotateLeft(this.v3, 16);
                this.v3 ^= this.v2;
                this.v0 += this.v3;
                this.v3 = Long.rotateLeft(this.v3, 21);
                this.v3 ^= this.v0;
                this.v2 += this.v1;
                this.v1 = Long.rotateLeft(this.v1, 17);
                this.v1 ^= this.v2;
                this.v2 = Long.rotateLeft(this.v2, 32);
            }
        }
    }
}

