/*
 * Decompiled with CFR 0.152.
 */
package android.ranging;

import android.annotation.NonNull;
import android.os.Binder;
import android.os.RemoteException;
import android.ranging.IRangingAdapter;
import android.ranging.IRangingCapabilitiesCallback;
import android.ranging.RangingCapabilities;
import android.ranging.RangingManager;
import android.util.Log;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

public class CapabilitiesListener
extends IRangingCapabilitiesCallback.Stub {
    private static final String TAG = CapabilitiesListener.class.getSimpleName();
    private final IRangingAdapter mRangingAdapter;
    private boolean mIsRegistered = false;
    private final Map<RangingManager.RangingCapabilitiesCallback, Executor> mCallbackMap = new ConcurrentHashMap<RangingManager.RangingCapabilitiesCallback, Executor>();
    private RangingCapabilities mCachedCapabilities;

    public CapabilitiesListener(@NonNull IRangingAdapter rangingAdapter) {
        this.mRangingAdapter = rangingAdapter;
    }

    public void register(@NonNull Executor executor, @NonNull RangingManager.RangingCapabilitiesCallback callback) {
        if (this.mCallbackMap.containsKey(callback)) {
            return;
        }
        this.mCallbackMap.put(callback, executor);
        if (!this.mIsRegistered) {
            try {
                this.mRangingAdapter.registerCapabilitiesCallback(this);
                this.mIsRegistered = true;
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed to register capabilities callback");
                throw e.rethrowFromSystemServer();
            }
        } else {
            this.sendCurrentCapabilities(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(@NonNull RangingManager.RangingCapabilitiesCallback callback) {
        CapabilitiesListener capabilitiesListener = this;
        synchronized (capabilitiesListener) {
            if (!this.mCallbackMap.containsKey(callback)) {
                return;
            }
            this.mCallbackMap.remove(callback);
            if (this.mCallbackMap.isEmpty() && this.mIsRegistered) {
                try {
                    this.mRangingAdapter.unregisterCapabilitiesCallback(this);
                    this.mIsRegistered = false;
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Failed to unregister capabilities callback");
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCurrentCapabilities(@NonNull RangingManager.RangingCapabilitiesCallback callback) {
        CapabilitiesListener capabilitiesListener = this;
        synchronized (capabilitiesListener) {
            if (this.mCachedCapabilities != null) {
                Executor executor = this.mCallbackMap.get(callback);
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> callback.onRangingCapabilities(this.mCachedCapabilities));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCapabilitiesUpdated(RangingCapabilities rangingCapabilities) {
        CapabilitiesListener capabilitiesListener = this;
        synchronized (capabilitiesListener) {
            this.mCachedCapabilities = rangingCapabilities;
            for (RangingManager.RangingCapabilitiesCallback cb : this.mCallbackMap.keySet()) {
                this.sendCurrentCapabilities(cb);
            }
        }
    }

    @Override
    public void onRangingCapabilities(RangingCapabilities rangingCapabilities) throws RemoteException {
        this.onCapabilitiesUpdated(rangingCapabilities);
    }
}

