/*
 * Decompiled with CFR 0.152.
 */
package android.ranging;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.ranging.RangingMeasurement;
import java.util.Objects;

@FlaggedApi(value="com.android.x.ranging.com.android.ranging.flags.ranging_stack_enabled")
public class RangingData
implements Parcelable {
    private final int mRangingTechnology;
    private final RangingMeasurement mDistance;
    @Nullable
    private final RangingMeasurement mAzimuth;
    @Nullable
    private final RangingMeasurement mElevation;
    private final int mRssi;
    private final long mTimestamp;
    private final double mDelaySpreadMeters;
    private final byte mDetectedAttackLevel;
    private final double mVelocityMetersPerSec;
    @NonNull
    public static final Parcelable.Creator<RangingData> CREATOR = new Parcelable.Creator<RangingData>(){

        @Override
        public RangingData createFromParcel(Parcel in) {
            return new RangingData(in);
        }

        public RangingData[] newArray(int size) {
            return new RangingData[size];
        }
    };

    private RangingData(Builder builder) {
        if (builder.mDistance == null) {
            throw new IllegalArgumentException("Missing required parameter: distance");
        }
        if (builder.mTimestamp == Long.MIN_VALUE) {
            throw new IllegalArgumentException("Missing required parameter: timestamp");
        }
        if (builder.mRangingTechnology == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Missing required parameter: rangingTechnology");
        }
        this.mRangingTechnology = builder.mRangingTechnology;
        this.mDistance = builder.mDistance;
        this.mAzimuth = builder.mAzimuth;
        this.mElevation = builder.mElevation;
        this.mRssi = builder.mRssi;
        this.mTimestamp = builder.mTimestamp;
        this.mDelaySpreadMeters = builder.mDelaySpreadMeters;
        this.mDetectedAttackLevel = builder.mDetectedAttackLevel;
        this.mVelocityMetersPerSec = builder.mVelocityMetersPerSec;
    }

    private RangingData(Parcel in) {
        this.mRangingTechnology = in.readInt();
        this.mDistance = Objects.requireNonNull(in.readParcelable(RangingMeasurement.class.getClassLoader(), RangingMeasurement.class));
        this.mAzimuth = in.readParcelable(RangingMeasurement.class.getClassLoader(), RangingMeasurement.class);
        this.mElevation = in.readParcelable(RangingMeasurement.class.getClassLoader(), RangingMeasurement.class);
        this.mRssi = in.readInt();
        this.mTimestamp = in.readLong();
        this.mDelaySpreadMeters = in.readDouble();
        this.mDetectedAttackLevel = in.readByte();
        this.mVelocityMetersPerSec = in.readDouble();
    }

    public int getRangingTechnology() {
        return this.mRangingTechnology;
    }

    @Nullable
    public RangingMeasurement getDistance() {
        return this.mDistance;
    }

    @Nullable
    public RangingMeasurement getAzimuth() {
        return this.mAzimuth;
    }

    @Nullable
    public RangingMeasurement getElevation() {
        return this.mElevation;
    }

    public boolean hasRssi() {
        return this.mRssi != Integer.MIN_VALUE;
    }

    public int getRssi() {
        if (!this.hasRssi()) {
            throw new IllegalStateException("rssi is not set");
        }
        return this.mRssi;
    }

    public boolean hasDelaySpread() {
        return !Double.isNaN(this.mDelaySpreadMeters);
    }

    public double getDelaySpreadMeters() {
        return this.mDelaySpreadMeters;
    }

    public boolean hasDetectedAttackLevel() {
        return Byte.compareUnsigned(this.mDetectedAttackLevel, (byte)-1) != 0;
    }

    public byte getDetectedAttackLevel() {
        return this.mDetectedAttackLevel;
    }

    public boolean hasVelocity() {
        return !Double.isNaN(this.mVelocityMetersPerSec);
    }

    public double getVelocityMetersPerSec() {
        return this.mVelocityMetersPerSec;
    }

    public long getTimestampMillis() {
        return this.mTimestamp;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mRangingTechnology);
        dest.writeParcelable(this.mDistance, flags);
        dest.writeParcelable(this.mAzimuth, flags);
        dest.writeParcelable(this.mElevation, flags);
        dest.writeInt(this.mRssi);
        dest.writeLong(this.mTimestamp);
        dest.writeDouble(this.mDelaySpreadMeters);
        dest.writeByte(this.mDetectedAttackLevel);
        dest.writeDouble(this.mVelocityMetersPerSec);
    }

    public static class Builder {
        private int mRangingTechnology = Integer.MIN_VALUE;
        private RangingMeasurement mDistance = null;
        private RangingMeasurement mAzimuth = null;
        private RangingMeasurement mElevation = null;
        private int mRssi = Integer.MIN_VALUE;
        private long mTimestamp = Long.MIN_VALUE;
        private double mDelaySpreadMeters = Double.NaN;
        private byte mDetectedAttackLevel = (byte)-1;
        private double mVelocityMetersPerSec = Double.NaN;

        @NonNull
        public Builder setRangingTechnology(int rangingTechnology) {
            this.mRangingTechnology = rangingTechnology;
            return this;
        }

        @NonNull
        public Builder setDistance(@NonNull RangingMeasurement distance) {
            this.mDistance = distance;
            return this;
        }

        @NonNull
        public Builder setAzimuth(@NonNull RangingMeasurement azimuth) {
            this.mAzimuth = azimuth;
            return this;
        }

        @NonNull
        public Builder setElevation(@NonNull RangingMeasurement elevation) {
            this.mElevation = elevation;
            return this;
        }

        @NonNull
        public Builder setRssi(int rssi) {
            this.mRssi = rssi;
            return this;
        }

        @NonNull
        public Builder setTimestampMillis(long timestamp) {
            this.mTimestamp = timestamp;
            return this;
        }

        @NonNull
        public Builder setDelaySpreadMeters(double delaySpread) {
            if (delaySpread < 0.0) {
                throw new IllegalArgumentException("Delay spread meters must be >= 0");
            }
            this.mDelaySpreadMeters = delaySpread;
            return this;
        }

        @NonNull
        public Builder setDetectedAttackLevel(byte detectedAttackLevel) {
            this.mDetectedAttackLevel = detectedAttackLevel;
            return this;
        }

        @NonNull
        public Builder setVelocityMetersPerSec(double velocity) {
            this.mVelocityMetersPerSec = velocity;
            return this;
        }

        @NonNull
        public RangingData build() {
            return new RangingData(this);
        }
    }
}

