/*
 * Decompiled with CFR 0.152.
 */
package android.ranging.oob;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.ranging.RangingConfig;
import android.ranging.oob.DeviceHandle;
import android.util.Range;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

@FlaggedApi(value="com.android.x.ranging.com.android.ranging.flags.ranging_stack_enabled")
public class OobInitiatorRangingConfig
extends RangingConfig
implements Parcelable {
    public static final int SECURITY_LEVEL_BASIC = 0;
    public static final int SECURITY_LEVEL_SECURE = 1;
    public static final int RANGING_MODE_AUTO = 0;
    public static final int RANGING_MODE_HIGH_ACCURACY = 1;
    public static final int RANGING_MODE_HIGH_ACCURACY_PREFERRED = 2;
    public static final int RANGING_MODE_FUSED = 3;
    private final List<DeviceHandle> mDeviceHandles;
    private final Range<Duration> mRangingIntervalRange;
    private final int mSecurityLevel;
    private final int mRangingMode;
    @NonNull
    public static final Parcelable.Creator<OobInitiatorRangingConfig> CREATOR = new Parcelable.Creator<OobInitiatorRangingConfig>(){

        @Override
        public OobInitiatorRangingConfig createFromParcel(Parcel in) {
            return new OobInitiatorRangingConfig(in);
        }

        public OobInitiatorRangingConfig[] newArray(int size) {
            return new OobInitiatorRangingConfig[size];
        }
    };

    private OobInitiatorRangingConfig(Builder builder) {
        this.setRangingSessionType(1);
        this.mDeviceHandles = new ArrayList<DeviceHandle>(builder.mDeviceHandles);
        this.mSecurityLevel = builder.mSecurityLevel;
        this.mRangingMode = builder.mRangingMode;
        this.mRangingIntervalRange = new Range<Duration>(builder.mFastestRangingInterval, builder.mSlowestRangingInterval);
    }

    private OobInitiatorRangingConfig(Parcel in) {
        this.setRangingSessionType(in.readInt());
        this.mDeviceHandles = in.createTypedArrayList(DeviceHandle.CREATOR);
        this.mSecurityLevel = in.readInt();
        this.mRangingMode = in.readInt();
        Duration lower = Duration.ofMillis(in.readLong());
        Duration upper = Duration.ofMillis(in.readLong());
        this.mRangingIntervalRange = new Range<Duration>(lower, upper);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.getRangingSessionType());
        dest.writeTypedList(this.mDeviceHandles);
        dest.writeInt(this.mSecurityLevel);
        dest.writeInt(this.mRangingMode);
        dest.writeLong(this.mRangingIntervalRange.getLower().toMillis());
        dest.writeLong(this.mRangingIntervalRange.getUpper().toMillis());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @NonNull
    public List<DeviceHandle> getDeviceHandles() {
        return this.mDeviceHandles;
    }

    @NonNull
    public Range<Duration> getRangingIntervalRange() {
        return this.mRangingIntervalRange;
    }

    @NonNull
    public Duration getFastestRangingInterval() {
        return this.mRangingIntervalRange.getLower();
    }

    @NonNull
    public Duration getSlowestRangingInterval() {
        return this.mRangingIntervalRange.getUpper();
    }

    public int getSecurityLevel() {
        return this.mSecurityLevel;
    }

    public int getRangingMode() {
        return this.mRangingMode;
    }

    @Override
    public String toString() {
        return "OobInitiatorRangingConfig{ mDeviceHandles=" + this.mDeviceHandles + ", mRangingIntervalRange=" + this.mRangingIntervalRange + ", mSecurityLevel=" + this.mSecurityLevel + ", mRangingMode=" + this.mRangingMode + ", " + super.toString() + ",  }";
    }

    public static class Builder {
        private final List<DeviceHandle> mDeviceHandles = new ArrayList<DeviceHandle>();
        private int mSecurityLevel = 0;
        private int mRangingMode = 0;
        private Duration mFastestRangingInterval = Duration.ofMillis(100L);
        private Duration mSlowestRangingInterval = Duration.ofMillis(5000L);

        @NonNull
        public Builder setFastestRangingInterval(@NonNull Duration intervalMs) {
            this.mFastestRangingInterval = intervalMs;
            return this;
        }

        @NonNull
        public Builder setSlowestRangingInterval(@NonNull Duration intervalMs) {
            if (intervalMs.isNegative() || intervalMs.isZero()) {
                throw new IllegalArgumentException("Slowest duration cannot be negative or zero");
            }
            this.mSlowestRangingInterval = intervalMs;
            return this;
        }

        @NonNull
        public Builder addDeviceHandle(@NonNull DeviceHandle deviceHandle) {
            this.mDeviceHandles.add(deviceHandle);
            return this;
        }

        @NonNull
        public Builder addDeviceHandles(@NonNull List<DeviceHandle> deviceHandles) {
            this.mDeviceHandles.addAll(deviceHandles);
            return this;
        }

        @NonNull
        public Builder setSecurityLevel(int securityLevel) {
            this.mSecurityLevel = securityLevel;
            return this;
        }

        @NonNull
        public Builder setRangingMode(int rangingMode) {
            this.mRangingMode = rangingMode;
            return this;
        }

        @NonNull
        public OobInitiatorRangingConfig build() {
            if (this.mDeviceHandles.isEmpty()) {
                throw new IllegalArgumentException("Device handle list cannot be empty");
            }
            return new OobInitiatorRangingConfig(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RangingMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SecurityLevel {
    }
}

