/*
 * Decompiled with CFR 0.152.
 */
package android.security.advancedprotection;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Intent;
import android.os.Binder;
import android.os.RemoteException;
import android.security.advancedprotection.AdvancedProtectionFeature;
import android.security.advancedprotection.IAdvancedProtectionCallback;
import android.security.advancedprotection.IAdvancedProtectionService;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

@FlaggedApi(value="android.security.aapm_api")
public class AdvancedProtectionManager {
    private static final String TAG = "AdvancedProtectionMgr";
    private static final String PKG_SETTINGS = "com.android.settings";
    private static final String MEMORY_TAGGING_POLICY = "memoryTagging";
    public static final String ADVANCED_PROTECTION_SYSTEM_ENTITY = "android.security.advancedprotection";
    @SystemApi
    public static final int FEATURE_ID_DISALLOW_CELLULAR_2G = 0;
    @SystemApi
    public static final int FEATURE_ID_DISALLOW_INSTALL_UNKNOWN_SOURCES = 1;
    @SystemApi
    public static final int FEATURE_ID_DISALLOW_USB = 2;
    @SystemApi
    public static final int FEATURE_ID_DISALLOW_WEP = 3;
    @SystemApi
    public static final int FEATURE_ID_ENABLE_MTE = 4;
    private static final Set<Integer> ALL_FEATURE_IDS = Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4));
    public static final String ACTION_SHOW_ADVANCED_PROTECTION_SUPPORT_DIALOG = "android.security.advancedprotection.action.SHOW_ADVANCED_PROTECTION_SUPPORT_DIALOG";
    public static final String EXTRA_SUPPORT_DIALOG_FEATURE = "android.security.advancedprotection.extra.SUPPORT_DIALOG_FEATURE";
    public static final String EXTRA_SUPPORT_DIALOG_TYPE = "android.security.advancedprotection.extra.SUPPORT_DIALOG_TYPE";
    public static final int SUPPORT_DIALOG_TYPE_UNKNOWN = 0;
    public static final int SUPPORT_DIALOG_TYPE_BLOCKED_INTERACTION = 1;
    public static final int SUPPORT_DIALOG_TYPE_DISABLED_SETTING = 2;
    private static final Set<Integer> ALL_SUPPORT_DIALOG_TYPES = Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2));
    private final ConcurrentHashMap<Callback, IAdvancedProtectionCallback> mCallbackMap = new ConcurrentHashMap();
    @NonNull
    private final IAdvancedProtectionService mService;

    public static String featureIdToString(int featureId) {
        String string2;
        switch (featureId) {
            case 0: {
                string2 = "DISALLOW_CELLULAR_2G";
                break;
            }
            case 1: {
                string2 = "DISALLOW_INSTALL_UNKNOWN_SOURCES";
                break;
            }
            case 2: {
                string2 = "DISALLOW_USB";
                break;
            }
            case 3: {
                string2 = "DISALLOW_WEP";
                break;
            }
            case 4: {
                string2 = "ENABLE_MTE";
                break;
            }
            default: {
                string2 = "UNKNOWN";
            }
        }
        return string2;
    }

    public static String supportDialogTypeToString(int type) {
        String string2;
        switch (type) {
            case 0: {
                string2 = "UNKNOWN";
                break;
            }
            case 1: {
                string2 = "BLOCKED_INTERACTION";
                break;
            }
            case 2: {
                string2 = "DISABLED_SETTING";
                break;
            }
            default: {
                string2 = "UNKNOWN";
            }
        }
        return string2;
    }

    public AdvancedProtectionManager(@NonNull IAdvancedProtectionService service) {
        this.mService = service;
    }

    @RequiresPermission(value="android.permission.QUERY_ADVANCED_PROTECTION_MODE")
    public boolean isAdvancedProtectionEnabled() {
        try {
            return this.mService.isAdvancedProtectionEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.QUERY_ADVANCED_PROTECTION_MODE")
    public void registerAdvancedProtectionCallback(final @NonNull Executor executor, final @NonNull Callback callback) {
        if (this.mCallbackMap.get(callback) != null) {
            Log.d(TAG, "registerAdvancedProtectionCallback callback already present");
            return;
        }
        IAdvancedProtectionCallback.Stub delegate = new IAdvancedProtectionCallback.Stub(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAdvancedProtectionChanged(boolean enabled) {
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> callback.onAdvancedProtectionChanged(enabled));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        };
        try {
            this.mService.registerAdvancedProtectionCallback(delegate);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        this.mCallbackMap.put(callback, delegate);
    }

    @RequiresPermission(value="android.permission.QUERY_ADVANCED_PROTECTION_MODE")
    public void unregisterAdvancedProtectionCallback(@NonNull Callback callback) {
        IAdvancedProtectionCallback delegate = this.mCallbackMap.get(callback);
        if (delegate == null) {
            Log.d(TAG, "unregisterAdvancedProtectionCallback callback not present");
            return;
        }
        try {
            this.mService.unregisterAdvancedProtectionCallback(delegate);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        this.mCallbackMap.remove(callback);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_ADVANCED_PROTECTION_MODE")
    public void setAdvancedProtectionEnabled(boolean enabled) {
        try {
            this.mService.setAdvancedProtectionEnabled(enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @NonNull
    @RequiresPermission(value="android.permission.MANAGE_ADVANCED_PROTECTION_MODE")
    public List<AdvancedProtectionFeature> getAdvancedProtectionFeatures() {
        try {
            return this.mService.getAdvancedProtectionFeatures();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public static Intent createSupportIntent(int featureId, int type) {
        if (!ALL_FEATURE_IDS.contains(featureId)) {
            throw new IllegalArgumentException(featureId + " is not a valid feature ID. See FEATURE_ID_* APIs.");
        }
        if (!ALL_SUPPORT_DIALOG_TYPES.contains(type)) {
            throw new IllegalArgumentException(type + " is not a valid type. See SUPPORT_DIALOG_TYPE_* APIs.");
        }
        Intent intent = new Intent(ACTION_SHOW_ADVANCED_PROTECTION_SUPPORT_DIALOG);
        intent.setPackage(PKG_SETTINGS);
        intent.setFlags(0x10000000);
        intent.putExtra(EXTRA_SUPPORT_DIALOG_FEATURE, featureId);
        intent.putExtra(EXTRA_SUPPORT_DIALOG_TYPE, type);
        return intent;
    }

    @NonNull
    public static Intent createSupportIntentForPolicyIdentifierOrRestriction(@NonNull String identifier, int type) {
        int featureId;
        Objects.requireNonNull(identifier);
        if (!ALL_SUPPORT_DIALOG_TYPES.contains(type)) {
            throw new IllegalArgumentException(type + " is not a valid type. See SUPPORT_DIALOG_TYPE_* APIs.");
        }
        int dialogType = type;
        if ("no_install_unknown_sources_globally".equals(identifier)) {
            featureId = 1;
        } else if ("no_cellular_2g".equals(identifier)) {
            featureId = 0;
            dialogType = dialogType == 0 ? 2 : dialogType;
        } else if (MEMORY_TAGGING_POLICY.equals(identifier)) {
            featureId = 4;
            dialogType = dialogType == 0 ? 2 : dialogType;
        } else {
            throw new UnsupportedOperationException("Unsupported identifier: " + identifier);
        }
        return AdvancedProtectionManager.createSupportIntent(featureId, dialogType);
    }

    @RequiresPermission(value="android.permission.MANAGE_ADVANCED_PROTECTION_MODE")
    public void logDialogShown(int featureId, int type, boolean learnMoreClicked) {
        try {
            this.mService.logDialogShown(featureId, type, learnMoreClicked);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.security.aapm_api")
    public static interface Callback {
        public void onAdvancedProtectionChanged(boolean var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SupportDialogType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FeatureId {
    }
}

