/*
 * Decompiled with CFR 0.152.
 */
package android.security.authenticationpolicy;

import android.annotation.EnforcePermission;
import android.app.ActivityThread;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteException;
import android.security.authenticationpolicy.DisableSecureLockDeviceParams;
import android.security.authenticationpolicy.EnableSecureLockDeviceParams;

public interface IAuthenticationPolicyService
extends IInterface {
    public static final String DESCRIPTOR = "android.security.authenticationpolicy.IAuthenticationPolicyService";

    @EnforcePermission(value="android.permission.MANAGE_SECURE_LOCK_DEVICE")
    public int enableSecureLockDevice(EnableSecureLockDeviceParams var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_SECURE_LOCK_DEVICE")
    public int disableSecureLockDevice(DisableSecureLockDeviceParams var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAuthenticationPolicyService {
        private final PermissionEnforcer mEnforcer;
        static final int TRANSACTION_enableSecureLockDevice = 1;
        static final int TRANSACTION_disableSecureLockDevice = 2;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, IAuthenticationPolicyService.DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentActivityThread().getSystemContext()));
        }

        public static IAuthenticationPolicyService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IAuthenticationPolicyService.DESCRIPTOR);
            if (iin != null && iin instanceof IAuthenticationPolicyService) {
                return (IAuthenticationPolicyService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "enableSecureLockDevice";
                }
                case 2: {
                    return "disableSecureLockDevice";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IAuthenticationPolicyService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    EnableSecureLockDeviceParams _arg0 = data.readTypedObject(EnableSecureLockDeviceParams.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.enableSecureLockDevice(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 2: {
                    DisableSecureLockDeviceParams _arg0 = data.readTypedObject(DisableSecureLockDeviceParams.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.disableSecureLockDevice(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void enableSecureLockDevice_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_SECURE_LOCK_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void disableSecureLockDevice_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_SECURE_LOCK_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IAuthenticationPolicyService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IAuthenticationPolicyService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int enableSecureLockDevice(EnableSecureLockDeviceParams params) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthenticationPolicyService.DESCRIPTOR);
                    _data.writeTypedObject(params, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int disableSecureLockDevice(DisableSecureLockDeviceParams params) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAuthenticationPolicyService.DESCRIPTOR);
                    _data.writeTypedObject(params, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IAuthenticationPolicyService {
        @Override
        public int enableSecureLockDevice(EnableSecureLockDeviceParams params) throws RemoteException {
            return 0;
        }

        @Override
        public int disableSecureLockDevice(DisableSecureLockDeviceParams params) throws RemoteException {
            return 0;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

