/*
 * Decompiled with CFR 0.152.
 */
package android.security.identity;

import android.annotation.NonNull;
import android.annotation.Nullable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class CredentialDataRequest {
    Map<String, Collection<String>> mDeviceSignedEntriesToRequest = new LinkedHashMap<String, Collection<String>>();
    Map<String, Collection<String>> mIssuerSignedEntriesToRequest = new LinkedHashMap<String, Collection<String>>();
    boolean mAllowUsingExhaustedKeys = true;
    boolean mAllowUsingExpiredKeys = false;
    boolean mIncrementUseCount = true;
    byte[] mRequestMessage = null;
    byte[] mReaderSignature = null;

    CredentialDataRequest() {
    }

    @NonNull
    public Map<String, Collection<String>> getDeviceSignedEntriesToRequest() {
        return this.mDeviceSignedEntriesToRequest;
    }

    @NonNull
    public Map<String, Collection<String>> getIssuerSignedEntriesToRequest() {
        return this.mIssuerSignedEntriesToRequest;
    }

    public boolean isAllowUsingExhaustedKeys() {
        return this.mAllowUsingExhaustedKeys;
    }

    public boolean isAllowUsingExpiredKeys() {
        return this.mAllowUsingExpiredKeys;
    }

    public boolean isIncrementUseCount() {
        return this.mIncrementUseCount;
    }

    @Nullable
    public byte[] getRequestMessage() {
        return this.mRequestMessage;
    }

    @Nullable
    public byte[] getReaderSignature() {
        return this.mReaderSignature;
    }

    public static class Builder {
        private CredentialDataRequest mData = new CredentialDataRequest();

        @NonNull
        public Builder setDeviceSignedEntriesToRequest(@NonNull Map<String, Collection<String>> entriesToRequest) {
            this.mData.mDeviceSignedEntriesToRequest = entriesToRequest;
            return this;
        }

        @NonNull
        public Builder setIssuerSignedEntriesToRequest(@NonNull Map<String, Collection<String>> entriesToRequest) {
            this.mData.mIssuerSignedEntriesToRequest = entriesToRequest;
            return this;
        }

        @NonNull
        public Builder setAllowUsingExhaustedKeys(boolean allowUsingExhaustedKeys) {
            this.mData.mAllowUsingExhaustedKeys = allowUsingExhaustedKeys;
            return this;
        }

        @NonNull
        public Builder setAllowUsingExpiredKeys(boolean allowUsingExpiredKeys) {
            this.mData.mAllowUsingExpiredKeys = allowUsingExpiredKeys;
            return this;
        }

        @NonNull
        public Builder setIncrementUseCount(boolean incrementUseCount) {
            this.mData.mIncrementUseCount = incrementUseCount;
            return this;
        }

        @NonNull
        public Builder setRequestMessage(@NonNull byte[] requestMessage) {
            this.mData.mRequestMessage = requestMessage;
            return this;
        }

        @NonNull
        public Builder setReaderSignature(@NonNull byte[] readerSignature) {
            this.mData.mReaderSignature = readerSignature;
            return this;
        }

        @NonNull
        public CredentialDataRequest build() {
            return this.mData;
        }
    }
}

