/*
 * Decompiled with CFR 0.152.
 */
package android.security.intrusiondetection;

import android.annotation.EnforcePermission;
import android.app.ActivityThread;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteException;
import android.security.intrusiondetection.IIntrusionDetectionServiceCommandCallback;
import android.security.intrusiondetection.IIntrusionDetectionServiceStateCallback;

public interface IIntrusionDetectionService
extends IInterface {
    public static final String DESCRIPTOR = "android.security.intrusiondetection.IIntrusionDetectionService";

    @EnforcePermission(value="android.permission.READ_INTRUSION_DETECTION_STATE")
    public void addStateCallback(IIntrusionDetectionServiceStateCallback var1) throws RemoteException;

    @EnforcePermission(value="android.permission.READ_INTRUSION_DETECTION_STATE")
    public void removeStateCallback(IIntrusionDetectionServiceStateCallback var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_INTRUSION_DETECTION_STATE")
    public void enable(IIntrusionDetectionServiceCommandCallback var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_INTRUSION_DETECTION_STATE")
    public void disable(IIntrusionDetectionServiceCommandCallback var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IIntrusionDetectionService {
        private final PermissionEnforcer mEnforcer;
        static final int TRANSACTION_addStateCallback = 1;
        static final int TRANSACTION_removeStateCallback = 2;
        static final int TRANSACTION_enable = 3;
        static final int TRANSACTION_disable = 4;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, IIntrusionDetectionService.DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentActivityThread().getSystemContext()));
        }

        public static IIntrusionDetectionService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IIntrusionDetectionService.DESCRIPTOR);
            if (iin != null && iin instanceof IIntrusionDetectionService) {
                return (IIntrusionDetectionService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "addStateCallback";
                }
                case 2: {
                    return "removeStateCallback";
                }
                case 3: {
                    return "enable";
                }
                case 4: {
                    return "disable";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IIntrusionDetectionService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IIntrusionDetectionServiceStateCallback _arg0 = IIntrusionDetectionServiceStateCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addStateCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    IIntrusionDetectionServiceStateCallback _arg0 = IIntrusionDetectionServiceStateCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeStateCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    IIntrusionDetectionServiceCommandCallback _arg0 = IIntrusionDetectionServiceCommandCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.enable(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    IIntrusionDetectionServiceCommandCallback _arg0 = IIntrusionDetectionServiceCommandCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.disable(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void addStateCallback_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.READ_INTRUSION_DETECTION_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void removeStateCallback_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.READ_INTRUSION_DETECTION_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void enable_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_INTRUSION_DETECTION_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void disable_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_INTRUSION_DETECTION_STATE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements IIntrusionDetectionService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IIntrusionDetectionService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addStateCallback(IIntrusionDetectionServiceStateCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IIntrusionDetectionService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeStateCallback(IIntrusionDetectionServiceStateCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IIntrusionDetectionService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enable(IIntrusionDetectionServiceCommandCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IIntrusionDetectionService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disable(IIntrusionDetectionServiceCommandCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IIntrusionDetectionService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IIntrusionDetectionService {
        @Override
        public void addStateCallback(IIntrusionDetectionServiceStateCallback callback) throws RemoteException {
        }

        @Override
        public void removeStateCallback(IIntrusionDetectionServiceStateCallback callback) throws RemoteException {
        }

        @Override
        public void enable(IIntrusionDetectionServiceCommandCallback callback) throws RemoteException {
        }

        @Override
        public void disable(IIntrusionDetectionServiceCommandCallback callback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

