/*
 * Decompiled with CFR 0.152.
 */
package android.security.intrusiondetection;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IIntrusionDetectionServiceCommandCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.security.intrusiondetection.IIntrusionDetectionServiceCommandCallback";

    public void onSuccess() throws RemoteException;

    public void onFailure(int var1) throws RemoteException;

    public static @interface ErrorCode {
        public static final int UNKNOWN = 0;
        public static final int PERMISSION_DENIED = 1;
        public static final int INVALID_STATE_TRANSITION = 2;
        public static final int TRANSPORT_UNAVAILABLE = 3;
        public static final int DATA_SOURCE_UNAVAILABLE = 4;
    }

    public static abstract class Stub
    extends Binder
    implements IIntrusionDetectionServiceCommandCallback {
        static final int TRANSACTION_onSuccess = 1;
        static final int TRANSACTION_onFailure = 2;

        public Stub() {
            this.attachInterface(this, IIntrusionDetectionServiceCommandCallback.DESCRIPTOR);
        }

        public static IIntrusionDetectionServiceCommandCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IIntrusionDetectionServiceCommandCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IIntrusionDetectionServiceCommandCallback) {
                return (IIntrusionDetectionServiceCommandCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onSuccess";
                }
                case 2: {
                    return "onFailure";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IIntrusionDetectionServiceCommandCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    this.onSuccess();
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onFailure(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IIntrusionDetectionServiceCommandCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IIntrusionDetectionServiceCommandCallback.DESCRIPTOR;
            }

            @Override
            public void onSuccess() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IIntrusionDetectionServiceCommandCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(int error) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IIntrusionDetectionServiceCommandCallback.DESCRIPTOR);
                    _data.writeInt(error);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IIntrusionDetectionServiceCommandCallback {
        @Override
        public void onSuccess() throws RemoteException {
        }

        @Override
        public void onFailure(int error) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

