/*
 * Decompiled with CFR 0.152.
 */
package android.service.wallpaper;

import android.animation.AnimationHandler;
import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.app.Service;
import android.app.WallpaperColors;
import android.app.WallpaperInfo;
import android.app.WallpaperManager;
import android.app.compat.CompatChanges;
import android.app.wallpaper.WallpaperDescription;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.BLASTBufferQueue;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.HardwareBuffer;
import android.hardware.display.DisplayManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.service.wallpaper.EngineWindowPage;
import android.service.wallpaper.IWallpaperConnection;
import android.service.wallpaper.IWallpaperEngine;
import android.service.wallpaper.IWallpaperService;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.MergedConfiguration;
import android.util.Slog;
import android.view.Display;
import android.view.DisplayCutout;
import android.view.IWindowSession;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.MotionEvent;
import android.view.PixelCopy;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.SurfaceHolder;
import android.view.WindowInsets;
import android.view.WindowLayout;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import android.view.WindowRelayoutResult;
import android.window.ActivityWindowInfo;
import android.window.ClientWindowFrames;
import android.window.ScreenCapture;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags;
import com.android.internal.os.HandlerCaller;
import com.android.internal.view.BaseIWindow;
import com.android.internal.view.BaseSurfaceHolder;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public abstract class WallpaperService
extends Service {
    public static final String SERVICE_INTERFACE = "android.service.wallpaper.WallpaperService";
    public static final String SERVICE_META_DATA = "android.service.wallpaper";
    static final String TAG = "WallpaperService";
    static final boolean DEBUG = false;
    static final float MIN_PAGE_ALLOWED_MARGIN = 0.05f;
    private static final int MIN_BITMAP_SCREENSHOT_WIDTH = 64;
    private static final long DEFAULT_UPDATE_SCREENSHOT_DURATION = 60000L;
    @NonNull
    private static final RectF LOCAL_COLOR_BOUNDS = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
    private static final int DO_ATTACH = 10;
    private static final int DO_DETACH = 20;
    private static final int DO_SET_DESIRED_SIZE = 30;
    private static final int DO_SET_DISPLAY_PADDING = 40;
    private static final int DO_IN_AMBIENT_MODE = 50;
    private static final int MSG_UPDATE_SURFACE = 10000;
    private static final int MSG_VISIBILITY_CHANGED = 10010;
    private static final int MSG_WALLPAPER_OFFSETS = 10020;
    private static final int MSG_WALLPAPER_COMMAND = 10025;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private static final int MSG_WINDOW_RESIZED = 10030;
    private static final int MSG_WINDOW_MOVED = 10035;
    private static final int MSG_TOUCH_EVENT = 10040;
    private static final int MSG_REQUEST_WALLPAPER_COLORS = 10050;
    private static final int MSG_ZOOM = 10100;
    private static final int MSG_RESIZE_PREVIEW = 10110;
    private static final int MSG_REPORT_SHOWN = 10150;
    private static final int MSG_UPDATE_SCREEN_TURNING_ON = 10170;
    private static final int MSG_UPDATE_DIMMING = 10200;
    private static final int MSG_WALLPAPER_FLAGS_CHANGED = 10210;
    private static final int NOTIFY_COLORS_RATE_LIMIT_MS = 1000;
    private static final int PROCESS_LOCAL_COLORS_INTERVAL_MS = 2000;
    private static final boolean ENABLE_WALLPAPER_DIMMING = SystemProperties.getBoolean("persist.debug.enable_wallpaper_dimming", true);
    private static final long DIMMING_ANIMATION_DURATION_MS = 300L;
    @GuardedBy(value={"itself"})
    private final ArrayMap<IBinder, IWallpaperEngineWrapper> mActiveEngines = new ArrayMap();
    private Handler mBackgroundHandler;
    private HandlerThread mBackgroundThread;
    private boolean mIsWearOs;
    private static final long DISABLE_DRAW_WAKE_LOCK_WALLPAPER = 361433696L;
    public static final long WEAROS_WALLPAPER_HANDLES_SCALING = 272527315L;

    @NonNull
    public Looper onProvideEngineLooper() {
        return super.getMainLooper();
    }

    private boolean isValid(RectF area) {
        if (area == null) {
            return false;
        }
        boolean valid = area.bottom > area.top && area.left < area.right && LOCAL_COLOR_BOUNDS.contains(area);
        return valid;
    }

    private boolean inRectFRange(float number) {
        return number >= 0.0f && number <= 1.0f;
    }

    @Override
    public void onCreate() {
        Trace.beginSection("WPMS.onCreate");
        this.mBackgroundThread = new HandlerThread("DefaultWallpaperLocalColorExtractor");
        this.mBackgroundThread.start();
        this.mBackgroundHandler = new Handler(this.mBackgroundThread.getLooper());
        this.mIsWearOs = this.getPackageManager().hasSystemFeature("android.hardware.type.watch");
        super.onCreate();
        Trace.endSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDestroy() {
        Trace.beginSection("WPMS.onDestroy");
        super.onDestroy();
        ArrayMap<IBinder, IWallpaperEngineWrapper> arrayMap = this.mActiveEngines;
        synchronized (arrayMap) {
            for (IWallpaperEngineWrapper engineWrapper : this.mActiveEngines.values()) {
                engineWrapper.destroy();
            }
            this.mActiveEngines.clear();
        }
        if (this.mBackgroundThread != null) {
            this.mBackgroundThread.quitSafely();
        }
        Trace.endSection();
    }

    @Override
    public IBinder onBind(Intent intent) {
        return new IWallpaperServiceWrapper(this);
    }

    public abstract Engine onCreateEngine();

    @FlaggedApi(value="android.app.live_wallpaper_content_handling")
    @Nullable
    public Engine onCreateEngine(@NonNull WallpaperDescription description) {
        return this.onCreateEngine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter out, String[] args) {
        out.print("State of wallpaper ");
        out.print(this);
        out.println(":");
        ArrayMap<IBinder, IWallpaperEngineWrapper> arrayMap = this.mActiveEngines;
        synchronized (arrayMap) {
            for (IWallpaperEngineWrapper engineWrapper : this.mActiveEngines.values()) {
                Engine engine = engineWrapper.mEngine;
                if (engine == null) {
                    Slog.w(TAG, "Engine for wrapper " + engineWrapper + " not attached");
                    continue;
                }
                out.print("  Engine ");
                out.print(engine);
                out.println(":");
                engine.dump("    ", fd, out, args);
            }
        }
    }

    class IWallpaperEngineWrapper
    extends IWallpaperEngine.Stub
    implements HandlerCaller.Callback {
        private final HandlerCaller mCaller;
        final IWallpaperConnection mConnection;
        final IBinder mWindowToken;
        final int mWindowType;
        final boolean mIsPreview;
        final AtomicInteger mPendingResizeCount = new AtomicInteger();
        boolean mReportDraw;
        boolean mShownReported;
        int mReqWidth;
        int mReqHeight;
        final Rect mDisplayPadding = new Rect();
        final int mDisplayId;
        final DisplayManager mDisplayManager;
        final Display mDisplay;
        final WallpaperManager mWallpaperManager;
        @Nullable
        final WallpaperInfo mInfo;
        @NonNull
        final WallpaperDescription mDescription;
        Engine mEngine;
        int mWhich;

        IWallpaperEngineWrapper(WallpaperService service, IWallpaperConnection conn, IBinder windowToken, int windowType, boolean isPreview, int reqWidth, int reqHeight, Rect padding, int displayId, @Nullable int which, @NonNull WallpaperInfo info, WallpaperDescription description) {
            this.mWallpaperManager = WallpaperService.this.getSystemService(WallpaperManager.class);
            this.mCaller = new HandlerCaller(service, service.onProvideEngineLooper(), this, true);
            this.mConnection = conn;
            this.mWindowToken = windowToken;
            this.mWindowType = windowType;
            this.mIsPreview = isPreview;
            this.mReqWidth = reqWidth;
            this.mReqHeight = reqHeight;
            this.mDisplayPadding.set(padding);
            this.mDisplayId = displayId;
            this.mWhich = which;
            this.mInfo = info;
            this.mDescription = description;
            this.mDisplayManager = WallpaperService.this.getSystemService(DisplayManager.class);
            this.mDisplay = this.mDisplayManager.getDisplay(this.mDisplayId);
            if (this.mDisplay == null) {
                throw new IllegalArgumentException("Cannot find display with id" + this.mDisplayId);
            }
            Message msg = this.mCaller.obtainMessage(10);
            this.mCaller.sendMessage(msg);
        }

        @Override
        public void setDesiredSize(int width, int height) {
            Message msg = this.mCaller.obtainMessageII(30, width, height);
            this.mCaller.sendMessage(msg);
        }

        @Override
        public void setDisplayPadding(Rect padding) {
            Message msg = this.mCaller.obtainMessageO(40, padding);
            this.mCaller.sendMessage(msg);
        }

        @Override
        public void setVisibility(boolean visible) {
            Message msg = this.mCaller.obtainMessageI(10010, visible ? 1 : 0);
            this.mCaller.sendMessage(msg);
        }

        @Override
        public void setWallpaperFlags(int which) {
            if (which == this.mWhich) {
                return;
            }
            this.mWhich = which;
            Message msg = this.mCaller.obtainMessageI(10210, which);
            this.mCaller.sendMessage(msg);
        }

        @Override
        public void setInAmbientMode(boolean inAmbientDisplay, long animationDuration) throws RemoteException {
            Message msg = this.mCaller.obtainMessageIO(50, inAmbientDisplay ? 1 : 0, animationDuration);
            this.mCaller.sendMessage(msg);
        }

        @Override
        public void dispatchPointer(MotionEvent event) {
            if (this.mEngine != null) {
                this.mEngine.dispatchPointer(event);
            } else {
                event.recycle();
            }
        }

        @Override
        public void dispatchWallpaperCommand(String action, int x, int y, int z, Bundle extras) {
            if (this.mEngine != null) {
                this.mEngine.mWindow.dispatchWallpaperCommand(action, x, y, z, extras, false);
            }
        }

        @Override
        public void setZoomOut(float scale) {
            Message msg = this.mCaller.obtainMessageI(10100, Float.floatToIntBits(scale));
            this.mCaller.sendMessage(msg);
        }

        public void reportShown() {
            if (this.mEngine == null) {
                Log.i(WallpaperService.TAG, "Can't report null engine as shown.");
                return;
            }
            if (this.mEngine.mDestroyed) {
                Log.i(WallpaperService.TAG, "Engine was destroyed before we could draw.");
                return;
            }
            if (!this.mShownReported) {
                this.mShownReported = true;
                Trace.beginSection("WPMS.mConnection.engineShown");
                try {
                    this.mConnection.engineShown(this);
                    Log.d(WallpaperService.TAG, "Wallpaper has updated the surface:" + this.mInfo);
                }
                catch (RemoteException e) {
                    Log.w(WallpaperService.TAG, "Wallpaper host disappeared", e);
                }
                Trace.endSection();
            }
        }

        @Override
        public void requestWallpaperColors() {
            Message msg = this.mCaller.obtainMessage(10050);
            this.mCaller.sendMessage(msg);
        }

        @Override
        public void addLocalColorsAreas(List<RectF> regions) {
            this.mEngine.addLocalColorsAreas(regions);
        }

        @Override
        public void removeLocalColorsAreas(List<RectF> regions) {
            this.mEngine.removeLocalColorsAreas(regions);
        }

        @Override
        public void applyDimming(float dimAmount) throws RemoteException {
            Message msg = this.mCaller.obtainMessageI(10200, Float.floatToIntBits(dimAmount));
            this.mCaller.sendMessage(msg);
        }

        @Override
        public void destroy() {
            Message msg = this.mCaller.obtainMessage(20);
            this.mCaller.getHandler().removeCallbacksAndMessages(null);
            this.mCaller.sendMessage(msg);
        }

        @Override
        public void resizePreview(Rect position) {
            Message msg = this.mCaller.obtainMessageO(10110, position);
            this.mCaller.sendMessage(msg);
        }

        @Override
        @Nullable
        public SurfaceControl mirrorSurfaceControl() {
            return this.mEngine == null ? null : SurfaceControl.mirrorSurface(this.mEngine.mSurfaceControl);
        }

        @Override
        @Nullable
        public WallpaperDescription onApplyWallpaper(int which) {
            return this.mEngine != null ? this.mEngine.onApplyWallpaper(which) : null;
        }

        private void doAttachEngine() {
            Trace.beginSection("WPMS.onCreateEngine");
            Engine engine = android.app.Flags.liveWallpaperContentHandling() ? WallpaperService.this.onCreateEngine(this.mDescription) : WallpaperService.this.onCreateEngine();
            Trace.endSection();
            this.mEngine = engine;
            Trace.beginSection("WPMS.mConnection.attachEngine-" + this.mDisplayId);
            try {
                this.mConnection.attachEngine(this, this.mDisplayId);
            }
            catch (RemoteException e) {
                engine.detach();
                Log.w(WallpaperService.TAG, "Wallpaper host disappeared", e);
                return;
            }
            catch (IllegalStateException e) {
                Log.w(WallpaperService.TAG, "Connector instance already destroyed, can't attach engine to non existing connector", e);
                return;
            }
            finally {
                Trace.endSection();
            }
            Trace.beginSection("WPMS.engine.attach");
            engine.attach(this);
            Trace.endSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doDetachEngine() {
            if (this.mEngine != null && !this.mEngine.mDestroyed) {
                this.mEngine.detach();
                ArrayMap<IBinder, IWallpaperEngineWrapper> arrayMap = WallpaperService.this.mActiveEngines;
                synchronized (arrayMap) {
                    for (IWallpaperEngineWrapper engineWrapper : WallpaperService.this.mActiveEngines.values()) {
                        if (engineWrapper.mEngine == null || !engineWrapper.mEngine.mVisible) continue;
                        engineWrapper.mEngine.doVisibilityChanged(false);
                        engineWrapper.mEngine.doVisibilityChanged(true);
                    }
                }
            }
        }

        public void updateScreenTurningOn(boolean isScreenTurningOn) {
            Message msg = this.mCaller.obtainMessageBO(10170, isScreenTurningOn, null);
            this.mCaller.sendMessage(msg);
        }

        @Override
        public void onScreenTurningOn() throws RemoteException {
            this.updateScreenTurningOn(true);
        }

        @Override
        public void onScreenTurnedOn() throws RemoteException {
            this.updateScreenTurningOn(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void executeMessage(Message message) {
            switch (message.what) {
                case 10: {
                    Trace.beginSection("WPMS.DO_ATTACH");
                    this.doAttachEngine();
                    Trace.endSection();
                    return;
                }
                case 20: {
                    Trace.beginSection("WPMS.DO_DETACH");
                    this.doDetachEngine();
                    Trace.endSection();
                    return;
                }
                case 30: {
                    this.mEngine.doDesiredSizeChanged(message.arg1, message.arg2);
                    return;
                }
                case 40: {
                    this.mEngine.doDisplayPaddingChanged((Rect)message.obj);
                    return;
                }
                case 50: {
                    this.mEngine.doAmbientModeChanged(message.arg1 != 0, (Long)message.obj);
                    return;
                }
                case 10000: {
                    this.mEngine.updateSurface(true, false, false);
                    break;
                }
                case 10100: {
                    this.mEngine.setZoom(Float.intBitsToFloat(message.arg1));
                    break;
                }
                case 10200: {
                    this.mEngine.updateWallpaperDimming(Float.intBitsToFloat(message.arg1));
                    break;
                }
                case 10110: {
                    this.mEngine.resizePreview((Rect)message.obj);
                    break;
                }
                case 10010: {
                    this.mEngine.doVisibilityChanged(message.arg1 != 0);
                    break;
                }
                case 10170: {
                    this.mEngine.onScreenTurningOnChanged(message.arg1 != 0);
                    break;
                }
                case 10020: {
                    this.mEngine.doOffsetsChanged(true);
                    break;
                }
                case 10025: {
                    WallpaperCommand cmd = (WallpaperCommand)message.obj;
                    this.mEngine.doCommand(cmd);
                    break;
                }
                case 10030: {
                    this.handleResized((MergedConfiguration)message.obj, message.arg1 != 0);
                    break;
                }
                case 10035: {
                    break;
                }
                case 10040: {
                    boolean skip = false;
                    MotionEvent ev = (MotionEvent)message.obj;
                    if (ev.getAction() == 2) {
                        Object object = this.mEngine.mLock;
                        synchronized (object) {
                            if (this.mEngine.mPendingMove == ev) {
                                this.mEngine.mPendingMove = null;
                            } else {
                                skip = true;
                            }
                        }
                    }
                    if (!skip) {
                        this.mEngine.onTouchEvent(ev);
                    }
                    ev.recycle();
                    break;
                }
                case 10050: {
                    if (this.mConnection == null) break;
                    try {
                        WallpaperColors colors = this.mEngine.onComputeColors();
                        this.mEngine.setPrimaryWallpaperColors(colors);
                        this.mConnection.onWallpaperColorsChanged(colors, this.mDisplayId);
                    }
                    catch (RemoteException remoteException) {}
                    break;
                }
                case 10150: {
                    Trace.beginSection("WPMS.MSG_REPORT_SHOWN");
                    this.reportShown();
                    Trace.endSection();
                    break;
                }
                case 10210: {
                    this.mEngine.onWallpaperFlagsChanged(message.arg1);
                    break;
                }
                default: {
                    Log.w(WallpaperService.TAG, "Unknown message type " + message.what);
                }
            }
        }

        private void handleResized(MergedConfiguration config, boolean reportDraw) {
            int pendingCount;
            int n = pendingCount = config != null ? this.mPendingResizeCount.decrementAndGet() : -1;
            if (reportDraw) {
                this.mReportDraw = true;
            }
            if (pendingCount > 0) {
                return;
            }
            if (config != null) {
                this.mEngine.mMergedConfiguration.setTo(config);
            }
            this.mEngine.updateSurface(true, false, this.mReportDraw);
            this.mReportDraw = false;
            this.mEngine.doOffsetsChanged(true);
            this.mEngine.scaleAndCropScreenshot();
        }
    }

    class IWallpaperServiceWrapper
    extends IWallpaperService.Stub {
        private final WallpaperService mTarget;

        public IWallpaperServiceWrapper(WallpaperService context) {
            this.mTarget = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void attach(IWallpaperConnection conn, IBinder windowToken, int windowType, boolean isPreview, int reqWidth, int reqHeight, Rect padding, int displayId, int which, WallpaperInfo info, @NonNull WallpaperDescription description) {
            Trace.beginSection("WPMS.ServiceWrapper.attach");
            IWallpaperEngineWrapper engineWrapper = new IWallpaperEngineWrapper(this.mTarget, conn, windowToken, windowType, isPreview, reqWidth, reqHeight, padding, displayId, which, info, description);
            ArrayMap<IBinder, IWallpaperEngineWrapper> arrayMap = WallpaperService.this.mActiveEngines;
            synchronized (arrayMap) {
                WallpaperService.this.mActiveEngines.put(windowToken, engineWrapper);
            }
            Trace.endSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void detach(IBinder windowToken) {
            IWallpaperEngineWrapper engineWrapper;
            ArrayMap<IBinder, IWallpaperEngineWrapper> arrayMap = WallpaperService.this.mActiveEngines;
            synchronized (arrayMap) {
                engineWrapper = WallpaperService.this.mActiveEngines.remove(windowToken);
            }
            if (engineWrapper == null) {
                Log.w(WallpaperService.TAG, "Engine for window token " + windowToken + " already detached");
                return;
            }
            engineWrapper.destroy();
        }
    }

    public class Engine {
        IWallpaperEngineWrapper mIWallpaperEngine;
        HandlerCaller mCaller;
        IWallpaperConnection mConnection;
        IBinder mWindowToken;
        boolean mInitializing = true;
        boolean mVisible;
        private boolean mIsScreenTurningOn;
        boolean mReportedVisible;
        boolean mReportedSurfaceCreated;
        boolean mDestroyed;
        private boolean mFrozenRequested = false;
        boolean mCreated;
        boolean mSurfaceCreated;
        boolean mIsCreating;
        boolean mDrawingAllowed;
        boolean mOffsetsChanged;
        boolean mFixedSizeAllowed;
        boolean mShouldDimByDefault;
        int mWidth;
        int mHeight;
        int mFormat;
        int mType;
        int mCurWidth;
        int mCurHeight;
        float mZoom = 0.0f;
        int mWindowFlags = 16;
        int mWindowPrivateFlags = 4;
        int mCurWindowFlags = this.mWindowFlags;
        int mCurWindowPrivateFlags = this.mWindowPrivateFlags;
        Rect mPreviewSurfacePosition;
        final ClientWindowFrames mWinFrames = new ClientWindowFrames();
        final Rect mDispatchedContentInsets = new Rect();
        final Rect mDispatchedStableInsets = new Rect();
        DisplayCutout mDispatchedDisplayCutout = DisplayCutout.NO_CUTOUT;
        final InsetsState mInsetsState = new InsetsState();
        final InsetsSourceControl.Array mTempControls = new InsetsSourceControl.Array();
        final MergedConfiguration mMergedConfiguration = new MergedConfiguration();
        SurfaceControl mSurfaceControl = new SurfaceControl();
        WindowRelayoutResult mRelayoutResult = new WindowRelayoutResult(this.mWinFrames, this.mMergedConfiguration, this.mSurfaceControl, this.mInsetsState, this.mTempControls);
        private final Point mSurfaceSize = new Point();
        private final Point mLastSurfaceSize = new Point();
        private final Matrix mTmpMatrix = new Matrix();
        private final float[] mTmpValues = new float[9];
        final WindowManager.LayoutParams mLayout = new WindowManager.LayoutParams();
        IWindowSession mSession;
        final Object mLock = new Object();
        private final Object mSurfaceReleaseLock = new Object();
        boolean mOffsetMessageEnqueued;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
        @GuardedBy(value={"mLock"})
        private float mPendingXOffset;
        @GuardedBy(value={"mLock"})
        private float mPendingYOffset;
        @GuardedBy(value={"mLock"})
        private float mPendingXOffsetStep;
        @GuardedBy(value={"mLock"})
        private float mPendingYOffsetStep;
        @GuardedBy(value={"mLock"})
        private final ArraySet<RectF> mLocalColorAreas = new ArraySet(4);
        @GuardedBy(value={"mLock"})
        private final ArraySet<RectF> mLocalColorsToAdd = new ArraySet(4);
        private long mLastProcessLocalColorsTimestamp;
        private AtomicBoolean mProcessLocalColorsPending = new AtomicBoolean(false);
        private int mPixelCopyCount = 0;
        @GuardedBy(value={"mLock"})
        private EngineWindowPage[] mWindowPages = new EngineWindowPage[0];
        private Bitmap mLastScreenshot;
        private boolean mResetWindowPages;
        boolean mPendingSync;
        MotionEvent mPendingMove;
        boolean mIsInAmbientMode;
        private long mLastColorInvalidation;
        private final Runnable mNotifyColorsChanged = this::notifyColorsChanged;
        private final Supplier<Long> mClockFunction;
        private final Handler mHandler;
        private Display mDisplay;
        private Context mDisplayContext;
        private int mDisplayState;
        private float mCustomDimAmount = 0.0f;
        private float mWallpaperDimAmount;
        private float mPreviousWallpaperDimAmount = this.mWallpaperDimAmount = 0.0f;
        private float mDefaultDimAmount = 0.05f;
        SurfaceControl mBbqSurfaceControl;
        BLASTBufferQueue mBlastBufferQueue;
        IBinder mBbqApplyToken = new Binder();
        private SurfaceControl mScreenshotSurfaceControl;
        private Point mScreenshotSize = new Point();
        private final boolean mDisableDrawWakeLock;
        final BaseSurfaceHolder mSurfaceHolder = new BaseSurfaceHolder(){
            {
                this.mRequestedFormat = 2;
            }

            @Override
            public boolean onAllowLockCanvas() {
                return Engine.this.mDrawingAllowed;
            }

            @Override
            public void onRelayoutContainer() {
                Message msg = Engine.this.mCaller.obtainMessage(10000);
                Engine.this.mCaller.sendMessage(msg);
            }

            @Override
            public void onUpdateSurface() {
                Message msg = Engine.this.mCaller.obtainMessage(10000);
                Engine.this.mCaller.sendMessage(msg);
            }

            @Override
            public boolean isCreating() {
                return Engine.this.mIsCreating;
            }

            @Override
            public void setFixedSize(int width, int height) {
                if (!Engine.this.mFixedSizeAllowed && !Engine.this.mIWallpaperEngine.mIsPreview) {
                    throw new UnsupportedOperationException("Wallpapers currently only support sizing from layout");
                }
                super.setFixedSize(width, height);
            }

            @Override
            public void setKeepScreenOn(boolean screenOn) {
                throw new UnsupportedOperationException("Wallpapers do not support keep screen on");
            }

            private void prepareToDraw() {
                if (Engine.this.mDisableDrawWakeLock) {
                    return;
                }
                if (Engine.this.mDisplayState == 3) {
                    try {
                        Engine.this.mSession.pokeDrawLock(Engine.this.mWindow);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }

            @Override
            public Canvas lockCanvas() {
                this.prepareToDraw();
                return super.lockCanvas();
            }

            @Override
            public Canvas lockCanvas(Rect dirty) {
                this.prepareToDraw();
                return super.lockCanvas(dirty);
            }

            @Override
            public Canvas lockHardwareCanvas() {
                this.prepareToDraw();
                return super.lockHardwareCanvas();
            }
        };
        WallpaperInputEventReceiver mInputEventReceiver;
        final BaseIWindow mWindow = new BaseIWindow(){

            @Override
            public void resized(ClientWindowFrames frames, boolean reportDraw, MergedConfiguration mergedConfiguration, InsetsState insetsState, boolean forceLayout, boolean alwaysConsumeSystemBars, int displayId, int syncSeqId, boolean dragResizing, @Nullable ActivityWindowInfo activityWindowInfo) {
                Message msg = Engine.this.mCaller.obtainMessageIO(10030, reportDraw ? 1 : 0, mergedConfiguration);
                Engine.this.mIWallpaperEngine.mPendingResizeCount.incrementAndGet();
                Engine.this.mCaller.sendMessage(msg);
            }

            @Override
            public void moved(int newX, int newY) {
                Message msg = Engine.this.mCaller.obtainMessageII(10035, newX, newY);
                Engine.this.mCaller.sendMessage(msg);
            }

            @Override
            public void dispatchAppVisibility(boolean visible) {
                if (!Engine.this.mIWallpaperEngine.mIsPreview) {
                    Message msg = Engine.this.mCaller.obtainMessageI(10010, visible ? 1 : 0);
                    Engine.this.mCaller.sendMessage(msg);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchWallpaperOffsets(float x, float y, float xStep, float yStep, float zoom, boolean sync) {
                Object object = Engine.this.mLock;
                synchronized (object) {
                    Message msg;
                    Engine.this.mPendingXOffset = x;
                    Engine.this.mPendingYOffset = y;
                    Engine.this.mPendingXOffsetStep = xStep;
                    Engine.this.mPendingYOffsetStep = yStep;
                    if (sync) {
                        Engine.this.mPendingSync = true;
                    }
                    if (!Engine.this.mOffsetMessageEnqueued) {
                        Engine.this.mOffsetMessageEnqueued = true;
                        msg = Engine.this.mCaller.obtainMessage(10020);
                        Engine.this.mCaller.sendMessage(msg);
                    }
                    msg = Engine.this.mCaller.obtainMessageI(10100, Float.floatToIntBits(zoom));
                    Engine.this.mCaller.sendMessage(msg);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchWallpaperCommand(String action, int x, int y, int z, Bundle extras, boolean sync) {
                Object object = Engine.this.mLock;
                synchronized (object) {
                    WallpaperCommand cmd = new WallpaperCommand();
                    cmd.action = action;
                    cmd.x = x;
                    cmd.y = y;
                    cmd.z = z;
                    cmd.extras = extras;
                    cmd.sync = sync;
                    Message msg = Engine.this.mCaller.obtainMessage(10025);
                    msg.obj = cmd;
                    Engine.this.mCaller.sendMessage(msg);
                }
            }
        };
        private final DisplayManager.DisplayListener mDisplayListener = new DisplayManager.DisplayListener(){

            @Override
            public void onDisplayChanged(int displayId) {
                if (Engine.this.mDisplay.getDisplayId() == displayId) {
                    boolean forceReport = !Flags.noVisibilityEventOnDisplayStateChange() && WallpaperService.this.mIsWearOs && Engine.this.mDisplay.getState() != 4;
                    Engine.this.reportVisibility(forceReport);
                }
            }

            @Override
            public void onDisplayRemoved(int displayId) {
            }

            @Override
            public void onDisplayAdded(int displayId) {
            }
        };

        public Engine() {
            this(SystemClock::elapsedRealtime, Handler.getMain());
        }

        @VisibleForTesting
        public Engine(Supplier<Long> clockFunction, Handler handler) {
            this.mClockFunction = clockFunction;
            this.mHandler = handler;
            this.mDisableDrawWakeLock = CompatChanges.isChangeEnabled(361433696L) && android.view.flags.Flags.disableDrawWakeLock();
        }

        public SurfaceHolder getSurfaceHolder() {
            return this.mSurfaceHolder;
        }

        public int getWallpaperFlags() {
            return this.mIWallpaperEngine.mWhich;
        }

        public int getDesiredMinimumWidth() {
            return this.mIWallpaperEngine.mReqWidth;
        }

        public int getDesiredMinimumHeight() {
            return this.mIWallpaperEngine.mReqHeight;
        }

        public boolean isVisible() {
            return this.mReportedVisible;
        }

        public boolean supportsLocalColorExtraction() {
            return false;
        }

        public boolean isPreview() {
            return this.mIWallpaperEngine.mIsPreview;
        }

        @SystemApi
        public boolean isInAmbientMode() {
            return this.mIsInAmbientMode;
        }

        public boolean shouldZoomOutWallpaper() {
            return WallpaperService.this.mIsWearOs && !CompatChanges.isChangeEnabled(272527315L);
        }

        public boolean shouldWaitForEngineShown() {
            return false;
        }

        public void reportEngineShown(boolean waitForEngineShown) {
            if (this.mIWallpaperEngine.mShownReported) {
                return;
            }
            Trace.beginSection("WPMS.reportEngineShown-" + waitForEngineShown);
            Log.d(WallpaperService.TAG, "reportEngineShown: shouldWait=" + waitForEngineShown);
            if (!waitForEngineShown) {
                Message message = this.mCaller.obtainMessage(10150);
                this.mCaller.removeMessages(10150);
                this.mCaller.sendMessage(message);
            } else if (!this.mCaller.hasMessages(10150)) {
                Message message = this.mCaller.obtainMessage(10150);
                this.mCaller.sendMessageDelayed(message, TimeUnit.SECONDS.toMillis(5L));
            }
            Trace.endSection();
        }

        public void setTouchEventsEnabled(boolean enabled) {
            int n = this.mWindowFlags = enabled ? this.mWindowFlags & 0xFFFFFFEF : this.mWindowFlags | 0x10;
            if (this.mCreated) {
                this.updateSurface(false, false, false);
            }
        }

        public void setOffsetNotificationsEnabled(boolean enabled) {
            int n = this.mWindowPrivateFlags = enabled ? this.mWindowPrivateFlags | 4 : this.mWindowPrivateFlags & 0xFFFFFFFB;
            if (this.mCreated) {
                this.updateSurface(false, false, false);
            }
        }

        public void setShowForAllUsers(boolean show) {
            int n = this.mWindowPrivateFlags = show ? this.mWindowPrivateFlags | 0x10 : this.mWindowPrivateFlags & 0xFFFFFFEF;
            if (this.mCreated) {
                this.updateSurface(false, false, false);
            }
        }

        @UnsupportedAppUsage
        public void setFixedSizeAllowed(boolean allowed) {
            this.mFixedSizeAllowed = allowed;
        }

        @VisibleForTesting
        public float getZoom() {
            return this.mZoom;
        }

        public void onCreate(SurfaceHolder surfaceHolder) {
        }

        public void onDestroy() {
        }

        public void onVisibilityChanged(boolean visible) {
        }

        public void onApplyWindowInsets(WindowInsets insets) {
        }

        public void onTouchEvent(MotionEvent event) {
        }

        public void onOffsetsChanged(float xOffset, float yOffset, float xOffsetStep, float yOffsetStep, int xPixelOffset, int yPixelOffset) {
        }

        public Bundle onCommand(String action, int x, int y, int z, Bundle extras, boolean resultRequested) {
            return null;
        }

        @SystemApi
        public void onAmbientModeChanged(boolean inAmbientMode, long animationDuration) {
        }

        @FlaggedApi(value="com.android.window.flags.offload_color_extraction")
        public void onDimAmountChanged(float dimAmount) {
        }

        public void onDesiredSizeChanged(int desiredWidth, int desiredHeight) {
        }

        public void onSurfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        }

        public void onSurfaceRedrawNeeded(SurfaceHolder holder) {
        }

        public void onSurfaceCreated(SurfaceHolder holder) {
        }

        public void onSurfaceDestroyed(SurfaceHolder holder) {
        }

        public void onWallpaperFlagsChanged(int which) {
        }

        public void onZoomChanged(float zoom) {
        }

        @Nullable
        @FlaggedApi(value="android.app.live_wallpaper_content_handling")
        public WallpaperDescription onApplyWallpaper(int which) {
            return null;
        }

        public void notifyColorsChanged() {
            if (this.mDestroyed) {
                Log.i(WallpaperService.TAG, "Ignoring notifyColorsChanged(), Engine has already been destroyed.");
                return;
            }
            long now = this.mClockFunction.get();
            if (now - this.mLastColorInvalidation < 1000L) {
                Log.w(WallpaperService.TAG, "This call has been deferred. You should only call notifyColorsChanged() once every 1.0 seconds.");
                if (!this.mHandler.hasCallbacks(this.mNotifyColorsChanged)) {
                    this.mHandler.postDelayed(this.mNotifyColorsChanged, 1000L);
                }
                return;
            }
            this.mLastColorInvalidation = now;
            this.mHandler.removeCallbacks(this.mNotifyColorsChanged);
            try {
                WallpaperColors newColors = this.onComputeColors();
                if (this.mConnection != null) {
                    this.mConnection.onWallpaperColorsChanged(newColors, this.mDisplay.getDisplayId());
                } else {
                    Log.w(WallpaperService.TAG, "Can't notify system because wallpaper connection was not established.");
                }
                this.mResetWindowPages = true;
                this.processLocalColors();
            }
            catch (RemoteException e) {
                Log.w(WallpaperService.TAG, "Can't notify system because wallpaper connection was lost.", e);
            }
        }

        @Nullable
        public WallpaperColors onComputeColors() {
            return null;
        }

        public void notifyLocalColorsChanged(@NonNull List<RectF> regions, @NonNull List<WallpaperColors> colors) throws RuntimeException {
            for (int i = 0; i < regions.size() && i < colors.size(); ++i) {
                WallpaperColors color2 = colors.get(i);
                RectF area = regions.get(i);
                if (color2 == null || area == null) continue;
                try {
                    this.mConnection.onLocalWallpaperColorsChanged(area, color2, this.mDisplayContext.getDisplayId());
                    continue;
                }
                catch (RemoteException e) {
                    throw new RuntimeException(e);
                }
            }
            WallpaperColors primaryColors = this.mIWallpaperEngine.mWallpaperManager.getWallpaperColors(1);
            this.setPrimaryWallpaperColors(primaryColors);
        }

        private void setPrimaryWallpaperColors(WallpaperColors colors) {
            if (colors == null) {
                return;
            }
            int colorHints = colors.getColorHints();
            this.mShouldDimByDefault = (colorHints & 1) == 0 && (colorHints & 2) == 0;
            this.updateWallpaperDimming(this.mCustomDimAmount);
        }

        private void updateWallpaperDimming(float dimAmount) {
            this.mCustomDimAmount = Math.min(1.0f, dimAmount);
            float f = this.mWallpaperDimAmount = !this.mShouldDimByDefault ? this.mCustomDimAmount : Math.max(this.mDefaultDimAmount, this.mCustomDimAmount);
            if (!ENABLE_WALLPAPER_DIMMING || this.mBbqSurfaceControl == null || !this.mBbqSurfaceControl.isValid() || this.mWallpaperDimAmount == this.mPreviousWallpaperDimAmount) {
                return;
            }
            SurfaceControl.Transaction surfaceControlTransaction = new SurfaceControl.Transaction();
            if (!this.isPreview()) {
                Log.v(WallpaperService.TAG, "Setting wallpaper dimming: " + this.mWallpaperDimAmount);
                ValueAnimator animator2 = ValueAnimator.ofFloat(this.mPreviousWallpaperDimAmount, this.mWallpaperDimAmount);
                animator2.setDuration(300L);
                animator2.addUpdateListener(va -> {
                    float dimValue = ((Float)va.getAnimatedValue()).floatValue();
                    Object object = this.mSurfaceReleaseLock;
                    synchronized (object) {
                        if (this.mBbqSurfaceControl != null && this.mBbqSurfaceControl.isValid()) {
                            surfaceControlTransaction.setAlpha(this.mBbqSurfaceControl, 1.0f - dimValue).apply();
                        }
                    }
                });
                animator2.addListener(new AnimatorListenerAdapter(){

                    @Override
                    public void onAnimationEnd(Animator animation) {
                        Engine.this.updateSurface(false, false, true);
                    }
                });
                animator2.start();
            } else {
                Log.v(WallpaperService.TAG, "Setting wallpaper dimming: 0");
                surfaceControlTransaction.setAlpha(this.mBbqSurfaceControl, 1.0f).apply();
                this.updateSurface(false, false, true);
            }
            this.mPreviousWallpaperDimAmount = this.mWallpaperDimAmount;
            this.mLastColorInvalidation = 0L;
            if (Flags.offloadColorExtraction()) {
                this.onDimAmountChanged(this.mWallpaperDimAmount);
            }
        }

        @VisibleForTesting
        public void setCreated(boolean created) {
            this.mCreated = created;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void dump(String prefix, FileDescriptor fd, PrintWriter out, String[] args) {
            out.print(prefix);
            out.print("mInitializing=");
            out.print(this.mInitializing);
            out.print(" mDestroyed=");
            out.println(this.mDestroyed);
            out.print(prefix);
            out.print("mVisible=");
            out.print(this.mVisible);
            out.print(" mReportedVisible=");
            out.println(this.mReportedVisible);
            out.print(" mIsScreenTurningOn=");
            out.println(this.mIsScreenTurningOn);
            out.print(prefix);
            out.print("mDisplay=");
            out.println(this.mDisplay);
            out.print(prefix);
            out.print("mCreated=");
            out.print(this.mCreated);
            out.print(" mSurfaceCreated=");
            out.print(this.mSurfaceCreated);
            if (Flags.noDuplicateSurfaceDestroyedEvents()) {
                out.print(" mReportedSurfaceCreated=");
                out.print(this.mReportedSurfaceCreated);
            }
            out.print(" mIsCreating=");
            out.print(this.mIsCreating);
            out.print(" mDrawingAllowed=");
            out.println(this.mDrawingAllowed);
            out.print(prefix);
            out.print("mWidth=");
            out.print(this.mWidth);
            out.print(" mCurWidth=");
            out.print(this.mCurWidth);
            out.print(" mHeight=");
            out.print(this.mHeight);
            out.print(" mCurHeight=");
            out.println(this.mCurHeight);
            out.print(prefix);
            out.print("mType=");
            out.print(this.mType);
            out.print(" mWindowFlags=");
            out.print(this.mWindowFlags);
            out.print(" mCurWindowFlags=");
            out.println(this.mCurWindowFlags);
            out.print(prefix);
            out.print("mWindowPrivateFlags=");
            out.print(this.mWindowPrivateFlags);
            out.print(" mCurWindowPrivateFlags=");
            out.println(this.mCurWindowPrivateFlags);
            out.print(prefix);
            out.println("mWinFrames=");
            out.println(this.mWinFrames);
            out.print(prefix);
            out.print("mConfiguration=");
            out.println(this.mMergedConfiguration.getMergedConfiguration());
            out.print(prefix);
            out.print("mLayout=");
            out.println(this.mLayout);
            out.print(prefix);
            out.print("mZoom=");
            out.println(this.mZoom);
            out.print(prefix);
            out.print("mPreviewSurfacePosition=");
            out.println(this.mPreviewSurfacePosition);
            int pendingCount = this.mIWallpaperEngine.mPendingResizeCount.get();
            if (pendingCount != 0) {
                out.print(prefix);
                out.print("mPendingResizeCount=");
                out.println(pendingCount);
            }
            Object object = this.mLock;
            synchronized (object) {
                out.print(prefix);
                out.print("mPendingXOffset=");
                out.print(this.mPendingXOffset);
                out.print(" mPendingXOffset=");
                out.println(this.mPendingXOffset);
                out.print(prefix);
                out.print("mPendingXOffsetStep=");
                out.print(this.mPendingXOffsetStep);
                out.print(" mPendingXOffsetStep=");
                out.println(this.mPendingXOffsetStep);
                out.print(prefix);
                out.print("mOffsetMessageEnqueued=");
                out.print(this.mOffsetMessageEnqueued);
                out.print(" mPendingSync=");
                out.println(this.mPendingSync);
                if (this.mPendingMove != null) {
                    out.print(prefix);
                    out.print("mPendingMove=");
                    out.println(this.mPendingMove);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        public void setZoom(float zoom) {
            boolean updated = false;
            Object object = this.mLock;
            synchronized (object) {
                if (this.mIsInAmbientMode) {
                    this.mZoom = 0.0f;
                }
                if (Float.compare(zoom, this.mZoom) != 0) {
                    this.mZoom = zoom;
                    updated = true;
                }
            }
            if (updated && !this.mDestroyed) {
                this.onZoomChanged(this.mZoom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchPointer(MotionEvent event) {
            if (event.isTouchEvent()) {
                Object object = this.mLock;
                synchronized (object) {
                    this.mPendingMove = event.getAction() == 2 ? event : null;
                }
                Message msg = this.mCaller.obtainMessageO(10040, event);
                this.mCaller.sendMessage(msg);
            } else {
                event.recycle();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateSurface(boolean forceRelayout, boolean forceReport, boolean redrawNeeded) {
            boolean flagsChanged;
            if (this.mDestroyed) {
                Log.w(WallpaperService.TAG, "Ignoring updateSurface due to destroyed");
                return;
            }
            boolean fixedSize = false;
            int myWidth = this.mSurfaceHolder.getRequestedWidth();
            if (myWidth <= 0) {
                myWidth = -1;
            } else {
                fixedSize = true;
            }
            int myHeight = this.mSurfaceHolder.getRequestedHeight();
            if (myHeight <= 0) {
                myHeight = -1;
            } else {
                fixedSize = true;
            }
            boolean creating = !this.mCreated;
            boolean surfaceCreating = !this.mSurfaceCreated;
            boolean formatChanged = this.mFormat != this.mSurfaceHolder.getRequestedFormat();
            boolean sizeChanged = this.mWidth != myWidth || this.mHeight != myHeight;
            boolean insetsChanged = !this.mCreated;
            boolean typeChanged = this.mType != this.mSurfaceHolder.getRequestedType();
            boolean bl = flagsChanged = this.mCurWindowFlags != this.mWindowFlags || this.mCurWindowPrivateFlags != this.mWindowPrivateFlags;
            if (forceRelayout || creating || surfaceCreating || formatChanged || sizeChanged || typeChanged || flagsChanged || redrawNeeded || !this.mIWallpaperEngine.mShownReported) {
                try {
                    this.mWidth = myWidth;
                    this.mHeight = myHeight;
                    this.mFormat = this.mSurfaceHolder.getRequestedFormat();
                    this.mType = this.mSurfaceHolder.getRequestedType();
                    this.mLayout.x = 0;
                    this.mLayout.y = 0;
                    this.mLayout.format = this.mFormat;
                    this.mCurWindowFlags = this.mWindowFlags;
                    this.mLayout.flags = this.mWindowFlags | 0x200 | 0x10000 | 0x100 | 8;
                    Configuration config = this.mMergedConfiguration.getMergedConfiguration();
                    Rect maxBounds = new Rect(config.windowConfiguration.getMaxBounds());
                    if (myWidth == -1 && myHeight == -1) {
                        this.mLayout.width = myWidth;
                        this.mLayout.height = myHeight;
                        this.mLayout.flags &= 0xFFFFBFFF;
                    } else {
                        float layoutScale = Math.max((float)maxBounds.width() / (float)myWidth, (float)maxBounds.height() / (float)myHeight);
                        this.mLayout.width = (int)((float)myWidth * layoutScale + 0.5f);
                        this.mLayout.height = (int)((float)myHeight * layoutScale + 0.5f);
                        this.mLayout.flags |= 0x4000;
                    }
                    this.mCurWindowPrivateFlags = this.mWindowPrivateFlags;
                    this.mLayout.privateFlags = this.mWindowPrivateFlags;
                    this.mLayout.memoryType = this.mType;
                    this.mLayout.token = this.mWindowToken;
                    if (!this.mCreated) {
                        this.mLayout.type = this.mIWallpaperEngine.mWindowType;
                        this.mLayout.gravity = 0x800033;
                        this.mLayout.setFitInsetsTypes(0);
                        this.mLayout.setTitle(WallpaperService.this.getClass().getName());
                        this.mLayout.windowAnimations = 16974622;
                        InputChannel inputChannel = new InputChannel();
                        if (this.mSession.addToDisplay(this.mWindow, this.mLayout, 0, this.mDisplay.getDisplayId(), WindowInsets.Type.defaultVisible(), inputChannel, this.mInsetsState, this.mTempControls, new Rect(), new float[1]) < 0) {
                            Log.w(WallpaperService.TAG, "Failed to add window while updating wallpaper surface.");
                            return;
                        }
                        this.mSession.setShouldZoomOutWallpaper(this.mWindow, this.shouldZoomOutWallpaper());
                        this.mCreated = true;
                        this.mInputEventReceiver = new WallpaperInputEventReceiver(inputChannel, Looper.myLooper());
                    }
                    this.mSurfaceHolder.mSurfaceLock.lock();
                    this.mDrawingAllowed = true;
                    if (!fixedSize) {
                        this.mLayout.surfaceInsets.set(this.mIWallpaperEngine.mDisplayPadding);
                    } else {
                        this.mLayout.surfaceInsets.set(0, 0, 0, 0);
                    }
                    int relayoutResult = this.mSession.relayout(this.mWindow, this.mLayout, this.mWidth, this.mHeight, 0, 0, 0, 0, this.mRelayoutResult);
                    Rect outMaxBounds = this.mMergedConfiguration.getMergedConfiguration().windowConfiguration.getMaxBounds();
                    if (!outMaxBounds.equals(maxBounds)) {
                        Log.i(WallpaperService.TAG, "Retry updateSurface because bounds changed from relayout: " + maxBounds + " -> " + outMaxBounds);
                        this.mSurfaceHolder.mSurfaceLock.unlock();
                        this.mDrawingAllowed = false;
                        this.mCaller.sendMessage(this.mCaller.obtainMessageI(10030, redrawNeeded ? 1 : 0));
                        return;
                    }
                    WindowLayout.computeSurfaceSize(this.mLayout, maxBounds, this.mWidth, this.mHeight, this.mWinFrames.frame, false, this.mSurfaceSize);
                    if (this.mSurfaceControl.isValid()) {
                        int transformHint = SurfaceControl.rotationToBufferTransform((this.mDisplay.getInstallOrientation() + this.mDisplay.getRotation()) % 4);
                        this.mSurfaceControl.setTransformHint(transformHint);
                        if (this.mBbqSurfaceControl == null) {
                            this.mBbqSurfaceControl = new SurfaceControl.Builder().setName("Wallpaper BBQ wrapper").setHidden(false).setBLASTLayer().setParent(this.mSurfaceControl).setCallsite("Wallpaper#relayout").build();
                            SurfaceControl.Transaction transaction = new SurfaceControl.Transaction();
                            int frameRateCompat = WallpaperService.this.getResources().getInteger(17695073);
                            transaction.setDefaultFrameRateCompatibility(this.mBbqSurfaceControl, frameRateCompat).apply();
                        }
                        this.mBbqSurfaceControl.setTransformHint(transformHint);
                        Surface blastSurface = this.getOrCreateBLASTSurface(this.mSurfaceSize.x, this.mSurfaceSize.y, this.mFormat);
                        if (blastSurface != null) {
                            this.mSurfaceHolder.mSurface.transferFrom(blastSurface);
                        }
                    }
                    if (!this.mLastSurfaceSize.equals(this.mSurfaceSize)) {
                        this.mLastSurfaceSize.set(this.mSurfaceSize.x, this.mSurfaceSize.y);
                    }
                    int w = this.mWinFrames.frame.width();
                    int h = this.mWinFrames.frame.height();
                    DisplayCutout rawCutout = this.mInsetsState.getDisplayCutout();
                    Rect visibleFrame = new Rect(this.mWinFrames.frame);
                    visibleFrame.intersect(this.mInsetsState.getDisplayFrame());
                    WindowInsets windowInsets = this.mInsetsState.calculateInsets(visibleFrame, null, config.isScreenRound(), this.mLayout.softInputMode, this.mLayout.flags, 0, this.mLayout.type, config.windowConfiguration.getActivityType(), null);
                    if (!fixedSize) {
                        Rect padding = this.mIWallpaperEngine.mDisplayPadding;
                        w += padding.left + padding.right;
                        h += padding.top + padding.bottom;
                        windowInsets = windowInsets.insetUnchecked(-padding.left, -padding.top, -padding.right, -padding.bottom);
                    } else {
                        w = myWidth;
                        h = myHeight;
                    }
                    if (this.mCurWidth != w) {
                        sizeChanged = true;
                        this.mCurWidth = w;
                    }
                    if (this.mCurHeight != h) {
                        sizeChanged = true;
                        this.mCurHeight = h;
                    }
                    Rect contentInsets = windowInsets.getSystemWindowInsets().toRect();
                    Rect stableInsets = windowInsets.getStableInsets().toRect();
                    DisplayCutout displayCutout = windowInsets.getDisplayCutout() != null ? windowInsets.getDisplayCutout() : rawCutout;
                    insetsChanged |= !this.mDispatchedContentInsets.equals(contentInsets);
                    insetsChanged |= !this.mDispatchedStableInsets.equals(stableInsets);
                    insetsChanged |= !this.mDispatchedDisplayCutout.equals(displayCutout);
                    this.mSurfaceHolder.setSurfaceFrameSize(w, h);
                    this.mSurfaceHolder.mSurfaceLock.unlock();
                    if (!this.mSurfaceHolder.mSurface.isValid()) {
                        this.reportSurfaceDestroyed();
                        return;
                    }
                    boolean didSurface = false;
                    try {
                        SurfaceHolder.Callback[] callbacks;
                        this.mSurfaceHolder.ungetCallbacks();
                        if (surfaceCreating) {
                            this.mIsCreating = true;
                            didSurface = true;
                            this.mReportedSurfaceCreated = true;
                            Trace.beginSection("WPMS.Engine.onSurfaceCreated");
                            this.onSurfaceCreated(this.mSurfaceHolder);
                            Trace.endSection();
                            callbacks = this.mSurfaceHolder.getCallbacks();
                            if (callbacks != null) {
                                for (SurfaceHolder.Callback c : callbacks) {
                                    c.surfaceCreated(this.mSurfaceHolder);
                                }
                            }
                        }
                        redrawNeeded |= creating || (relayoutResult & 1) != 0;
                        if (forceReport || creating || surfaceCreating || formatChanged || sizeChanged) {
                            didSurface = true;
                            Trace.beginSection("WPMS.Engine.onSurfaceChanged");
                            this.onSurfaceChanged(this.mSurfaceHolder, this.mFormat, this.mCurWidth, this.mCurHeight);
                            Trace.endSection();
                            callbacks = this.mSurfaceHolder.getCallbacks();
                            if (callbacks != null) {
                                for (SurfaceHolder.Callback c : callbacks) {
                                    c.surfaceChanged(this.mSurfaceHolder, this.mFormat, this.mCurWidth, this.mCurHeight);
                                }
                            }
                        }
                        if (insetsChanged) {
                            this.mDispatchedContentInsets.set(contentInsets);
                            this.mDispatchedStableInsets.set(stableInsets);
                            this.mDispatchedDisplayCutout = displayCutout;
                            Trace.beginSection("WPMS.Engine.onApplyWindowInsets");
                            this.onApplyWindowInsets(windowInsets);
                            Trace.endSection();
                        }
                        if (redrawNeeded || sizeChanged) {
                            Trace.beginSection("WPMS.Engine.onSurfaceRedrawNeeded");
                            this.onSurfaceRedrawNeeded(this.mSurfaceHolder);
                            Trace.endSection();
                            callbacks = this.mSurfaceHolder.getCallbacks();
                            if (callbacks != null) {
                                for (SurfaceHolder.Callback c : callbacks) {
                                    if (!(c instanceof SurfaceHolder.Callback2)) continue;
                                    ((SurfaceHolder.Callback2)c).surfaceRedrawNeeded(this.mSurfaceHolder);
                                }
                            }
                        }
                        if (didSurface && !this.mReportedVisible) {
                            if (this.mIsCreating) {
                                if (Flags.noConsecutiveVisibilityEvents()) {
                                    Trace.beginSection("WPMS.Engine.onVisibilityChanged-true");
                                    this.onVisibilityChanged(true);
                                    Trace.endSection();
                                    Trace.beginSection("WPMS.Engine.onVisibilityChanged-false");
                                    this.onVisibilityChanged(false);
                                    Trace.endSection();
                                } else {
                                    Trace.beginSection("WPMS.Engine.onVisibilityChanged-true");
                                    this.onVisibilityChanged(true);
                                    Trace.endSection();
                                }
                            }
                            if (!Flags.noConsecutiveVisibilityEvents()) {
                                Trace.beginSection("WPMS.Engine.onVisibilityChanged-false");
                                this.onVisibilityChanged(false);
                                Trace.endSection();
                            }
                        }
                    }
                    finally {
                        this.mIsCreating = false;
                        this.mSurfaceCreated = true;
                        if (redrawNeeded) {
                            this.mSession.finishDrawing(this.mWindow, null, Integer.MAX_VALUE);
                            this.processLocalColors();
                        }
                        this.reposition();
                        this.reportEngineShown(this.shouldWaitForEngineShown());
                    }
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        private void resizePreview(Rect position) {
            if (position != null) {
                this.mSurfaceHolder.setFixedSize(position.width(), position.height());
            }
        }

        private void reposition() {
            if (this.mPreviewSurfacePosition == null) {
                return;
            }
            this.mTmpMatrix.setTranslate(this.mPreviewSurfacePosition.left, this.mPreviewSurfacePosition.top);
            this.mTmpMatrix.postScale((float)this.mPreviewSurfacePosition.width() / (float)this.mCurWidth, (float)this.mPreviewSurfacePosition.height() / (float)this.mCurHeight);
            this.mTmpMatrix.getValues(this.mTmpValues);
            SurfaceControl.Transaction t = new SurfaceControl.Transaction();
            t.setPosition(this.mSurfaceControl, this.mPreviewSurfacePosition.left, this.mPreviewSurfacePosition.top);
            t.setMatrix(this.mSurfaceControl, this.mTmpValues[0], this.mTmpValues[3], this.mTmpValues[1], this.mTmpValues[4]);
            t.apply();
        }

        void attach(IWallpaperEngineWrapper wrapper) {
            if (this.mDestroyed) {
                return;
            }
            this.mIWallpaperEngine = wrapper;
            this.mCaller = wrapper.mCaller;
            this.mConnection = wrapper.mConnection;
            this.mWindowToken = wrapper.mWindowToken;
            this.mSurfaceHolder.setSizeFromLayout();
            this.mInitializing = true;
            this.mSession = WindowManagerGlobal.getWindowSession();
            this.mWindow.setSession(this.mSession);
            this.mLayout.packageName = WallpaperService.this.getPackageName();
            if (com.android.server.display.feature.flags.Flags.displayListenerPerformanceImprovements() && com.android.server.display.feature.flags.Flags.committedStateSeparateEvent()) {
                this.mIWallpaperEngine.mDisplayManager.registerDisplayListener(this.mDisplayListener, this.mCaller.getHandler(), 4L, 8L);
            } else {
                this.mIWallpaperEngine.mDisplayManager.registerDisplayListener(this.mDisplayListener, this.mCaller.getHandler());
            }
            this.mDisplay = this.mIWallpaperEngine.mDisplay;
            this.mDisplayContext = WallpaperService.this.createDisplayContext(this.mDisplay).createWindowContext(2013, null);
            this.mDefaultDimAmount = this.mDisplayContext.getResources().getFloat(17105183);
            this.mDisplayState = this.mDisplay.getCommittedState();
            this.mMergedConfiguration.setOverrideConfiguration(this.mDisplayContext.getResources().getConfiguration());
            Trace.beginSection("WPMS.Engine.onCreate");
            this.onCreate(this.mSurfaceHolder);
            Trace.endSection();
            this.mInitializing = false;
            this.mReportedVisible = false;
            Trace.beginSection("WPMS.Engine.updateSurface");
            this.updateSurface(false, false, false);
            Trace.endSection();
        }

        @Nullable
        public Context getDisplayContext() {
            return this.mDisplayContext;
        }

        @VisibleForTesting
        public void doAmbientModeChanged(boolean inAmbientMode, long animationDuration) {
            if (!this.mDestroyed) {
                this.mIsInAmbientMode = inAmbientMode;
                if (this.mCreated) {
                    this.onAmbientModeChanged(inAmbientMode, animationDuration);
                }
            }
        }

        void doDesiredSizeChanged(int desiredWidth, int desiredHeight) {
            if (!this.mDestroyed) {
                this.mIWallpaperEngine.mReqWidth = desiredWidth;
                this.mIWallpaperEngine.mReqHeight = desiredHeight;
                this.onDesiredSizeChanged(desiredWidth, desiredHeight);
                this.doOffsetsChanged(true);
            }
        }

        void doDisplayPaddingChanged(Rect padding) {
            if (!this.mDestroyed && !this.mIWallpaperEngine.mDisplayPadding.equals(padding)) {
                this.mIWallpaperEngine.mDisplayPadding.set(padding);
                this.updateSurface(true, false, false);
            }
        }

        void onScreenTurningOnChanged(boolean isScreenTurningOn) {
            if (!this.mDestroyed) {
                this.mIsScreenTurningOn = isScreenTurningOn;
                this.reportVisibility(false);
            }
        }

        void doVisibilityChanged(boolean visible) {
            if (!this.mDestroyed) {
                this.mVisible = visible;
                this.reportVisibility(false);
                if (this.mReportedVisible) {
                    this.processLocalColors();
                }
            } else {
                AnimationHandler.requestAnimatorsEnabled(visible, this);
            }
        }

        void reportVisibility(boolean forceReport) {
            if (this.mScreenshotSurfaceControl != null && this.mVisible) {
                return;
            }
            if (!this.mDestroyed) {
                boolean visible;
                this.mDisplayState = this.mDisplay == null ? 0 : this.mDisplay.getCommittedState();
                boolean displayFullyOn = Display.isOnState(this.mDisplayState) && !this.mIsScreenTurningOn;
                boolean supportsAmbientMode = this.mIWallpaperEngine.mInfo == null ? false : this.mIWallpaperEngine.mInfo.supportsAmbientMode();
                boolean bl = visible = this.mVisible && (displayFullyOn || supportsAmbientMode);
                if (this.mReportedVisible != visible || forceReport) {
                    this.mReportedVisible = visible;
                    if (visible) {
                        this.doOffsetsChanged(false);
                        this.updateSurface(false, false, false);
                    }
                    this.onVisibilityChanged(visible);
                    if (this.mReportedVisible && this.mFrozenRequested) {
                        this.freeze();
                    }
                    AnimationHandler.requestAnimatorsEnabled(visible, this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doOffsetsChanged(boolean always) {
            boolean sync;
            float yOffsetStep;
            float xOffsetStep;
            float yOffset;
            float xOffset;
            if (this.mDestroyed) {
                return;
            }
            if (!always && !this.mOffsetsChanged) {
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                xOffset = this.mPendingXOffset;
                yOffset = this.mPendingYOffset;
                xOffsetStep = this.mPendingXOffsetStep;
                yOffsetStep = this.mPendingYOffsetStep;
                sync = this.mPendingSync;
                this.mPendingSync = false;
                this.mOffsetMessageEnqueued = false;
            }
            if (this.mSurfaceCreated) {
                if (this.mReportedVisible) {
                    int availw = this.mIWallpaperEngine.mReqWidth - this.mCurWidth;
                    int xPixels = availw > 0 ? -((int)((float)availw * xOffset + 0.5f)) : 0;
                    int availh = this.mIWallpaperEngine.mReqHeight - this.mCurHeight;
                    int yPixels = availh > 0 ? -((int)((float)availh * yOffset + 0.5f)) : 0;
                    this.onOffsetsChanged(xOffset, yOffset, xOffsetStep, yOffsetStep, xPixels, yPixels);
                } else {
                    this.mOffsetsChanged = true;
                }
            }
            if (sync) {
                try {
                    this.mSession.wallpaperOffsetsComplete(this.mWindow.asBinder());
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.processLocalColors();
        }

        private void processLocalColors() {
            if (this.mProcessLocalColorsPending.compareAndSet(false, true)) {
                long now = this.mClockFunction.get();
                long timeSinceLastColorProcess = now - this.mLastProcessLocalColorsTimestamp;
                long timeToWait = Math.max(0L, 2000L - timeSinceLastColorProcess);
                this.mHandler.postDelayed(() -> {
                    this.mLastProcessLocalColorsTimestamp = now + timeToWait;
                    this.mProcessLocalColorsPending.set(false);
                    this.processLocalColorsInternal();
                }, timeToWait);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processLocalColorsInternal() {
            HashSet<RectF> areas;
            EngineWindowPage current;
            int xPage;
            int xPages;
            float wallpaperDimAmount;
            if (this.supportsLocalColorExtraction()) {
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                int xCurrentPage;
                float xOffset = this.mPendingXOffset;
                float xOffsetStep = this.mPendingXOffsetStep;
                wallpaperDimAmount = this.mWallpaperDimAmount;
                if (xOffset % xOffsetStep > 0.05f || !this.mSurfaceHolder.getSurface().isValid()) {
                    return;
                }
                if (!this.validStep(xOffsetStep)) {
                    xOffset = 0.0f;
                    xOffsetStep = 1.0f;
                    xCurrentPage = 0;
                    xPages = 1;
                } else {
                    xPages = Math.round(1.0f / xOffsetStep) + 1;
                    xOffsetStep = 1.0f / (float)xPages;
                    float shrink = (float)(xPages - 1) / (float)xPages;
                    xCurrentPage = Math.round((xOffset *= shrink) / xOffsetStep);
                }
                float finalXOffsetStep = xOffsetStep;
                float finalXOffset = xOffset;
                this.resetWindowPages();
                xPage = xCurrentPage;
                if (this.mWindowPages.length == 0 || this.mWindowPages.length != xPages) {
                    this.mWindowPages = new EngineWindowPage[xPages];
                    this.initWindowPages(this.mWindowPages, finalXOffsetStep);
                }
                if (this.mLocalColorsToAdd.size() != 0) {
                    for (RectF colorArea : this.mLocalColorsToAdd) {
                        if (!WallpaperService.this.isValid(colorArea)) continue;
                        this.mLocalColorAreas.add(colorArea);
                        int colorPage = this.getRectFPage(colorArea, finalXOffsetStep);
                        EngineWindowPage currentPage = this.mWindowPages[colorPage];
                        currentPage.setLastUpdateTime(0L);
                        currentPage.removeColor(colorArea);
                    }
                    this.mLocalColorsToAdd.clear();
                }
                if (xPage >= this.mWindowPages.length) {
                    xPage = this.mWindowPages.length - 1;
                }
                current = this.mWindowPages[xPage];
                areas = new HashSet<RectF>(current.getAreas());
            }
            this.updatePage(current, areas, xPage, xPages, wallpaperDimAmount);
        }

        @GuardedBy(value={"mLock"})
        private void initWindowPages(EngineWindowPage[] windowPages, float step) {
            for (int i = 0; i < windowPages.length; ++i) {
                windowPages[i] = new EngineWindowPage();
            }
            this.mLocalColorAreas.addAll(this.mLocalColorsToAdd);
            this.mLocalColorsToAdd.clear();
            for (RectF area : this.mLocalColorAreas) {
                if (!WallpaperService.this.isValid(area)) {
                    this.mLocalColorAreas.remove(area);
                    continue;
                }
                int pageNum = this.getRectFPage(area, step);
                windowPages[pageNum].addArea(area);
            }
        }

        void updatePage(EngineWindowPage currentPage, Set<RectF> areas, int pageIndx, int numPages, float wallpaperDimAmount) {
            Bitmap screenShot;
            long current = SystemClock.elapsedRealtime() - 60000L;
            long lapsed = current - currentPage.getLastUpdateTime();
            if (lapsed < 60000L) {
                return;
            }
            Surface surface = this.mSurfaceHolder.getSurface();
            if (!surface.isValid()) {
                return;
            }
            boolean widthIsLarger = this.mSurfaceSize.x > this.mSurfaceSize.y;
            int smaller = widthIsLarger ? this.mSurfaceSize.x : this.mSurfaceSize.y;
            float ratio = 64.0f / (float)smaller;
            int width = (int)(ratio * (float)this.mSurfaceSize.x);
            int height = (int)(ratio * (float)this.mSurfaceSize.y);
            if (width <= 0 || height <= 0) {
                Log.e(WallpaperService.TAG, "wrong width and height values of bitmap " + width + " " + height);
                return;
            }
            String pixelCopySectionName = "WallpaperService#pixelCopy";
            int pixelCopyCount = this.mPixelCopyCount++;
            Trace.beginAsyncSection("WallpaperService#pixelCopy", pixelCopyCount);
            Bitmap finalScreenShot = screenShot = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
            try {
                PixelCopy.request(surface, screenShot, res -> {
                    Trace.endAsyncSection("WallpaperService#pixelCopy", pixelCopyCount);
                    if (res != 0) {
                        Bitmap lastBitmap = currentPage.getBitmap();
                        currentPage.setBitmap(this.mLastScreenshot);
                        Bitmap lastScreenshot = this.mLastScreenshot;
                        if (lastScreenshot != null && !Objects.equals(lastBitmap, lastScreenshot)) {
                            this.updatePageColors(currentPage, areas, pageIndx, numPages, wallpaperDimAmount);
                        }
                    } else {
                        this.mLastScreenshot = finalScreenShot;
                        currentPage.setBitmap(finalScreenShot);
                        currentPage.setLastUpdateTime(current);
                        this.updatePageColors(currentPage, areas, pageIndx, numPages, wallpaperDimAmount);
                    }
                }, WallpaperService.this.mBackgroundHandler);
            }
            catch (IllegalArgumentException e) {
                Log.w(WallpaperService.TAG, "Cancelling processLocalColors: exception caught during PixelCopy");
            }
        }

        private void updatePageColors(EngineWindowPage page, Set<RectF> areas, int pageIndx, int numPages, float wallpaperDimAmount) {
            if (page.getBitmap() == null) {
                return;
            }
            if (!WallpaperService.this.mBackgroundHandler.getLooper().isCurrentThread()) {
                throw new IllegalStateException("ProcessLocalColors should be called from the background thread");
            }
            Trace.beginSection("WallpaperService#updatePageColors");
            for (RectF area : areas) {
                Bitmap target;
                if (area == null) continue;
                RectF subArea = this.generateSubRect(area, pageIndx, numPages);
                Bitmap b = page.getBitmap();
                int x = Math.round((float)b.getWidth() * subArea.left);
                int y = Math.round((float)b.getHeight() * subArea.top);
                int width = Math.round((float)b.getWidth() * subArea.width());
                int height = Math.round((float)b.getHeight() * subArea.height());
                try {
                    target = Bitmap.createBitmap(b, x, y, width, height);
                }
                catch (Exception e) {
                    Log.e(WallpaperService.TAG, "Error creating page local color bitmap", e);
                    continue;
                }
                WallpaperColors color2 = WallpaperColors.fromBitmap(target, wallpaperDimAmount);
                target.recycle();
                WallpaperColors currentColor = page.getColors(area);
                if (currentColor != null && color2.equals(currentColor)) continue;
                page.addWallpaperColors(area, color2);
                this.mHandler.post(() -> {
                    try {
                        this.mConnection.onLocalWallpaperColorsChanged(area, color2, this.mDisplayContext.getDisplayId());
                    }
                    catch (RemoteException e) {
                        Log.e(WallpaperService.TAG, "Error calling Connection.onLocalWallpaperColorsChanged", e);
                    }
                });
            }
            Trace.endSection();
        }

        private RectF generateSubRect(RectF in, int pageInx, int numPages) {
            float minLeft = (float)pageInx / (float)numPages;
            float maxRight = (float)(pageInx + 1) / (float)numPages;
            float left = in.left;
            float right = in.right;
            if (left < minLeft) {
                left = minLeft;
            }
            if (right > maxRight) {
                right = maxRight;
            }
            left = left * (float)numPages % 1.0f;
            if ((right = right * (float)numPages % 1.0f) == 0.0f) {
                right = 1.0f;
            }
            return new RectF(left, in.top, right, in.bottom);
        }

        @GuardedBy(value={"mLock"})
        private void resetWindowPages() {
            if (this.supportsLocalColorExtraction()) {
                return;
            }
            if (!this.mResetWindowPages) {
                return;
            }
            this.mResetWindowPages = false;
            for (int i = 0; i < this.mWindowPages.length; ++i) {
                this.mWindowPages[i].setLastUpdateTime(0L);
            }
        }

        @GuardedBy(value={"mLock"})
        private int getRectFPage(RectF area, float step) {
            if (!WallpaperService.this.isValid(area)) {
                return 0;
            }
            if (!this.validStep(step)) {
                return 0;
            }
            int pages = Math.round(1.0f / step);
            int page = Math.round(area.centerX() * (float)pages);
            if (page == pages) {
                return pages - 1;
            }
            if (page == this.mWindowPages.length) {
                page = this.mWindowPages.length - 1;
            }
            return page;
        }

        public void addLocalColorsAreas(@NonNull List<RectF> regions) {
            if (this.supportsLocalColorExtraction()) {
                return;
            }
            WallpaperService.this.mBackgroundHandler.post(() -> {
                Object object = this.mLock;
                synchronized (object) {
                    this.mLocalColorsToAdd.addAll(regions);
                }
                this.processLocalColors();
            });
        }

        public void removeLocalColorsAreas(@NonNull List<RectF> regions) {
            if (this.supportsLocalColorExtraction()) {
                return;
            }
            WallpaperService.this.mBackgroundHandler.post(() -> {
                Object object = this.mLock;
                synchronized (object) {
                    float step = this.mPendingXOffsetStep;
                    this.mLocalColorsToAdd.removeAll(regions);
                    this.mLocalColorAreas.removeAll(regions);
                    if (!this.validStep(step)) {
                        return;
                    }
                    for (int i = 0; i < this.mWindowPages.length; ++i) {
                        for (int j = 0; j < regions.size(); ++j) {
                            this.mWindowPages[i].removeArea((RectF)regions.get(j));
                        }
                    }
                }
            });
        }

        private Rect fixRect(Bitmap b, Rect r) {
            r.left = r.left >= r.right || r.left >= b.getWidth() || r.left > 0 ? 0 : r.left;
            r.right = r.left >= r.right || r.right > b.getWidth() ? b.getWidth() : r.right;
            return r;
        }

        private boolean validStep(float step) {
            return !Float.isNaN(step) && step > 0.0f && step <= 1.0f;
        }

        void doCommand(WallpaperCommand cmd) {
            Bundle result;
            if (!this.mDestroyed) {
                if ("android.wallpaper.freeze".equals(cmd.action) || "android.wallpaper.unfreeze".equals(cmd.action)) {
                    this.updateFrozenState(!"android.wallpaper.unfreeze".equals(cmd.action));
                }
                result = this.onCommand(cmd.action, cmd.x, cmd.y, cmd.z, cmd.extras, cmd.sync);
            } else {
                result = null;
            }
            if (cmd.sync) {
                try {
                    this.mSession.wallpaperCommandComplete(this.mWindow.asBinder(), result);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        private void updateFrozenState(boolean frozenRequested) {
            boolean isFrozen;
            if (this.mIWallpaperEngine.mInfo == null && frozenRequested) {
                return;
            }
            this.mFrozenRequested = frozenRequested;
            boolean bl = isFrozen = this.mScreenshotSurfaceControl != null;
            if (this.mFrozenRequested == isFrozen) {
                return;
            }
            if (this.mFrozenRequested) {
                this.freeze();
            } else {
                this.unfreeze();
            }
        }

        private void freeze() {
            if (!this.mReportedVisible || this.mDestroyed) {
                return;
            }
            if (!this.showScreenshotOfWallpaper()) {
                return;
            }
            this.doVisibilityChanged(false);
            this.mVisible = true;
        }

        private void unfreeze() {
            this.cleanUpScreenshotSurfaceControl();
            if (this.mVisible) {
                this.doVisibilityChanged(true);
            }
        }

        private void cleanUpScreenshotSurfaceControl() {
            if (this.mScreenshotSurfaceControl != null) {
                new SurfaceControl.Transaction().remove(this.mScreenshotSurfaceControl).show(this.mBbqSurfaceControl).apply();
                this.mScreenshotSurfaceControl = null;
            }
        }

        void scaleAndCropScreenshot() {
            if (this.mScreenshotSurfaceControl == null) {
                return;
            }
            if (this.mScreenshotSize.x <= 0 || this.mScreenshotSize.y <= 0) {
                Log.w(WallpaperService.TAG, "Unexpected screenshot size: " + this.mScreenshotSize);
                return;
            }
            float scaleFactor = Math.max(1.0f, Math.max((float)this.mSurfaceSize.x / (float)this.mScreenshotSize.x, (float)this.mSurfaceSize.y / (float)this.mScreenshotSize.y));
            int diffX = (int)((float)this.mScreenshotSize.x * scaleFactor) - this.mSurfaceSize.x;
            int diffY = (int)((float)this.mScreenshotSize.y * scaleFactor) - this.mSurfaceSize.y;
            new SurfaceControl.Transaction().setMatrix(this.mScreenshotSurfaceControl, scaleFactor, 0.0f, 0.0f, scaleFactor).setWindowCrop(this.mScreenshotSurfaceControl, new Rect(diffX / 2, diffY / 2, diffX / 2 + this.mScreenshotSize.x, diffY / 2 + this.mScreenshotSize.y)).setPosition(this.mScreenshotSurfaceControl, -diffX / 2, -diffY / 2).apply();
        }

        private boolean showScreenshotOfWallpaper() {
            ScreenCapture.ScreenshotHardwareBuffer screenshotBuffer;
            if (this.mDestroyed || this.mSurfaceControl == null || !this.mSurfaceControl.isValid()) {
                return false;
            }
            Rect bounds = new Rect(0, 0, this.mSurfaceSize.x, this.mSurfaceSize.y);
            if (bounds.isEmpty()) {
                Log.w(WallpaperService.TAG, "Failed to screenshot wallpaper: surface bounds are empty");
                return false;
            }
            if (this.mScreenshotSurfaceControl != null) {
                Log.e(WallpaperService.TAG, "Screenshot is unexpectedly not null");
                this.cleanUpScreenshotSurfaceControl();
            }
            if ((screenshotBuffer = ScreenCapture.captureLayers(((ScreenCapture.LayerCaptureArgs.Builder)((ScreenCapture.LayerCaptureArgs.Builder)new ScreenCapture.LayerCaptureArgs.Builder(this.mSurfaceControl).setUid(Process.myUid())).setChildrenOnly(false).setSourceCrop(bounds)).build())) == null) {
                Log.w(WallpaperService.TAG, "Failed to screenshot wallpaper: screenshotBuffer is null");
                return false;
            }
            HardwareBuffer hardwareBuffer = screenshotBuffer.getHardwareBuffer();
            SurfaceControl.Transaction t = new SurfaceControl.Transaction();
            this.mScreenshotSurfaceControl = new SurfaceControl.Builder().setName("Wallpaper snapshot for engine " + this).setFormat(hardwareBuffer.getFormat()).setParent(this.mSurfaceControl).setSecure(screenshotBuffer.containsSecureLayers()).setCallsite("WallpaperService.Engine.showScreenshotOfWallpaper").setBLASTLayer().build();
            this.mScreenshotSize.set(this.mSurfaceSize.x, this.mSurfaceSize.y);
            t.setBuffer(this.mScreenshotSurfaceControl, hardwareBuffer);
            t.setColorSpace(this.mScreenshotSurfaceControl, screenshotBuffer.getColorSpace());
            t.setLayer(this.mScreenshotSurfaceControl, Integer.MAX_VALUE);
            t.show(this.mScreenshotSurfaceControl);
            t.hide(this.mBbqSurfaceControl);
            t.apply();
            return true;
        }

        void reportSurfaceDestroyed() {
            if (!Flags.noDuplicateSurfaceDestroyedEvents() && this.mSurfaceCreated || Flags.noDuplicateSurfaceDestroyedEvents() && this.mReportedSurfaceCreated) {
                this.mSurfaceCreated = false;
                this.mReportedSurfaceCreated = false;
                this.mSurfaceHolder.ungetCallbacks();
                SurfaceHolder.Callback[] callbacks = this.mSurfaceHolder.getCallbacks();
                if (callbacks != null) {
                    for (SurfaceHolder.Callback c : callbacks) {
                        c.surfaceDestroyed(this.mSurfaceHolder);
                    }
                }
                this.onSurfaceDestroyed(this.mSurfaceHolder);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        public void detach() {
            if (this.mDestroyed) {
                return;
            }
            AnimationHandler.removeRequestor(this);
            this.mDestroyed = true;
            if (this.mIWallpaperEngine != null && this.mIWallpaperEngine.mDisplayManager != null) {
                this.mIWallpaperEngine.mDisplayManager.unregisterDisplayListener(this.mDisplayListener);
            }
            if (this.mVisible) {
                this.mVisible = false;
                this.onVisibilityChanged(false);
            }
            this.reportSurfaceDestroyed();
            this.onDestroy();
            Object object = this.mSurfaceReleaseLock;
            synchronized (object) {
                if (this.mCreated) {
                    try {
                        if (this.mInputEventReceiver != null) {
                            this.mInputEventReceiver.dispose();
                            this.mInputEventReceiver = null;
                        }
                        this.mSession.remove(this.mWindow.asBinder());
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    this.mSurfaceHolder.mSurface.release();
                    if (this.mBlastBufferQueue != null) {
                        this.mBlastBufferQueue.destroy();
                        this.mBlastBufferQueue = null;
                    }
                    if (this.mBbqSurfaceControl != null) {
                        new SurfaceControl.Transaction().remove(this.mBbqSurfaceControl).apply();
                        this.mBbqSurfaceControl = null;
                    }
                    this.mCreated = false;
                }
                if (this.mSurfaceControl != null) {
                    this.mSurfaceControl.release();
                    this.mSurfaceControl = null;
                    this.mRelayoutResult = null;
                }
            }
        }

        private Surface getOrCreateBLASTSurface(int width, int height, int format) {
            if (this.mBbqSurfaceControl == null || !this.mBbqSurfaceControl.isValid()) {
                Log.w(WallpaperService.TAG, "Skipping BlastBufferQueue update/create - invalid surface control");
                return null;
            }
            Surface ret = null;
            if (this.mBlastBufferQueue == null) {
                this.mBlastBufferQueue = new BLASTBufferQueue("Wallpaper", true);
                this.mBlastBufferQueue.setApplyToken(this.mBbqApplyToken);
                this.mBlastBufferQueue.update(this.mBbqSurfaceControl, width, height, format);
                ret = this.mBlastBufferQueue.createSurface();
            } else {
                this.mBlastBufferQueue.update(this.mBbqSurfaceControl, width, height, format);
            }
            return ret;
        }

        class WallpaperInputEventReceiver
        extends InputEventReceiver {
            public WallpaperInputEventReceiver(InputChannel inputChannel, Looper looper) {
                super(inputChannel, looper);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInputEvent(InputEvent event) {
                boolean handled = false;
                try {
                    if (event instanceof MotionEvent && (event.getSource() & 2) != 0) {
                        MotionEvent dup = MotionEvent.obtainNoHistory((MotionEvent)event);
                        Engine.this.dispatchPointer(dup);
                        handled = true;
                    }
                }
                finally {
                    this.finishInputEvent(event, handled);
                }
            }
        }
    }

    static class WallpaperCommand {
        String action;
        int x;
        int y;
        int z;
        Bundle extras;
        boolean sync;

        WallpaperCommand() {
        }
    }
}

