/*
 * Decompiled with CFR 0.152.
 */
package android.sysprop;

import android.os.SystemProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;

public class DisplayProperties {
    private DisplayProperties() {
    }

    private static Boolean tryParseBoolean(String str) {
        if (str == null) {
            return null;
        }
        switch (str.toLowerCase(Locale.US)) {
            case "1": 
            case "true": {
                return Boolean.TRUE;
            }
            case "0": 
            case "false": {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private static Integer tryParseInteger(String str) {
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Integer tryParseUInt(String str) {
        try {
            return Integer.parseUnsignedInt(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Long tryParseLong(String str) {
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Long tryParseULong(String str) {
        try {
            return Long.parseUnsignedLong(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Double tryParseDouble(String str) {
        try {
            return Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static String tryParseString(String str) {
        return "".equals(str) ? null : str;
    }

    private static <T extends Enum<T>> T tryParseEnum(Class<T> enumType, String str) {
        try {
            return Enum.valueOf(enumType, str.toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static <T> List<T> tryParseList(Function<String, T> elementParser, String str) {
        if ("".equals(str)) {
            return new ArrayList();
        }
        ArrayList<T> ret = new ArrayList<T>();
        int p = 0;
        while (true) {
            StringBuilder sb = new StringBuilder();
            while (p < str.length() && str.charAt(p) != ',') {
                if (str.charAt(p) == '\\') {
                    ++p;
                }
                if (p == str.length()) break;
                sb.append(str.charAt(p++));
            }
            ret.add(elementParser.apply(sb.toString()));
            if (p == str.length()) break;
            ++p;
        }
        return ret;
    }

    private static <T extends Enum<T>> List<T> tryParseEnumList(Class<T> enumType, String str) {
        if ("".equals(str)) {
            return new ArrayList();
        }
        ArrayList<T> ret = new ArrayList<T>();
        for (String element : str.split(",")) {
            ret.add(DisplayProperties.tryParseEnum(enumType, element));
        }
        return ret;
    }

    private static String escape(String str) {
        return str.replaceAll("([\\\\,])", "\\\\$1");
    }

    private static <T> String formatList(List<T> list) {
        StringJoiner joiner = new StringJoiner(",");
        for (T element : list) {
            joiner.add(element == null ? "" : DisplayProperties.escape(element.toString()));
        }
        return ((Object)joiner).toString();
    }

    private static String formatUIntList(List<Integer> list) {
        StringJoiner joiner = new StringJoiner(",");
        for (Integer element : list) {
            joiner.add(element == null ? "" : DisplayProperties.escape(Integer.toUnsignedString(element)));
        }
        return ((Object)joiner).toString();
    }

    private static String formatULongList(List<Long> list) {
        StringJoiner joiner = new StringJoiner(",");
        for (Long element : list) {
            joiner.add(element == null ? "" : DisplayProperties.escape(Long.toUnsignedString(element)));
        }
        return ((Object)joiner).toString();
    }

    private static <T extends Enum<T>> String formatEnumList(List<T> list, Function<T, String> elementFormatter) {
        StringJoiner joiner = new StringJoiner(",");
        for (Enum element : list) {
            joiner.add(element == null ? "" : (CharSequence)elementFormatter.apply(element));
        }
        return ((Object)joiner).toString();
    }

    public static Optional<Boolean> debug_force_msaa() {
        String value = SystemProperties.get("debug.egl.force_msaa");
        return Optional.ofNullable(DisplayProperties.tryParseBoolean(value));
    }

    public static void debug_force_msaa(Boolean value) {
        SystemProperties.set("debug.egl.force_msaa", value == null ? "" : ((Object)value).toString());
    }

    public static Optional<String> debug_opengl_trace() {
        String value = SystemProperties.get("debug.egl.trace");
        return Optional.ofNullable(DisplayProperties.tryParseString(value));
    }

    public static void debug_opengl_trace(String value) {
        SystemProperties.set("debug.egl.trace", value == null ? "" : value.toString());
    }

    public static Optional<Boolean> debug_force_rtl() {
        String value = SystemProperties.get("debug.force_rtl");
        return Optional.ofNullable(DisplayProperties.tryParseBoolean(value));
    }

    public static void debug_force_rtl(Boolean value) {
        SystemProperties.set("debug.force_rtl", value == null ? "" : ((Object)value).toString());
    }

    public static Optional<Boolean> debug_layout() {
        String value = SystemProperties.get("debug.layout");
        return Optional.ofNullable(DisplayProperties.tryParseBoolean(value));
    }

    public static void debug_layout(Boolean value) {
        SystemProperties.set("debug.layout", value == null ? "" : ((Object)value).toString());
    }

    public static Optional<String> debug_vri_package() {
        String value = SystemProperties.get("persist.debug.vri_package");
        return Optional.ofNullable(DisplayProperties.tryParseString(value));
    }

    public static void debug_vri_package(String value) {
        SystemProperties.set("persist.debug.vri_package", value == null ? "" : value.toString());
    }
}

