/*
 * Decompiled with CFR 0.152.
 */
package android.telecom.Logging;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.telecom.Log;
import android.text.TextUtils;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.telecom.flags.Flags;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.concurrent.atomic.AtomicInteger;

public class Session {
    public static final String LOG_TAG = "Session";
    public static final String START_SESSION = "START_SESSION";
    public static final String START_EXTERNAL_SESSION = "START_EXTERNAL_SESSION";
    public static final String CREATE_SUBSESSION = "CREATE_SUBSESSION";
    public static final String CONTINUE_SUBSESSION = "CONTINUE_SUBSESSION";
    public static final String END_SUBSESSION = "END_SUBSESSION";
    public static final String END_SESSION = "END_SESSION";
    public static final String SUBSESSION_SEPARATION_CHAR = "->";
    public static final String SESSION_SEPARATION_CHAR_CHILD = "_";
    public static final String EXTERNAL_INDICATOR = "E-";
    public static final String TRUNCATE_STRING = "...";
    private static final int SESSION_RECURSION_LIMIT = 25;
    public static final long UNDEFINED = -1L;
    private final String mSessionId;
    private volatile String mShortMethodName;
    private long mExecutionStartTimeMs;
    private long mExecutionEndTimeMs = -1L;
    private volatile Session mParentSession;
    private final ArrayList<Session> mChildSessions = new ArrayList(5);
    private boolean mIsCompleted = false;
    private final boolean mIsExternal;
    private final AtomicInteger mChildCounter = new AtomicInteger(0);
    private final boolean mIsStartedFromActiveSession;
    private final String mOwnerInfo;
    private volatile String mFullMethodPathCache;

    public Session(String sessionId, String shortMethodName, long startTimeMs, boolean isStartedFromActiveSession, boolean isExternal, String ownerInfo) {
        this.mSessionId = sessionId != null ? sessionId : "???";
        this.setShortMethodName(shortMethodName);
        this.mExecutionStartTimeMs = startTimeMs;
        this.mParentSession = null;
        this.mIsStartedFromActiveSession = isStartedFromActiveSession;
        this.mIsExternal = isExternal;
        this.mOwnerInfo = ownerInfo;
    }

    public String getShortMethodName() {
        return this.mShortMethodName;
    }

    public void setShortMethodName(String shortMethodName) {
        if (shortMethodName == null) {
            shortMethodName = "";
        }
        this.mShortMethodName = shortMethodName;
    }

    public boolean isExternal() {
        return this.mIsExternal;
    }

    public void setParentSession(Session parentSession) {
        this.mParentSession = parentSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(Session childSession) {
        if (childSession == null) {
            return;
        }
        ArrayList<Session> arrayList = this.mChildSessions;
        synchronized (arrayList) {
            this.mChildSessions.add(childSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(Session child) {
        if (child == null) {
            return;
        }
        ArrayList<Session> arrayList = this.mChildSessions;
        synchronized (arrayList) {
            this.mChildSessions.remove(child);
        }
    }

    public long getExecutionStartTimeMilliseconds() {
        return this.mExecutionStartTimeMs;
    }

    public void setExecutionStartTimeMs(long startTimeMs) {
        this.mExecutionStartTimeMs = startTimeMs;
    }

    public Session getParentSession() {
        return this.mParentSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Session> getChildSessions() {
        ArrayList<Session> arrayList = this.mChildSessions;
        synchronized (arrayList) {
            return new ArrayList<Session>(this.mChildSessions);
        }
    }

    public boolean isSessionCompleted() {
        return this.mIsCompleted;
    }

    public boolean isStartedFromActiveSession() {
        return this.mIsStartedFromActiveSession;
    }

    public Info getInfo() {
        return Info.getInfo(this);
    }

    public Info getExternalInfo(@Nullable String ownerInfo) {
        return Info.getExternalInfo(this, ownerInfo);
    }

    public String getOwnerInfo() {
        return this.mOwnerInfo;
    }

    @VisibleForTesting
    public String getSessionId() {
        return this.mSessionId;
    }

    public void markSessionCompleted(long executionEndTimeMs) {
        this.mExecutionEndTimeMs = executionEndTimeMs;
        this.mIsCompleted = true;
    }

    public long getLocalExecutionTime() {
        if (this.mExecutionEndTimeMs == -1L) {
            return -1L;
        }
        return this.mExecutionEndTimeMs - this.mExecutionStartTimeMs;
    }

    public String getNextChildId() {
        return String.valueOf(this.mChildCounter.getAndIncrement());
    }

    private String getFullSessionId() {
        if (!Flags.endSessionImprovements()) {
            return this.getFullSessionIdRecursive(0);
        }
        int currParentCount = 0;
        StringBuilder id2 = new StringBuilder();
        Session currSession = this;
        while (currSession != null) {
            Session parentSession = currSession.getParentSession();
            if (parentSession != null) {
                if (currParentCount >= 25) {
                    id2.insert(0, this.getSessionId());
                    id2.insert(0, TRUNCATE_STRING);
                    Slog.w(LOG_TAG, "getFullSessionId: Hit iteration limit!");
                    return id2.toString();
                }
                if (Log.VERBOSE) {
                    id2.insert(0, currSession.getSessionId());
                    id2.insert(0, SESSION_SEPARATION_CHAR_CHILD);
                }
            } else {
                id2.insert(0, currSession.getSessionId());
            }
            currSession = parentSession;
            ++currParentCount;
        }
        return id2.toString();
    }

    private String getFullSessionIdRecursive(int parentCount) {
        if (parentCount >= 25) {
            Slog.w(LOG_TAG, "getFullSessionId: Hit recursion limit!");
            return TRUNCATE_STRING + this.mSessionId;
        }
        Session parentSession = this.mParentSession;
        if (parentSession == null) {
            return this.mSessionId;
        }
        if (Log.VERBOSE) {
            return parentSession.getFullSessionIdRecursive(parentCount + 1) + SESSION_SEPARATION_CHAR_CHILD + this.mSessionId;
        }
        return parentSession.getFullSessionIdRecursive(parentCount + 1);
    }

    private Session getRootSession(String callingMethod) {
        int currParentCount = 0;
        Session topNode = this;
        Session parentNode = topNode.getParentSession();
        while (parentNode != null) {
            if (currParentCount >= 25) {
                Slog.w(LOG_TAG, "getRootSession: Hit iteration limit from " + callingMethod);
                break;
            }
            topNode = parentNode;
            parentNode = topNode.getParentSession();
            ++currParentCount;
        }
        return topNode;
    }

    public String printFullSessionTree() {
        return this.getRootSession("printFullSessionTree").printSessionTree();
    }

    private String printSessionTree() {
        StringBuilder sb = new StringBuilder();
        if (!Flags.endSessionImprovements()) {
            this.printSessionTreeRecursive(0, sb, 0);
            return sb.toString();
        }
        int depth = 0;
        ArrayDeque<Session> deque = new ArrayDeque<Session>();
        deque.add(this);
        while (!deque.isEmpty()) {
            Session node = (Session)deque.pollFirst();
            sb.append("\t".repeat(depth));
            sb.append(node.toString());
            sb.append("\n");
            if (depth >= 25) {
                sb.append(TRUNCATE_STRING);
                --depth;
                continue;
            }
            SequencedCollection childSessions = node.getChildSessions().reversed();
            if (!childSessions.isEmpty()) {
                ++depth;
                for (Session child : childSessions) {
                    deque.addFirst(child);
                }
                continue;
            }
            --depth;
        }
        return sb.toString();
    }

    private void printSessionTreeRecursive(int tabI, StringBuilder sb, int currChildCount) {
        if (currChildCount >= 25) {
            Slog.w(LOG_TAG, "printSessionTree: Hit recursion limit!");
            sb.append(TRUNCATE_STRING);
            return;
        }
        sb.append(this.toString());
        for (Session child : this.mChildSessions) {
            sb.append("\n");
            for (int i = 0; i <= tabI; ++i) {
                sb.append("\t");
            }
            child.printSessionTreeRecursive(tabI + 1, sb, currChildCount + 1);
        }
    }

    @VisibleForTesting
    public String getFullMethodPath(boolean truncatePath) {
        StringBuilder sb = new StringBuilder();
        if (!Flags.endSessionImprovements()) {
            this.getFullMethodPathRecursive(sb, truncatePath, 0);
            return sb.toString();
        }
        Session parentSession = this.getParentSession();
        boolean isSessionStarted = parentSession == null || !this.getShortMethodName().equals(parentSession.getShortMethodName());
        int depth = 0;
        Session currSession = this;
        while (currSession != null) {
            String cache = currSession.mFullMethodPathCache;
            if (!TextUtils.isEmpty(cache) && !truncatePath) {
                sb.insert(0, cache);
                return sb.toString();
            }
            parentSession = currSession.getParentSession();
            if (currSession.isExternal()) {
                if (truncatePath) {
                    sb.insert(0, TRUNCATE_STRING);
                } else {
                    sb.insert(0, ")");
                    sb.insert(0, currSession.getShortMethodName());
                    sb.insert(0, "(");
                }
            } else {
                sb.insert(0, currSession.getShortMethodName());
            }
            if (parentSession != null) {
                sb.insert(0, SUBSESSION_SEPARATION_CHAR);
            }
            if (depth >= 25) {
                Slog.w(LOG_TAG, "getFullMethodPath: Hit iteration limit!");
                sb.insert(0, TRUNCATE_STRING);
                return sb.toString();
            }
            currSession = parentSession;
            ++depth;
        }
        if (isSessionStarted && !truncatePath) {
            this.mFullMethodPathCache = sb.toString();
        }
        return sb.toString();
    }

    private synchronized void getFullMethodPathRecursive(StringBuilder sb, boolean truncatePath, int parentCount) {
        if (parentCount >= 25) {
            Slog.w(LOG_TAG, "getFullMethodPathRecursive: Hit recursion limit!");
            sb.append(TRUNCATE_STRING);
            return;
        }
        if (!TextUtils.isEmpty(this.mFullMethodPathCache) && !truncatePath) {
            sb.append(this.mFullMethodPathCache);
            return;
        }
        Session parentSession = this.getParentSession();
        boolean isSessionStarted = false;
        if (parentSession != null) {
            isSessionStarted = !this.mShortMethodName.equals(parentSession.mShortMethodName);
            parentSession.getFullMethodPathRecursive(sb, truncatePath, parentCount + 1);
            sb.append(SUBSESSION_SEPARATION_CHAR);
        }
        if (this.isExternal()) {
            if (truncatePath) {
                sb.append(TRUNCATE_STRING);
            } else {
                sb.append("(");
                sb.append(this.mShortMethodName);
                sb.append(")");
            }
        } else {
            sb.append(this.mShortMethodName);
        }
        if (isSessionStarted && !truncatePath) {
            this.mFullMethodPathCache = sb.toString();
        }
    }

    private boolean isSessionExternal() {
        return this.getRootSession("isSessionExternal").isExternal();
    }

    public int hashCode() {
        int result = this.mSessionId.hashCode();
        result = 31 * result + this.mShortMethodName.hashCode();
        result = 31 * result + Long.hashCode(this.mExecutionStartTimeMs);
        result = 31 * result + Long.hashCode(this.mExecutionEndTimeMs);
        result = 31 * result + (this.mParentSession != null ? this.mParentSession.hashCode() : 0);
        result = 31 * result + this.mChildSessions.hashCode();
        result = 31 * result + (this.mIsCompleted ? 1 : 0);
        result = 31 * result + this.mChildCounter.hashCode();
        result = 31 * result + (this.mIsStartedFromActiveSession ? 1 : 0);
        result = 31 * result + (this.mOwnerInfo != null ? this.mOwnerInfo.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Session session = (Session)o;
        if (this.mExecutionStartTimeMs != session.mExecutionStartTimeMs) {
            return false;
        }
        if (this.mExecutionEndTimeMs != session.mExecutionEndTimeMs) {
            return false;
        }
        if (this.mIsCompleted != session.mIsCompleted) {
            return false;
        }
        if (this.mChildCounter.get() != session.mChildCounter.get()) {
            return false;
        }
        if (this.mIsStartedFromActiveSession != session.mIsStartedFromActiveSession) {
            return false;
        }
        if (!Objects.equals(this.mSessionId, session.mSessionId)) {
            return false;
        }
        if (!Objects.equals(this.mShortMethodName, session.mShortMethodName)) {
            return false;
        }
        if (!Objects.equals(this.mParentSession, session.mParentSession)) {
            return false;
        }
        if (!Objects.equals(this.mChildSessions, session.mChildSessions)) {
            return false;
        }
        return Objects.equals(this.mOwnerInfo, session.mOwnerInfo);
    }

    public String toString() {
        Session sessionToPrint = this;
        if (this.getParentSession() != null && this.isStartedFromActiveSession()) {
            sessionToPrint = this.getRootSession("toString");
        }
        StringBuilder methodName = new StringBuilder();
        methodName.append(sessionToPrint.getFullMethodPath(false));
        if (sessionToPrint.getOwnerInfo() != null && !sessionToPrint.getOwnerInfo().isEmpty()) {
            methodName.append("(");
            methodName.append(sessionToPrint.getOwnerInfo());
            methodName.append(")");
        }
        return methodName.toString() + "@" + sessionToPrint.getFullSessionId();
    }

    public static class Info
    implements Parcelable {
        public final String sessionId;
        public final String methodPath;
        public final String ownerInfo;
        @NonNull
        public static final Parcelable.Creator<Info> CREATOR = new Parcelable.Creator<Info>(){

            @Override
            public Info createFromParcel(Parcel source) {
                String id2 = source.readString();
                String methodName = source.readString();
                String ownerInfo = source.readString();
                return new Info(id2, methodName, ownerInfo);
            }

            public Info[] newArray(int size) {
                return new Info[size];
            }
        };

        private Info(String id2, String path, String owner) {
            this.sessionId = id2;
            this.methodPath = path;
            this.ownerInfo = owner;
        }

        public static Info getInfo(Session s) {
            return new Info(s.getFullSessionId(), s.getFullMethodPath(!Log.DEBUG && s.isSessionExternal()), s.getOwnerInfo());
        }

        public static Info getExternalInfo(Session s, @Nullable String ownerInfo) {
            String newInfo = ownerInfo != null && s.getOwnerInfo() != null ? s.getOwnerInfo() + "/" + ownerInfo : (ownerInfo != null ? ownerInfo : s.getOwnerInfo());
            return new Info(s.getFullSessionId(), s.getFullMethodPath(!Log.DEBUG && s.isSessionExternal()), newInfo);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel destination, int flags) {
            destination.writeString(this.sessionId);
            destination.writeString(this.methodPath);
            destination.writeString(this.ownerInfo);
        }
    }
}

