/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.ModemInfo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@SystemApi
public class PhoneCapability
implements Parcelable {
    public static final PhoneCapability DEFAULT_DSDS_CAPABILITY;
    public static final PhoneCapability DEFAULT_SSSS_CAPABILITY;
    @SystemApi
    public static final int DEVICE_NR_CAPABILITY_NSA = 1;
    @SystemApi
    public static final int DEVICE_NR_CAPABILITY_SA = 2;
    private final int mMaxActiveVoiceSubscriptions;
    private final int mMaxActiveDataSubscriptions;
    private final boolean mNetworkValidationBeforeSwitchSupported;
    @NonNull
    private final List<ModemInfo> mLogicalModemList;
    @NonNull
    private final int[] mDeviceNrCapabilities;
    @NonNull
    public static final Parcelable.Creator<PhoneCapability> CREATOR;

    public PhoneCapability(int maxActiveVoiceSubscriptions, int maxActiveDataSubscriptions, List<ModemInfo> logicalModemList, boolean networkValidationBeforeSwitchSupported, int[] deviceNrCapabilities) {
        this.mMaxActiveVoiceSubscriptions = maxActiveVoiceSubscriptions;
        this.mMaxActiveDataSubscriptions = maxActiveDataSubscriptions;
        this.mLogicalModemList = logicalModemList == null ? new ArrayList() : logicalModemList;
        this.mNetworkValidationBeforeSwitchSupported = networkValidationBeforeSwitchSupported;
        this.mDeviceNrCapabilities = deviceNrCapabilities;
    }

    private PhoneCapability(@NonNull Builder builder) {
        this.mMaxActiveVoiceSubscriptions = builder.mMaxActiveVoiceSubscriptions;
        this.mMaxActiveDataSubscriptions = builder.mMaxActiveDataSubscriptions;
        this.mLogicalModemList = builder.mLogicalModemList == null ? new ArrayList() : builder.mLogicalModemList;
        this.mNetworkValidationBeforeSwitchSupported = builder.mNetworkValidationBeforeSwitchSupported;
        this.mDeviceNrCapabilities = builder.mDeviceNrCapabilities;
    }

    public String toString() {
        return "mMaxActiveVoiceSubscriptions=" + this.mMaxActiveVoiceSubscriptions + " mMaxActiveDataSubscriptions=" + this.mMaxActiveDataSubscriptions + " mNetworkValidationBeforeSwitchSupported=" + this.mNetworkValidationBeforeSwitchSupported + " mDeviceNrCapability " + Arrays.toString(this.mDeviceNrCapabilities);
    }

    private PhoneCapability(Parcel in) {
        this.mMaxActiveVoiceSubscriptions = in.readInt();
        this.mMaxActiveDataSubscriptions = in.readInt();
        this.mNetworkValidationBeforeSwitchSupported = in.readBoolean();
        this.mLogicalModemList = new ArrayList<ModemInfo>();
        in.readList(this.mLogicalModemList, ModemInfo.class.getClassLoader(), ModemInfo.class);
        this.mDeviceNrCapabilities = in.createIntArray();
    }

    public int hashCode() {
        return Objects.hash(this.mMaxActiveVoiceSubscriptions, this.mMaxActiveDataSubscriptions, this.mLogicalModemList, this.mNetworkValidationBeforeSwitchSupported, Arrays.hashCode(this.mDeviceNrCapabilities));
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PhoneCapability) || this.hashCode() != o.hashCode()) {
            return false;
        }
        if (this == o) {
            return true;
        }
        PhoneCapability s = (PhoneCapability)o;
        return this.mMaxActiveVoiceSubscriptions == s.mMaxActiveVoiceSubscriptions && this.mMaxActiveDataSubscriptions == s.mMaxActiveDataSubscriptions && this.mNetworkValidationBeforeSwitchSupported == s.mNetworkValidationBeforeSwitchSupported && this.mLogicalModemList.equals(s.mLogicalModemList) && Arrays.equals(this.mDeviceNrCapabilities, s.mDeviceNrCapabilities);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mMaxActiveVoiceSubscriptions);
        dest.writeInt(this.mMaxActiveDataSubscriptions);
        dest.writeBoolean(this.mNetworkValidationBeforeSwitchSupported);
        dest.writeList(this.mLogicalModemList);
        dest.writeIntArray(this.mDeviceNrCapabilities);
    }

    @SystemApi
    public int getMaxActiveVoiceSubscriptions() {
        return this.mMaxActiveVoiceSubscriptions;
    }

    @SystemApi
    public int getMaxActiveDataSubscriptions() {
        return this.mMaxActiveDataSubscriptions;
    }

    public boolean isNetworkValidationBeforeSwitchSupported() {
        return this.mNetworkValidationBeforeSwitchSupported;
    }

    public List<ModemInfo> getLogicalModemList() {
        return this.mLogicalModemList;
    }

    @SystemApi
    @NonNull
    public int[] getDeviceNrCapabilities() {
        return this.mDeviceNrCapabilities == null ? new int[]{} : this.mDeviceNrCapabilities;
    }

    static {
        ModemInfo modemInfo1 = new ModemInfo(0, 0, true, true);
        ModemInfo modemInfo2 = new ModemInfo(1, 0, true, true);
        ArrayList<ModemInfo> logicalModemList = new ArrayList<ModemInfo>();
        logicalModemList.add(modemInfo1);
        logicalModemList.add(modemInfo2);
        int[] deviceNrCapabilities = new int[]{};
        DEFAULT_DSDS_CAPABILITY = new PhoneCapability(1, 1, logicalModemList, false, deviceNrCapabilities);
        logicalModemList = new ArrayList();
        logicalModemList.add(modemInfo1);
        DEFAULT_SSSS_CAPABILITY = new PhoneCapability(1, 1, logicalModemList, false, deviceNrCapabilities);
        CREATOR = new Parcelable.Creator(){

            public PhoneCapability createFromParcel(Parcel in) {
                return new PhoneCapability(in);
            }

            public PhoneCapability[] newArray(int size) {
                return new PhoneCapability[size];
            }
        };
    }

    public static class Builder {
        private int mMaxActiveVoiceSubscriptions = 0;
        private int mMaxActiveDataSubscriptions = 0;
        private boolean mNetworkValidationBeforeSwitchSupported = false;
        @NonNull
        private List<ModemInfo> mLogicalModemList = new ArrayList<ModemInfo>();
        @NonNull
        private int[] mDeviceNrCapabilities = new int[0];

        public Builder() {
        }

        public Builder(@NonNull PhoneCapability phoneCapability) {
            this.mMaxActiveVoiceSubscriptions = phoneCapability.mMaxActiveVoiceSubscriptions;
            this.mMaxActiveDataSubscriptions = phoneCapability.mMaxActiveDataSubscriptions;
            this.mNetworkValidationBeforeSwitchSupported = phoneCapability.mNetworkValidationBeforeSwitchSupported;
            this.mLogicalModemList = phoneCapability.mLogicalModemList;
            this.mDeviceNrCapabilities = phoneCapability.mDeviceNrCapabilities;
        }

        public Builder setMaxActiveVoiceSubscriptions(int maxActiveVoiceSubscriptions) {
            this.mMaxActiveVoiceSubscriptions = maxActiveVoiceSubscriptions;
            return this;
        }

        public Builder setMaxActiveDataSubscriptions(int maxActiveDataSubscriptions) {
            this.mMaxActiveDataSubscriptions = maxActiveDataSubscriptions;
            return this;
        }

        public Builder setNetworkValidationBeforeSwitchSupported(boolean networkValidationBeforeSwitchSupported) {
            this.mNetworkValidationBeforeSwitchSupported = networkValidationBeforeSwitchSupported;
            return this;
        }

        public Builder setLogicalModemList(@NonNull List<ModemInfo> logicalModemList) {
            this.mLogicalModemList = logicalModemList;
            return this;
        }

        public Builder setDeviceNrCapabilities(@NonNull int[] deviceNrCapabilities) {
            this.mDeviceNrCapabilities = deviceNrCapabilities;
            return this;
        }

        public PhoneCapability build() {
            return new PhoneCapability(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceNrCapability {
    }
}

