/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.util.Objects;
import java.util.regex.Pattern;

@SystemApi
public class PhoneNumberRange
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<PhoneNumberRange> CREATOR = new Parcelable.Creator<PhoneNumberRange>(){

        @Override
        public PhoneNumberRange createFromParcel(Parcel in) {
            return new PhoneNumberRange(in);
        }

        public PhoneNumberRange[] newArray(int size) {
            return new PhoneNumberRange[size];
        }
    };
    private final String mCountryCode;
    private final String mPrefix;
    private final String mLowerBound;
    private final String mUpperBound;

    public PhoneNumberRange(@NonNull String countryCode, @NonNull String prefix, @NonNull String lowerBound, @NonNull String upperBound) {
        this.validateLowerAndUpperBounds(lowerBound, upperBound);
        if (!Pattern.matches("[0-9]*", countryCode)) {
            throw new IllegalArgumentException("Country code must be all numeric");
        }
        if (!Pattern.matches("[0-9]*", prefix)) {
            throw new IllegalArgumentException("Prefix must be all numeric");
        }
        this.mCountryCode = countryCode;
        this.mPrefix = prefix;
        this.mLowerBound = lowerBound;
        this.mUpperBound = upperBound;
    }

    private PhoneNumberRange(Parcel in) {
        this.mCountryCode = in.readString();
        this.mPrefix = in.readString();
        this.mLowerBound = in.readString();
        this.mUpperBound = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mCountryCode);
        dest.writeString(this.mPrefix);
        dest.writeString(this.mLowerBound);
        dest.writeString(this.mUpperBound);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhoneNumberRange that = (PhoneNumberRange)o;
        return Objects.equals(this.mCountryCode, that.mCountryCode) && Objects.equals(this.mPrefix, that.mPrefix) && Objects.equals(this.mLowerBound, that.mLowerBound) && Objects.equals(this.mUpperBound, that.mUpperBound);
    }

    public int hashCode() {
        return Objects.hash(this.mCountryCode, this.mPrefix, this.mLowerBound, this.mUpperBound);
    }

    @NonNull
    public String toString() {
        return "PhoneNumberRange{mCountryCode='" + this.mCountryCode + '\'' + ", mPrefix='" + this.mPrefix + '\'' + ", mLowerBound='" + this.mLowerBound + '\'' + ", mUpperBound='" + this.mUpperBound + '\'' + '}';
    }

    private void validateLowerAndUpperBounds(String lowerBound, String upperBound) {
        if (lowerBound.length() != upperBound.length()) {
            throw new IllegalArgumentException("Lower and upper bounds must have the same length");
        }
        if (!Pattern.matches("[0-9]*", lowerBound)) {
            throw new IllegalArgumentException("Lower bound must be all numeric");
        }
        if (!Pattern.matches("[0-9]*", upperBound)) {
            throw new IllegalArgumentException("Upper bound must be all numeric");
        }
        if (Integer.parseInt(lowerBound) > Integer.parseInt(upperBound)) {
            throw new IllegalArgumentException("Lower bound must be lower than upper bound");
        }
    }

    public boolean matches(@NonNull String number) {
        String numberPostfix;
        String prefixWithCountryCode;
        String normalizedNumber = number.replaceAll("[^0-9]", "");
        if (normalizedNumber.startsWith(prefixWithCountryCode = this.mCountryCode + this.mPrefix)) {
            numberPostfix = normalizedNumber.substring(prefixWithCountryCode.length());
        } else if (normalizedNumber.startsWith(this.mPrefix)) {
            numberPostfix = normalizedNumber.substring(this.mPrefix.length());
        } else {
            return false;
        }
        try {
            int lower = Integer.parseInt(this.mLowerBound);
            int upper = Integer.parseInt(this.mUpperBound);
            int numberToCheck = Integer.parseInt(numberPostfix);
            return numberToCheck <= upper && numberToCheck >= lower;
        }
        catch (NumberFormatException e) {
            Log.e(PhoneNumberRange.class.getSimpleName(), "Invalid bounds or number.", e);
            return false;
        }
    }
}

