/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.UiccPortInfo;
import com.android.internal.telephony.util.TelephonyUtils;
import com.android.telephony.Rlog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class UiccCardInfo
implements Parcelable {
    private final boolean mIsEuicc;
    private final int mCardId;
    private final String mEid;
    private final String mIccId;
    private final int mPhysicalSlotIndex;
    private final boolean mIsRemovable;
    private final boolean mIsMultipleEnabledProfilesSupported;
    private final List<UiccPortInfo> mPortList;
    private boolean mIccIdAccessRestricted = false;
    @NonNull
    public static final Parcelable.Creator<UiccCardInfo> CREATOR = new Parcelable.Creator<UiccCardInfo>(){

        @Override
        public UiccCardInfo createFromParcel(Parcel in) {
            return new UiccCardInfo(in);
        }

        public UiccCardInfo[] newArray(int size) {
            return new UiccCardInfo[size];
        }
    };

    private UiccCardInfo(Parcel in) {
        this.mIsEuicc = in.readBoolean();
        this.mCardId = in.readInt();
        this.mEid = in.readString8();
        this.mIccId = in.readString8();
        this.mPhysicalSlotIndex = in.readInt();
        this.mIsRemovable = in.readBoolean();
        this.mIsMultipleEnabledProfilesSupported = in.readBoolean();
        this.mPortList = new ArrayList<UiccPortInfo>();
        in.readTypedList(this.mPortList, UiccPortInfo.CREATOR);
        this.mIccIdAccessRestricted = in.readBoolean();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeBoolean(this.mIsEuicc);
        dest.writeInt(this.mCardId);
        dest.writeString8(this.mEid);
        dest.writeString8(this.mIccId);
        dest.writeInt(this.mPhysicalSlotIndex);
        dest.writeBoolean(this.mIsRemovable);
        dest.writeBoolean(this.mIsMultipleEnabledProfilesSupported);
        dest.writeTypedList(this.mPortList, flags);
        dest.writeBoolean(this.mIccIdAccessRestricted);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public UiccCardInfo(boolean isEuicc, int cardId, String eid, int physicalSlotIndex, boolean isRemovable, boolean isMultipleEnabledProfilesSupported, @NonNull List<UiccPortInfo> portList) {
        this.mIsEuicc = isEuicc;
        this.mCardId = cardId;
        this.mEid = eid;
        this.mIccId = null;
        this.mPhysicalSlotIndex = physicalSlotIndex;
        this.mIsRemovable = isRemovable;
        this.mIsMultipleEnabledProfilesSupported = isMultipleEnabledProfilesSupported;
        this.mPortList = portList;
    }

    public boolean isEuicc() {
        return this.mIsEuicc;
    }

    public int getCardId() {
        return this.mCardId;
    }

    @Nullable
    public String getEid() {
        if (!this.mIsEuicc) {
            return null;
        }
        return this.mEid;
    }

    @Deprecated
    @Nullable
    public String getIccId() {
        if (this.mIccIdAccessRestricted) {
            throw new UnsupportedOperationException("getIccId() is not supported by UiccCardInfo. Please Use UiccPortInfo API instead");
        }
        return this.mPortList.isEmpty() ? null : this.mPortList.get(0).getIccId();
    }

    @Deprecated
    public int getSlotIndex() {
        return this.mPhysicalSlotIndex;
    }

    public int getPhysicalSlotIndex() {
        return this.mPhysicalSlotIndex;
    }

    public boolean isRemovable() {
        return this.mIsRemovable;
    }

    public boolean isMultipleEnabledProfilesSupported() {
        return this.mIsMultipleEnabledProfilesSupported;
    }

    @NonNull
    public Collection<UiccPortInfo> getPorts() {
        return Collections.unmodifiableList(this.mPortList);
    }

    public void setIccIdAccessRestricted(boolean iccIdAccessRestricted) {
        this.mIccIdAccessRestricted = iccIdAccessRestricted;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UiccCardInfo that = (UiccCardInfo)obj;
        return this.mIsEuicc == that.mIsEuicc && this.mCardId == that.mCardId && Objects.equals(this.mEid, that.mEid) && Objects.equals(this.mIccId, that.mIccId) && this.mPhysicalSlotIndex == that.mPhysicalSlotIndex && this.mIsRemovable == that.mIsRemovable && this.mIsMultipleEnabledProfilesSupported == that.mIsMultipleEnabledProfilesSupported && Objects.equals(this.mPortList, that.mPortList);
    }

    public int hashCode() {
        return Objects.hash(this.mIsEuicc, this.mCardId, this.mEid, this.mIccId, this.mPhysicalSlotIndex, this.mIsRemovable, this.mIsMultipleEnabledProfilesSupported, this.mPortList);
    }

    public String toString() {
        return "UiccCardInfo (mIsEuicc=" + this.mIsEuicc + ", mCardId=" + this.mCardId + ", mEid=" + Rlog.pii(TelephonyUtils.IS_DEBUGGABLE, (Object)this.mEid) + ", mPhysicalSlotIndex=" + this.mPhysicalSlotIndex + ", mIsRemovable=" + this.mIsRemovable + ", mIsMultipleEnabledProfilesSupported=" + this.mIsMultipleEnabledProfilesSupported + ", mPortList=" + this.mPortList + ", mIccIdAccessRestricted=" + this.mIccIdAccessRestricted + ")";
    }
}

