/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.data;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.ServiceState;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.telephony.util.TelephonyUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class ApnSetting
implements Parcelable {
    private static final String LOG_TAG = "ApnSetting";
    private static final boolean VDBG = false;
    private static final String V2_FORMAT_REGEX = "^\\[ApnSettingV2\\]\\s*";
    private static final String V3_FORMAT_REGEX = "^\\[ApnSettingV3\\]\\s*";
    private static final String V4_FORMAT_REGEX = "^\\[ApnSettingV4\\]\\s*";
    private static final String V5_FORMAT_REGEX = "^\\[ApnSettingV5\\]\\s*";
    private static final String V6_FORMAT_REGEX = "^\\[ApnSettingV6\\]\\s*";
    private static final String V7_FORMAT_REGEX = "^\\[ApnSettingV7\\]\\s*";
    public static final int UNSET_MTU = 0;
    private static final int UNSPECIFIED_INT = -1;
    private static final String UNSPECIFIED_STRING = "";
    public static final int TYPE_NONE = 0;
    public static final int TYPE_ALL = 255;
    public static final int TYPE_DEFAULT = 17;
    public static final int TYPE_MMS = 2;
    public static final int TYPE_SUPL = 4;
    public static final int TYPE_DUN = 8;
    public static final int TYPE_HIPRI = 16;
    public static final int TYPE_FOTA = 32;
    public static final int TYPE_IMS = 64;
    public static final int TYPE_CBS = 128;
    public static final int TYPE_IA = 256;
    public static final int TYPE_EMERGENCY = 512;
    public static final int TYPE_MCX = 1024;
    public static final int TYPE_XCAP = 2048;
    public static final int TYPE_VSIM = 4096;
    public static final int TYPE_BIP = 8192;
    public static final int TYPE_ENTERPRISE = 16384;
    public static final int TYPE_RCS = 32768;
    @FlaggedApi(value="com.android.internal.telephony.flags.oem_paid_private")
    public static final int TYPE_OEM_PAID = 65536;
    @FlaggedApi(value="com.android.internal.telephony.flags.oem_paid_private")
    public static final int TYPE_OEM_PRIVATE = 131072;
    public static final int AUTH_TYPE_UNKNOWN = -1;
    public static final int AUTH_TYPE_NONE = 0;
    public static final int AUTH_TYPE_PAP = 1;
    public static final int AUTH_TYPE_CHAP = 2;
    public static final int AUTH_TYPE_PAP_OR_CHAP = 3;
    @SystemApi
    public static final String TYPE_ALL_STRING = "*";
    @SystemApi
    public static final String TYPE_DEFAULT_STRING = "default";
    @SystemApi
    public static final String TYPE_MMS_STRING = "mms";
    @SystemApi
    public static final String TYPE_SUPL_STRING = "supl";
    @SystemApi
    public static final String TYPE_DUN_STRING = "dun";
    @SystemApi
    public static final String TYPE_HIPRI_STRING = "hipri";
    @SystemApi
    public static final String TYPE_FOTA_STRING = "fota";
    @SystemApi
    public static final String TYPE_IMS_STRING = "ims";
    @SystemApi
    public static final String TYPE_CBS_STRING = "cbs";
    @SystemApi
    public static final String TYPE_IA_STRING = "ia";
    @SystemApi
    public static final String TYPE_EMERGENCY_STRING = "emergency";
    @SystemApi
    public static final String TYPE_MCX_STRING = "mcx";
    @SystemApi
    public static final String TYPE_XCAP_STRING = "xcap";
    @SystemApi
    public static final String TYPE_VSIM_STRING = "vsim";
    @SystemApi
    public static final String TYPE_BIP_STRING = "bip";
    @SystemApi
    public static final String TYPE_ENTERPRISE_STRING = "enterprise";
    @SystemApi
    public static final String TYPE_RCS_STRING = "rcs";
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.oem_paid_private")
    public static final String TYPE_OEM_PAID_STRING = "oem_paid";
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.oem_paid_private")
    public static final String TYPE_OEM_PRIVATE_STRING = "oem_private";
    public static final int PROTOCOL_UNKNOWN = -1;
    public static final int PROTOCOL_IP = 0;
    public static final int PROTOCOL_IPV6 = 1;
    public static final int PROTOCOL_IPV4V6 = 2;
    public static final int PROTOCOL_PPP = 3;
    public static final int PROTOCOL_NON_IP = 4;
    public static final int PROTOCOL_UNSTRUCTURED = 5;
    public static final int MVNO_TYPE_UNKNOWN = -1;
    public static final int MVNO_TYPE_SPN = 0;
    public static final int MVNO_TYPE_IMSI = 1;
    public static final int MVNO_TYPE_GID = 2;
    public static final int MVNO_TYPE_ICCID = 3;
    public static final int INFRASTRUCTURE_CELLULAR = 1;
    public static final int INFRASTRUCTURE_SATELLITE = 2;
    private static final Map<String, Integer> APN_TYPE_STRING_MAP = new ArrayMap<String, Integer>();
    private static final Map<Integer, String> APN_TYPE_INT_MAP;
    private static final Map<String, Integer> PROTOCOL_STRING_MAP;
    private static final Map<Integer, String> PROTOCOL_INT_MAP;
    private static final Map<String, Integer> MVNO_TYPE_STRING_MAP;
    private static final Map<Integer, String> MVNO_TYPE_INT_MAP;
    private final String mEntryName;
    private final String mApnName;
    private final String mProxyAddress;
    private final int mProxyPort;
    private final Uri mMmsc;
    private final String mMmsProxyAddress;
    private final int mMmsProxyPort;
    private final String mUser;
    private final String mPassword;
    private final int mAuthType;
    private final int mApnTypeBitmask;
    private final int mId;
    private final String mOperatorNumeric;
    private final int mProtocol;
    private final int mRoamingProtocol;
    private final int mMtuV4;
    private final int mMtuV6;
    private final boolean mCarrierEnabled;
    private final int mNetworkTypeBitmask;
    private final long mLingeringNetworkTypeBitmask;
    private final int mProfileId;
    private final boolean mPersistent;
    private final int mMaxConns;
    private final int mWaitTime;
    private final int mMaxConnsTime;
    private final int mMvnoType;
    private final String mMvnoMatchData;
    private final int mApnSetId;
    private boolean mPermanentFailed = false;
    private final int mCarrierId;
    private final int mSkip464Xlat;
    private final boolean mAlwaysOn;
    private final int mInfrastructureBitmask;
    private final boolean mEsimBootstrapProvisioning;
    private final int mEditedStatus;
    @NonNull
    public static final Parcelable.Creator<ApnSetting> CREATOR;

    public int getMtuV4() {
        return this.mMtuV4;
    }

    public int getMtuV6() {
        return this.mMtuV6;
    }

    public int getProfileId() {
        return this.mProfileId;
    }

    public boolean isPersistent() {
        return this.mPersistent;
    }

    public int getMaxConns() {
        return this.mMaxConns;
    }

    public int getWaitTime() {
        return this.mWaitTime;
    }

    public int getMaxConnsTime() {
        return this.mMaxConnsTime;
    }

    public String getMvnoMatchData() {
        return this.mMvnoMatchData;
    }

    public int getApnSetId() {
        return this.mApnSetId;
    }

    public boolean getPermanentFailed() {
        return this.mPermanentFailed;
    }

    public void setPermanentFailed(boolean permanentFailed) {
        this.mPermanentFailed = permanentFailed;
    }

    public String getEntryName() {
        return this.mEntryName;
    }

    public String getApnName() {
        return this.mApnName;
    }

    @Deprecated
    public InetAddress getProxyAddress() {
        return ApnSetting.inetAddressFromString(this.mProxyAddress);
    }

    public String getProxyAddressAsString() {
        return this.mProxyAddress;
    }

    public int getProxyPort() {
        return this.mProxyPort;
    }

    public Uri getMmsc() {
        return this.mMmsc;
    }

    @Deprecated
    public InetAddress getMmsProxyAddress() {
        return ApnSetting.inetAddressFromString(this.mMmsProxyAddress);
    }

    public String getMmsProxyAddressAsString() {
        return this.mMmsProxyAddress;
    }

    public int getMmsProxyPort() {
        return this.mMmsProxyPort;
    }

    public String getUser() {
        return this.mUser;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public int getAuthType() {
        return this.mAuthType;
    }

    public int getApnTypeBitmask() {
        return this.mApnTypeBitmask;
    }

    public int getId() {
        return this.mId;
    }

    public String getOperatorNumeric() {
        return this.mOperatorNumeric;
    }

    public int getProtocol() {
        return this.mProtocol;
    }

    public int getRoamingProtocol() {
        return this.mRoamingProtocol;
    }

    public boolean isEnabled() {
        return this.mCarrierEnabled;
    }

    public int getNetworkTypeBitmask() {
        return this.mNetworkTypeBitmask;
    }

    public long getLingeringNetworkTypeBitmask() {
        return this.mLingeringNetworkTypeBitmask;
    }

    public int getMvnoType() {
        return this.mMvnoType;
    }

    public int getCarrierId() {
        return this.mCarrierId;
    }

    public int getSkip464Xlat() {
        return this.mSkip464Xlat;
    }

    public boolean isAlwaysOn() {
        return this.mAlwaysOn;
    }

    public boolean isForInfrastructure(int infrastructures) {
        return (this.mInfrastructureBitmask & infrastructures) != 0;
    }

    public int getInfrastructureBitmask() {
        return this.mInfrastructureBitmask;
    }

    public boolean isEsimBootstrapProvisioning() {
        return this.mEsimBootstrapProvisioning;
    }

    public int getEditedStatus() {
        return this.mEditedStatus;
    }

    private ApnSetting(Builder builder) {
        this.mEntryName = builder.mEntryName;
        this.mApnName = builder.mApnName;
        this.mProxyAddress = builder.mProxyAddress;
        this.mProxyPort = builder.mProxyPort;
        this.mMmsc = builder.mMmsc;
        this.mMmsProxyAddress = builder.mMmsProxyAddress;
        this.mMmsProxyPort = builder.mMmsProxyPort;
        this.mUser = builder.mUser;
        this.mPassword = builder.mPassword;
        this.mAuthType = builder.mAuthType != -1 ? builder.mAuthType : (TextUtils.isEmpty(builder.mUser) ? 0 : 3);
        this.mApnTypeBitmask = builder.mApnTypeBitmask;
        this.mId = builder.mId;
        this.mOperatorNumeric = builder.mOperatorNumeric;
        this.mProtocol = builder.mProtocol;
        this.mRoamingProtocol = builder.mRoamingProtocol;
        this.mMtuV4 = builder.mMtuV4;
        this.mMtuV6 = builder.mMtuV6;
        this.mCarrierEnabled = builder.mCarrierEnabled;
        this.mNetworkTypeBitmask = builder.mNetworkTypeBitmask;
        this.mLingeringNetworkTypeBitmask = builder.mLingeringNetworkTypeBitmask;
        this.mProfileId = builder.mProfileId;
        this.mPersistent = builder.mModemCognitive;
        this.mMaxConns = builder.mMaxConns;
        this.mWaitTime = builder.mWaitTime;
        this.mMaxConnsTime = builder.mMaxConnsTime;
        this.mMvnoType = builder.mMvnoType;
        this.mMvnoMatchData = builder.mMvnoMatchData;
        this.mApnSetId = builder.mApnSetId;
        this.mCarrierId = builder.mCarrierId;
        this.mSkip464Xlat = builder.mSkip464Xlat;
        this.mAlwaysOn = builder.mAlwaysOn;
        this.mInfrastructureBitmask = builder.mInfrastructureBitmask;
        this.mEsimBootstrapProvisioning = builder.mEsimBootstrapProvisioning;
        this.mEditedStatus = builder.mEditedStatus;
    }

    public static ApnSetting makeApnSetting(Cursor cursor) {
        int mtuV4;
        int apnTypesBitmask = ApnSetting.getApnTypesBitmaskFromString(cursor.getString(cursor.getColumnIndexOrThrow("type")));
        int networkTypeBitmask = cursor.getInt(cursor.getColumnIndexOrThrow("network_type_bitmask"));
        if (networkTypeBitmask == 0) {
            int bearerBitmask = cursor.getInt(cursor.getColumnIndexOrThrow("bearer_bitmask"));
            networkTypeBitmask = ServiceState.convertBearerBitmaskToNetworkTypeBitmask(bearerBitmask);
        }
        if ((mtuV4 = cursor.getInt(cursor.getColumnIndexOrThrow("mtu_v4"))) == 0) {
            mtuV4 = cursor.getInt(cursor.getColumnIndexOrThrow("mtu"));
        }
        return new Builder().setId(cursor.getInt(cursor.getColumnIndexOrThrow("_id"))).setOperatorNumeric(cursor.getString(cursor.getColumnIndexOrThrow("numeric"))).setEntryName(cursor.getString(cursor.getColumnIndexOrThrow("name"))).setApnName(cursor.getString(cursor.getColumnIndexOrThrow("apn"))).setProxyAddress(cursor.getString(cursor.getColumnIndexOrThrow("proxy"))).setProxyPort(ApnSetting.portFromString(cursor.getString(cursor.getColumnIndexOrThrow("port")))).setMmsc(ApnSetting.UriFromString(cursor.getString(cursor.getColumnIndexOrThrow("mmsc")))).setMmsProxyAddress(cursor.getString(cursor.getColumnIndexOrThrow("mmsproxy"))).setMmsProxyPort(ApnSetting.portFromString(cursor.getString(cursor.getColumnIndexOrThrow("mmsport")))).setUser(cursor.getString(cursor.getColumnIndexOrThrow("user"))).setPassword(cursor.getString(cursor.getColumnIndexOrThrow("password"))).setAuthType(cursor.getInt(cursor.getColumnIndexOrThrow("authtype"))).setApnTypeBitmask(apnTypesBitmask).setProtocol(ApnSetting.getProtocolIntFromString(cursor.getString(cursor.getColumnIndexOrThrow("protocol")))).setRoamingProtocol(ApnSetting.getProtocolIntFromString(cursor.getString(cursor.getColumnIndexOrThrow("roaming_protocol")))).setCarrierEnabled(cursor.getInt(cursor.getColumnIndexOrThrow("carrier_enabled")) == 1).setNetworkTypeBitmask(networkTypeBitmask).setLingeringNetworkTypeBitmask(cursor.getInt(cursor.getColumnIndexOrThrow("lingering_network_type_bitmask"))).setProfileId(cursor.getInt(cursor.getColumnIndexOrThrow("profile_id"))).setModemCognitive(cursor.getInt(cursor.getColumnIndexOrThrow("modem_cognitive")) == 1).setMaxConns(cursor.getInt(cursor.getColumnIndexOrThrow("max_conns"))).setWaitTime(cursor.getInt(cursor.getColumnIndexOrThrow("wait_time"))).setMaxConnsTime(cursor.getInt(cursor.getColumnIndexOrThrow("max_conns_time"))).setMtuV4(mtuV4).setMtuV6(cursor.getInt(cursor.getColumnIndexOrThrow("mtu_v6"))).setMvnoType(ApnSetting.getMvnoTypeIntFromString(cursor.getString(cursor.getColumnIndexOrThrow("mvno_type")))).setMvnoMatchData(cursor.getString(cursor.getColumnIndexOrThrow("mvno_match_data"))).setApnSetId(cursor.getInt(cursor.getColumnIndexOrThrow("apn_set_id"))).setCarrierId(cursor.getInt(cursor.getColumnIndexOrThrow("carrier_id"))).setSkip464Xlat(cursor.getInt(cursor.getColumnIndexOrThrow("skip_464xlat"))).setAlwaysOn(cursor.getInt(cursor.getColumnIndexOrThrow("always_on")) == 1).setInfrastructureBitmask(cursor.getInt(cursor.getColumnIndexOrThrow("infrastructure_bitmask"))).setEsimBootstrapProvisioning(cursor.getInt(cursor.getColumnIndexOrThrow("esim_bootstrap_provisioning")) == 1).setEditedStatus(cursor.getInt(cursor.getColumnIndexOrThrow("edited"))).buildWithoutCheck();
    }

    public static ApnSetting makeApnSetting(ApnSetting apn) {
        return new Builder().setId(apn.mId).setOperatorNumeric(apn.mOperatorNumeric).setEntryName(apn.mEntryName).setApnName(apn.mApnName).setProxyAddress(apn.mProxyAddress).setProxyPort(apn.mProxyPort).setMmsc(apn.mMmsc).setMmsProxyAddress(apn.mMmsProxyAddress).setMmsProxyPort(apn.mMmsProxyPort).setUser(apn.mUser).setPassword(apn.mPassword).setAuthType(apn.mAuthType).setApnTypeBitmask(apn.mApnTypeBitmask).setProtocol(apn.mProtocol).setRoamingProtocol(apn.mRoamingProtocol).setCarrierEnabled(apn.mCarrierEnabled).setNetworkTypeBitmask(apn.mNetworkTypeBitmask).setLingeringNetworkTypeBitmask(apn.mLingeringNetworkTypeBitmask).setProfileId(apn.mProfileId).setModemCognitive(apn.mPersistent).setMaxConns(apn.mMaxConns).setWaitTime(apn.mWaitTime).setMaxConnsTime(apn.mMaxConnsTime).setMtuV4(apn.mMtuV4).setMtuV6(apn.mMtuV6).setMvnoType(apn.mMvnoType).setMvnoMatchData(apn.mMvnoMatchData).setApnSetId(apn.mApnSetId).setCarrierId(apn.mCarrierId).setSkip464Xlat(apn.mSkip464Xlat).setAlwaysOn(apn.mAlwaysOn).setInfrastructureBitmask(apn.mInfrastructureBitmask).setEsimBootstrapProvisioning(apn.mEsimBootstrapProvisioning).setEditedStatus(apn.mEditedStatus).buildWithoutCheck();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ApnSetting] ").append(this.mEntryName).append(", ").append(this.mId).append(", ").append(this.mOperatorNumeric).append(", ").append(this.mApnName).append(", ").append(this.mProxyAddress).append(", ").append(ApnSetting.UriToString(this.mMmsc)).append(", ").append(this.mMmsProxyAddress).append(", ").append(ApnSetting.portToString(this.mMmsProxyPort)).append(", ").append(ApnSetting.portToString(this.mProxyPort)).append(", ").append(this.mAuthType).append(", ");
        Object[] types = ApnSetting.getApnTypesStringFromBitmask(this.mApnTypeBitmask).split(",");
        sb.append(TextUtils.join((CharSequence)" | ", types));
        sb.append(", ").append(PROTOCOL_INT_MAP.get(this.mProtocol));
        sb.append(", ").append(PROTOCOL_INT_MAP.get(this.mRoamingProtocol));
        sb.append(", ").append(this.mCarrierEnabled);
        sb.append(", ").append(this.mProfileId);
        sb.append(", ").append(this.mPersistent);
        sb.append(", ").append(this.mMaxConns);
        sb.append(", ").append(this.mWaitTime);
        sb.append(", ").append(this.mMaxConnsTime);
        sb.append(", ").append(this.mMtuV4);
        sb.append(", ").append(this.mMtuV6);
        sb.append(", ").append(MVNO_TYPE_INT_MAP.get(this.mMvnoType));
        sb.append(", ").append(this.mMvnoMatchData);
        sb.append(", ").append(this.mPermanentFailed);
        sb.append(", ").append(TelephonyManager.convertNetworkTypeBitmaskToString(this.mNetworkTypeBitmask));
        sb.append(", ").append(TelephonyManager.convertNetworkTypeBitmaskToString(this.mLingeringNetworkTypeBitmask));
        sb.append(", ").append(this.mApnSetId);
        sb.append(", ").append(this.mCarrierId);
        sb.append(", ").append(this.mSkip464Xlat);
        sb.append(", ").append(this.mAlwaysOn);
        sb.append(", ").append(this.mInfrastructureBitmask);
        sb.append(", ").append(Objects.hash(this.mUser, this.mPassword));
        sb.append(", ").append(this.mEsimBootstrapProvisioning);
        sb.append(", ").append(TelephonyUtils.apnEditedStatusToString(this.mEditedStatus));
        return sb.toString();
    }

    public boolean hasMvnoParams() {
        return !TextUtils.isEmpty(ApnSetting.getMvnoTypeStringFromInt(this.mMvnoType)) && !TextUtils.isEmpty(this.mMvnoMatchData);
    }

    private boolean hasApnType(int type) {
        return (this.mApnTypeBitmask & type) == type;
    }

    public boolean isEmergencyApn() {
        return this.hasApnType(512);
    }

    public boolean canHandleType(int type) {
        if (!this.mCarrierEnabled) {
            return false;
        }
        return this.hasApnType(type);
    }

    private boolean typeSameAny(ApnSetting first, ApnSetting second) {
        return (first.mApnTypeBitmask & second.mApnTypeBitmask) != 0;
    }

    public int hashCode() {
        return Objects.hash(this.mApnName, this.mProxyAddress, this.mProxyPort, this.mMmsc, this.mMmsProxyAddress, this.mMmsProxyPort, this.mUser, this.mPassword, this.mAuthType, this.mApnTypeBitmask, this.mId, this.mOperatorNumeric, this.mProtocol, this.mRoamingProtocol, this.mMtuV4, this.mMtuV6, this.mCarrierEnabled, this.mNetworkTypeBitmask, this.mLingeringNetworkTypeBitmask, this.mProfileId, this.mPersistent, this.mMaxConns, this.mWaitTime, this.mMaxConnsTime, this.mMvnoType, this.mMvnoMatchData, this.mApnSetId, this.mCarrierId, this.mSkip464Xlat, this.mAlwaysOn, this.mInfrastructureBitmask, this.mEsimBootstrapProvisioning);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ApnSetting)) {
            return false;
        }
        ApnSetting other = (ApnSetting)o;
        return this.mEntryName.equals(other.mEntryName) && this.mId == other.mId && Objects.equals(this.mOperatorNumeric, other.mOperatorNumeric) && Objects.equals(this.mApnName, other.mApnName) && Objects.equals(this.mProxyAddress, other.mProxyAddress) && Objects.equals(this.mMmsc, other.mMmsc) && Objects.equals(this.mMmsProxyAddress, other.mMmsProxyAddress) && this.mMmsProxyPort == other.mMmsProxyPort && this.mProxyPort == other.mProxyPort && Objects.equals(this.mUser, other.mUser) && Objects.equals(this.mPassword, other.mPassword) && this.mAuthType == other.mAuthType && this.mApnTypeBitmask == other.mApnTypeBitmask && this.mProtocol == other.mProtocol && this.mRoamingProtocol == other.mRoamingProtocol && this.mCarrierEnabled == other.mCarrierEnabled && this.mProfileId == other.mProfileId && this.mPersistent == other.mPersistent && this.mMaxConns == other.mMaxConns && this.mWaitTime == other.mWaitTime && this.mMaxConnsTime == other.mMaxConnsTime && this.mMtuV4 == other.mMtuV4 && this.mMtuV6 == other.mMtuV6 && this.mMvnoType == other.mMvnoType && Objects.equals(this.mMvnoMatchData, other.mMvnoMatchData) && this.mNetworkTypeBitmask == other.mNetworkTypeBitmask && this.mLingeringNetworkTypeBitmask == other.mLingeringNetworkTypeBitmask && this.mApnSetId == other.mApnSetId && this.mCarrierId == other.mCarrierId && this.mSkip464Xlat == other.mSkip464Xlat && this.mAlwaysOn == other.mAlwaysOn && this.mInfrastructureBitmask == other.mInfrastructureBitmask && this.mEsimBootstrapProvisioning == other.mEsimBootstrapProvisioning;
    }

    public boolean equals(Object o, boolean isDataRoaming) {
        if (!(o instanceof ApnSetting)) {
            return false;
        }
        ApnSetting other = (ApnSetting)o;
        return !(!this.mEntryName.equals(other.mEntryName) || !Objects.equals(this.mOperatorNumeric, other.mOperatorNumeric) || !Objects.equals(this.mApnName, other.mApnName) || !Objects.equals(this.mProxyAddress, other.mProxyAddress) || !Objects.equals(this.mMmsc, other.mMmsc) || !Objects.equals(this.mMmsProxyAddress, other.mMmsProxyAddress) || !Objects.equals(this.mMmsProxyPort, other.mMmsProxyPort) || !Objects.equals(this.mProxyPort, other.mProxyPort) || !Objects.equals(this.mUser, other.mUser) || !Objects.equals(this.mPassword, other.mPassword) || !Objects.equals(this.mAuthType, other.mAuthType) || !Objects.equals(this.mApnTypeBitmask, other.mApnTypeBitmask) || !Objects.equals(this.mLingeringNetworkTypeBitmask, other.mLingeringNetworkTypeBitmask) || !isDataRoaming && !Objects.equals(this.mProtocol, other.mProtocol) || isDataRoaming && !Objects.equals(this.mRoamingProtocol, other.mRoamingProtocol) || !Objects.equals(this.mCarrierEnabled, other.mCarrierEnabled) || !Objects.equals(this.mProfileId, other.mProfileId) || !Objects.equals(this.mPersistent, other.mPersistent) || !Objects.equals(this.mMaxConns, other.mMaxConns) || !Objects.equals(this.mWaitTime, other.mWaitTime) || !Objects.equals(this.mMaxConnsTime, other.mMaxConnsTime) || !Objects.equals(this.mMtuV4, other.mMtuV4) || !Objects.equals(this.mMtuV6, other.mMtuV6) || !Objects.equals(this.mMvnoType, other.mMvnoType) || !Objects.equals(this.mMvnoMatchData, other.mMvnoMatchData) || !Objects.equals(this.mApnSetId, other.mApnSetId) || !Objects.equals(this.mCarrierId, other.mCarrierId) || !Objects.equals(this.mSkip464Xlat, other.mSkip464Xlat) || !Objects.equals(this.mAlwaysOn, other.mAlwaysOn) || !Objects.equals(this.mInfrastructureBitmask, other.mInfrastructureBitmask) || !Objects.equals(this.mEsimBootstrapProvisioning, other.mEsimBootstrapProvisioning));
    }

    public boolean similar(ApnSetting other) {
        return !this.canHandleType(8) && !other.canHandleType(8) && Objects.equals(this.mApnName, other.mApnName) && this.xorEqualsString(this.mProxyAddress, other.mProxyAddress) && this.xorEqualsInt(this.mProxyPort, other.mProxyPort) && this.xorEquals(this.mMmsc, other.mMmsc) && this.xorEqualsString(this.mMmsProxyAddress, other.mMmsProxyAddress) && this.xorEqualsInt(this.mMmsProxyPort, other.mMmsProxyPort) && this.xorEqualsString(this.mUser, other.mUser) && this.xorEqualsString(this.mPassword, other.mPassword) && Objects.equals(this.mAuthType, other.mAuthType) && !this.typeSameAny(this, other) && Objects.equals(this.mOperatorNumeric, other.mOperatorNumeric) && Objects.equals(this.mProtocol, other.mProtocol) && Objects.equals(this.mRoamingProtocol, other.mRoamingProtocol) && this.mtuUnsetOrEquals(this.mMtuV4, other.mMtuV4) && this.mtuUnsetOrEquals(this.mMtuV6, other.mMtuV6) && Objects.equals(this.mCarrierEnabled, other.mCarrierEnabled) && Objects.equals(this.mNetworkTypeBitmask, other.mNetworkTypeBitmask) && Objects.equals(this.mLingeringNetworkTypeBitmask, other.mLingeringNetworkTypeBitmask) && Objects.equals(this.mProfileId, other.mProfileId) && Objects.equals(this.mPersistent, other.mPersistent) && Objects.equals(this.mApnSetId, other.mApnSetId) && Objects.equals(this.mCarrierId, other.mCarrierId) && Objects.equals(this.mSkip464Xlat, other.mSkip464Xlat) && Objects.equals(this.mAlwaysOn, other.mAlwaysOn) && Objects.equals(this.mInfrastructureBitmask, other.mInfrastructureBitmask) && Objects.equals(this.mEsimBootstrapProvisioning, other.mEsimBootstrapProvisioning);
    }

    private boolean xorEquals(Object first, Object second) {
        return first == null || second == null || first.equals(second);
    }

    private boolean xorEqualsString(String first, String second) {
        return TextUtils.isEmpty(first) || TextUtils.isEmpty(second) || first.equals(second);
    }

    private boolean xorEqualsInt(int first, int second) {
        return first == -1 || second == -1 || first == second;
    }

    private boolean mtuUnsetOrEquals(int first, int second) {
        return first <= 0 || second <= 0 || first == second;
    }

    private String nullToEmpty(String stringValue) {
        return stringValue == null ? UNSPECIFIED_STRING : stringValue;
    }

    public ContentValues toContentValues() {
        ContentValues apnValue = new ContentValues();
        apnValue.put("numeric", this.nullToEmpty(this.mOperatorNumeric));
        if (!(TextUtils.isEmpty(this.mOperatorNumeric) || this.mOperatorNumeric.length() != 5 && this.mOperatorNumeric.length() != 6)) {
            apnValue.put("mcc", this.mOperatorNumeric.substring(0, 3));
            apnValue.put("mnc", this.mOperatorNumeric.substring(3));
        }
        apnValue.put("name", this.nullToEmpty(this.mEntryName));
        apnValue.put("apn", this.nullToEmpty(this.mApnName));
        apnValue.put("proxy", this.nullToEmpty(this.mProxyAddress));
        apnValue.put("port", this.nullToEmpty(ApnSetting.portToString(this.mProxyPort)));
        apnValue.put("mmsc", this.nullToEmpty(ApnSetting.UriToString(this.mMmsc)));
        apnValue.put("mmsport", this.nullToEmpty(ApnSetting.portToString(this.mMmsProxyPort)));
        apnValue.put("mmsproxy", this.nullToEmpty(this.mMmsProxyAddress));
        apnValue.put("user", this.nullToEmpty(this.mUser));
        apnValue.put("password", this.nullToEmpty(this.mPassword));
        apnValue.put("authtype", this.mAuthType);
        String apnType = ApnSetting.getApnTypesStringFromBitmask(this.mApnTypeBitmask);
        apnValue.put("type", this.nullToEmpty(apnType));
        apnValue.put("protocol", ApnSetting.getProtocolStringFromInt(this.mProtocol));
        apnValue.put("roaming_protocol", ApnSetting.getProtocolStringFromInt(this.mRoamingProtocol));
        apnValue.put("carrier_enabled", this.mCarrierEnabled);
        apnValue.put("mvno_type", ApnSetting.getMvnoTypeStringFromInt(this.mMvnoType));
        apnValue.put("mvno_match_data", this.nullToEmpty(this.mMvnoMatchData));
        apnValue.put("network_type_bitmask", this.mNetworkTypeBitmask);
        apnValue.put("lingering_network_type_bitmask", this.mLingeringNetworkTypeBitmask);
        apnValue.put("mtu_v4", this.mMtuV4);
        apnValue.put("mtu_v6", this.mMtuV6);
        apnValue.put("carrier_id", this.mCarrierId);
        apnValue.put("skip_464xlat", this.mSkip464Xlat);
        apnValue.put("always_on", this.mAlwaysOn);
        apnValue.put("infrastructure_bitmask", this.mInfrastructureBitmask);
        apnValue.put("esim_bootstrap_provisioning", this.mEsimBootstrapProvisioning);
        return apnValue;
    }

    public List<Integer> getApnTypes() {
        ArrayList<Integer> types = new ArrayList<Integer>();
        for (Integer type : APN_TYPE_INT_MAP.keySet()) {
            if ((this.mApnTypeBitmask & type) != type) continue;
            types.add(type);
        }
        return types;
    }

    @NonNull
    public static String getApnTypesStringFromBitmask(int apnTypeBitmask) {
        ArrayList<String> types = new ArrayList<String>();
        for (Integer type : APN_TYPE_INT_MAP.keySet()) {
            if ((apnTypeBitmask & type) != type) continue;
            types.add(APN_TYPE_INT_MAP.get(type));
        }
        return TextUtils.join((CharSequence)",", types);
    }

    @NonNull
    public static int[] getApnTypesFromBitmask(int apnTypeBitmask) {
        return APN_TYPE_INT_MAP.keySet().stream().filter(type -> (apnTypeBitmask & type) == type).mapToInt(Integer::intValue).toArray();
    }

    @SystemApi
    @NonNull
    public static String getApnTypeString(int apnType) {
        if (apnType == 255) {
            return TYPE_ALL_STRING;
        }
        String apnTypeString = APN_TYPE_INT_MAP.get(apnType);
        return apnTypeString == null ? UNSPECIFIED_STRING : apnTypeString;
    }

    @SystemApi
    public static int getApnTypeInt(@NonNull String apnType) {
        return APN_TYPE_STRING_MAP.getOrDefault(apnType.toLowerCase(Locale.ROOT), 0);
    }

    public static int getApnTypesBitmaskFromString(String types) {
        if (TextUtils.isEmpty(types)) {
            return 255;
        }
        int result = 0;
        for (String str : types.split(",")) {
            Integer type = APN_TYPE_STRING_MAP.get(str.toLowerCase(Locale.ROOT));
            if (type == null) continue;
            result |= type.intValue();
        }
        return result;
    }

    public static int getMvnoTypeIntFromString(String mvnoType) {
        String mvnoTypeString = TextUtils.isEmpty(mvnoType) ? mvnoType : mvnoType.toLowerCase(Locale.ROOT);
        Integer mvnoTypeInt = MVNO_TYPE_STRING_MAP.get(mvnoTypeString);
        return mvnoTypeInt == null ? -1 : mvnoTypeInt;
    }

    public static String getMvnoTypeStringFromInt(int mvnoType) {
        String mvnoTypeString = MVNO_TYPE_INT_MAP.get(mvnoType);
        return mvnoTypeString == null ? UNSPECIFIED_STRING : mvnoTypeString;
    }

    public static int getProtocolIntFromString(String protocol) {
        Integer protocolInt = PROTOCOL_STRING_MAP.get(protocol);
        return protocolInt == null ? -1 : protocolInt;
    }

    public static String getProtocolStringFromInt(int protocol) {
        String protocolString = PROTOCOL_INT_MAP.get(protocol);
        return protocolString == null ? UNSPECIFIED_STRING : protocolString;
    }

    private static Uri UriFromString(String uri) {
        return TextUtils.isEmpty(uri) ? null : Uri.parse(uri);
    }

    private static String UriToString(Uri uri) {
        return uri == null ? null : uri.toString();
    }

    public static InetAddress inetAddressFromString(String inetAddress) {
        if (TextUtils.isEmpty(inetAddress)) {
            return null;
        }
        try {
            return InetAddress.getByName(inetAddress);
        }
        catch (UnknownHostException e) {
            Log.e(LOG_TAG, "Can't parse InetAddress from string: unknown host.");
            return null;
        }
    }

    public static String inetAddressToString(InetAddress inetAddress) {
        if (inetAddress == null) {
            return null;
        }
        String inetAddressString = ((Object)inetAddress).toString();
        if (TextUtils.isEmpty(inetAddressString)) {
            return null;
        }
        String hostName = inetAddressString.substring(0, inetAddressString.indexOf("/"));
        String address = inetAddressString.substring(inetAddressString.indexOf("/") + 1);
        if (TextUtils.isEmpty(hostName) && TextUtils.isEmpty(address)) {
            return null;
        }
        return TextUtils.isEmpty(hostName) ? address : hostName;
    }

    private static int portFromString(String strPort) {
        int port = -1;
        if (!TextUtils.isEmpty(strPort)) {
            try {
                port = Integer.parseInt(strPort);
            }
            catch (NumberFormatException e) {
                Log.e(LOG_TAG, "Can't parse port from String");
            }
        }
        return port;
    }

    private static String portToString(int port) {
        return port == -1 ? null : Integer.toString(port);
    }

    public boolean canSupportNetworkType(int networkType) {
        if (networkType == 16 && ((long)this.mNetworkTypeBitmask & 3L) != 0L) {
            return true;
        }
        return ServiceState.bitmaskHasTech(this.mNetworkTypeBitmask, networkType);
    }

    public boolean canSupportLingeringNetworkType(int networkType) {
        if (this.mLingeringNetworkTypeBitmask == 0L) {
            return this.canSupportNetworkType(networkType);
        }
        if (networkType == 16 && (this.mLingeringNetworkTypeBitmask & 3L) != 0L) {
            return true;
        }
        return ServiceState.bitmaskHasTech((int)this.mLingeringNetworkTypeBitmask, networkType);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mId);
        dest.writeString(this.mOperatorNumeric);
        dest.writeString(this.mEntryName);
        dest.writeString(this.mApnName);
        dest.writeString(this.mProxyAddress);
        dest.writeInt(this.mProxyPort);
        dest.writeParcelable(this.mMmsc, flags);
        dest.writeString(this.mMmsProxyAddress);
        dest.writeInt(this.mMmsProxyPort);
        dest.writeString(this.mUser);
        dest.writeString(this.mPassword);
        dest.writeInt(this.mAuthType);
        dest.writeInt(this.mApnTypeBitmask);
        dest.writeInt(this.mProtocol);
        dest.writeInt(this.mRoamingProtocol);
        dest.writeBoolean(this.mCarrierEnabled);
        dest.writeInt(this.mNetworkTypeBitmask);
        dest.writeLong(this.mLingeringNetworkTypeBitmask);
        dest.writeInt(this.mProfileId);
        dest.writeBoolean(this.mPersistent);
        dest.writeInt(this.mMaxConns);
        dest.writeInt(this.mWaitTime);
        dest.writeInt(this.mMaxConnsTime);
        dest.writeInt(this.mMtuV4);
        dest.writeInt(this.mMtuV6);
        dest.writeInt(this.mMvnoType);
        dest.writeString(this.mMvnoMatchData);
        dest.writeInt(this.mApnSetId);
        dest.writeInt(this.mCarrierId);
        dest.writeInt(this.mSkip464Xlat);
        dest.writeBoolean(this.mAlwaysOn);
        dest.writeInt(this.mInfrastructureBitmask);
        dest.writeBoolean(this.mEsimBootstrapProvisioning);
        dest.writeInt(this.mEditedStatus);
    }

    private static ApnSetting readFromParcel(Parcel in) {
        return new Builder().setId(in.readInt()).setOperatorNumeric(in.readString()).setEntryName(in.readString()).setApnName(in.readString()).setProxyAddress(in.readString()).setProxyPort(in.readInt()).setMmsc(in.readParcelable(Uri.class.getClassLoader(), Uri.class)).setMmsProxyAddress(in.readString()).setMmsProxyPort(in.readInt()).setUser(in.readString()).setPassword(in.readString()).setAuthType(in.readInt()).setApnTypeBitmask(in.readInt()).setProtocol(in.readInt()).setRoamingProtocol(in.readInt()).setCarrierEnabled(in.readBoolean()).setNetworkTypeBitmask(in.readInt()).setLingeringNetworkTypeBitmask(in.readLong()).setProfileId(in.readInt()).setModemCognitive(in.readBoolean()).setMaxConns(in.readInt()).setWaitTime(in.readInt()).setMaxConnsTime(in.readInt()).setMtuV4(in.readInt()).setMtuV6(in.readInt()).setMvnoType(in.readInt()).setMvnoMatchData(in.readString()).setApnSetId(in.readInt()).setCarrierId(in.readInt()).setSkip464Xlat(in.readInt()).setAlwaysOn(in.readBoolean()).setInfrastructureBitmask(in.readInt()).setEsimBootstrapProvisioning(in.readBoolean()).setEditedStatus(in.readInt()).buildWithoutCheck();
    }

    static {
        APN_TYPE_STRING_MAP.put(TYPE_ALL_STRING, 255);
        APN_TYPE_STRING_MAP.put(TYPE_DEFAULT_STRING, 17);
        APN_TYPE_STRING_MAP.put(TYPE_MMS_STRING, 2);
        APN_TYPE_STRING_MAP.put(TYPE_SUPL_STRING, 4);
        APN_TYPE_STRING_MAP.put(TYPE_DUN_STRING, 8);
        APN_TYPE_STRING_MAP.put(TYPE_HIPRI_STRING, 16);
        APN_TYPE_STRING_MAP.put(TYPE_FOTA_STRING, 32);
        APN_TYPE_STRING_MAP.put(TYPE_IMS_STRING, 64);
        APN_TYPE_STRING_MAP.put(TYPE_CBS_STRING, 128);
        APN_TYPE_STRING_MAP.put(TYPE_IA_STRING, 256);
        APN_TYPE_STRING_MAP.put(TYPE_EMERGENCY_STRING, 512);
        APN_TYPE_STRING_MAP.put(TYPE_MCX_STRING, 1024);
        APN_TYPE_STRING_MAP.put(TYPE_XCAP_STRING, 2048);
        APN_TYPE_STRING_MAP.put(TYPE_ENTERPRISE_STRING, 16384);
        APN_TYPE_STRING_MAP.put(TYPE_VSIM_STRING, 4096);
        APN_TYPE_STRING_MAP.put(TYPE_BIP_STRING, 8192);
        APN_TYPE_STRING_MAP.put(TYPE_RCS_STRING, 32768);
        APN_TYPE_STRING_MAP.put(TYPE_OEM_PAID_STRING, 65536);
        APN_TYPE_STRING_MAP.put(TYPE_OEM_PRIVATE_STRING, 131072);
        APN_TYPE_INT_MAP = new ArrayMap<Integer, String>();
        APN_TYPE_INT_MAP.put(17, TYPE_DEFAULT_STRING);
        APN_TYPE_INT_MAP.put(2, TYPE_MMS_STRING);
        APN_TYPE_INT_MAP.put(4, TYPE_SUPL_STRING);
        APN_TYPE_INT_MAP.put(8, TYPE_DUN_STRING);
        APN_TYPE_INT_MAP.put(16, TYPE_HIPRI_STRING);
        APN_TYPE_INT_MAP.put(32, TYPE_FOTA_STRING);
        APN_TYPE_INT_MAP.put(64, TYPE_IMS_STRING);
        APN_TYPE_INT_MAP.put(128, TYPE_CBS_STRING);
        APN_TYPE_INT_MAP.put(256, TYPE_IA_STRING);
        APN_TYPE_INT_MAP.put(512, TYPE_EMERGENCY_STRING);
        APN_TYPE_INT_MAP.put(1024, TYPE_MCX_STRING);
        APN_TYPE_INT_MAP.put(2048, TYPE_XCAP_STRING);
        APN_TYPE_INT_MAP.put(16384, TYPE_ENTERPRISE_STRING);
        APN_TYPE_INT_MAP.put(4096, TYPE_VSIM_STRING);
        APN_TYPE_INT_MAP.put(8192, TYPE_BIP_STRING);
        APN_TYPE_INT_MAP.put(32768, TYPE_RCS_STRING);
        APN_TYPE_INT_MAP.put(65536, TYPE_OEM_PAID_STRING);
        APN_TYPE_INT_MAP.put(131072, TYPE_OEM_PRIVATE_STRING);
        PROTOCOL_STRING_MAP = new ArrayMap<String, Integer>();
        PROTOCOL_STRING_MAP.put("IP", 0);
        PROTOCOL_STRING_MAP.put("IPV6", 1);
        PROTOCOL_STRING_MAP.put("IPV4V6", 2);
        PROTOCOL_STRING_MAP.put("PPP", 3);
        PROTOCOL_STRING_MAP.put("NON-IP", 4);
        PROTOCOL_STRING_MAP.put("UNSTRUCTURED", 5);
        PROTOCOL_INT_MAP = new ArrayMap<Integer, String>();
        PROTOCOL_INT_MAP.put(0, "IP");
        PROTOCOL_INT_MAP.put(1, "IPV6");
        PROTOCOL_INT_MAP.put(2, "IPV4V6");
        PROTOCOL_INT_MAP.put(3, "PPP");
        PROTOCOL_INT_MAP.put(4, "NON-IP");
        PROTOCOL_INT_MAP.put(5, "UNSTRUCTURED");
        MVNO_TYPE_STRING_MAP = new ArrayMap<String, Integer>();
        MVNO_TYPE_STRING_MAP.put("spn", 0);
        MVNO_TYPE_STRING_MAP.put("imsi", 1);
        MVNO_TYPE_STRING_MAP.put("gid", 2);
        MVNO_TYPE_STRING_MAP.put("iccid", 3);
        MVNO_TYPE_INT_MAP = new ArrayMap<Integer, String>();
        MVNO_TYPE_INT_MAP.put(0, "spn");
        MVNO_TYPE_INT_MAP.put(1, "imsi");
        MVNO_TYPE_INT_MAP.put(2, "gid");
        MVNO_TYPE_INT_MAP.put(3, "iccid");
        CREATOR = new Parcelable.Creator<ApnSetting>(){

            @Override
            public ApnSetting createFromParcel(Parcel in) {
                return ApnSetting.readFromParcel(in);
            }

            public ApnSetting[] newArray(int size) {
                return new ApnSetting[size];
            }
        };
    }

    public static class Builder {
        private String mEntryName;
        private String mApnName;
        private String mProxyAddress;
        private int mProxyPort = -1;
        private Uri mMmsc;
        private String mMmsProxyAddress;
        private int mMmsProxyPort = -1;
        private String mUser;
        private String mPassword;
        private int mAuthType = -1;
        private int mApnTypeBitmask;
        private int mId;
        private String mOperatorNumeric;
        private int mProtocol = -1;
        private int mRoamingProtocol = -1;
        private int mMtuV4;
        private int mMtuV6;
        private int mNetworkTypeBitmask;
        private long mLingeringNetworkTypeBitmask;
        private boolean mCarrierEnabled;
        private int mProfileId;
        private boolean mModemCognitive;
        private int mMaxConns;
        private int mWaitTime;
        private int mMaxConnsTime;
        private int mMvnoType = -1;
        private String mMvnoMatchData;
        private int mApnSetId;
        private int mCarrierId = -1;
        private int mSkip464Xlat = -1;
        private boolean mAlwaysOn;
        private int mInfrastructureBitmask = 3;
        private boolean mEsimBootstrapProvisioning;
        private int mEditedStatus = 0;

        public Builder setId(int id2) {
            this.mId = id2;
            return this;
        }

        @NonNull
        public Builder setMtuV4(int mtuV4) {
            this.mMtuV4 = mtuV4;
            return this;
        }

        @NonNull
        public Builder setMtuV6(int mtuV6) {
            this.mMtuV6 = mtuV6;
            return this;
        }

        @NonNull
        public Builder setProfileId(int profileId) {
            this.mProfileId = profileId;
            return this;
        }

        @NonNull
        public Builder setPersistent(boolean isPersistent) {
            return this.setModemCognitive(isPersistent);
        }

        public Builder setModemCognitive(boolean modemCognitive) {
            this.mModemCognitive = modemCognitive;
            return this;
        }

        public Builder setMaxConns(int maxConns) {
            this.mMaxConns = maxConns;
            return this;
        }

        public Builder setWaitTime(int waitTime) {
            this.mWaitTime = waitTime;
            return this;
        }

        public Builder setMaxConnsTime(int maxConnsTime) {
            this.mMaxConnsTime = maxConnsTime;
            return this;
        }

        public Builder setMvnoMatchData(@Nullable String mvnoMatchData) {
            this.mMvnoMatchData = mvnoMatchData;
            return this;
        }

        public Builder setApnSetId(int apnSetId) {
            this.mApnSetId = apnSetId;
            return this;
        }

        @NonNull
        public Builder setEntryName(@Nullable String entryName) {
            this.mEntryName = entryName;
            return this;
        }

        @NonNull
        public Builder setApnName(@Nullable String apnName) {
            this.mApnName = apnName;
            return this;
        }

        @Deprecated
        public Builder setProxyAddress(InetAddress proxy) {
            this.mProxyAddress = ApnSetting.inetAddressToString(proxy);
            return this;
        }

        @NonNull
        public Builder setProxyAddress(@Nullable String proxy) {
            this.mProxyAddress = proxy;
            return this;
        }

        @NonNull
        public Builder setProxyPort(int port) {
            this.mProxyPort = port;
            return this;
        }

        @NonNull
        public Builder setMmsc(@Nullable Uri mmsc) {
            this.mMmsc = mmsc;
            return this;
        }

        @Deprecated
        public Builder setMmsProxyAddress(InetAddress mmsProxy) {
            this.mMmsProxyAddress = ApnSetting.inetAddressToString(mmsProxy);
            return this;
        }

        @NonNull
        public Builder setMmsProxyAddress(@Nullable String mmsProxy) {
            this.mMmsProxyAddress = mmsProxy;
            return this;
        }

        @NonNull
        public Builder setMmsProxyPort(int mmsPort) {
            this.mMmsProxyPort = mmsPort;
            return this;
        }

        @NonNull
        public Builder setUser(@Nullable String user) {
            this.mUser = user;
            return this;
        }

        @NonNull
        public Builder setPassword(@Nullable String password) {
            this.mPassword = password;
            return this;
        }

        @NonNull
        public Builder setAuthType(int authType) {
            this.mAuthType = authType;
            return this;
        }

        @NonNull
        public Builder setApnTypeBitmask(int apnTypeBitmask) {
            this.mApnTypeBitmask = apnTypeBitmask;
            return this;
        }

        @NonNull
        public Builder setOperatorNumeric(@Nullable String operatorNumeric) {
            this.mOperatorNumeric = operatorNumeric;
            return this;
        }

        @NonNull
        public Builder setProtocol(int protocol) {
            this.mProtocol = protocol;
            return this;
        }

        @NonNull
        public Builder setRoamingProtocol(int roamingProtocol) {
            this.mRoamingProtocol = roamingProtocol;
            return this;
        }

        @NonNull
        public Builder setCarrierEnabled(boolean carrierEnabled) {
            this.mCarrierEnabled = carrierEnabled;
            return this;
        }

        @NonNull
        public Builder setNetworkTypeBitmask(int networkTypeBitmask) {
            this.mNetworkTypeBitmask = networkTypeBitmask;
            return this;
        }

        @NonNull
        public Builder setLingeringNetworkTypeBitmask(long lingeringNetworkTypeBitmask) {
            this.mLingeringNetworkTypeBitmask = lingeringNetworkTypeBitmask;
            return this;
        }

        @NonNull
        public Builder setMvnoType(int mvnoType) {
            this.mMvnoType = mvnoType;
            return this;
        }

        @NonNull
        public Builder setCarrierId(int carrierId) {
            this.mCarrierId = carrierId;
            return this;
        }

        public Builder setSkip464Xlat(int skip464xlat) {
            this.mSkip464Xlat = skip464xlat;
            return this;
        }

        @NonNull
        public Builder setAlwaysOn(boolean alwaysOn) {
            this.mAlwaysOn = alwaysOn;
            return this;
        }

        @NonNull
        public Builder setInfrastructureBitmask(int infrastructureBitmask) {
            this.mInfrastructureBitmask = infrastructureBitmask;
            return this;
        }

        @NonNull
        public Builder setEsimBootstrapProvisioning(boolean esimBootstrapProvisioning) {
            this.mEsimBootstrapProvisioning = esimBootstrapProvisioning;
            return this;
        }

        @NonNull
        public Builder setEditedStatus(int editedStatus) {
            this.mEditedStatus = editedStatus;
            return this;
        }

        public ApnSetting build() {
            if ((this.mApnTypeBitmask & 0x3FFFF) == 0 || TextUtils.isEmpty(this.mApnName) || TextUtils.isEmpty(this.mEntryName)) {
                return null;
            }
            if ((this.mApnTypeBitmask & 2) != 0 && !TextUtils.isEmpty(this.mMmsProxyAddress) && this.mMmsProxyAddress.startsWith("http")) {
                Log.wtf(ApnSetting.LOG_TAG, "mms proxy(" + this.mMmsProxyAddress + ") should be a hostname, not a url");
                Uri mMmsProxyAddressUri = Uri.parse(this.mMmsProxyAddress);
                this.mMmsProxyAddress = mMmsProxyAddressUri.getHost();
            }
            return new ApnSetting(this);
        }

        public ApnSetting buildWithoutCheck() {
            return new ApnSetting(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InfrastructureBitmask {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MvnoType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProtocolType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AuthType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ApnTypeString {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Skip464XlatStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ApnType {
    }
}

