/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.fonts.FontStyle;
import android.graphics.fonts.FontVariationAxis;
import android.icu.util.ULocale;
import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

@SystemApi
@RavenwoodKeepWholeClass
public class FontConfig
implements Parcelable {
    @NonNull
    private final List<FontFamily> mFamilies;
    @NonNull
    private final List<Alias> mAliases;
    @NonNull
    private final List<NamedFamilyList> mNamedFamilyLists;
    @NonNull
    private final List<Customization.LocaleFallback> mLocaleFallbackCustomizations;
    private final long mLastModifiedTimeMillis;
    private final int mConfigVersion;
    @NonNull
    public static final Parcelable.Creator<FontConfig> CREATOR = new Parcelable.Creator<FontConfig>(){

        @Override
        public FontConfig createFromParcel(Parcel source) {
            ArrayList<FontFamily> families = new ArrayList<FontFamily>();
            source.readTypedList(families, FontFamily.CREATOR);
            ArrayList<Alias> aliases = new ArrayList<Alias>();
            source.readTypedList(aliases, Alias.CREATOR);
            ArrayList<NamedFamilyList> familyLists = new ArrayList<NamedFamilyList>();
            source.readTypedList(familyLists, NamedFamilyList.CREATOR);
            long lastModifiedDate = source.readLong();
            int configVersion = source.readInt();
            return new FontConfig(families, aliases, familyLists, Collections.emptyList(), lastModifiedDate, configVersion);
        }

        public FontConfig[] newArray(int size) {
            return new FontConfig[size];
        }
    };

    public FontConfig(@NonNull List<FontFamily> families, @NonNull List<Alias> aliases, @NonNull List<NamedFamilyList> namedFamilyLists, @NonNull List<Customization.LocaleFallback> localeFallbackCustomizations, long lastModifiedTimeMillis, int configVersion) {
        this.mFamilies = families;
        this.mAliases = aliases;
        this.mNamedFamilyLists = namedFamilyLists;
        this.mLocaleFallbackCustomizations = localeFallbackCustomizations;
        this.mLastModifiedTimeMillis = lastModifiedTimeMillis;
        this.mConfigVersion = configVersion;
    }

    public FontConfig(@NonNull List<FontFamily> families, @NonNull List<Alias> aliases, long lastModifiedTimeMillis, int configVersion) {
        this(families, aliases, Collections.emptyList(), Collections.emptyList(), lastModifiedTimeMillis, configVersion);
    }

    @NonNull
    public List<FontFamily> getFontFamilies() {
        return this.mFamilies;
    }

    @NonNull
    public List<Alias> getAliases() {
        return this.mAliases;
    }

    @NonNull
    public List<NamedFamilyList> getNamedFamilyLists() {
        return this.mNamedFamilyLists;
    }

    @NonNull
    public List<Customization.LocaleFallback> getLocaleFallbackCustomizations() {
        return this.mLocaleFallbackCustomizations;
    }

    public long getLastModifiedTimeMillis() {
        return this.mLastModifiedTimeMillis;
    }

    public int getConfigVersion() {
        return this.mConfigVersion;
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @NonNull
    public FontFamily[] getFamilies() {
        return this.mFamilies.toArray(new FontFamily[0]);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeTypedList(this.mFamilies, flags);
        dest.writeTypedList(this.mAliases, flags);
        dest.writeTypedList(this.mNamedFamilyLists, flags);
        dest.writeLong(this.mLastModifiedTimeMillis);
        dest.writeInt(this.mConfigVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FontConfig that = (FontConfig)o;
        return this.mLastModifiedTimeMillis == that.mLastModifiedTimeMillis && this.mConfigVersion == that.mConfigVersion && Objects.equals(this.mFamilies, that.mFamilies) && Objects.equals(this.mAliases, that.mAliases);
    }

    public int hashCode() {
        return Objects.hash(this.mFamilies, this.mAliases, this.mLastModifiedTimeMillis, this.mConfigVersion);
    }

    public String toString() {
        return "FontConfig{mFamilies=" + this.mFamilies + ", mAliases=" + this.mAliases + ", mLastModifiedTimeMillis=" + this.mLastModifiedTimeMillis + ", mConfigVersion=" + this.mConfigVersion + '}';
    }

    public static String resolveScript(Locale locale) {
        String script = locale.getScript();
        if (script != null && !script.isEmpty()) {
            return script;
        }
        return ULocale.addLikelySubtags(ULocale.forLocale(locale)).getScript();
    }

    public static class FontFamily
    implements Parcelable {
        @NonNull
        private final List<Font> mFonts;
        @NonNull
        private final LocaleList mLocaleList;
        private final int mVariant;
        public static final int VARIANT_DEFAULT = 0;
        public static final int VARIANT_COMPACT = 1;
        public static final int VARIANT_ELEGANT = 2;
        @NonNull
        public static final Parcelable.Creator<FontFamily> CREATOR = new Parcelable.Creator<FontFamily>(){

            @Override
            public FontFamily createFromParcel(Parcel source) {
                ArrayList<Font> fonts = new ArrayList<Font>();
                source.readTypedList(fonts, Font.CREATOR);
                String langTags = source.readString8();
                int variant = source.readInt();
                return new FontFamily(fonts, LocaleList.forLanguageTags(langTags), variant);
            }

            public FontFamily[] newArray(int size) {
                return new FontFamily[size];
            }
        };

        public FontFamily(@NonNull List<Font> fonts, @NonNull LocaleList localeList, int variant) {
            this.mFonts = fonts;
            this.mLocaleList = localeList;
            this.mVariant = variant;
        }

        @NonNull
        public List<Font> getFontList() {
            return this.mFonts;
        }

        @Deprecated
        @Nullable
        public String getName() {
            return null;
        }

        @NonNull
        public LocaleList getLocaleList() {
            return this.mLocaleList;
        }

        public int getVariant() {
            return this.mVariant;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeTypedList(this.mFonts, flags);
            dest.writeString8(this.mLocaleList.toLanguageTags());
            dest.writeInt(this.mVariant);
        }

        @Deprecated
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        @Nullable
        public Font[] getFonts() {
            return this.mFonts.toArray(new Font[0]);
        }

        @Deprecated
        @NonNull
        public String getLanguages() {
            return this.mLocaleList.toLanguageTags();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FontFamily that = (FontFamily)o;
            return this.mVariant == that.mVariant && Objects.equals(this.mFonts, that.mFonts) && Objects.equals(this.mLocaleList, that.mLocaleList);
        }

        public int hashCode() {
            return Objects.hash(this.mFonts, this.mLocaleList, this.mVariant);
        }

        public String toString() {
            return "FontFamily{mFonts=" + this.mFonts + ", mLocaleList=" + this.mLocaleList + ", mVariant=" + this.mVariant + '}';
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Variant {
        }
    }

    public static class Customization {
        private Customization() {
        }

        public static class LocaleFallback {
            private final Locale mLocale;
            private final int mOperation;
            private final FontFamily mFamily;
            private final String mScript;
            public static final int OPERATION_PREPEND = 0;
            public static final int OPERATION_APPEND = 1;
            public static final int OPERATION_REPLACE = 2;

            public LocaleFallback(@NonNull Locale locale, int operation, @NonNull FontFamily family) {
                this.mLocale = locale;
                this.mOperation = operation;
                this.mFamily = family;
                this.mScript = FontConfig.resolveScript(locale);
            }

            @NonNull
            public Locale getLocale() {
                return this.mLocale;
            }

            public int getOperation() {
                return this.mOperation;
            }

            @NonNull
            public FontFamily getFamily() {
                return this.mFamily;
            }

            @NonNull
            public String getScript() {
                return this.mScript;
            }

            public String toString() {
                return "LocaleFallback{mLocale=" + this.mLocale + ", mOperation=" + this.mOperation + ", mFamily=" + this.mFamily + '}';
            }

            @Retention(value=RetentionPolicy.SOURCE)
            public static @interface Operation {
            }
        }
    }

    public static class NamedFamilyList
    implements Parcelable {
        private final List<FontFamily> mFamilies;
        private final String mName;
        @NonNull
        public static final Parcelable.Creator<NamedFamilyList> CREATOR = new Parcelable.Creator<NamedFamilyList>(){

            @Override
            public NamedFamilyList createFromParcel(Parcel source) {
                ArrayList<FontFamily> families = new ArrayList<FontFamily>();
                source.readTypedList(families, FontFamily.CREATOR);
                String name = source.readString8();
                return new NamedFamilyList(families, name);
            }

            public NamedFamilyList[] newArray(int size) {
                return new NamedFamilyList[size];
            }
        };

        public NamedFamilyList(@NonNull List<FontFamily> families, @NonNull String name) {
            this.mFamilies = families;
            this.mName = name;
        }

        public NamedFamilyList(@NonNull FontFamily family) {
            this.mFamilies = new ArrayList<FontFamily>();
            this.mFamilies.add(family);
            this.mName = family.getName();
        }

        @NonNull
        public List<FontFamily> getFamilies() {
            return this.mFamilies;
        }

        @NonNull
        public String getName() {
            return this.mName;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@com.android.layoutlib.androidx.annotation.NonNull Parcel dest, int flags) {
            dest.writeTypedList(this.mFamilies, flags);
            dest.writeString8(this.mName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NamedFamilyList that = (NamedFamilyList)o;
            return Objects.equals(this.mFamilies, that.mFamilies) && Objects.equals(this.mName, that.mName);
        }

        public int hashCode() {
            return Objects.hash(this.mFamilies, this.mName);
        }

        public String toString() {
            return "NamedFamilyList{mFamilies=" + this.mFamilies + ", mName='" + this.mName + '\'' + '}';
        }
    }

    public static class Alias
    implements Parcelable {
        @NonNull
        private final String mName;
        @NonNull
        private final String mOriginal;
        private final int mWeight;
        @NonNull
        public static final Parcelable.Creator<Alias> CREATOR = new Parcelable.Creator<Alias>(){

            @Override
            public Alias createFromParcel(Parcel source) {
                String alias = source.readString8();
                String referName = source.readString8();
                int weight = source.readInt();
                return new Alias(alias, referName, weight);
            }

            public Alias[] newArray(int size) {
                return new Alias[size];
            }
        };

        public Alias(@NonNull String name, @NonNull String original, int weight) {
            this.mName = name;
            this.mOriginal = original;
            this.mWeight = weight;
        }

        @NonNull
        public String getName() {
            return this.mName;
        }

        @NonNull
        public String getOriginal() {
            return this.mOriginal;
        }

        public int getWeight() {
            return this.mWeight;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeString8(this.mName);
            dest.writeString8(this.mOriginal);
            dest.writeInt(this.mWeight);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Alias alias = (Alias)o;
            return this.mWeight == alias.mWeight && Objects.equals(this.mName, alias.mName) && Objects.equals(this.mOriginal, alias.mOriginal);
        }

        public int hashCode() {
            return Objects.hash(this.mName, this.mOriginal, this.mWeight);
        }

        public String toString() {
            return "Alias{mName='" + this.mName + '\'' + ", mOriginal='" + this.mOriginal + '\'' + ", mWeight=" + this.mWeight + '}';
        }
    }

    public static class Font
    implements Parcelable {
        @NonNull
        private final File mFile;
        @Nullable
        private final File mOriginalFile;
        @NonNull
        private final String mPostScriptName;
        @NonNull
        private final FontStyle mStyle;
        private final int mIndex;
        @NonNull
        private final String mFontVariationSettings;
        @Nullable
        private final String mFontFamilyName;
        private final int mVarTypeAxes;
        public static final int VAR_TYPE_AXES_NONE = 0;
        public static final int VAR_TYPE_AXES_WGHT = 1;
        public static final int VAR_TYPE_AXES_ITAL = 2;
        @NonNull
        public static final Parcelable.Creator<Font> CREATOR = new Parcelable.Creator<Font>(){

            @Override
            public Font createFromParcel(Parcel source) {
                File path = new File(source.readString8());
                String originalPathStr = source.readString8();
                File originalPath = originalPathStr == null ? null : new File(originalPathStr);
                String postScriptName = source.readString8();
                int weight = source.readInt();
                int slant = source.readInt();
                int index = source.readInt();
                String varSettings = source.readString8();
                String fallback = source.readString8();
                int varTypeAxes = source.readInt();
                return new Font(path, originalPath, postScriptName, new FontStyle(weight, slant), index, varSettings, fallback, varTypeAxes);
            }

            public Font[] newArray(int size) {
                return new Font[size];
            }
        };

        public Font(@NonNull File file, @Nullable File originalFile, @NonNull String postScriptName, @NonNull FontStyle style2, int index, @NonNull String fontVariationSettings, @Nullable String fontFamilyName, int varTypeAxes) {
            this.mFile = file;
            this.mOriginalFile = originalFile;
            this.mPostScriptName = postScriptName;
            this.mStyle = style2;
            this.mIndex = index;
            this.mFontVariationSettings = fontVariationSettings;
            this.mFontFamilyName = fontFamilyName;
            this.mVarTypeAxes = varTypeAxes;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeString8(this.mFile.getAbsolutePath());
            dest.writeString8(this.mOriginalFile == null ? null : this.mOriginalFile.getAbsolutePath());
            dest.writeString8(this.mPostScriptName);
            dest.writeInt(this.mStyle.getWeight());
            dest.writeInt(this.mStyle.getSlant());
            dest.writeInt(this.mIndex);
            dest.writeString8(this.mFontVariationSettings);
            dest.writeString8(this.mFontFamilyName);
            dest.writeInt(this.mVarTypeAxes);
        }

        @NonNull
        public File getFile() {
            return this.mFile;
        }

        @Nullable
        public File getOriginalFile() {
            return this.mOriginalFile;
        }

        @NonNull
        public FontStyle getStyle() {
            return this.mStyle;
        }

        @NonNull
        public String getFontVariationSettings() {
            return this.mFontVariationSettings;
        }

        @Nullable
        public String getFontFamilyName() {
            return this.mFontFamilyName;
        }

        public int getTtcIndex() {
            return this.mIndex;
        }

        @NonNull
        public String getPostScriptName() {
            return this.mPostScriptName;
        }

        public int getVarTypeAxes() {
            return this.mVarTypeAxes;
        }

        @Deprecated
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        @NonNull
        public FontVariationAxis[] getAxes() {
            return FontVariationAxis.fromFontVariationSettings(this.mFontVariationSettings);
        }

        @Deprecated
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public int getWeight() {
            return this.getStyle().getWeight();
        }

        @Deprecated
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public boolean isItalic() {
            return this.getStyle().getSlant() == 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Font font = (Font)o;
            return this.mIndex == font.mIndex && Objects.equals(this.mFile, font.mFile) && Objects.equals(this.mOriginalFile, font.mOriginalFile) && Objects.equals(this.mStyle, font.mStyle) && Objects.equals(this.mFontVariationSettings, font.mFontVariationSettings) && Objects.equals(this.mFontFamilyName, font.mFontFamilyName) && this.mVarTypeAxes == font.mVarTypeAxes;
        }

        public int hashCode() {
            return Objects.hash(this.mFile, this.mOriginalFile, this.mStyle, this.mIndex, this.mFontVariationSettings, this.mFontFamilyName, this.mVarTypeAxes);
        }

        public String toString() {
            return "Font{mFile=" + this.mFile + ", mOriginalFile=" + this.mOriginalFile + ", mStyle=" + this.mStyle + ", mIndex=" + this.mIndex + ", mFontVariationSettings='" + this.mFontVariationSettings + '\'' + ", mFontFamilyName='" + this.mFontFamilyName + '\'' + ", mVarTypeAxes='" + this.mVarTypeAxes + '\'' + '}';
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface VarTypeAxes {
        }
    }
}

