/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.text.LineBreakConfig;
import android.graphics.text.MeasuredText;
import android.icu.lang.UCharacter;
import android.icu.text.Bidi;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.AutoGrowArray;
import android.text.Layout;
import android.text.Spanned;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.LineBreakConfigSpan;
import android.text.style.MetricAffectingSpan;
import android.text.style.ReplacementSpan;
import android.util.Pools;
import java.util.Arrays;

@RavenwoodKeepWholeClass
public class MeasuredParagraph {
    private static final char OBJECT_REPLACEMENT_CHARACTER = '\ufffc';
    private static final Pools.SynchronizedPool<MeasuredParagraph> sPool = new Pools.SynchronizedPool(1);
    @Nullable
    private Spanned mSpanned;
    private int mTextStart;
    private int mTextLength;
    @Nullable
    private char[] mCopiedBuffer;
    private int mParaDir;
    private boolean mLtrWithoutBidi;
    @NonNull
    private AutoGrowArray.ByteArray mLevels = new AutoGrowArray.ByteArray();
    private Bidi mBidi;
    private float mWholeWidth;
    @Nullable
    private AutoGrowArray.FloatArray mWidths = new AutoGrowArray.FloatArray();
    @Nullable
    private AutoGrowArray.IntArray mSpanEndCache = new AutoGrowArray.IntArray(4);
    @Nullable
    private AutoGrowArray.IntArray mFontMetrics = new AutoGrowArray.IntArray(16);
    @Nullable
    private MeasuredText mMeasuredText;
    @NonNull
    private final TextPaint mCachedPaint = new TextPaint();
    @Nullable
    private Paint.FontMetricsInt mCachedFm;
    @NonNull
    private final LineBreakConfig.Builder mLineBreakConfigBuilder = new LineBreakConfig.Builder();

    private MeasuredParagraph() {
    }

    @NonNull
    private static MeasuredParagraph obtain() {
        MeasuredParagraph mt = sPool.acquire();
        return mt != null ? mt : new MeasuredParagraph();
    }

    public void recycle() {
        this.release();
        sPool.release(this);
    }

    public void release() {
        this.reset();
        this.mLevels.clearWithReleasingLargeArray();
        this.mWidths.clearWithReleasingLargeArray();
        this.mFontMetrics.clearWithReleasingLargeArray();
        this.mSpanEndCache.clearWithReleasingLargeArray();
    }

    private void reset() {
        this.mSpanned = null;
        this.mCopiedBuffer = null;
        this.mWholeWidth = 0.0f;
        this.mLevels.clear();
        this.mWidths.clear();
        this.mFontMetrics.clear();
        this.mSpanEndCache.clear();
        this.mMeasuredText = null;
        this.mBidi = null;
    }

    public int getTextLength() {
        return this.mTextLength;
    }

    @NonNull
    public char[] getChars() {
        return this.mCopiedBuffer;
    }

    public int getParagraphDir() {
        if (this.mBidi == null) {
            return 1;
        }
        return (this.mBidi.getParaLevel() & 1) == 0 ? 1 : -1;
    }

    public Layout.Directions getDirections(int start, int end) {
        if (this.mBidi == null) {
            return Layout.DIRS_ALL_LEFT_TO_RIGHT;
        }
        if (start == end) {
            if ((this.mBidi.getParaLevel() & 1) == 0) {
                return Layout.DIRS_ALL_LEFT_TO_RIGHT;
            }
            return Layout.DIRS_ALL_RIGHT_TO_LEFT;
        }
        Bidi bidi = this.mBidi.createLineBidi(start, end);
        if (bidi.getRunCount() == 1) {
            if (bidi.getRunLevel(0) == 1) {
                return Layout.DIRS_ALL_RIGHT_TO_LEFT;
            }
            if (bidi.getRunLevel(0) == 0) {
                return Layout.DIRS_ALL_LEFT_TO_RIGHT;
            }
            return new Layout.Directions(new int[]{0, bidi.getRunLevel(0) << 26 | end - start});
        }
        byte[] levels = new byte[bidi.getRunCount()];
        for (int i = 0; i < bidi.getRunCount(); ++i) {
            levels[i] = (byte)bidi.getRunLevel(i);
        }
        int[] visualOrders = Bidi.reorderVisual(levels);
        int[] dirs = new int[bidi.getRunCount() * 2];
        for (int i = 0; i < bidi.getRunCount(); ++i) {
            int vIndex = (this.mBidi.getBaseLevel() & 1) == 1 ? visualOrders[bidi.getRunCount() - i - 1] : visualOrders[i];
            dirs[i * 2] = bidi.getRunStart(vIndex);
            dirs[i * 2 + 1] = bidi.getRunLevel(vIndex) << 26 | bidi.getRunLimit(vIndex) - dirs[i * 2];
        }
        return new Layout.Directions(dirs);
    }

    public float getWholeWidth() {
        return this.mWholeWidth;
    }

    @NonNull
    public AutoGrowArray.FloatArray getWidths() {
        return this.mWidths;
    }

    @NonNull
    public AutoGrowArray.IntArray getSpanEndCache() {
        return this.mSpanEndCache;
    }

    @NonNull
    public AutoGrowArray.IntArray getFontMetrics() {
        return this.mFontMetrics;
    }

    public MeasuredText getMeasuredText() {
        return this.mMeasuredText;
    }

    public float getWidth(int start, int end) {
        if (this.mMeasuredText == null) {
            float[] widths = this.mWidths.getRawArray();
            float r = 0.0f;
            for (int i = start; i < end; ++i) {
                r += widths[i];
            }
            return r;
        }
        return this.mMeasuredText.getWidth(start, end);
    }

    public void getBounds(int start, int end, @NonNull Rect bounds) {
        this.mMeasuredText.getBounds(start, end, bounds);
    }

    public void getFontMetricsInt(int start, int end, @NonNull Paint.FontMetricsInt fmi) {
        this.mMeasuredText.getFontMetricsInt(start, end, fmi);
    }

    public float getCharWidthAt(int offset) {
        return this.mMeasuredText.getCharWidthAt(offset);
    }

    @NonNull
    public static MeasuredParagraph buildForBidi(@NonNull CharSequence text, int start, int end, @NonNull TextDirectionHeuristic textDir, @Nullable MeasuredParagraph recycle) {
        MeasuredParagraph mt = recycle == null ? MeasuredParagraph.obtain() : recycle;
        mt.resetAndAnalyzeBidi(text, start, end, textDir);
        return mt;
    }

    @NonNull
    public static MeasuredParagraph buildForMeasurement(@NonNull TextPaint paint, @NonNull CharSequence text, int start, int end, @NonNull TextDirectionHeuristic textDir, @Nullable MeasuredParagraph recycle) {
        MeasuredParagraph mt = recycle == null ? MeasuredParagraph.obtain() : recycle;
        mt.resetAndAnalyzeBidi(text, start, end, textDir);
        mt.mWidths.resize(mt.mTextLength);
        if (mt.mTextLength == 0) {
            return mt;
        }
        if (mt.mSpanned == null) {
            mt.applyMetricsAffectingSpan(paint, null, null, null, start, end, null, null);
        } else {
            int spanStart = start;
            while (spanStart < end) {
                int maSpanEnd = mt.mSpanned.nextSpanTransition(spanStart, end, MetricAffectingSpan.class);
                int lbcSpanEnd = mt.mSpanned.nextSpanTransition(spanStart, end, LineBreakConfigSpan.class);
                int spanEnd = Math.min(maSpanEnd, lbcSpanEnd);
                MetricAffectingSpan[] spans = mt.mSpanned.getSpans(spanStart, spanEnd, MetricAffectingSpan.class);
                LineBreakConfigSpan[] lbcSpans = mt.mSpanned.getSpans(spanStart, spanEnd, LineBreakConfigSpan.class);
                spans = TextUtils.removeEmptySpans(spans, mt.mSpanned, MetricAffectingSpan.class);
                lbcSpans = TextUtils.removeEmptySpans(lbcSpans, mt.mSpanned, LineBreakConfigSpan.class);
                mt.applyMetricsAffectingSpan(paint, null, spans, lbcSpans, spanStart, spanEnd, null, null);
                spanStart = spanEnd;
            }
        }
        return mt;
    }

    @NonNull
    public static MeasuredParagraph buildForStaticLayout(@NonNull TextPaint paint, @Nullable LineBreakConfig lineBreakConfig, @NonNull CharSequence text, int start, int end, @NonNull TextDirectionHeuristic textDir, int hyphenationMode, boolean computeLayout, boolean computeBounds, @Nullable MeasuredParagraph hint, @Nullable MeasuredParagraph recycle) {
        return MeasuredParagraph.buildForStaticLayoutInternal(paint, lineBreakConfig, text, start, end, textDir, hyphenationMode, computeLayout, computeBounds, hint, recycle, null);
    }

    @SuppressLint(value={"ExecutorRegistration"})
    @NonNull
    @FlaggedApi(value="com.android.text.flags.no_break_no_hyphenation_span")
    public static MeasuredParagraph buildForStaticLayoutTest(@NonNull TextPaint paint, @Nullable LineBreakConfig lineBreakConfig, @NonNull CharSequence text, int start, int end, @NonNull TextDirectionHeuristic textDir, int hyphenationMode, boolean computeLayout, @Nullable StyleRunCallback testCallback) {
        return MeasuredParagraph.buildForStaticLayoutInternal(paint, lineBreakConfig, text, start, end, textDir, hyphenationMode, computeLayout, false, null, null, testCallback);
    }

    @NonNull
    private static MeasuredParagraph buildForStaticLayoutInternal(@NonNull TextPaint paint, @Nullable LineBreakConfig lineBreakConfig, @NonNull CharSequence text, int start, int end, @NonNull TextDirectionHeuristic textDir, int hyphenationMode, boolean computeLayout, boolean computeBounds, @Nullable MeasuredParagraph hint, @Nullable MeasuredParagraph recycle, @Nullable StyleRunCallback testCallback) {
        MeasuredParagraph mt = recycle == null ? MeasuredParagraph.obtain() : recycle;
        mt.resetAndAnalyzeBidi(text, start, end, textDir);
        MeasuredText.Builder builder = hint == null ? new MeasuredText.Builder(mt.mCopiedBuffer).setComputeHyphenation(hyphenationMode).setComputeLayout(computeLayout).setComputeBounds(computeBounds) : new MeasuredText.Builder(hint.mMeasuredText);
        if (mt.mTextLength == 0) {
            mt.mMeasuredText = builder.build();
        } else {
            if (mt.mSpanned == null) {
                mt.applyMetricsAffectingSpan(paint, lineBreakConfig, null, null, start, end, builder, testCallback);
                mt.mSpanEndCache.append(end);
            } else {
                int spanStart = start;
                while (spanStart < end) {
                    int maSpanEnd = mt.mSpanned.nextSpanTransition(spanStart, end, MetricAffectingSpan.class);
                    int lbcSpanEnd = mt.mSpanned.nextSpanTransition(spanStart, end, LineBreakConfigSpan.class);
                    int spanEnd = Math.min(maSpanEnd, lbcSpanEnd);
                    MetricAffectingSpan[] spans = mt.mSpanned.getSpans(spanStart, spanEnd, MetricAffectingSpan.class);
                    LineBreakConfigSpan[] lbcSpans = mt.mSpanned.getSpans(spanStart, spanEnd, LineBreakConfigSpan.class);
                    spans = TextUtils.removeEmptySpans(spans, mt.mSpanned, MetricAffectingSpan.class);
                    lbcSpans = TextUtils.removeEmptySpans(lbcSpans, mt.mSpanned, LineBreakConfigSpan.class);
                    mt.applyMetricsAffectingSpan(paint, lineBreakConfig, spans, lbcSpans, spanStart, spanEnd, builder, testCallback);
                    mt.mSpanEndCache.append(spanEnd);
                    spanStart = spanEnd;
                }
            }
            mt.mMeasuredText = builder.build();
        }
        return mt;
    }

    private void resetAndAnalyzeBidi(@NonNull CharSequence text, int start, int end, @NonNull TextDirectionHeuristic textDir) {
        boolean isRtl;
        int i;
        this.reset();
        this.mSpanned = text instanceof Spanned ? (Spanned)text : null;
        this.mTextStart = start;
        this.mTextLength = end - start;
        if (this.mCopiedBuffer == null || this.mCopiedBuffer.length != this.mTextLength) {
            this.mCopiedBuffer = new char[this.mTextLength];
        }
        TextUtils.getChars(text, start, end, this.mCopiedBuffer, 0);
        if (this.mSpanned != null) {
            ReplacementSpan[] spans = this.mSpanned.getSpans(start, end, ReplacementSpan.class);
            for (i = 0; i < spans.length; ++i) {
                int startInPara = this.mSpanned.getSpanStart(spans[i]) - start;
                int endInPara = this.mSpanned.getSpanEnd(spans[i]) - start;
                if (startInPara < 0) {
                    startInPara = 0;
                }
                if (endInPara > this.mTextLength) {
                    endInPara = this.mTextLength;
                }
                Arrays.fill(this.mCopiedBuffer, startInPara, endInPara, '\ufffc');
            }
        }
        if ((textDir == TextDirectionHeuristics.LTR || textDir == TextDirectionHeuristics.FIRSTSTRONG_LTR || textDir == TextDirectionHeuristics.ANYRTL_LTR) && TextUtils.doesNotNeedBidi(this.mCopiedBuffer, 0, this.mTextLength)) {
            this.mLevels.clear();
            this.mLtrWithoutBidi = true;
            return;
        }
        int bidiRequest = textDir == TextDirectionHeuristics.LTR ? 0 : (textDir == TextDirectionHeuristics.RTL ? 1 : (textDir == TextDirectionHeuristics.FIRSTSTRONG_LTR ? 126 : (textDir == TextDirectionHeuristics.FIRSTSTRONG_RTL ? 127 : ((isRtl = textDir.isRtl(this.mCopiedBuffer, 0, this.mTextLength)) ? 1 : 0))));
        this.mBidi = new Bidi(this.mCopiedBuffer, 0, null, 0, this.mCopiedBuffer.length, bidiRequest);
        if (this.mCopiedBuffer.length > 0 && this.mBidi.getParagraphIndex(this.mCopiedBuffer.length - 1) != 0) {
            for (i = 0; i < this.mTextLength; ++i) {
                if (Character.isSurrogate(this.mCopiedBuffer[i]) || UCharacter.getDirection(this.mCopiedBuffer[i]) != 7) continue;
                this.mCopiedBuffer[i] = 65532;
            }
            this.mBidi = new Bidi(this.mCopiedBuffer, 0, null, 0, this.mCopiedBuffer.length, bidiRequest);
        }
        this.mLevels.resize(this.mTextLength);
        byte[] rawArray = this.mLevels.getRawArray();
        for (int i2 = 0; i2 < this.mTextLength; ++i2) {
            rawArray[i2] = this.mBidi.getLevelAt(i2);
        }
        this.mLtrWithoutBidi = false;
    }

    private void applyReplacementRun(@NonNull ReplacementSpan replacement, int start, int end, @NonNull TextPaint paint, @Nullable MeasuredText.Builder builder, @Nullable StyleRunCallback testCallback) {
        float width = replacement.getSize(paint, this.mSpanned, start + this.mTextStart, end + this.mTextStart, this.mCachedFm);
        if (builder == null) {
            this.mWidths.set(start, width);
            if (end > start + 1) {
                Arrays.fill(this.mWidths.getRawArray(), start + 1, end, 0.0f);
            }
            this.mWholeWidth += width;
        } else {
            builder.appendReplacementRun(paint, end - start, width);
        }
        if (testCallback != null) {
            testCallback.onAppendReplacementRun(paint, end - start, width);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyStyleRun(int start, int end, @NonNull TextPaint paint, @Nullable LineBreakConfig config, @Nullable MeasuredText.Builder builder, @Nullable StyleRunCallback testCallback) {
        if (this.mLtrWithoutBidi) {
            if (builder == null) {
                int oldFlag = paint.getFlags();
                paint.setFlags(paint.getFlags() | 0x6000);
                try {
                    this.mWholeWidth += paint.getTextRunAdvances(this.mCopiedBuffer, start, end - start, start, end - start, false, this.mWidths.getRawArray(), start);
                }
                finally {
                    paint.setFlags(oldFlag);
                }
            } else {
                builder.appendStyleRun(paint, config, end - start, false);
            }
            if (testCallback != null) {
                testCallback.onAppendStyleRun(paint, config, end - start, false);
            }
        } else {
            byte level = this.mLevels.get(start);
            int levelStart = start;
            int levelEnd = start + 1;
            while (true) {
                if (levelEnd == end || this.mLevels.get(levelEnd) != level) {
                    boolean isRtl;
                    boolean bl = isRtl = (level & 1) != 0;
                    if (builder == null) {
                        int levelLength = levelEnd - levelStart;
                        int oldFlag = paint.getFlags();
                        paint.setFlags(paint.getFlags() | 0x6000);
                        try {
                            this.mWholeWidth += paint.getTextRunAdvances(this.mCopiedBuffer, levelStart, levelLength, levelStart, levelLength, isRtl, this.mWidths.getRawArray(), levelStart);
                        }
                        finally {
                            paint.setFlags(oldFlag);
                        }
                    } else {
                        builder.appendStyleRun(paint, config, levelEnd - levelStart, isRtl);
                    }
                    if (testCallback != null) {
                        testCallback.onAppendStyleRun(paint, config, levelEnd - levelStart, isRtl);
                    }
                    if (levelEnd == end) break;
                    levelStart = levelEnd;
                    level = this.mLevels.get(levelEnd);
                }
                ++levelEnd;
            }
        }
    }

    private void applyMetricsAffectingSpan(@NonNull TextPaint paint, @Nullable LineBreakConfig lineBreakConfig, @Nullable MetricAffectingSpan[] spans, @Nullable LineBreakConfigSpan[] lbcSpans, int start, int end, @Nullable MeasuredText.Builder builder, @Nullable StyleRunCallback testCallback) {
        boolean needFontMetrics;
        this.mCachedPaint.set(paint);
        this.mCachedPaint.baselineShift = 0;
        boolean bl = needFontMetrics = builder != null;
        if (needFontMetrics && this.mCachedFm == null) {
            this.mCachedFm = new Paint.FontMetricsInt();
        }
        ReplacementSpan replacement = null;
        if (spans != null) {
            for (int i = 0; i < spans.length; ++i) {
                MetricAffectingSpan span = spans[i];
                if (span instanceof ReplacementSpan) {
                    replacement = (ReplacementSpan)span;
                    continue;
                }
                span.updateMeasureState(this.mCachedPaint);
            }
        }
        if (lbcSpans != null) {
            this.mLineBreakConfigBuilder.reset(lineBreakConfig);
            for (LineBreakConfigSpan lbcSpan : lbcSpans) {
                this.mLineBreakConfigBuilder.merge(lbcSpan.getLineBreakConfig());
            }
            lineBreakConfig = this.mLineBreakConfigBuilder.build();
        }
        int startInCopiedBuffer = start - this.mTextStart;
        int endInCopiedBuffer = end - this.mTextStart;
        if (builder != null) {
            this.mCachedPaint.getFontMetricsInt(this.mCachedFm);
        }
        if (replacement != null) {
            this.applyReplacementRun(replacement, startInCopiedBuffer, endInCopiedBuffer, this.mCachedPaint, builder, testCallback);
        } else {
            this.applyStyleRun(startInCopiedBuffer, endInCopiedBuffer, this.mCachedPaint, lineBreakConfig, builder, testCallback);
        }
        if (needFontMetrics) {
            if (this.mCachedPaint.baselineShift < 0) {
                this.mCachedFm.ascent += this.mCachedPaint.baselineShift;
                this.mCachedFm.top += this.mCachedPaint.baselineShift;
            } else {
                this.mCachedFm.descent += this.mCachedPaint.baselineShift;
                this.mCachedFm.bottom += this.mCachedPaint.baselineShift;
            }
            this.mFontMetrics.append(this.mCachedFm.top);
            this.mFontMetrics.append(this.mCachedFm.bottom);
            this.mFontMetrics.append(this.mCachedFm.ascent);
            this.mFontMetrics.append(this.mCachedFm.descent);
        }
    }

    int breakText(int limit, boolean forwards, float width) {
        int i;
        float[] w = this.mWidths.getRawArray();
        if (forwards) {
            int i2;
            for (i2 = 0; i2 < limit && !((width -= w[i2]) < 0.0f); ++i2) {
            }
            while (i2 > 0 && this.mCopiedBuffer[i2 - 1] == ' ') {
                --i2;
            }
            return i2;
        }
        for (i = limit - 1; i >= 0 && !((width -= w[i]) < 0.0f); --i) {
        }
        while (i < limit - 1 && (this.mCopiedBuffer[i + 1] == ' ' || w[i + 1] == 0.0f)) {
            ++i;
        }
        return limit - i - 1;
    }

    float measure(int start, int limit) {
        float width = 0.0f;
        float[] w = this.mWidths.getRawArray();
        for (int i = start; i < limit; ++i) {
            width += w[i];
        }
        return width;
    }

    public int getMemoryUsage() {
        return this.mMeasuredText.getMemoryUsage();
    }

    @FlaggedApi(value="com.android.text.flags.no_break_no_hyphenation_span")
    public static interface StyleRunCallback {
        @FlaggedApi(value="com.android.text.flags.no_break_no_hyphenation_span")
        public void onAppendStyleRun(@NonNull Paint var1, @Nullable LineBreakConfig var2, int var3, boolean var4);

        @FlaggedApi(value="com.android.text.flags.no_break_no_hyphenation_span")
        public void onAppendReplacementRun(@NonNull Paint var1, int var2, float var3);
    }
}

