/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.annotation.NonNull;
import android.graphics.text.PositionedGlyphs;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.MeasuredParagraph;
import android.text.TextDirectionHeuristic;
import android.text.TextLine;
import android.text.TextPaint;

@RavenwoodKeepWholeClass
public class TextShaper {
    private TextShaper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shapeText(@NonNull CharSequence text, int start, int count, @NonNull TextDirectionHeuristic dir, @NonNull TextPaint paint, @NonNull GlyphsConsumer consumer) {
        MeasuredParagraph mp = MeasuredParagraph.buildForBidi(text, start, start + count, dir, null);
        TextLine tl = TextLine.obtain();
        try {
            tl.set(paint, text, start, start + count, mp.getParagraphDir(), mp.getDirections(0, count), false, null, -1, -1, false);
            tl.shape(consumer);
        }
        finally {
            TextLine.recycle(tl);
        }
    }

    public static interface GlyphsConsumer {
        public void accept(int var1, int var2, @NonNull PositionedGlyphs var3, @NonNull TextPaint var4);
    }
}

