/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.annotation.NonNull;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Parcel;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.ParcelableSpan;
import android.text.style.ParagraphStyle;

@RavenwoodKeepWholeClass
public interface LineBackgroundSpan
extends ParagraphStyle {
    public void drawBackground(@NonNull Canvas var1, @NonNull Paint var2, int var3, int var4, int var5, int var6, int var7, @NonNull CharSequence var8, int var9, int var10, int var11);

    public static class Standard
    implements LineBackgroundSpan,
    ParcelableSpan {
        private final int mColor;

        public Standard(int color2) {
            this.mColor = color2;
        }

        public Standard(@NonNull Parcel src) {
            this.mColor = src.readInt();
        }

        @Override
        public int getSpanTypeId() {
            return this.getSpanTypeIdInternal();
        }

        @Override
        public int getSpanTypeIdInternal() {
            return 27;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            this.writeToParcelInternal(dest, flags);
        }

        @Override
        public void writeToParcelInternal(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.mColor);
        }

        public int getColor() {
            return this.mColor;
        }

        @Override
        public void drawBackground(@NonNull Canvas canvas, @NonNull Paint paint, int left, int right, int top, int baseline, int bottom, @NonNull CharSequence text, int start, int end, int lineNumber) {
            int originColor = paint.getColor();
            paint.setColor(this.mColor);
            canvas.drawRect(left, top, right, bottom, paint);
            paint.setColor(originColor);
        }
    }
}

