/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.annotation.NonNull;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.Spannable;
import android.text.style.StyleSpan;
import android.text.style.UnderlineSpan;
import android.util.LongArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@RavenwoodKeepWholeClass
public class SpanUtils {
    private SpanUtils() {
    }

    public static boolean toggleBold(@NonNull Spannable spannable, int min, int max) {
        if (min == max) {
            return false;
        }
        StyleSpan[] boldSpans = spannable.getSpans(min, max, StyleSpan.class);
        ArrayList<StyleSpan> filteredBoldSpans = new ArrayList<StyleSpan>();
        for (StyleSpan span : boldSpans) {
            if ((span.getStyle() & 1) != 1) continue;
            filteredBoldSpans.add(span);
        }
        if (!SpanUtils.isCovered(spannable, filteredBoldSpans, min, max)) {
            spannable.setSpan(new StyleSpan(1), min, max, 17);
            return true;
        }
        for (int si = 0; si < filteredBoldSpans.size(); ++si) {
            boolean needItalicSpan;
            StyleSpan span = (StyleSpan)filteredBoldSpans.get(si);
            int start = spannable.getSpanStart(span);
            int end = spannable.getSpanEnd(span);
            int flag = spannable.getSpanFlags(span);
            boolean bl = needItalicSpan = (span.getStyle() & 2) == 2;
            if (start < min) {
                if (end > max) {
                    spannable.setSpan(span, start, min, flag);
                    spannable.setSpan(new StyleSpan(span.getStyle()), max, end, flag);
                    if (!needItalicSpan) continue;
                    spannable.setSpan(new StyleSpan(2), min, max, flag);
                    continue;
                }
                spannable.setSpan(span, start, min, flag);
                if (!needItalicSpan) continue;
                spannable.setSpan(new StyleSpan(2), min, end, flag);
                continue;
            }
            if (end > max) {
                spannable.setSpan(span, max, end, flag);
                if (!needItalicSpan) continue;
                spannable.setSpan(new StyleSpan(2), max, end, flag);
                continue;
            }
            spannable.removeSpan(span);
            if (!needItalicSpan) continue;
            spannable.setSpan(new StyleSpan(2), start, end, flag);
        }
        return true;
    }

    public static boolean toggleItalic(@NonNull Spannable spannable, int min, int max) {
        if (min == max) {
            return false;
        }
        StyleSpan[] boldSpans = spannable.getSpans(min, max, StyleSpan.class);
        ArrayList<StyleSpan> filteredBoldSpans = new ArrayList<StyleSpan>();
        for (StyleSpan span : boldSpans) {
            if ((span.getStyle() & 2) != 2) continue;
            filteredBoldSpans.add(span);
        }
        if (!SpanUtils.isCovered(spannable, filteredBoldSpans, min, max)) {
            spannable.setSpan(new StyleSpan(2), min, max, 17);
            return true;
        }
        for (int si = 0; si < filteredBoldSpans.size(); ++si) {
            boolean needBoldSpan;
            StyleSpan span = (StyleSpan)filteredBoldSpans.get(si);
            int start = spannable.getSpanStart(span);
            int end = spannable.getSpanEnd(span);
            int flag = spannable.getSpanFlags(span);
            boolean bl = needBoldSpan = (span.getStyle() & 1) == 1;
            if (start < min) {
                if (end > max) {
                    spannable.setSpan(span, start, min, flag);
                    spannable.setSpan(new StyleSpan(span.getStyle()), max, end, flag);
                    if (!needBoldSpan) continue;
                    spannable.setSpan(new StyleSpan(1), min, max, flag);
                    continue;
                }
                spannable.setSpan(span, start, min, flag);
                if (!needBoldSpan) continue;
                spannable.setSpan(new StyleSpan(1), min, end, flag);
                continue;
            }
            if (end > max) {
                spannable.setSpan(span, max, end, flag);
                if (!needBoldSpan) continue;
                spannable.setSpan(new StyleSpan(1), max, end, flag);
                continue;
            }
            spannable.removeSpan(span);
            if (!needBoldSpan) continue;
            spannable.setSpan(new StyleSpan(1), start, end, flag);
        }
        return true;
    }

    public static boolean toggleUnderline(@NonNull Spannable spannable, int min, int max) {
        if (min == max) {
            return false;
        }
        List<UnderlineSpan> spans = Arrays.asList(spannable.getSpans(min, max, UnderlineSpan.class));
        if (!SpanUtils.isCovered(spannable, spans, min, max)) {
            spannable.setSpan(new UnderlineSpan(), min, max, 17);
            return true;
        }
        for (int si = 0; si < spans.size(); ++si) {
            UnderlineSpan span = spans.get(si);
            int start = spannable.getSpanStart(span);
            int end = spannable.getSpanEnd(span);
            int flag = spannable.getSpanFlags(span);
            if (start < min) {
                if (end > max) {
                    spannable.setSpan(span, start, min, flag);
                    spannable.setSpan(new UnderlineSpan(), max, end, flag);
                    continue;
                }
                spannable.setSpan(span, start, min, flag);
                continue;
            }
            if (end > max) {
                spannable.setSpan(span, max, end, flag);
                continue;
            }
            spannable.removeSpan(span);
        }
        return true;
    }

    private static long pack(int from, int to) {
        return (long)from << 32 | (long)to;
    }

    private static int min(long packed) {
        return (int)(packed >> 32);
    }

    private static int max(long packed) {
        return (int)(packed & 0xFFFFFFFFL);
    }

    private static boolean hasIntersection(int aMin, int aMax, int bMin, int bMax) {
        return aMin < bMax && bMin < aMax;
    }

    private static long intersection(int aMin, int aMax, int bMin, int bMax) {
        return SpanUtils.pack(Math.max(aMin, bMin), Math.min(aMax, bMax));
    }

    private static <T> boolean isCovered(@NonNull Spannable spannable, @NonNull List<T> spans, int min, int max) {
        if (min == max) {
            return false;
        }
        LongArray uncoveredRanges = new LongArray();
        LongArray nextUncoveredRanges = new LongArray();
        uncoveredRanges.add(SpanUtils.pack(min, max));
        for (int si = 0; si < spans.size(); ++si) {
            T span = spans.get(si);
            int start = spannable.getSpanStart(span);
            int end = spannable.getSpanEnd(span);
            for (int i = 0; i < uncoveredRanges.size(); ++i) {
                int uncoveredEnd;
                long packed = uncoveredRanges.get(i);
                int uncoveredStart = SpanUtils.min(packed);
                if (!SpanUtils.hasIntersection(start, end, uncoveredStart, uncoveredEnd = SpanUtils.max(packed))) {
                    nextUncoveredRanges.add(packed);
                    continue;
                }
                long intersectionPack = SpanUtils.intersection(start, end, uncoveredStart, uncoveredEnd);
                int intersectStart = SpanUtils.min(intersectionPack);
                int intersectEnd = SpanUtils.max(intersectionPack);
                if (uncoveredStart != intersectStart) {
                    nextUncoveredRanges.add(SpanUtils.pack(uncoveredStart, intersectStart));
                }
                if (intersectEnd == uncoveredEnd) continue;
                nextUncoveredRanges.add(SpanUtils.pack(intersectEnd, uncoveredEnd));
            }
            if (nextUncoveredRanges.size() == 0) {
                return true;
            }
            LongArray tmp = nextUncoveredRanges;
            nextUncoveredRanges = uncoveredRanges;
            uncoveredRanges = tmp;
            nextUncoveredRanges.clear();
        }
        return false;
    }
}

