/*
 * Decompiled with CFR 0.152.
 */
package android.text.util;

import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.util.Rfc822Token;
import android.widget.MultiAutoCompleteTextView;
import java.util.ArrayList;
import java.util.Collection;

@RavenwoodKeepWholeClass
public class Rfc822Tokenizer
implements MultiAutoCompleteTextView.Tokenizer {
    public static void tokenize(CharSequence text, Collection<Rfc822Token> out) {
        StringBuilder name = new StringBuilder();
        StringBuilder address = new StringBuilder();
        StringBuilder comment = new StringBuilder();
        int i = 0;
        int cursor = text.length();
        block0: while (i < cursor) {
            char c = text.charAt(i);
            if (c == ',' || c == ';') {
                ++i;
                while (i < cursor && text.charAt(i) == ' ') {
                    ++i;
                }
                Rfc822Tokenizer.crunch(name);
                if (address.length() > 0) {
                    out.add(new Rfc822Token(name.toString(), address.toString(), comment.toString()));
                } else if (name.length() > 0) {
                    out.add(new Rfc822Token(null, name.toString(), comment.toString()));
                }
                name.setLength(0);
                address.setLength(0);
                comment.setLength(0);
                continue;
            }
            if (c == '\"') {
                ++i;
                while (i < cursor) {
                    c = text.charAt(i);
                    if (c == '\"') {
                        ++i;
                        continue block0;
                    }
                    if (c == '\\') {
                        if (i + 1 < cursor) {
                            name.append(text.charAt(i + 1));
                        }
                        i += 2;
                        continue;
                    }
                    name.append(c);
                    ++i;
                }
                continue;
            }
            if (c == '(') {
                int level = 1;
                ++i;
                while (i < cursor && level > 0) {
                    c = text.charAt(i);
                    if (c == ')') {
                        if (level > 1) {
                            comment.append(c);
                        }
                        --level;
                        ++i;
                        continue;
                    }
                    if (c == '(') {
                        comment.append(c);
                        ++level;
                        ++i;
                        continue;
                    }
                    if (c == '\\') {
                        if (i + 1 < cursor) {
                            comment.append(text.charAt(i + 1));
                        }
                        i += 2;
                        continue;
                    }
                    comment.append(c);
                    ++i;
                }
                continue;
            }
            if (c == '<') {
                ++i;
                while (i < cursor) {
                    c = text.charAt(i);
                    if (c == '>') {
                        ++i;
                        continue block0;
                    }
                    address.append(c);
                    ++i;
                }
                continue;
            }
            if (c == ' ') {
                name.append('\u0000');
                ++i;
                continue;
            }
            name.append(c);
            ++i;
        }
        Rfc822Tokenizer.crunch(name);
        if (address.length() > 0) {
            out.add(new Rfc822Token(name.toString(), address.toString(), comment.toString()));
        } else if (name.length() > 0) {
            out.add(new Rfc822Token(null, name.toString(), comment.toString()));
        }
    }

    public static Rfc822Token[] tokenize(CharSequence text) {
        ArrayList<Rfc822Token> out = new ArrayList<Rfc822Token>();
        Rfc822Tokenizer.tokenize(text, out);
        return out.toArray(new Rfc822Token[out.size()]);
    }

    private static void crunch(StringBuilder sb) {
        int i = 0;
        int len = sb.length();
        while (i < len) {
            char c = sb.charAt(i);
            if (c == '\u0000') {
                if (i == 0 || i == len - 1 || sb.charAt(i - 1) == ' ' || sb.charAt(i - 1) == '\u0000' || sb.charAt(i + 1) == ' ' || sb.charAt(i + 1) == '\u0000') {
                    sb.deleteCharAt(i);
                    --len;
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
        for (i = 0; i < len; ++i) {
            if (sb.charAt(i) != '\u0000') continue;
            sb.setCharAt(i, ' ');
        }
    }

    @Override
    public int findTokenStart(CharSequence text, int cursor) {
        int best = 0;
        int i = 0;
        while (i < cursor) {
            if ((i = this.findTokenEnd(text, i)) >= cursor) continue;
            ++i;
            while (i < cursor && text.charAt(i) == ' ') {
                ++i;
            }
            if (i >= cursor) continue;
            best = i;
        }
        return best;
    }

    @Override
    public int findTokenEnd(CharSequence text, int cursor) {
        int len = text.length();
        int i = cursor;
        block0: while (i < len) {
            char c = text.charAt(i);
            if (c == ',' || c == ';') {
                return i;
            }
            if (c == '\"') {
                ++i;
                while (i < len) {
                    c = text.charAt(i);
                    if (c == '\"') {
                        ++i;
                        continue block0;
                    }
                    if (c == '\\' && i + 1 < len) {
                        i += 2;
                        continue;
                    }
                    ++i;
                }
                continue;
            }
            if (c == '(') {
                int level = 1;
                ++i;
                while (i < len && level > 0) {
                    c = text.charAt(i);
                    if (c == ')') {
                        --level;
                        ++i;
                        continue;
                    }
                    if (c == '(') {
                        ++level;
                        ++i;
                        continue;
                    }
                    if (c == '\\' && i + 1 < len) {
                        i += 2;
                        continue;
                    }
                    ++i;
                }
                continue;
            }
            if (c == '<') {
                ++i;
                while (i < len) {
                    c = text.charAt(i);
                    if (c == '>') {
                        ++i;
                        continue block0;
                    }
                    ++i;
                }
                continue;
            }
            ++i;
        }
        return i;
    }

    @Override
    public CharSequence terminateToken(CharSequence text) {
        return text + ", ";
    }
}

