/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.SystemProperties;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodReplace;
import android.system.ErrnoException;
import android.system.Os;
import android.util.AttributeSet;
import android.util.XmlPullAttributes;
import android.util.Xml_Delegate;
import com.android.internal.util.ArtBinaryXmlPullParser;
import com.android.internal.util.ArtBinaryXmlSerializer;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import com.android.modules.utils.BinaryXmlPullParser;
import com.android.modules.utils.BinaryXmlSerializer;
import com.android.modules.utils.TypedXmlPullParser;
import com.android.modules.utils.TypedXmlSerializer;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.xml.parsers.SAXParserFactory;
import libcore.util.XmlObjectFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

@RavenwoodKeepWholeClass
public class Xml {
    public static String FEATURE_RELAXED = "http://xmlpull.org/v1/doc/features.html#relaxed";
    public static final boolean ENABLE_BINARY_DEFAULT = Xml.shouldEnableBinaryDefault();
    public static final boolean ENABLE_RESOLVE_OPTIMIZATIONS = Xml.shouldEnableResolveOptimizations();

    private Xml() {
    }

    @RavenwoodReplace
    private static boolean shouldEnableBinaryDefault() {
        return SystemProperties.getBoolean("persist.sys.binary_xml", true);
    }

    private static boolean shouldEnableBinaryDefault$ravenwood() {
        return true;
    }

    @RavenwoodReplace
    private static boolean shouldEnableResolveOptimizations() {
        return true;
    }

    private static boolean shouldEnableResolveOptimizations$ravenwood() {
        return false;
    }

    public static void parse(String xml2, ContentHandler contentHandler) throws SAXException {
        try {
            XMLReader reader = Xml.newXMLReader();
            reader.setContentHandler(contentHandler);
            reader.parse(new InputSource(new StringReader(xml2)));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void parse(Reader in, ContentHandler contentHandler) throws IOException, SAXException {
        XMLReader reader = Xml.newXMLReader();
        reader.setContentHandler(contentHandler);
        reader.parse(new InputSource(in));
    }

    public static void parse(InputStream in, Encoding encoding, ContentHandler contentHandler) throws IOException, SAXException {
        XMLReader reader = Xml.newXMLReader();
        reader.setContentHandler(contentHandler);
        InputSource source = new InputSource(in);
        source.setEncoding(encoding.expatName);
        reader.parse(source);
    }

    @RavenwoodReplace
    public static XmlPullParser newPullParser_Original() {
        try {
            XmlPullParser parser = Xml.newXmlPullParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-docdecl", true);
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            return parser;
        }
        catch (XmlPullParserException e) {
            throw new AssertionError((Object)e);
        }
    }

    @LayoutlibDelegate
    public static XmlPullParser newPullParser() {
        return Xml_Delegate.newPullParser();
    }

    public static XmlPullParser newPullParser$ravenwood() {
        try {
            XmlPullParser parser = Xml.newXmlPullParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            return parser;
        }
        catch (XmlPullParserException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NonNull
    public static TypedXmlPullParser newFastPullParser() {
        return XmlUtils.makeTyped(Xml.newPullParser());
    }

    @RavenwoodReplace
    @NonNull
    public static TypedXmlPullParser newBinaryPullParser() {
        return new ArtBinaryXmlPullParser();
    }

    public static TypedXmlPullParser newBinaryPullParser$ravenwood() {
        return new BinaryXmlPullParser();
    }

    @NonNull
    public static TypedXmlPullParser resolvePullParser(@NonNull InputStream in) throws IOException {
        byte[] magic = new byte[4];
        if (ENABLE_RESOLVE_OPTIMIZATIONS && in instanceof FileInputStream) {
            try {
                Os.pread(((FileInputStream)in).getFD(), magic, 0, magic.length, 0L);
            }
            catch (ErrnoException e) {
                throw e.rethrowAsIOException();
            }
        } else {
            if (!in.markSupported()) {
                in = new BufferedInputStream(in);
            }
            in.mark(8);
            in.read(magic);
            in.reset();
        }
        TypedXmlPullParser xml2 = Arrays.equals(magic, BinaryXmlSerializer.PROTOCOL_MAGIC_VERSION_0) ? Xml.newBinaryPullParser() : Xml.newFastPullParser();
        try {
            xml2.setInput(in, StandardCharsets.UTF_8.name());
        }
        catch (XmlPullParserException e) {
            throw new IOException(e);
        }
        return xml2;
    }

    public static XmlSerializer newSerializer() {
        return Xml.newXmlSerializer();
    }

    @NonNull
    public static TypedXmlSerializer newFastSerializer() {
        return XmlUtils.makeTyped(new FastXmlSerializer());
    }

    @RavenwoodReplace
    @NonNull
    public static TypedXmlSerializer newBinarySerializer() {
        return new ArtBinaryXmlSerializer();
    }

    @NonNull
    public static TypedXmlSerializer newBinarySerializer$ravenwood() {
        return new BinaryXmlSerializer();
    }

    @RavenwoodReplace
    @NonNull
    public static TypedXmlSerializer resolveSerializer(@NonNull OutputStream out) throws IOException {
        TypedXmlSerializer xml2 = ENABLE_BINARY_DEFAULT ? Xml.newBinarySerializer() : Xml.newFastSerializer();
        xml2.setOutput(out, StandardCharsets.UTF_8.name());
        return xml2;
    }

    @NonNull
    public static TypedXmlSerializer resolveSerializer$ravenwood(@NonNull OutputStream out) throws IOException {
        BinaryXmlSerializer xml2 = new BinaryXmlSerializer();
        xml2.setOutput(out, StandardCharsets.UTF_8.name());
        return xml2;
    }

    public static void copy(@NonNull XmlPullParser in, @NonNull XmlSerializer out) throws XmlPullParserException, IOException {
        if (in.getEventType() == 0) {
            out.startDocument(in.getInputEncoding(), Boolean.valueOf(true));
        }
        block13: while (true) {
            int token = in.nextToken();
            switch (token) {
                case 0: {
                    out.startDocument(in.getInputEncoding(), Boolean.valueOf(true));
                    break;
                }
                case 1: {
                    out.endDocument();
                    return;
                }
                case 2: {
                    out.startTag(Xml.normalizeNamespace(in.getNamespace()), in.getName());
                    int i = 0;
                    while (true) {
                        if (i >= in.getAttributeCount()) continue block13;
                        out.attribute(Xml.normalizeNamespace(in.getAttributeNamespace(i)), in.getAttributeName(i), in.getAttributeValue(i));
                        ++i;
                    }
                }
                case 3: {
                    out.endTag(Xml.normalizeNamespace(in.getNamespace()), in.getName());
                    break;
                }
                case 4: {
                    out.text(in.getText());
                    break;
                }
                case 5: {
                    out.cdsect(in.getText());
                    break;
                }
                case 6: {
                    out.entityRef(in.getName());
                    break;
                }
                case 7: {
                    out.ignorableWhitespace(in.getText());
                    break;
                }
                case 8: {
                    out.processingInstruction(in.getText());
                    break;
                }
                case 9: {
                    out.comment(in.getText());
                    break;
                }
                case 10: {
                    out.docdecl(in.getText());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown token " + token);
                }
            }
        }
    }

    @Nullable
    private static String normalizeNamespace(@Nullable String namespace) {
        if (namespace == null || namespace.isEmpty()) {
            return null;
        }
        return namespace;
    }

    public static Encoding findEncodingByName(String encodingName) throws UnsupportedEncodingException {
        if (encodingName == null) {
            return Encoding.UTF_8;
        }
        for (Encoding encoding : Encoding.values()) {
            if (!encoding.expatName.equalsIgnoreCase(encodingName)) continue;
            return encoding;
        }
        throw new UnsupportedEncodingException(encodingName);
    }

    public static AttributeSet asAttributeSet(XmlPullParser parser) {
        return parser instanceof AttributeSet ? (AttributeSet)parser : new XmlPullAttributes(parser);
    }

    @RavenwoodReplace
    @NonNull
    private static XmlSerializer newXmlSerializer() {
        return XmlObjectFactory.newXmlSerializer();
    }

    @NonNull
    private static XmlSerializer newXmlSerializer$ravenwood() {
        try {
            return XmlPullParserFactory.newInstance().newSerializer();
        }
        catch (XmlPullParserException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @RavenwoodReplace
    @NonNull
    private static XmlPullParser newXmlPullParser() {
        return XmlObjectFactory.newXmlPullParser();
    }

    @NonNull
    private static XmlPullParser newXmlPullParser$ravenwood() {
        try {
            return XmlPullParserFactory.newInstance().newPullParser();
        }
        catch (XmlPullParserException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @RavenwoodReplace
    @NonNull
    private static XMLReader newXMLReader() {
        return XmlObjectFactory.newXMLReader();
    }

    @NonNull
    private static XMLReader newXMLReader$ravenwood() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            return factory.newSAXParser().getXMLReader();
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static enum Encoding {
        US_ASCII("US-ASCII"),
        UTF_8("UTF-8"),
        UTF_16("UTF-16"),
        ISO_8859_1("ISO-8859-1");

        final String expatName;

        private Encoding(String expatName) {
            this.expatName = expatName;
        }
    }
}

