/*
 * Decompiled with CFR 0.152.
 */
package android.util.apk;

import android.os.incremental.IncrementalManager;
import android.os.incremental.V4Signature;
import android.util.ArrayMap;
import android.util.Pair;
import android.util.apk.ApkSigningBlockUtils;
import android.util.apk.SignatureNotFoundException;
import android.util.apk.VerbatimX509Certificate;
import com.android.internal.security.VerityUtils;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Map;

public class ApkSignatureSchemeV4Verifier {
    static final int APK_SIGNATURE_SCHEME_DEFAULT = -1;

    public static VerifiedSigner extractCertificates(String apkFile) throws SignatureNotFoundException, SignatureException, SecurityException {
        Pair<V4Signature.HashingInfo, V4Signature.SigningInfos> pair = ApkSignatureSchemeV4Verifier.extractSignature(apkFile);
        return ApkSignatureSchemeV4Verifier.verify(apkFile, (V4Signature.HashingInfo)pair.first, (V4Signature.SigningInfos)pair.second, -1);
    }

    public static Pair<V4Signature.HashingInfo, V4Signature.SigningInfos> extractSignature(String apkFile) throws SignatureNotFoundException, SignatureException {
        try {
            V4Signature signature;
            boolean needsConsistencyCheck;
            File apk = new File(apkFile);
            byte[] signatureBytes = IncrementalManager.unsafeGetFileSignature(apk.getAbsolutePath());
            if (signatureBytes != null && signatureBytes.length > 0) {
                needsConsistencyCheck = false;
                signature = V4Signature.readFrom(signatureBytes);
            } else {
                needsConsistencyCheck = true;
                File idsig = new File(apk.getAbsolutePath() + ".idsig");
                try (FileInputStream fis = new FileInputStream(idsig.getAbsolutePath());){
                    signature = V4Signature.readFrom(fis);
                }
                catch (IOException e) {
                    throw new SignatureNotFoundException("Failed to obtain signature bytes from .idsig");
                }
            }
            if (!signature.isVersionSupported()) {
                throw new SecurityException("v4 signature version " + signature.version + " is not supported");
            }
            V4Signature.HashingInfo hashingInfo = V4Signature.HashingInfo.fromByteArray(signature.hashingInfo);
            V4Signature.SigningInfos signingInfos = V4Signature.SigningInfos.fromByteArray(signature.signingInfos);
            if (needsConsistencyCheck) {
                byte[] actualDigest = VerityUtils.getFsverityDigest(apk.getAbsolutePath());
                if (actualDigest == null) {
                    throw new SecurityException("The APK does not have fs-verity");
                }
                byte[] computedDigest = VerityUtils.generateFsVerityDigest(apk.length(), hashingInfo);
                if (!Arrays.equals(computedDigest, actualDigest)) {
                    throw new SignatureException("Actual digest does not match the v4 signature");
                }
            }
            return Pair.create(hashingInfo, signingInfos);
        }
        catch (EOFException e) {
            throw new SignatureException("V4 signature is invalid.", e);
        }
        catch (IOException e) {
            throw new SignatureNotFoundException("Failed to read V4 signature.", e);
        }
        catch (DigestException | NoSuchAlgorithmException e) {
            throw new SecurityException("Failed to calculate the digest", e);
        }
    }

    public static VerifiedSigner verify(String apkFile, V4Signature.HashingInfo hashingInfo, V4Signature.SigningInfos signingInfos, int v3BlockId) throws SignatureNotFoundException, SecurityException {
        V4Signature.SigningInfo signingInfo = ApkSignatureSchemeV4Verifier.findSigningInfoForBlockId(signingInfos, v3BlockId);
        byte[] signedData = V4Signature.getSignedData(new File(apkFile).length(), hashingInfo, signingInfo);
        Pair<Certificate, byte[]> result = ApkSignatureSchemeV4Verifier.verifySigner(signingInfo, signedData);
        ArrayMap<Integer, byte[]> contentDigests = new ArrayMap<Integer, byte[]>();
        contentDigests.put(ApkSignatureSchemeV4Verifier.convertToContentDigestType(hashingInfo.hashAlgorithm), hashingInfo.rawRootHash);
        return new VerifiedSigner(new Certificate[]{(Certificate)result.first}, (byte[])result.second, contentDigests);
    }

    private static V4Signature.SigningInfo findSigningInfoForBlockId(V4Signature.SigningInfos signingInfos, int v3BlockId) throws SignatureNotFoundException {
        if (v3BlockId == -1 || v3BlockId == -262969152) {
            return signingInfos.signingInfo;
        }
        for (V4Signature.SigningInfoBlock signingInfoBlock : signingInfos.signingInfoBlocks) {
            if (v3BlockId != signingInfoBlock.blockId) continue;
            try {
                return V4Signature.SigningInfo.fromByteArray(signingInfoBlock.signingInfo);
            }
            catch (IOException e) {
                throw new SecurityException("Failed to read V4 signature block: " + signingInfoBlock.blockId, e);
            }
        }
        throw new SecurityException("Failed to find V4 signature block corresponding to V3 blockId: " + v3BlockId);
    }

    private static Pair<Certificate, byte[]> verifySigner(V4Signature.SigningInfo signingInfo, byte[] signedData) throws SecurityException {
        X509Certificate certificate;
        CertificateFactory certFactory;
        boolean sigVerified;
        if (!ApkSigningBlockUtils.isSupportedSignatureAlgorithm(signingInfo.signatureAlgorithmId)) {
            throw new SecurityException("No supported signatures found");
        }
        int signatureAlgorithmId = signingInfo.signatureAlgorithmId;
        byte[] signatureBytes = signingInfo.signature;
        byte[] publicKeyBytes = signingInfo.publicKey;
        byte[] encodedCert = signingInfo.certificate;
        String keyAlgorithm = ApkSigningBlockUtils.getSignatureAlgorithmJcaKeyAlgorithm(signatureAlgorithmId);
        Pair<String, ? extends AlgorithmParameterSpec> signatureAlgorithmParams = ApkSigningBlockUtils.getSignatureAlgorithmJcaSignatureAlgorithm(signatureAlgorithmId);
        String jcaSignatureAlgorithm = (String)signatureAlgorithmParams.first;
        AlgorithmParameterSpec jcaSignatureAlgorithmParams = (AlgorithmParameterSpec)signatureAlgorithmParams.second;
        try {
            PublicKey publicKey = KeyFactory.getInstance(keyAlgorithm).generatePublic(new X509EncodedKeySpec(publicKeyBytes));
            Signature sig = Signature.getInstance(jcaSignatureAlgorithm);
            sig.initVerify(publicKey);
            if (jcaSignatureAlgorithmParams != null) {
                sig.setParameter(jcaSignatureAlgorithmParams);
            }
            sig.update(signedData);
            sigVerified = sig.verify(signatureBytes);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            throw new SecurityException("Failed to verify " + jcaSignatureAlgorithm + " signature", e);
        }
        if (!sigVerified) {
            throw new SecurityException(jcaSignatureAlgorithm + " signature did not verify");
        }
        try {
            certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Failed to obtain X.509 CertificateFactory", e);
        }
        try {
            certificate = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(encodedCert));
        }
        catch (CertificateException e) {
            throw new SecurityException("Failed to decode certificate", e);
        }
        certificate = new VerbatimX509Certificate(certificate, encodedCert);
        byte[] certificatePublicKeyBytes = certificate.getPublicKey().getEncoded();
        if (!Arrays.equals(publicKeyBytes, certificatePublicKeyBytes)) {
            throw new SecurityException("Public key mismatch between certificate and signature record");
        }
        return Pair.create(certificate, signingInfo.apkDigest);
    }

    private static int convertToContentDigestType(int hashAlgorithm) throws SecurityException {
        if (hashAlgorithm == 1) {
            return 3;
        }
        throw new SecurityException("Unsupported hashAlgorithm: " + hashAlgorithm);
    }

    public static class VerifiedSigner {
        public final Certificate[] certs;
        public final byte[] apkDigest;
        public final Map<Integer, byte[]> contentDigests;

        public VerifiedSigner(Certificate[] certs, byte[] apkDigest, Map<Integer, byte[]> contentDigests) {
            this.certs = certs;
            this.apkDigest = apkDigest;
            this.contentDigests = contentDigests;
        }
    }
}

