/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.AttributionSource;
import android.os.CancellationSignal;
import android.os.PersistableBundle;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import android.uwb.IUwbAdapter;
import android.uwb.IUwbRangingCallbacks;
import android.uwb.RangingChangeReason;
import android.uwb.RangingReport;
import android.uwb.RangingSession;
import android.uwb.SessionHandle;
import android.uwb.UwbAddress;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Executor;

public class RangingManager
extends IUwbRangingCallbacks.Stub {
    private final String mTag = "Uwb.RangingManager[" + this + "]";
    private final IUwbAdapter mAdapter;
    private final Hashtable<SessionHandle, RangingSession> mRangingSessionTable = new Hashtable();
    private static int sNextSessionId = 1;

    public RangingManager(IUwbAdapter adapter) {
        this.mAdapter = adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CancellationSignal openSession(@NonNull AttributionSource attributionSource, @NonNull PersistableBundle params, @NonNull Executor executor, @NonNull RangingSession.Callback callbacks, @Nullable String chipId) {
        if (chipId != null) {
            try {
                List<String> validChipIds = this.mAdapter.getChipIds();
                if (!validChipIds.contains(chipId)) {
                    throw new IllegalArgumentException("openSession - received invalid chipId: " + chipId);
                }
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            SessionHandle sessionHandle = new SessionHandle(sNextSessionId++, attributionSource, Process.myPid());
            RangingSession session = new RangingSession(executor, callbacks, this.mAdapter, sessionHandle, chipId);
            Log.v(this.mTag, "openSession - sessionHandle: " + sessionHandle);
            this.mRangingSessionTable.put(sessionHandle, session);
            try {
                this.mAdapter.openRanging(attributionSource, sessionHandle, this, params, chipId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            CancellationSignal cancellationSignal = new CancellationSignal();
            cancellationSignal.setOnCancelListener(() -> session.close());
            return cancellationSignal;
        }
    }

    private boolean hasSession(SessionHandle sessionHandle) {
        return this.mRangingSessionTable.containsKey(sessionHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingOpened(SessionHandle sessionHandle) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onRangingOpened - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingOpened();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingOpenFailed(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onRangingOpenedFailed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingOpenFailed(RangingManager.convertToReason(reason), parameters);
            this.mRangingSessionTable.remove(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingReconfigured(SessionHandle sessionHandle, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onRangingReconfigured - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingReconfigured(parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingReconfigureFailed(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle params) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onRangingReconfigureFailed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingReconfigureFailed(RangingManager.convertToReason(reason), params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingStarted(SessionHandle sessionHandle, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onRangingStarted - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingStarted(parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingStartFailed(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle params) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onRangingStartFailed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingStartFailed(RangingManager.convertToReason(reason), params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingStopped(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle params) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onRangingStopped - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingStopped(RangingManager.convertToReason(reason), params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingStopFailed(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onRangingStopFailed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingStopFailed(RangingManager.convertToReason(reason), parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingClosed(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle params) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onRangingClosed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingClosed(RangingManager.convertToReason(reason), params);
            this.mRangingSessionTable.remove(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingResult(SessionHandle sessionHandle, RangingReport result) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onRangingResult - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingResult(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onControleeAdded(SessionHandle sessionHandle, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onControleeAdded - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onControleeAdded(parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onControleeAddFailed(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onControleeAddFailed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onControleeAddFailed(reason, parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onControleeRemoved(SessionHandle sessionHandle, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onControleeRemoved - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onControleeRemoved(parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onControleeRemoveFailed(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onControleeRemoveFailed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onControleeRemoveFailed(reason, parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingPaused(SessionHandle sessionHandle, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onRangingPaused - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingPaused(parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingPauseFailed(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onRangingPauseFailed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingPauseFailed(reason, parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingResumed(SessionHandle sessionHandle, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onRangingResumed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingResumed(parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingResumeFailed(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onRangingResumeFailed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingResumeFailed(reason, parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataSent(SessionHandle sessionHandle, UwbAddress remoteDeviceAddress, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onDataSent - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onDataSent(remoteDeviceAddress, parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataSendFailed(SessionHandle sessionHandle, UwbAddress remoteDeviceAddress, @RangingChangeReason int reason, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onDataSendFailed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onDataSendFailed(remoteDeviceAddress, reason, parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataTransferPhaseConfigured(SessionHandle sessionHandle, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onDataTransferPhaseConfigured - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onDataTransferPhaseConfigured(parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataTransferPhaseConfigFailed(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onDataTransferPhaseConfigFailed - received unknown SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onDataTransferPhaseConfigFailed(reason, parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataReceived(SessionHandle sessionHandle, UwbAddress remoteDeviceAddress, PersistableBundle parameters, byte[] data) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onDataReceived - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onDataReceived(remoteDeviceAddress, parameters, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataReceiveFailed(SessionHandle sessionHandle, UwbAddress remoteDeviceAddress, @RangingChangeReason int reason, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onDataReceiveFailed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onDataReceiveFailed(remoteDeviceAddress, reason, parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceDiscovered(SessionHandle sessionHandle, @NonNull PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onServiceDiscovered - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onServiceDiscovered(parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onHybridSessionControllerConfigured(SessionHandle sessionHandle, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onHybridSessionControllerConfigured - received unexpectedSessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onHybridSessionControllerConfigured(parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onHybridSessionControllerConfigurationFailed(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onHybridSessionControllerConfigurationFailed - receivedunexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onHybridSessionControllerConfigurationFailed(reason, parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onHybridSessionControleeConfigured(SessionHandle sessionHandle, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onHybridSessionControleeConfigured - received unexpectedSessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onHybridSessionControleeConfigured(parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onHybridSessionControleeConfigurationFailed(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onHybridSessionControleeConfigurationFailed - receivedunexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onHybridSessionControleeConfigurationFailed(reason, parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceConnected(SessionHandle sessionHandle, @NonNull PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onServiceConnected - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onServiceConnected(parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingRoundsUpdateDtTagStatus(SessionHandle sessionHandle, @NonNull PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(this.mTag, "onRangingRoundsUpdateDtTagStatus - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingRoundsUpdateDtTagStatus(parameters);
        }
    }

    private static int convertToReason(@RangingChangeReason int reason) {
        switch (reason) {
            case 1: {
                return 1;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 6;
            }
            case 9: {
                return 15;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 7;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 9;
            }
            case 8: {
                return 14;
            }
            case 12: {
                return 16;
            }
        }
        return 0;
    }
}

