/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.app.ActivityThread;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.ColorSpace;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.OverlayProperties;
import android.hardware.display.BrightnessInfo;
import android.hardware.display.DeviceProductInfo;
import android.hardware.display.DisplayManager;
import android.hardware.display.DisplayManagerGlobal;
import android.hardware.graphics.common.DisplayDecorationSupport;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.ravenwood.annotation.RavenwoodKeep;
import android.ravenwood.annotation.RavenwoodKeepPartialClass;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.ArraySet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.DisplayAddress;
import android.view.DisplayAdjustments;
import android.view.DisplayCutout;
import android.view.DisplayInfo;
import android.view.DisplayShape;
import android.view.Display_Delegate;
import android.view.RoundedCorner;
import android.view.RoundedCorners;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

@RavenwoodKeepPartialClass
public class Display {
    private static final String TAG = "Display";
    private static final boolean DEBUG = false;
    private final Object mLock = new Object();
    private final DisplayManagerGlobal mGlobal;
    private final int mDisplayId;
    private final int mFlags;
    private final int mType;
    private final int mOwnerUid;
    private final String mOwnerPackageName;
    private final Resources mResources;
    private DisplayAdjustments mDisplayAdjustments;
    private boolean mRefreshRateChangesRegistered;
    @UnsupportedAppUsage
    private DisplayInfo mDisplayInfo;
    private boolean mIsValid;
    private final DisplayMetrics mTempMetrics = new DisplayMetrics();
    private static final int CACHED_APP_SIZE_DURATION_MILLIS = 20;
    private long mLastCachedAppSizeUpdate;
    private int mCachedAppWidthCompat;
    private int mCachedAppHeightCompat;
    private ArrayList<HdrSdrRatioListenerWrapper> mHdrSdrRatioListeners = new ArrayList();
    public static final int DEFAULT_DISPLAY = 0;
    public static final int INVALID_DISPLAY = -1;
    public static final int INVALID_DISPLAY_WIDTH = -1;
    public static final int INVALID_DISPLAY_HEIGHT = -1;
    public static final float INVALID_DISPLAY_REFRESH_RATE = 0.0f;
    public static final int DEFAULT_DISPLAY_GROUP = 0;
    public static final int INVALID_DISPLAY_GROUP = -1;
    public static final int FLAG_SUPPORTS_PROTECTED_BUFFERS = 1;
    public static final int FLAG_SECURE = 2;
    public static final int FLAG_PRIVATE = 4;
    public static final int FLAG_PRESENTATION = 8;
    public static final int FLAG_ROUND = 16;
    public static final int FLAG_CAN_SHOW_WITH_INSECURE_KEYGUARD = 32;
    public static final int FLAG_SHOULD_SHOW_SYSTEM_DECORATIONS = 64;
    public static final int FLAG_TRUSTED = 128;
    public static final int FLAG_OWN_DISPLAY_GROUP = 256;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int FLAG_ALWAYS_UNLOCKED = 512;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int FLAG_TOUCH_FEEDBACK_DISABLED = 1024;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int FLAG_OWN_FOCUS = 2048;
    public static final int FLAG_STEAL_TOP_FOCUS_DISABLED = 4096;
    public static final int FLAG_REAR = 8192;
    public static final int FLAG_ROTATES_WITH_CONTENT = 16384;
    public static final int FLAG_ALLOWS_CONTENT_MODE_SWITCH = 32768;
    public static final int FLAG_SCALING_DISABLED = 0x40000000;
    @UnsupportedAppUsage
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_INTERNAL = 1;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int TYPE_EXTERNAL = 2;
    @UnsupportedAppUsage
    public static final int TYPE_WIFI = 3;
    public static final int TYPE_OVERLAY = 4;
    @UnsupportedAppUsage
    public static final int TYPE_VIRTUAL = 5;
    public static final int TYPE_MAX = 5;
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_OFF = 1;
    public static final int STATE_ON = 2;
    public static final int STATE_DOZE = 3;
    public static final int STATE_DOZE_SUSPEND = 4;
    public static final int STATE_VR = 5;
    public static final int STATE_ON_SUSPEND = 6;
    public static final int STATE_REASON_UNKNOWN = 0;
    public static final int STATE_REASON_DEFAULT_POLICY = 1;
    public static final int STATE_REASON_DRAW_WAKE_LOCK = 2;
    public static final int STATE_REASON_OFFLOAD = 3;
    public static final int STATE_REASON_TILT = 4;
    public static final int STATE_REASON_DREAM_MANAGER = 5;
    public static final int STATE_REASON_KEY = 6;
    public static final int STATE_REASON_MOTION = 7;
    public static final int COLOR_MODE_INVALID = -1;
    public static final int COLOR_MODE_DEFAULT = 0;
    public static final int COLOR_MODE_BT601_625 = 1;
    public static final int COLOR_MODE_BT601_625_UNADJUSTED = 2;
    public static final int COLOR_MODE_BT601_525 = 3;
    public static final int COLOR_MODE_BT601_525_UNADJUSTED = 4;
    public static final int COLOR_MODE_BT709 = 5;
    public static final int COLOR_MODE_DCI_P3 = 6;
    public static final int COLOR_MODE_SRGB = 7;
    public static final int COLOR_MODE_ADOBE_RGB = 8;
    public static final int COLOR_MODE_DISPLAY_P3 = 9;
    public static final int REMOVE_MODE_MOVE_CONTENT_TO_PRIMARY = 0;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int REMOVE_MODE_DESTROY_CONTENT = 1;
    public static final int DISPLAY_MODE_ID_FOR_FRAME_RATE_OVERRIDE = 255;
    @FlaggedApi(value="com.android.server.display.feature.flags.enable_get_suggested_frame_rate")
    public static final int FRAME_RATE_CATEGORY_NORMAL = 0;
    @FlaggedApi(value="com.android.server.display.feature.flags.enable_get_suggested_frame_rate")
    public static final int FRAME_RATE_CATEGORY_HIGH = 1;

    public Display(DisplayManagerGlobal global, int displayId, DisplayInfo displayInfo, DisplayAdjustments daj) {
        this(global, displayId, displayInfo, daj, null);
    }

    public Display(DisplayManagerGlobal global, int displayId, DisplayInfo displayInfo, Resources res) {
        this(global, displayId, displayInfo, null, res);
    }

    private Display(DisplayManagerGlobal global, int displayId, DisplayInfo displayInfo, DisplayAdjustments daj, Resources res) {
        this.mGlobal = global;
        this.mDisplayId = displayId;
        this.mDisplayInfo = displayInfo;
        this.mResources = res;
        this.mDisplayAdjustments = this.mResources != null ? new DisplayAdjustments(this.mResources.getConfiguration()) : (daj != null ? new DisplayAdjustments(daj) : new DisplayAdjustments());
        this.mIsValid = true;
        this.mFlags = displayInfo.flags;
        this.mType = displayInfo.type;
        this.mOwnerUid = displayInfo.ownerUid;
        this.mOwnerPackageName = displayInfo.ownerPackageName;
    }

    public int getDisplayId() {
        return this.mDisplayId;
    }

    @Nullable
    public String getUniqueId() {
        return this.mDisplayInfo.uniqueId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mIsValid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=28)
    public boolean getDisplayInfo(DisplayInfo outDisplayInfo) {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            outDisplayInfo.copyFrom(this.mDisplayInfo);
            return this.mIsValid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLayerStack() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.layerStack;
        }
    }

    public int getFlags() {
        return this.mFlags;
    }

    @UnsupportedAppUsage
    public int getType() {
        return this.mType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayAddress getAddress() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.address;
        }
    }

    public int getOwnerUid() {
        return this.mOwnerUid;
    }

    @UnsupportedAppUsage
    public String getOwnerPackageName() {
        return this.mOwnerPackageName;
    }

    @UnsupportedAppUsage
    public DisplayAdjustments getDisplayAdjustments() {
        DisplayAdjustments currentAdjustments;
        if (this.mResources != null && !this.mDisplayAdjustments.equals(currentAdjustments = this.mResources.getDisplayAdjustments())) {
            this.mDisplayAdjustments = new DisplayAdjustments(currentAdjustments);
        }
        return this.mDisplayAdjustments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getBrightnessDefault() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.brightnessDefault;
        }
    }

    @RequiresPermission(value="android.permission.CONTROL_DISPLAY_BRIGHTNESS")
    @Nullable
    public BrightnessInfo getBrightnessInfo() {
        return this.mGlobal.getBrightnessInfo(this.mDisplayId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void getSize(Point outSize) {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(this.mTempMetrics, this.getDisplayAdjustments());
            outSize.x = this.mTempMetrics.widthPixels;
            outSize.y = this.mTempMetrics.heightPixels;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void getRectSize(Rect outSize) {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(this.mTempMetrics, this.getDisplayAdjustments());
            outSize.set(0, 0, this.mTempMetrics.widthPixels, this.mTempMetrics.heightPixels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCurrentSizeRange(Point outSmallestSize, Point outLargestSize) {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            outSmallestSize.x = this.mDisplayInfo.smallestNominalAppWidth;
            outSmallestSize.y = this.mDisplayInfo.smallestNominalAppHeight;
            outLargestSize.x = this.mDisplayInfo.largestNominalAppWidth;
            outLargestSize.y = this.mDisplayInfo.largestNominalAppHeight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public int getMaximumSizeDimension() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return Math.max(this.mDisplayInfo.logicalWidth, this.mDisplayInfo.logicalHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getMinSizeDimensionDp() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(this.mTempMetrics);
            return TypedValue.deriveDimension(1, Math.min(this.mDisplayInfo.logicalWidth, this.mDisplayInfo.logicalHeight), this.mTempMetrics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int getWidth() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateCachedAppSizeIfNeededLocked();
            return this.mCachedAppWidthCompat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int getHeight() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateCachedAppSizeIfNeededLocked();
            return this.mCachedAppHeightCompat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRotation() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.getLocalRotation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInstallOrientation() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.installOrientation;
        }
    }

    @Deprecated
    public int getOrientation() {
        return this.getRotation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DisplayCutout getCutout() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            if (this.mResources == null) {
                return this.mDisplayInfo.displayCutout;
            }
            DisplayCutout localCutout = this.mDisplayInfo.displayCutout;
            if (localCutout == null) {
                return null;
            }
            int rotation = this.getLocalRotation();
            if (rotation != this.mDisplayInfo.rotation) {
                return localCutout.getRotated(this.mDisplayInfo.logicalWidth, this.mDisplayInfo.logicalHeight, this.mDisplayInfo.rotation, rotation);
            }
            return localCutout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"VisiblySynchronized"})
    @Nullable
    public RoundedCorner getRoundedCorner(int position) {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            RoundedCorners roundedCorners = this.mDisplayInfo.roundedCorners;
            int rotation = this.getLocalRotation();
            if (roundedCorners != null && rotation != this.mDisplayInfo.rotation) {
                roundedCorners.rotate(rotation, this.mDisplayInfo.logicalWidth, this.mDisplayInfo.logicalHeight);
            }
            return roundedCorners == null ? null : roundedCorners.getRoundedCorner(position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"VisiblySynchronized"})
    @NonNull
    public DisplayShape getShape() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            DisplayShape displayShape = this.mDisplayInfo.displayShape;
            int rotation = this.getLocalRotation();
            if (displayShape != null && rotation != this.mDisplayInfo.rotation) {
                return displayShape.setRotation(rotation);
            }
            return displayShape;
        }
    }

    @Deprecated
    public int getPixelFormat() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getRefreshRate() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mRefreshRateChangesRegistered) {
                DisplayManagerGlobal.getInstance().registerForRefreshRateChanges();
                this.mRefreshRateChangesRegistered = true;
            }
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.getRefreshRate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="com.android.server.display.feature.flags.enable_get_supported_refresh_rates")
    @NonNull
    public float[] getSupportedRefreshRates() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            float[] refreshRates = this.mDisplayInfo.getDefaultRefreshRates();
            Objects.requireNonNull(refreshRates);
            return refreshRates;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"UnflaggedApi"})
    @NonNull
    public float[] getSupportedRefreshRatesLegacy() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            float[] refreshRates = this.mDisplayInfo.getDefaultRefreshRatesLegacy();
            Objects.requireNonNull(refreshRates);
            return refreshRates;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mode getMode() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.getMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Mode getDefaultMode() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.getDefaultMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mode[] getSupportedModes() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            Mode[] modes = this.mDisplayInfo.appsSupportedModes;
            return Arrays.copyOf(modes, modes.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"ArrayReturn"})
    @NonNull
    public Mode[] getSystemSupportedModes() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            Mode[] modes = this.mDisplayInfo.supportedModes;
            return Arrays.copyOf(modes, modes.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="com.android.server.display.feature.flags.enable_has_arr_support")
    public boolean hasArrSupport() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.hasArrSupport;
        }
    }

    @FlaggedApi(value="com.android.server.display.feature.flags.enable_get_suggested_frame_rate")
    public float getSuggestedFrameRate(int category) {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            if (category == 1) {
                return this.mDisplayInfo.frameRateCategoryRate.getHigh();
            }
            if (category == 0) {
                return this.mDisplayInfo.frameRateCategoryRate.getNormal();
            }
            throw new IllegalArgumentException("Invalid FrameRateCategory provided");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"VisiblySynchronized"})
    public boolean isMinimalPostProcessingSupported() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.minimalPostProcessingSupported;
        }
    }

    @RequiresPermission(value="android.permission.CONFIGURE_DISPLAY_COLOR_MODE")
    public void requestColorMode(int colorMode) {
        this.mGlobal.requestColorMode(this.mDisplayId, colorMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColorMode() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.colorMode;
        }
    }

    @SuppressLint(value={"UnflaggedApi"})
    public int getRemoveMode() {
        return this.mDisplayInfo.removeMode;
    }

    @Nullable
    public Mode getSystemPreferredDisplayMode() {
        return this.mGlobal.getSystemPreferredDisplayMode(this.getDisplayId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HdrCapabilities getHdrCapabilities() {
        Object object = this.mLock;
        synchronized (object) {
            int[] supportedHdrTypes;
            this.updateDisplayInfoLocked();
            if (this.mDisplayInfo.hdrCapabilities == null || this.mDisplayInfo.isForceSdr) {
                return null;
            }
            if (this.mDisplayInfo.userDisabledHdrTypes.length == 0) {
                int[] modeSupportedHdrTypes = this.getMode().getSupportedHdrTypes();
                supportedHdrTypes = Arrays.copyOf(modeSupportedHdrTypes, modeSupportedHdrTypes.length);
            } else {
                ArraySet<Integer> enabledTypesSet = new ArraySet<Integer>();
                for (int supportedType : this.getMode().getSupportedHdrTypes()) {
                    if (this.contains(this.mDisplayInfo.userDisabledHdrTypes, supportedType)) continue;
                    enabledTypesSet.add(supportedType);
                }
                supportedHdrTypes = new int[enabledTypesSet.size()];
                int index = 0;
                Iterator iterator = enabledTypesSet.iterator();
                while (iterator.hasNext()) {
                    int enabledType = (Integer)iterator.next();
                    supportedHdrTypes[index++] = enabledType;
                }
            }
            return new HdrCapabilities(supportedHdrTypes, this.mDisplayInfo.hdrCapabilities.mMaxLuminance, this.mDisplayInfo.hdrCapabilities.mMaxAverageLuminance, this.mDisplayInfo.hdrCapabilities.mMinLuminance);
        }
    }

    private boolean contains(int[] disabledHdrTypes, int hdrType) {
        int[] nArray = disabledHdrTypes;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer disabledHdrFormat = nArray[i];
            if (disabledHdrFormat != hdrType) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public int[] getReportedHdrTypes() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.getMode().getSupportedHdrTypes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHdr() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            HdrCapabilities hdrCapabilities = this.getHdrCapabilities();
            if (hdrCapabilities == null) {
                return false;
            }
            return hdrCapabilities.getSupportedHdrTypes().length != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHdrSdrRatioAvailable() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return !Float.isNaN(this.mDisplayInfo.hdrSdrRatio);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getHdrSdrRatio() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return Float.isNaN(this.mDisplayInfo.hdrSdrRatio) ? 1.0f : this.mDisplayInfo.hdrSdrRatio;
        }
    }

    private int findHdrSdrRatioListenerLocked(Consumer<Display> listener) {
        for (int i = 0; i < this.mHdrSdrRatioListeners.size(); ++i) {
            HdrSdrRatioListenerWrapper wrapper = this.mHdrSdrRatioListeners.get(i);
            if (wrapper.mListener != listener) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHdrSdrRatioChangedListener(@NonNull Executor executor, @NonNull Consumer<Display> listener) {
        if (!this.isHdrSdrRatioAvailable()) {
            throw new IllegalStateException("HDR/SDR ratio changed not available");
        }
        HdrSdrRatioListenerWrapper toRegister = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.findHdrSdrRatioListenerLocked(listener) == -1) {
                toRegister = new HdrSdrRatioListenerWrapper(listener);
                this.mHdrSdrRatioListeners.add(toRegister);
            }
        }
        if (toRegister != null) {
            this.mGlobal.registerDisplayListener((DisplayManager.DisplayListener)toRegister, executor, 18L, ActivityThread.currentPackageName(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHdrSdrRatioChangedListener(@NonNull Consumer<Display> listener) {
        HdrSdrRatioListenerWrapper toRemove = null;
        Object object = this.mLock;
        synchronized (object) {
            int index = this.findHdrSdrRatioListenerLocked(listener);
            if (index != -1) {
                toRemove = this.mHdrSdrRatioListeners.remove(index);
            }
        }
        if (toRemove != null) {
            this.mGlobal.unregisterDisplayListener(toRemove);
        }
    }

    @FlaggedApi(value="com.android.server.display.feature.flags.highest_hdr_sdr_ratio_api")
    public float getHighestHdrSdrRatio() {
        return this.mGlobal.getHighestHdrSdrRatio(this.mDisplayId);
    }

    @RequiresPermission(value="android.permission.MODIFY_USER_PREFERRED_DISPLAY_MODE")
    public void setUserPreferredDisplayMode(@NonNull Mode mode) {
        Mode preferredMode = new Mode(mode.getPhysicalWidth(), mode.getPhysicalHeight(), mode.getRefreshRate());
        this.mGlobal.setUserPreferredDisplayMode(this.mDisplayId, preferredMode);
    }

    @RequiresPermission(value="android.permission.MODIFY_USER_PREFERRED_DISPLAY_MODE")
    public void clearUserPreferredDisplayMode() {
        this.mGlobal.setUserPreferredDisplayMode(this.mDisplayId, null);
    }

    @Nullable
    public Mode getUserPreferredDisplayMode() {
        return this.mGlobal.getUserPreferredDisplayMode(this.mDisplayId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWideColorGamut() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.isWideColorGamut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ColorSpace getPreferredWideGamutColorSpace() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            if (this.mDisplayInfo.isWideColorGamut()) {
                return this.mGlobal.getPreferredWideGamutColorSpace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="android.hardware.flags.overlayproperties_class_api")
    @NonNull
    public OverlayProperties getOverlaySupport() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            if (this.mDisplayInfo.type == 1 || this.mDisplayInfo.type == 2) {
                return this.mGlobal.getOverlaySupport();
            }
            return OverlayProperties.getDefault();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getSupportedColorModes() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            int[] colorModes = this.mDisplayInfo.supportedColorModes;
            return Arrays.copyOf(colorModes, colorModes.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"VisiblySynchronized"})
    @NonNull
    public ColorSpace[] getSupportedWideColorGamut() {
        Object object = this.mLock;
        synchronized (object) {
            ColorSpace[] defaultColorSpaces = new ColorSpace[]{};
            this.updateDisplayInfoLocked();
            if (!this.isWideColorGamut()) {
                return defaultColorSpaces;
            }
            int[] colorModes = this.getSupportedColorModes();
            ArrayList<ColorSpace> colorSpaces = new ArrayList<ColorSpace>();
            block7: for (int colorMode : colorModes) {
                switch (colorMode) {
                    case 6: {
                        colorSpaces.add(ColorSpace.get(ColorSpace.Named.DCI_P3));
                        continue block7;
                    }
                    case 9: {
                        colorSpaces.add(ColorSpace.get(ColorSpace.Named.DISPLAY_P3));
                    }
                }
            }
            return colorSpaces.toArray(defaultColorSpaces);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAppVsyncOffsetNanos() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.appVsyncOffsetNanos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPresentationDeadlineNanos() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.presentationDeadlineNanos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DeviceProductInfo getDeviceProductInfo() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.deviceProductInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void getMetrics(DisplayMetrics outMetrics) {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(outMetrics, this.getDisplayAdjustments());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void getRealSize(Point outSize) {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            if (this.shouldReportMaxBounds()) {
                Rect bounds = this.mResources.getConfiguration().windowConfiguration.getMaxBounds();
                outSize.x = bounds.width();
                outSize.y = bounds.height();
                return;
            }
            outSize.x = this.mDisplayInfo.logicalWidth;
            outSize.y = this.mDisplayInfo.logicalHeight;
            int rotation = this.getLocalRotation();
            if (rotation != this.mDisplayInfo.rotation) {
                this.adjustSize(outSize, this.mDisplayInfo.rotation, rotation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void getRealMetrics(DisplayMetrics outMetrics) {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            if (this.shouldReportMaxBounds()) {
                this.mDisplayInfo.getMaxBoundsMetrics(outMetrics, CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO, this.mResources.getConfiguration());
                return;
            }
            this.mDisplayInfo.getLogicalMetrics(outMetrics, CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO, null);
            int rotation = this.getLocalRotation();
            if (rotation != this.mDisplayInfo.rotation) {
                this.adjustMetrics(outMetrics, this.mDisplayInfo.rotation, rotation);
            }
        }
    }

    private boolean shouldReportMaxBounds() {
        if (this.mResources == null) {
            return false;
        }
        Configuration config = this.mResources.getConfiguration();
        return config != null && !config.windowConfiguration.getMaxBounds().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mIsValid ? this.mDisplayInfo.state : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCommittedState() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mIsValid ? this.mDisplayInfo.committedState : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canHostTasks() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            return this.mIsValid && this.mDisplayInfo.canHostTasks;
        }
    }

    public boolean hasAccess(int uid) {
        return Display.hasAccess(uid, this.mFlags, this.mOwnerUid, this.mDisplayId);
    }

    public static boolean hasAccess(int uid, int flags, int ownerUid, int displayId) {
        return (flags & 4) == 0 || uid == ownerUid || uid == 1000 || uid == 0 || DisplayManagerGlobal.getInstance().isUidPresentOnDisplay(uid, displayId);
    }

    public boolean isPublicPresentation() {
        return (this.mFlags & 0xC) == 8;
    }

    public boolean isTrusted() {
        return (this.mFlags & 0x80) == 128;
    }

    public boolean canStealTopFocus() {
        return (this.mFlags & 0x1000) == 0;
    }

    void updateDisplayInfoLocked_Original() {
        DisplayInfo newInfo = this.mGlobal.getDisplayInfo(this.mDisplayId);
        if (newInfo == null) {
            if (this.mIsValid) {
                this.mIsValid = false;
            }
        } else {
            this.mDisplayInfo = newInfo;
            if (!this.mIsValid) {
                this.mIsValid = true;
            }
        }
    }

    @LayoutlibDelegate
    private void updateDisplayInfoLocked() {
        Display_Delegate.updateDisplayInfoLocked(this);
    }

    private void updateCachedAppSizeIfNeededLocked() {
        long now = SystemClock.uptimeMillis();
        if (now > this.mLastCachedAppSizeUpdate + 20L) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(this.mTempMetrics, this.getDisplayAdjustments());
            this.mCachedAppWidthCompat = this.mTempMetrics.widthPixels;
            this.mCachedAppHeightCompat = this.mTempMetrics.heightPixels;
            this.mLastCachedAppSizeUpdate = now;
        }
    }

    private static boolean noFlip(int realRotation, int localRotation) {
        return (realRotation - localRotation + 4) % 2 == 0;
    }

    private void adjustSize(@NonNull Point size, int realRotation, int localRotation) {
        if (Display.noFlip(realRotation, localRotation)) {
            return;
        }
        int w = size.x;
        size.x = size.y;
        size.y = w;
    }

    private void adjustMetrics(@NonNull DisplayMetrics metrics, int realRotation, int localRotation) {
        if (Display.noFlip(realRotation, localRotation)) {
            return;
        }
        int w = metrics.widthPixels;
        metrics.widthPixels = metrics.heightPixels;
        metrics.heightPixels = w;
        w = metrics.noncompatWidthPixels;
        metrics.noncompatWidthPixels = metrics.noncompatHeightPixels;
        metrics.noncompatHeightPixels = w;
    }

    private int getLocalRotation() {
        if (this.mResources == null) {
            return this.mDisplayInfo.rotation;
        }
        int localRotation = this.mResources.getConfiguration().windowConfiguration.getDisplayRotation();
        if (localRotation != -1) {
            return localRotation;
        }
        return this.mDisplayInfo.rotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.mLock;
        synchronized (object) {
            this.updateDisplayInfoLocked();
            DisplayAdjustments adjustments = this.getDisplayAdjustments();
            this.mDisplayInfo.getAppMetrics(this.mTempMetrics, adjustments);
            return "Display id " + this.mDisplayId + ": " + this.mDisplayInfo + ", " + this.mTempMetrics + ", isValid=" + this.mIsValid;
        }
    }

    public static String typeToString(int type) {
        switch (type) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "INTERNAL";
            }
            case 2: {
                return "EXTERNAL";
            }
            case 3: {
                return "WIFI";
            }
            case 4: {
                return "OVERLAY";
            }
            case 5: {
                return "VIRTUAL";
            }
        }
        return Integer.toString(type);
    }

    @RavenwoodKeep
    public static String stateToString(int state) {
        switch (state) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "OFF";
            }
            case 2: {
                return "ON";
            }
            case 3: {
                return "DOZE";
            }
            case 4: {
                return "DOZE_SUSPEND";
            }
            case 5: {
                return "VR";
            }
            case 6: {
                return "ON_SUSPEND";
            }
        }
        return Integer.toString(state);
    }

    @RavenwoodKeep
    public static String stateReasonToString(int reason) {
        switch (reason) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "DEFAULT_POLICY";
            }
            case 2: {
                return "DRAW_WAKE_LOCK";
            }
            case 3: {
                return "OFFLOAD";
            }
            case 4: {
                return "TILT";
            }
            case 5: {
                return "DREAM_MANAGER";
            }
            case 6: {
                return "KEY";
            }
            case 7: {
                return "MOTION";
            }
        }
        return Integer.toString(reason);
    }

    @RavenwoodKeep
    public static boolean isSuspendedState(int state) {
        return state == 1 || state == 4 || state == 6;
    }

    @RavenwoodKeep
    public static boolean isDozeState(int state) {
        return state == 3 || state == 4;
    }

    @RavenwoodKeep
    public static boolean isActiveState(int state) {
        return state == 2 || state == 5;
    }

    @RavenwoodKeep
    public static boolean isOffState(int state) {
        return state == 1;
    }

    @RavenwoodKeep
    public static boolean isOnState(int state) {
        return state == 2 || state == 5 || state == 6;
    }

    public static boolean isWidthValid(int width) {
        return width > 0;
    }

    public static boolean isHeightValid(int height) {
        return height > 0;
    }

    public static boolean isRefreshRateValid(float refreshRate) {
        return refreshRate > 0.0f;
    }

    public DisplayDecorationSupport getDisplayDecorationSupport() {
        return this.mGlobal.getDisplayDecorationSupport(this.mDisplayId);
    }

    @RavenwoodKeepWholeClass
    public static class Mode
    implements Parcelable {
        public static final Mode[] EMPTY_ARRAY = new Mode[0];
        public static final int INVALID_MODE_ID = -1;
        private final int mModeId;
        private final int mWidth;
        private final int mHeight;
        private final float mPeakRefreshRate;
        private final float mVsyncRate;
        @NonNull
        private final float[] mAlternativeRefreshRates;
        @NonNull
        private final int[] mSupportedHdrTypes;
        private final boolean mIsSynthetic;
        @NonNull
        public static final Parcelable.Creator<Mode> CREATOR = new Parcelable.Creator<Mode>(){

            @Override
            public Mode createFromParcel(Parcel in) {
                return new Mode(in);
            }

            public Mode[] newArray(int size) {
                return new Mode[size];
            }
        };

        public Mode(int width, int height, float refreshRate) {
            this(-1, width, height, refreshRate, refreshRate, new float[0], new int[0]);
        }

        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public Mode(int modeId, int width, int height, float refreshRate) {
            this(modeId, width, height, refreshRate, refreshRate, new float[0], new int[0]);
        }

        public Mode(int modeId, int width, int height, float refreshRate, float[] alternativeRefreshRates, int[] supportedHdrTypes) {
            this(modeId, width, height, refreshRate, refreshRate, alternativeRefreshRates, supportedHdrTypes);
        }

        public Mode(int modeId, int width, int height, float refreshRate, float vsyncRate, float[] alternativeRefreshRates, int[] supportedHdrTypes) {
            this(modeId, width, height, refreshRate, vsyncRate, false, alternativeRefreshRates, supportedHdrTypes);
        }

        public Mode(int modeId, int width, int height, float refreshRate, float vsyncRate, boolean isSynthetic, float[] alternativeRefreshRates, int[] supportedHdrTypes) {
            this.mModeId = modeId;
            this.mWidth = width;
            this.mHeight = height;
            this.mPeakRefreshRate = refreshRate;
            this.mVsyncRate = vsyncRate;
            this.mIsSynthetic = isSynthetic;
            this.mAlternativeRefreshRates = Arrays.copyOf(alternativeRefreshRates, alternativeRefreshRates.length);
            Arrays.sort(this.mAlternativeRefreshRates);
            this.mSupportedHdrTypes = Arrays.copyOf(supportedHdrTypes, supportedHdrTypes.length);
            Arrays.sort(this.mSupportedHdrTypes);
        }

        public int getModeId() {
            return this.mModeId;
        }

        public int getPhysicalWidth() {
            return this.mWidth;
        }

        public int getPhysicalHeight() {
            return this.mHeight;
        }

        public float getRefreshRate() {
            return this.mPeakRefreshRate;
        }

        public float getVsyncRate() {
            return this.mVsyncRate;
        }

        public boolean isSynthetic() {
            return this.mIsSynthetic;
        }

        @NonNull
        public float[] getAlternativeRefreshRates() {
            return Arrays.copyOf(this.mAlternativeRefreshRates, this.mAlternativeRefreshRates.length);
        }

        @NonNull
        public int[] getSupportedHdrTypes() {
            return Arrays.copyOf(this.mSupportedHdrTypes, this.mSupportedHdrTypes.length);
        }

        public boolean matches(int width, int height, float refreshRate) {
            return this.mWidth == width && this.mHeight == height && Float.floatToIntBits(this.mPeakRefreshRate) == Float.floatToIntBits(refreshRate);
        }

        public boolean matchesIfValid(int width, int height, float peakRefreshRate) {
            if (!(Display.isWidthValid(width) || Display.isHeightValid(height) || Display.isRefreshRateValid(peakRefreshRate))) {
                return false;
            }
            if (Display.isWidthValid(width) != Display.isHeightValid(height)) {
                return false;
            }
            return !(Display.isWidthValid(width) && this.mWidth != width || Display.isHeightValid(height) && this.mHeight != height || Display.isRefreshRateValid(peakRefreshRate) && Float.floatToIntBits(this.mPeakRefreshRate) != Float.floatToIntBits(peakRefreshRate));
        }

        public boolean equalsExceptRefreshRate(@Nullable Mode other) {
            return this.mWidth == other.mWidth && this.mHeight == other.mHeight;
        }

        public boolean isRefreshRateSet() {
            return this.mPeakRefreshRate != 0.0f;
        }

        public boolean isResolutionSet() {
            return this.mWidth != -1 && this.mHeight != -1;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Mode)) {
                return false;
            }
            Mode that = (Mode)other;
            return this.mModeId == that.mModeId && this.matches(that.mWidth, that.mHeight, that.mPeakRefreshRate) && Arrays.equals(this.mAlternativeRefreshRates, that.mAlternativeRefreshRates) && Arrays.equals(this.mSupportedHdrTypes, that.mSupportedHdrTypes);
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 17 + this.mModeId;
            hash = hash * 17 + this.mWidth;
            hash = hash * 17 + this.mHeight;
            hash = hash * 17 + Float.floatToIntBits(this.mPeakRefreshRate);
            hash = hash * 17 + Float.floatToIntBits(this.mVsyncRate);
            hash = hash * 17 + Arrays.hashCode(this.mAlternativeRefreshRates);
            hash = hash * 17 + Arrays.hashCode(this.mSupportedHdrTypes);
            return hash;
        }

        public String toString() {
            return "{" + "id=" + this.mModeId + ", width=" + this.mWidth + ", height=" + this.mHeight + ", fps=" + this.mPeakRefreshRate + ", vsync=" + this.mVsyncRate + ", synthetic=" + this.mIsSynthetic + ", alternativeRefreshRates=" + Arrays.toString(this.mAlternativeRefreshRates) + ", supportedHdrTypes=" + Arrays.toString(this.mSupportedHdrTypes) + "}";
        }

        @Override
        public int describeContents() {
            return 0;
        }

        private Mode(Parcel in) {
            this(in.readInt(), in.readInt(), in.readInt(), in.readFloat(), in.readFloat(), in.readBoolean(), in.createFloatArray(), in.createIntArray());
        }

        @Override
        public void writeToParcel(Parcel out, int parcelableFlags) {
            out.writeInt(this.mModeId);
            out.writeInt(this.mWidth);
            out.writeInt(this.mHeight);
            out.writeFloat(this.mPeakRefreshRate);
            out.writeFloat(this.mVsyncRate);
            out.writeBoolean(this.mIsSynthetic);
            out.writeFloatArray(this.mAlternativeRefreshRates);
            out.writeIntArray(this.mSupportedHdrTypes);
        }

        public static class Builder {
            private int mWidth = -1;
            private int mHeight = -1;
            private float mRefreshRate = 0.0f;

            @NonNull
            public Builder setResolution(int width, int height) {
                if (width > 0 && height > 0) {
                    this.mWidth = width;
                    this.mHeight = height;
                }
                return this;
            }

            @NonNull
            public Builder setRefreshRate(float refreshRate) {
                if (refreshRate > 0.0f) {
                    this.mRefreshRate = refreshRate;
                }
                return this;
            }

            @NonNull
            public Mode build() {
                Mode mode = new Mode(this.mWidth, this.mHeight, this.mRefreshRate);
                return mode;
            }
        }
    }

    @RavenwoodKeepWholeClass
    public static class HdrCapabilities
    implements Parcelable {
        public static final float INVALID_LUMINANCE = -1.0f;
        public static final int HDR_TYPE_INVALID = -1;
        public static final int HDR_TYPE_DOLBY_VISION = 1;
        public static final int HDR_TYPE_HDR10 = 2;
        public static final int HDR_TYPE_HLG = 3;
        public static final int HDR_TYPE_HDR10_PLUS = 4;
        public static final int[] HDR_TYPES = new int[]{1, 2, 3, 4};
        private int[] mSupportedHdrTypes = new int[0];
        private float mMaxLuminance = -1.0f;
        private float mMaxAverageLuminance = -1.0f;
        private float mMinLuminance = -1.0f;
        @NonNull
        public static final Parcelable.Creator<HdrCapabilities> CREATOR = new Parcelable.Creator<HdrCapabilities>(){

            @Override
            public HdrCapabilities createFromParcel(Parcel source) {
                return new HdrCapabilities(source);
            }

            public HdrCapabilities[] newArray(int size) {
                return new HdrCapabilities[size];
            }
        };

        public HdrCapabilities() {
        }

        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public HdrCapabilities(int[] supportedHdrTypes, float maxLuminance, float maxAverageLuminance, float minLuminance) {
            this.mSupportedHdrTypes = supportedHdrTypes;
            Arrays.sort(this.mSupportedHdrTypes);
            this.mMaxLuminance = maxLuminance;
            this.mMaxAverageLuminance = maxAverageLuminance;
            this.mMinLuminance = minLuminance;
        }

        @Deprecated
        public int[] getSupportedHdrTypes() {
            return Arrays.copyOf(this.mSupportedHdrTypes, this.mSupportedHdrTypes.length);
        }

        public float getDesiredMaxLuminance() {
            return this.mMaxLuminance;
        }

        public float getDesiredMaxAverageLuminance() {
            return this.mMaxAverageLuminance;
        }

        public float getDesiredMinLuminance() {
            return this.mMinLuminance;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HdrCapabilities)) {
                return false;
            }
            HdrCapabilities that = (HdrCapabilities)other;
            return Arrays.equals(this.mSupportedHdrTypes, that.mSupportedHdrTypes) && this.mMaxLuminance == that.mMaxLuminance && this.mMaxAverageLuminance == that.mMaxAverageLuminance && this.mMinLuminance == that.mMinLuminance;
        }

        public int hashCode() {
            int hash = 23;
            hash = hash * 17 + Arrays.hashCode(this.mSupportedHdrTypes);
            hash = hash * 17 + Float.floatToIntBits(this.mMaxLuminance);
            hash = hash * 17 + Float.floatToIntBits(this.mMaxAverageLuminance);
            hash = hash * 17 + Float.floatToIntBits(this.mMinLuminance);
            return hash;
        }

        private HdrCapabilities(Parcel source) {
            this.readFromParcel(source);
        }

        public void readFromParcel(Parcel source) {
            int types = source.readInt();
            this.mSupportedHdrTypes = new int[types];
            for (int i = 0; i < types; ++i) {
                this.mSupportedHdrTypes[i] = source.readInt();
            }
            this.mMaxLuminance = source.readFloat();
            this.mMaxAverageLuminance = source.readFloat();
            this.mMinLuminance = source.readFloat();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mSupportedHdrTypes.length);
            for (int i = 0; i < this.mSupportedHdrTypes.length; ++i) {
                dest.writeInt(this.mSupportedHdrTypes[i]);
            }
            dest.writeFloat(this.mMaxLuminance);
            dest.writeFloat(this.mMaxAverageLuminance);
            dest.writeFloat(this.mMinLuminance);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public String toString() {
            return "HdrCapabilities{mSupportedHdrTypes=" + Arrays.toString(this.mSupportedHdrTypes) + ", mMaxLuminance=" + this.mMaxLuminance + ", mMaxAverageLuminance=" + this.mMaxAverageLuminance + ", mMinLuminance=" + this.mMinLuminance + '}';
        }

        @NonNull
        public static String hdrTypeToString(int hdrType) {
            switch (hdrType) {
                case 1: {
                    return "HDR_TYPE_DOLBY_VISION";
                }
                case 2: {
                    return "HDR_TYPE_HDR10";
                }
                case 3: {
                    return "HDR_TYPE_HLG";
                }
                case 4: {
                    return "HDR_TYPE_HDR10_PLUS";
                }
            }
            return "HDR_TYPE_INVALID";
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface HdrType {
        }
    }

    private class HdrSdrRatioListenerWrapper
    implements DisplayManager.DisplayListener {
        Consumer<Display> mListener;
        float mLastReportedRatio = 1.0f;

        private HdrSdrRatioListenerWrapper(Consumer<Display> listener) {
            this.mListener = listener;
        }

        @Override
        public void onDisplayAdded(int displayId) {
        }

        @Override
        public void onDisplayRemoved(int displayId) {
        }

        @Override
        public void onDisplayChanged(int displayId) {
            float newRatio;
            if (displayId == Display.this.getDisplayId() && (newRatio = Display.this.getHdrSdrRatio()) != this.mLastReportedRatio) {
                this.mLastReportedRatio = newRatio;
                this.mListener.accept(Display.this);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FrameRateCategory {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ColorMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StateReason {
    }
}

