/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import java.util.Objects;

@RavenwoodKeepWholeClass
public class DisplayAdjustments {
    public static final DisplayAdjustments DEFAULT_DISPLAY_ADJUSTMENTS = new DisplayAdjustments();
    private volatile CompatibilityInfo mCompatInfo = CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO;
    private final Configuration mConfiguration = new Configuration(Configuration.EMPTY);

    @UnsupportedAppUsage
    public DisplayAdjustments() {
    }

    public DisplayAdjustments(@Nullable Configuration configuration) {
        if (configuration != null) {
            this.mConfiguration.setTo(configuration);
        }
    }

    public DisplayAdjustments(@NonNull DisplayAdjustments daj) {
        this.setCompatibilityInfo(daj.mCompatInfo);
        this.mConfiguration.setTo(daj.getConfiguration());
    }

    @UnsupportedAppUsage
    public void setCompatibilityInfo(@Nullable CompatibilityInfo compatInfo) {
        if (this == DEFAULT_DISPLAY_ADJUSTMENTS) {
            throw new IllegalArgumentException("setCompatbilityInfo: Cannot modify DEFAULT_DISPLAY_ADJUSTMENTS");
        }
        this.mCompatInfo = compatInfo != null && (compatInfo.isScalingRequired() || !compatInfo.supportsScreen()) ? compatInfo : CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO;
    }

    public CompatibilityInfo getCompatibilityInfo() {
        return this.mCompatInfo;
    }

    public void setConfiguration(@Nullable Configuration configuration) {
        if (this == DEFAULT_DISPLAY_ADJUSTMENTS) {
            throw new IllegalArgumentException("setConfiguration: Cannot modify DEFAULT_DISPLAY_ADJUSTMENTS");
        }
        this.mConfiguration.setTo(configuration != null ? configuration : Configuration.EMPTY);
    }

    @UnsupportedAppUsage
    @NonNull
    public Configuration getConfiguration() {
        return this.mConfiguration;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + Objects.hashCode(this.mCompatInfo);
        hash = hash * 31 + Objects.hashCode(this.mConfiguration);
        return hash;
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof DisplayAdjustments)) {
            return false;
        }
        DisplayAdjustments daj = (DisplayAdjustments)o;
        return Objects.equals(daj.mCompatInfo, this.mCompatInfo) && Objects.equals(daj.mConfiguration, this.mConfiguration);
    }
}

