/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Looper;
import android.os.MessageQueue;
import android.util.Log;
import android.view.DisplayEventReceiver_Delegate;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.annotations.WeaklyReferencedCallback;
import com.android.internal.lang.System_Delegate;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.FastNative;
import java.lang.ref.WeakReference;
import libcore.util.NativeAllocationRegistry;

@WeaklyReferencedCallback
public abstract class DisplayEventReceiver {
    public static final int VSYNC_SOURCE_APP = 0;
    public static final int VSYNC_SOURCE_SURFACE_FLINGER = 1;
    public static final int EVENT_REGISTRATION_MODE_CHANGED_FLAG = 1;
    public static final int EVENT_REGISTRATION_FRAME_RATE_OVERRIDE_FLAG = 2;
    private static final String TAG = "DisplayEventReceiver";
    @UnsupportedAppUsage
    private long mReceiverPtr;
    private MessageQueue mMessageQueue;
    private final VsyncEventData mVsyncEventData = new VsyncEventData();
    private static final NativeAllocationRegistry sNativeAllocationRegistry = NativeAllocationRegistry.createMalloced(DisplayEventReceiver.class.getClassLoader(), DisplayEventReceiver.nativeGetDisplayEventReceiverFinalizer());
    private Runnable mFreeNativeResources;

    @LayoutlibDelegate
    private static long nativeInit(WeakReference<DisplayEventReceiver> weakReference, WeakReference<VsyncEventData> weakReference2, MessageQueue messageQueue, int n, int n2, long l) {
        return DisplayEventReceiver_Delegate.nativeInit(weakReference, weakReference2, messageQueue, n, n2, l);
    }

    @LayoutlibDelegate
    private static long nativeGetDisplayEventReceiverFinalizer() {
        return DisplayEventReceiver_Delegate.nativeGetDisplayEventReceiverFinalizer();
    }

    @FastNative
    private static void nativeScheduleVsync(long l) {
        OverrideMethod.invokeV("android.view.DisplayEventReceiver#nativeScheduleVsync(J)V", true, null);
    }

    private static VsyncEventData nativeGetLatestVsyncEventData(long l) {
        return (VsyncEventData)OverrideMethod.invokeA("android.view.DisplayEventReceiver#nativeGetLatestVsyncEventData(J)Landroid/view/DisplayEventReceiver$VsyncEventData;", true, null);
    }

    @UnsupportedAppUsage
    public DisplayEventReceiver(Looper looper) {
        this(looper, 0, 0, 0L);
    }

    public DisplayEventReceiver(Looper looper, int vsyncSource, int eventRegistration) {
        this(looper, vsyncSource, eventRegistration, 0L);
    }

    public DisplayEventReceiver(Looper looper, int vsyncSource, int eventRegistration, long layerHandle) {
        if (looper == null) {
            throw new IllegalArgumentException("looper must not be null");
        }
        this.mMessageQueue = looper.getQueue();
        this.mReceiverPtr = DisplayEventReceiver.nativeInit(new WeakReference<DisplayEventReceiver>(this), new WeakReference<VsyncEventData>(this.mVsyncEventData), this.mMessageQueue, vsyncSource, eventRegistration, layerHandle);
        this.mFreeNativeResources = sNativeAllocationRegistry.registerNativeAllocation(this, this.mReceiverPtr);
    }

    public void dispose() {
        if (this.mReceiverPtr != 0L) {
            this.mFreeNativeResources.run();
            this.mReceiverPtr = 0L;
        }
        this.mMessageQueue = null;
    }

    public void onVsync(long timestampNanos, long physicalDisplayId, int frame, VsyncEventData vsyncEventData) {
    }

    @UnsupportedAppUsage
    public void onHotplug(long timestampNanos, long physicalDisplayId, boolean connected) {
    }

    public void onHotplugConnectionError(long timestampNanos, int connectionError) {
    }

    public void onModeChanged(long timestampNanos, long physicalDisplayId, int modeId, long renderPeriod) {
    }

    public void onModeRejected(long physicalDisplayId, int modeId) {
    }

    public void onHdcpLevelsChanged(long physicalDisplayId, int connectedLevel, int maxLevel) {
    }

    public void onFrameRateOverridesChanged(long timestampNanos, long physicalDisplayId, FrameRateOverride[] overrides) {
    }

    @UnsupportedAppUsage
    public void scheduleVsync() {
        if (this.mReceiverPtr == 0L) {
            Log.w(TAG, "Attempted to schedule a vertical sync pulse but the display event receiver has already been disposed.");
        } else {
            DisplayEventReceiver.nativeScheduleVsync(this.mReceiverPtr);
        }
    }

    VsyncEventData getLatestVsyncEventData() {
        return DisplayEventReceiver.nativeGetLatestVsyncEventData(this.mReceiverPtr);
    }

    private void dispatchVsync(long timestampNanos, long physicalDisplayId, int frame) {
        this.onVsync(timestampNanos, physicalDisplayId, frame, this.mVsyncEventData);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private void dispatchHotplug(long timestampNanos, long physicalDisplayId, boolean connected) {
        this.onHotplug(timestampNanos, physicalDisplayId, connected);
    }

    private void dispatchHotplugConnectionError(long timestampNanos, int connectionError) {
        this.onHotplugConnectionError(timestampNanos, connectionError);
    }

    private void dispatchModeChanged(long timestampNanos, long physicalDisplayId, int modeId, long renderPeriod) {
        this.onModeChanged(timestampNanos, physicalDisplayId, modeId, renderPeriod);
    }

    private void dispatchModeRejected(long physicalDisplayId, int modeId) {
        this.onModeRejected(physicalDisplayId, modeId);
    }

    private void dispatchFrameRateOverrides(long timestampNanos, long physicalDisplayId, FrameRateOverride[] overrides) {
        this.onFrameRateOverridesChanged(timestampNanos, physicalDisplayId, overrides);
    }

    private void dispatchHdcpLevelsChanged(long physicalDisplayId, int connectedLevel, int maxLevel) {
        this.onHdcpLevelsChanged(physicalDisplayId, connectedLevel, maxLevel);
    }

    public static class VsyncEventData {
        static final int FRAME_TIMELINES_CAPACITY = 7;
        public long frameInterval = -1L;
        public final FrameTimeline[] frameTimelines;
        public int preferredFrameTimelineIndex = 0;
        public int frameTimelinesLength = 1;
        public int numberQueuedBuffers = 0;

        VsyncEventData() {
            this.frameTimelines = new FrameTimeline[7];
            for (int i = 0; i < this.frameTimelines.length; ++i) {
                this.frameTimelines[i] = new FrameTimeline();
            }
        }

        VsyncEventData(FrameTimeline[] frameTimelines, int preferredFrameTimelineIndex, int frameTimelinesLength, long frameInterval, int numberQueuedBuffers) {
            this.frameTimelines = frameTimelines;
            this.preferredFrameTimelineIndex = preferredFrameTimelineIndex;
            this.frameTimelinesLength = frameTimelinesLength;
            this.frameInterval = frameInterval;
            this.numberQueuedBuffers = numberQueuedBuffers;
        }

        void copyFrom(VsyncEventData other) {
            this.preferredFrameTimelineIndex = other.preferredFrameTimelineIndex;
            this.frameTimelinesLength = other.frameTimelinesLength;
            this.frameInterval = other.frameInterval;
            for (int i = 0; i < this.frameTimelines.length; ++i) {
                this.frameTimelines[i].copyFrom(other.frameTimelines[i]);
            }
            this.numberQueuedBuffers = other.numberQueuedBuffers;
        }

        public FrameTimeline preferredFrameTimeline() {
            return this.frameTimelines[this.preferredFrameTimelineIndex];
        }

        public static class FrameTimeline {
            public long vsyncId = -1L;
            public long expectedPresentationTime;
            public long deadline;

            FrameTimeline() {
                this.deadline = System_Delegate.nanoTime() + 10000000L;
                this.expectedPresentationTime = this.deadline + 10000000L;
            }

            FrameTimeline(long vsyncId, long expectedPresentationTime, long deadline) {
                this.vsyncId = vsyncId;
                this.expectedPresentationTime = expectedPresentationTime;
                this.deadline = deadline;
            }

            void copyFrom(FrameTimeline other) {
                this.vsyncId = other.vsyncId;
                this.expectedPresentationTime = other.expectedPresentationTime;
                this.deadline = other.deadline;
            }
        }
    }

    public static class FrameRateOverride {
        public final int uid;
        public final float frameRateHz;

        @VisibleForTesting
        public FrameRateOverride(int uid, float frameRateHz) {
            this.uid = uid;
            this.frameRateHz = frameRateHz;
        }

        public String toString() {
            return "{uid=" + this.uid + " frameRateHz=" + this.frameRateHz + "}";
        }
    }
}

