/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.os.StrictMode;
import android.os.SystemClock;
import android.view.InputEventConsistencyVerifier;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import com.android.internal.util.FrameworkStatsLog;

public class GestureDetector {
    private static final String TAG = GestureDetector.class.getSimpleName();
    @UnsupportedAppUsage
    private int mTouchSlopSquare;
    private int mDoubleTapTouchSlopSquare;
    private int mDoubleTapSlopSquare;
    private float mAmbiguousGestureMultiplier;
    @UnsupportedAppUsage
    private int mMinimumFlingVelocity;
    private int mMaximumFlingVelocity;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private static final int LONGPRESS_TIMEOUT = ViewConfiguration.getLongPressTimeout();
    private static final int TAP_TIMEOUT = ViewConfiguration.getTapTimeout();
    private static final int DOUBLE_TAP_TIMEOUT = ViewConfiguration.getDoubleTapTimeout();
    private static final int DOUBLE_TAP_MIN_TIME = ViewConfiguration.getDoubleTapMinTime();
    private static final int SHOW_PRESS = 1;
    private static final int LONG_PRESS = 2;
    private static final int TAP = 3;
    private final Handler mHandler;
    @UnsupportedAppUsage
    private final OnGestureListener mListener;
    private OnDoubleTapListener mDoubleTapListener;
    private OnContextClickListener mContextClickListener;
    private boolean mStillDown;
    private boolean mDeferConfirmSingleTap;
    private boolean mInLongPress;
    private boolean mInContextClick;
    @UnsupportedAppUsage
    private boolean mAlwaysInTapRegion;
    private boolean mAlwaysInBiggerTapRegion;
    private boolean mIgnoreNextUpEvent;
    private boolean mHasRecordedClassification;
    private MotionEvent mCurrentDownEvent;
    private MotionEvent mCurrentMotionEvent;
    private MotionEvent mPreviousUpEvent;
    private boolean mIsDoubleTapping;
    private float mLastFocusX;
    private float mLastFocusY;
    private float mDownFocusX;
    private float mDownFocusY;
    private boolean mIsLongpressEnabled;
    private VelocityTracker mVelocityTracker;
    private int mVelocityTrackerStrategy;
    private final InputEventConsistencyVerifier mInputEventConsistencyVerifier = InputEventConsistencyVerifier.isInstrumentationEnabled() ? new InputEventConsistencyVerifier(this, 0) : null;

    @Deprecated
    public GestureDetector(@NonNull OnGestureListener listener, @Nullable Handler handler) {
        this(null, listener, handler);
    }

    @Deprecated
    public GestureDetector(@NonNull OnGestureListener listener) {
        this(null, listener, null);
    }

    public GestureDetector(@Nullable Context context, @NonNull OnGestureListener listener) {
        this(context, listener, null);
    }

    public GestureDetector(@Nullable Context context, @NonNull OnGestureListener listener, @Nullable Handler handler) {
        this(context, listener, handler, -1);
    }

    public GestureDetector(@Nullable Context context, @NonNull OnGestureListener listener, @Nullable Handler handler, int velocityTrackerStrategy) {
        this.mHandler = handler != null ? new GestureHandler(handler) : new GestureHandler();
        this.mListener = listener;
        if (listener instanceof OnDoubleTapListener) {
            this.setOnDoubleTapListener((OnDoubleTapListener)((Object)listener));
        }
        if (listener instanceof OnContextClickListener) {
            this.setContextClickListener((OnContextClickListener)((Object)listener));
        }
        this.mVelocityTrackerStrategy = velocityTrackerStrategy;
        this.init(context);
    }

    public GestureDetector(@Nullable Context context, @NonNull OnGestureListener listener, @Nullable Handler handler, boolean unused) {
        this(context, listener, handler);
    }

    private void init(Context context) {
        int doubleTapSlop;
        int doubleTapTouchSlop;
        int touchSlop;
        if (this.mListener == null) {
            throw new NullPointerException("OnGestureListener must not be null");
        }
        this.mIsLongpressEnabled = true;
        if (context == null) {
            doubleTapTouchSlop = touchSlop = ViewConfiguration.getTouchSlop();
            doubleTapSlop = ViewConfiguration.getDoubleTapSlop();
            this.mMinimumFlingVelocity = ViewConfiguration.getMinimumFlingVelocity();
            this.mMaximumFlingVelocity = ViewConfiguration.getMaximumFlingVelocity();
            this.mAmbiguousGestureMultiplier = ViewConfiguration.getAmbiguousGestureMultiplier();
        } else {
            StrictMode.assertConfigurationContext(context, "GestureDetector#init");
            ViewConfiguration configuration = ViewConfiguration.get(context);
            touchSlop = configuration.getScaledTouchSlop();
            doubleTapTouchSlop = configuration.getScaledDoubleTapTouchSlop();
            doubleTapSlop = configuration.getScaledDoubleTapSlop();
            this.mMinimumFlingVelocity = configuration.getScaledMinimumFlingVelocity();
            this.mMaximumFlingVelocity = configuration.getScaledMaximumFlingVelocity();
            this.mAmbiguousGestureMultiplier = configuration.getScaledAmbiguousGestureMultiplier();
        }
        this.mTouchSlopSquare = touchSlop * touchSlop;
        this.mDoubleTapTouchSlopSquare = doubleTapTouchSlop * doubleTapTouchSlop;
        this.mDoubleTapSlopSquare = doubleTapSlop * doubleTapSlop;
    }

    public void setOnDoubleTapListener(@Nullable OnDoubleTapListener onDoubleTapListener) {
        this.mDoubleTapListener = onDoubleTapListener;
    }

    public void setContextClickListener(@Nullable OnContextClickListener onContextClickListener) {
        this.mContextClickListener = onContextClickListener;
    }

    public void setIsLongpressEnabled(boolean isLongpressEnabled) {
        this.mIsLongpressEnabled = isLongpressEnabled;
    }

    public boolean isLongpressEnabled() {
        return this.mIsLongpressEnabled;
    }

    public boolean onTouchEvent(@NonNull MotionEvent ev) {
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onTouchEvent(ev, 0);
        }
        int action = ev.getAction();
        if (this.mCurrentMotionEvent != null) {
            this.mCurrentMotionEvent.recycle();
        }
        this.mCurrentMotionEvent = MotionEvent.obtain(ev);
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain(this.mVelocityTrackerStrategy);
        }
        this.mVelocityTracker.addMovement(ev);
        boolean pointerUp = (action & 0xFF) == 6;
        int skipIndex = pointerUp ? ev.getActionIndex() : -1;
        boolean isGeneratedGesture = (ev.getFlags() & 8) != 0;
        float sumX = 0.0f;
        float sumY = 0.0f;
        int count = ev.getPointerCount();
        for (int i = 0; i < count; ++i) {
            if (skipIndex == i) continue;
            sumX += ev.getX(i);
            sumY += ev.getY(i);
        }
        int div = pointerUp ? count - 1 : count;
        float focusX = sumX / (float)div;
        float focusY = sumY / (float)div;
        boolean handled = false;
        block0 : switch (action & 0xFF) {
            case 5: {
                this.mDownFocusX = this.mLastFocusX = focusX;
                this.mDownFocusY = this.mLastFocusY = focusY;
                this.cancelTaps();
                break;
            }
            case 6: {
                this.mDownFocusX = this.mLastFocusX = focusX;
                this.mDownFocusY = this.mLastFocusY = focusY;
                this.mVelocityTracker.computeCurrentVelocity(1000, this.mMaximumFlingVelocity);
                int upIndex = ev.getActionIndex();
                int id1 = ev.getPointerId(upIndex);
                float x1 = this.mVelocityTracker.getXVelocity(id1);
                float y1 = this.mVelocityTracker.getYVelocity(id1);
                for (int i = 0; i < count; ++i) {
                    float y;
                    int id2;
                    float x;
                    float dot;
                    if (i == upIndex || !((dot = (x = x1 * this.mVelocityTracker.getXVelocity(id2 = ev.getPointerId(i))) + (y = y1 * this.mVelocityTracker.getYVelocity(id2))) < 0.0f)) continue;
                    this.mVelocityTracker.clear();
                    break block0;
                }
                break;
            }
            case 0: {
                if (this.mDoubleTapListener != null) {
                    boolean hadTapMessage = this.mHandler.hasMessages(3);
                    if (hadTapMessage) {
                        this.mHandler.removeMessages(3);
                    }
                    if (this.mCurrentDownEvent != null && this.mPreviousUpEvent != null && hadTapMessage && this.isConsideredDoubleTap(this.mCurrentDownEvent, this.mPreviousUpEvent, ev)) {
                        this.mIsDoubleTapping = true;
                        this.recordGestureClassification(2);
                        handled |= this.mDoubleTapListener.onDoubleTap(this.mCurrentDownEvent);
                        handled |= this.mDoubleTapListener.onDoubleTapEvent(ev);
                    } else {
                        this.mHandler.sendEmptyMessageDelayed(3, DOUBLE_TAP_TIMEOUT);
                    }
                }
                this.mDownFocusX = this.mLastFocusX = focusX;
                this.mDownFocusY = this.mLastFocusY = focusY;
                if (this.mCurrentDownEvent != null) {
                    this.mCurrentDownEvent.recycle();
                }
                this.mCurrentDownEvent = MotionEvent.obtain(ev);
                this.mAlwaysInTapRegion = true;
                this.mAlwaysInBiggerTapRegion = true;
                this.mStillDown = true;
                this.mInLongPress = false;
                this.mDeferConfirmSingleTap = false;
                this.mHasRecordedClassification = false;
                if (this.mIsLongpressEnabled) {
                    this.mHandler.removeMessages(2);
                    this.mHandler.sendMessageAtTime(this.mHandler.obtainMessage(2, 3, 0), this.mCurrentDownEvent.getDownTime() + (long)ViewConfiguration.getLongPressTimeout());
                }
                this.mHandler.sendEmptyMessageAtTime(1, this.mCurrentDownEvent.getDownTime() + (long)TAP_TIMEOUT);
                handled |= this.mListener.onDown(ev);
                break;
            }
            case 2: {
                boolean deepPress;
                if (this.mInLongPress || this.mInContextClick) break;
                int motionClassification = ev.getClassification();
                boolean hasPendingLongPress = this.mHandler.hasMessages(2);
                float scrollX = this.mLastFocusX - focusX;
                float scrollY = this.mLastFocusY - focusY;
                if (this.mIsDoubleTapping) {
                    this.recordGestureClassification(2);
                    handled |= this.mDoubleTapListener.onDoubleTapEvent(ev);
                } else if (this.mAlwaysInTapRegion) {
                    int doubleTapSlopSquare;
                    boolean shouldInhibitDefaultAction;
                    int deltaX = (int)(focusX - this.mDownFocusX);
                    int deltaY = (int)(focusY - this.mDownFocusY);
                    int distance = deltaX * deltaX + deltaY * deltaY;
                    int slopSquare = isGeneratedGesture ? 0 : this.mTouchSlopSquare;
                    boolean ambiguousGesture = motionClassification == 1;
                    boolean bl = shouldInhibitDefaultAction = hasPendingLongPress && ambiguousGesture;
                    if (shouldInhibitDefaultAction) {
                        if (distance > slopSquare) {
                            this.mHandler.removeMessages(2);
                            long longPressTimeout = ViewConfiguration.getLongPressTimeout();
                            this.mHandler.sendMessageAtTime(this.mHandler.obtainMessage(2, 3, 0), ev.getDownTime() + (long)((float)longPressTimeout * this.mAmbiguousGestureMultiplier));
                        }
                        slopSquare = (int)((float)slopSquare * (this.mAmbiguousGestureMultiplier * this.mAmbiguousGestureMultiplier));
                    }
                    if (distance > slopSquare) {
                        this.recordGestureClassification(5);
                        handled = this.mListener.onScroll(this.mCurrentDownEvent, ev, scrollX, scrollY);
                        this.mLastFocusX = focusX;
                        this.mLastFocusY = focusY;
                        this.mAlwaysInTapRegion = false;
                        this.mHandler.removeMessages(3);
                        this.mHandler.removeMessages(1);
                        this.mHandler.removeMessages(2);
                    }
                    int n = doubleTapSlopSquare = isGeneratedGesture ? 0 : this.mDoubleTapTouchSlopSquare;
                    if (distance > doubleTapSlopSquare) {
                        this.mAlwaysInBiggerTapRegion = false;
                    }
                } else if (Math.abs(scrollX) >= 1.0f || Math.abs(scrollY) >= 1.0f) {
                    this.recordGestureClassification(5);
                    handled = this.mListener.onScroll(this.mCurrentDownEvent, ev, scrollX, scrollY);
                    this.mLastFocusX = focusX;
                    this.mLastFocusY = focusY;
                }
                boolean bl = deepPress = motionClassification == 2;
                if (!deepPress || !hasPendingLongPress) break;
                this.mHandler.removeMessages(2);
                this.mHandler.sendMessage(this.mHandler.obtainMessage(2, 4, 0));
                break;
            }
            case 1: {
                this.mStillDown = false;
                MotionEvent currentUpEvent = MotionEvent.obtain(ev);
                if (this.mIsDoubleTapping) {
                    this.recordGestureClassification(2);
                    handled |= this.mDoubleTapListener.onDoubleTapEvent(ev);
                } else if (this.mInLongPress) {
                    this.mHandler.removeMessages(3);
                    this.mInLongPress = false;
                } else if (this.mAlwaysInTapRegion && !this.mIgnoreNextUpEvent) {
                    this.recordGestureClassification(1);
                    handled = this.mListener.onSingleTapUp(ev);
                    if (this.mDeferConfirmSingleTap && this.mDoubleTapListener != null) {
                        this.mDoubleTapListener.onSingleTapConfirmed(ev);
                    }
                } else if (!this.mIgnoreNextUpEvent) {
                    VelocityTracker velocityTracker = this.mVelocityTracker;
                    int pointerId = ev.getPointerId(0);
                    velocityTracker.computeCurrentVelocity(1000, this.mMaximumFlingVelocity);
                    float velocityY = velocityTracker.getYVelocity(pointerId);
                    float velocityX = velocityTracker.getXVelocity(pointerId);
                    if (Math.abs(velocityY) > (float)this.mMinimumFlingVelocity || Math.abs(velocityX) > (float)this.mMinimumFlingVelocity) {
                        handled = this.mListener.onFling(this.mCurrentDownEvent, ev, velocityX, velocityY);
                    }
                }
                if (this.mPreviousUpEvent != null) {
                    this.mPreviousUpEvent.recycle();
                }
                this.mPreviousUpEvent = currentUpEvent;
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.recycle();
                    this.mVelocityTracker = null;
                }
                this.mIsDoubleTapping = false;
                this.mDeferConfirmSingleTap = false;
                this.mIgnoreNextUpEvent = false;
                this.mHandler.removeMessages(1);
                this.mHandler.removeMessages(2);
                break;
            }
            case 3: {
                this.cancel();
            }
        }
        if (!handled && this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onUnhandledEvent(ev, 0);
        }
        return handled;
    }

    public boolean onGenericMotionEvent(@NonNull MotionEvent ev) {
        if (this.mInputEventConsistencyVerifier != null) {
            this.mInputEventConsistencyVerifier.onGenericMotionEvent(ev, 0);
        }
        int actionButton = ev.getActionButton();
        switch (ev.getActionMasked()) {
            case 11: {
                if (this.mContextClickListener == null || this.mInContextClick || this.mInLongPress || actionButton != 32 && actionButton != 2 || !this.mContextClickListener.onContextClick(ev)) break;
                this.mInContextClick = true;
                this.mHandler.removeMessages(2);
                this.mHandler.removeMessages(3);
                return true;
            }
            case 12: {
                if (!this.mInContextClick || actionButton != 32 && actionButton != 2) break;
                this.mInContextClick = false;
                this.mIgnoreNextUpEvent = true;
            }
        }
        return false;
    }

    private void cancel() {
        this.mHandler.removeMessages(1);
        this.mHandler.removeMessages(2);
        this.mHandler.removeMessages(3);
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
        this.mIsDoubleTapping = false;
        this.mStillDown = false;
        this.mAlwaysInTapRegion = false;
        this.mAlwaysInBiggerTapRegion = false;
        this.mDeferConfirmSingleTap = false;
        this.mInLongPress = false;
        this.mInContextClick = false;
        this.mIgnoreNextUpEvent = false;
    }

    private void cancelTaps() {
        this.mHandler.removeMessages(1);
        this.mHandler.removeMessages(2);
        this.mHandler.removeMessages(3);
        this.mIsDoubleTapping = false;
        this.mAlwaysInTapRegion = false;
        this.mAlwaysInBiggerTapRegion = false;
        this.mDeferConfirmSingleTap = false;
        this.mInLongPress = false;
        this.mInContextClick = false;
        this.mIgnoreNextUpEvent = false;
    }

    private boolean isConsideredDoubleTap(@NonNull MotionEvent firstDown, @NonNull MotionEvent firstUp, @NonNull MotionEvent secondDown) {
        if (!this.mAlwaysInBiggerTapRegion) {
            return false;
        }
        long deltaTime = secondDown.getEventTime() - firstUp.getEventTime();
        if (deltaTime > (long)DOUBLE_TAP_TIMEOUT || deltaTime < (long)DOUBLE_TAP_MIN_TIME) {
            return false;
        }
        int deltaX = (int)firstDown.getX() - (int)secondDown.getX();
        int deltaY = (int)firstDown.getY() - (int)secondDown.getY();
        boolean isGeneratedGesture = (firstDown.getFlags() & 8) != 0;
        int slopSquare = isGeneratedGesture ? 0 : this.mDoubleTapSlopSquare;
        return deltaX * deltaX + deltaY * deltaY < slopSquare;
    }

    private void dispatchLongPress() {
        this.mHandler.removeMessages(3);
        this.mDeferConfirmSingleTap = false;
        this.mInLongPress = true;
        this.mListener.onLongPress(this.mCurrentDownEvent);
    }

    private void recordGestureClassification(int classification) {
        if (this.mHasRecordedClassification || classification == 0) {
            return;
        }
        if (this.mCurrentDownEvent == null || this.mCurrentMotionEvent == null) {
            this.mHasRecordedClassification = true;
            return;
        }
        FrameworkStatsLog.write(177, this.getClass().getName(), classification, (int)(SystemClock.uptimeMillis() - this.mCurrentMotionEvent.getDownTime()), (float)Math.hypot(this.mCurrentMotionEvent.getRawX() - this.mCurrentDownEvent.getRawX(), this.mCurrentMotionEvent.getRawY() - this.mCurrentDownEvent.getRawY()));
        this.mHasRecordedClassification = true;
    }

    public static interface OnGestureListener {
        public boolean onDown(@NonNull MotionEvent var1);

        public void onShowPress(@NonNull MotionEvent var1);

        public boolean onSingleTapUp(@NonNull MotionEvent var1);

        public boolean onScroll(@Nullable MotionEvent var1, @NonNull MotionEvent var2, float var3, float var4);

        public void onLongPress(@NonNull MotionEvent var1);

        public boolean onFling(@Nullable MotionEvent var1, @NonNull MotionEvent var2, float var3, float var4);
    }

    private class GestureHandler
    extends Handler {
        GestureHandler() {
        }

        GestureHandler(Handler handler) {
            super(handler.getLooper());
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    GestureDetector.this.mListener.onShowPress(GestureDetector.this.mCurrentDownEvent);
                    break;
                }
                case 2: {
                    GestureDetector.this.recordGestureClassification(msg.arg1);
                    GestureDetector.this.dispatchLongPress();
                    break;
                }
                case 3: {
                    if (GestureDetector.this.mDoubleTapListener == null) break;
                    if (!GestureDetector.this.mStillDown) {
                        GestureDetector.this.recordGestureClassification(1);
                        GestureDetector.this.mDoubleTapListener.onSingleTapConfirmed(GestureDetector.this.mCurrentDownEvent);
                        break;
                    }
                    GestureDetector.this.mDeferConfirmSingleTap = true;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown message " + msg);
                }
            }
        }
    }

    public static interface OnDoubleTapListener {
        public boolean onSingleTapConfirmed(@NonNull MotionEvent var1);

        public boolean onDoubleTap(@NonNull MotionEvent var1);

        public boolean onDoubleTapEvent(@NonNull MotionEvent var1);
    }

    public static interface OnContextClickListener {
        public boolean onContextClick(@NonNull MotionEvent var1);
    }

    public static class SimpleOnGestureListener
    implements OnGestureListener,
    OnDoubleTapListener,
    OnContextClickListener {
        @Override
        public boolean onSingleTapUp(@NonNull MotionEvent e) {
            return false;
        }

        @Override
        public void onLongPress(@NonNull MotionEvent e) {
        }

        @Override
        public boolean onScroll(@Nullable MotionEvent e1, @NonNull MotionEvent e2, float distanceX, float distanceY) {
            return false;
        }

        @Override
        public boolean onFling(@Nullable MotionEvent e1, @NonNull MotionEvent e2, float velocityX, float velocityY) {
            return false;
        }

        @Override
        public void onShowPress(@NonNull MotionEvent e) {
        }

        @Override
        public boolean onDown(@NonNull MotionEvent e) {
            return false;
        }

        @Override
        public boolean onDoubleTap(@NonNull MotionEvent e) {
            return false;
        }

        @Override
        public boolean onDoubleTapEvent(@NonNull MotionEvent e) {
            return false;
        }

        @Override
        public boolean onSingleTapConfirmed(@NonNull MotionEvent e) {
            return false;
        }

        @Override
        public boolean onContextClick(@NonNull MotionEvent e) {
            return false;
        }
    }
}

