/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.view.ScrollFeedbackProvider;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.flags.Flags;
import com.android.internal.annotations.VisibleForTesting;

public class HapticScrollFeedbackProvider
implements ScrollFeedbackProvider {
    private static final String TAG = "HapticScrollFeedbackProvider";
    private static final int TICK_INTERVAL_NO_TICK = 0;
    private static final boolean INITIAL_END_OF_LIST_HAPTICS_ENABLED = false;
    private final View mView;
    private final ViewConfiguration mViewConfig;
    private final boolean mIsFromView;
    private int mDeviceId = -1;
    private int mAxis = -1;
    private int mSource = -1;
    private int mTickIntervalPixels = 0;
    private int mTotalScrollPixels = 0;
    private boolean mCanPlayLimitFeedback = false;
    private boolean mHapticScrollFeedbackEnabled = false;

    public HapticScrollFeedbackProvider(@NonNull View view) {
        this(view, ViewConfiguration.get(view.getContext()), false);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public HapticScrollFeedbackProvider(View view, ViewConfiguration viewConfig, boolean isFromView) {
        this.mView = view;
        this.mViewConfig = viewConfig;
        this.mIsFromView = isFromView;
        if (Flags.dynamicViewRotaryHapticsConfiguration() && !isFromView) {
            view.disableRotaryScrollFeedback();
        }
    }

    @Override
    public void onScrollProgress(int inputDeviceId, int source, int axis, int deltaInPixels) {
        this.maybeUpdateCurrentConfig(inputDeviceId, source, axis);
        if (!this.mHapticScrollFeedbackEnabled) {
            return;
        }
        if (deltaInPixels != 0) {
            this.mCanPlayLimitFeedback = true;
        }
        if (this.mTickIntervalPixels == 0) {
            return;
        }
        this.mTotalScrollPixels += deltaInPixels;
        if (Math.abs(this.mTotalScrollPixels) >= this.mTickIntervalPixels) {
            this.mTotalScrollPixels %= this.mTickIntervalPixels;
            if (android.os.vibrator.Flags.hapticFeedbackInputSourceCustomizationEnabled()) {
                this.mView.performHapticFeedbackForInputDevice(18, inputDeviceId, source, 0);
            } else {
                this.mView.performHapticFeedback(18);
            }
        }
    }

    @Override
    public void onScrollLimit(int inputDeviceId, int source, int axis, boolean isStart) {
        this.maybeUpdateCurrentConfig(inputDeviceId, source, axis);
        if (!this.mHapticScrollFeedbackEnabled) {
            return;
        }
        if (!this.mCanPlayLimitFeedback) {
            return;
        }
        if (android.os.vibrator.Flags.hapticFeedbackInputSourceCustomizationEnabled()) {
            this.mView.performHapticFeedbackForInputDevice(20, inputDeviceId, source, 0);
        } else {
            this.mView.performHapticFeedback(20);
        }
        this.mCanPlayLimitFeedback = false;
    }

    @Override
    public void onSnapToItem(int inputDeviceId, int source, int axis) {
        this.maybeUpdateCurrentConfig(inputDeviceId, source, axis);
        if (!this.mHapticScrollFeedbackEnabled) {
            return;
        }
        if (android.os.vibrator.Flags.hapticFeedbackInputSourceCustomizationEnabled()) {
            this.mView.performHapticFeedbackForInputDevice(19, inputDeviceId, source, 0);
        } else {
            this.mView.performHapticFeedback(19);
        }
        this.mCanPlayLimitFeedback = true;
    }

    private void maybeUpdateCurrentConfig(int deviceId, int source, int axis) {
        if (this.mAxis != axis || this.mSource != source || this.mDeviceId != deviceId) {
            this.mSource = source;
            this.mAxis = axis;
            this.mDeviceId = deviceId;
            if (!Flags.dynamicViewRotaryHapticsConfiguration() && !this.mIsFromView && source == 0x400000 && this.mViewConfig.isViewBasedRotaryEncoderHapticScrollFeedbackEnabled()) {
                this.mHapticScrollFeedbackEnabled = false;
                return;
            }
            this.mHapticScrollFeedbackEnabled = this.mViewConfig.isHapticScrollFeedbackEnabled(deviceId, axis, source);
            this.mCanPlayLimitFeedback = false;
            this.mTotalScrollPixels = 0;
            this.updateTickIntervals(deviceId, source, axis);
        }
    }

    private void updateTickIntervals(int deviceId, int source, int axis) {
        this.mTickIntervalPixels = this.mHapticScrollFeedbackEnabled ? this.mViewConfig.getHapticScrollFeedbackTickInterval(deviceId, axis, source) : 0;
    }
}

