/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.MergedConfiguration;
import android.view.DragEvent;
import android.view.IScrollCaptureResponseListener;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.inputmethod.ImeTracker;
import android.window.ActivityWindowInfo;
import android.window.ClientWindowFrames;
import com.android.internal.os.IResultReceiver;

public interface IWindow
extends IInterface {
    public void executeCommand(String var1, String var2, ParcelFileDescriptor var3) throws RemoteException;

    public void resized(ClientWindowFrames var1, boolean var2, MergedConfiguration var3, InsetsState var4, boolean var5, boolean var6, int var7, int var8, boolean var9, ActivityWindowInfo var10) throws RemoteException;

    public void insetsControlChanged(InsetsState var1, InsetsSourceControl.Array var2) throws RemoteException;

    public void showInsets(int var1, boolean var2, ImeTracker.Token var3) throws RemoteException;

    public void hideInsets(int var1, boolean var2, ImeTracker.Token var3) throws RemoteException;

    public void moved(int var1, int var2) throws RemoteException;

    public void dispatchAppVisibility(boolean var1) throws RemoteException;

    public void dispatchGetNewSurface() throws RemoteException;

    public void closeSystemDialogs(String var1) throws RemoteException;

    public void dispatchWallpaperOffsets(float var1, float var2, float var3, float var4, float var5, boolean var6) throws RemoteException;

    public void dispatchWallpaperCommand(String var1, int var2, int var3, int var4, Bundle var5, boolean var6) throws RemoteException;

    public void dispatchDragEvent(DragEvent var1) throws RemoteException;

    public void dispatchWindowShown() throws RemoteException;

    public void requestAppKeyboardShortcuts(IResultReceiver var1, int var2) throws RemoteException;

    public void requestScrollCapture(IScrollCaptureResponseListener var1) throws RemoteException;

    public void dumpWindow(ParcelFileDescriptor var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWindow {
        public static final String DESCRIPTOR = "android.view.IWindow";
        static final int TRANSACTION_executeCommand = 1;
        static final int TRANSACTION_resized = 2;
        static final int TRANSACTION_insetsControlChanged = 3;
        static final int TRANSACTION_showInsets = 4;
        static final int TRANSACTION_hideInsets = 5;
        static final int TRANSACTION_moved = 6;
        static final int TRANSACTION_dispatchAppVisibility = 7;
        static final int TRANSACTION_dispatchGetNewSurface = 8;
        static final int TRANSACTION_closeSystemDialogs = 9;
        static final int TRANSACTION_dispatchWallpaperOffsets = 10;
        static final int TRANSACTION_dispatchWallpaperCommand = 11;
        static final int TRANSACTION_dispatchDragEvent = 12;
        static final int TRANSACTION_dispatchWindowShown = 13;
        static final int TRANSACTION_requestAppKeyboardShortcuts = 14;
        static final int TRANSACTION_requestScrollCapture = 15;
        static final int TRANSACTION_dumpWindow = 16;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWindow asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWindow) {
                return (IWindow)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "executeCommand";
                }
                case 2: {
                    return "resized";
                }
                case 3: {
                    return "insetsControlChanged";
                }
                case 4: {
                    return "showInsets";
                }
                case 5: {
                    return "hideInsets";
                }
                case 6: {
                    return "moved";
                }
                case 7: {
                    return "dispatchAppVisibility";
                }
                case 8: {
                    return "dispatchGetNewSurface";
                }
                case 9: {
                    return "closeSystemDialogs";
                }
                case 10: {
                    return "dispatchWallpaperOffsets";
                }
                case 11: {
                    return "dispatchWallpaperCommand";
                }
                case 12: {
                    return "dispatchDragEvent";
                }
                case 13: {
                    return "dispatchWindowShown";
                }
                case 14: {
                    return "requestAppKeyboardShortcuts";
                }
                case 15: {
                    return "requestScrollCapture";
                }
                case 16: {
                    return "dumpWindow";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    ParcelFileDescriptor _arg2 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    data.enforceNoDataAvail();
                    this.executeCommand(_arg0, _arg1, _arg2);
                    break;
                }
                case 2: {
                    ClientWindowFrames _arg0 = data.readTypedObject(ClientWindowFrames.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    MergedConfiguration _arg2 = data.readTypedObject(MergedConfiguration.CREATOR);
                    InsetsState _arg3 = data.readTypedObject(InsetsState.CREATOR);
                    boolean _arg4 = data.readBoolean();
                    boolean _arg5 = data.readBoolean();
                    int _arg6 = data.readInt();
                    int _arg7 = data.readInt();
                    boolean _arg8 = data.readBoolean();
                    ActivityWindowInfo _arg9 = data.readTypedObject(ActivityWindowInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.resized(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9);
                    break;
                }
                case 3: {
                    InsetsState _arg0 = data.readTypedObject(InsetsState.CREATOR);
                    InsetsSourceControl.Array _arg1 = data.readTypedObject(InsetsSourceControl.Array.CREATOR);
                    data.enforceNoDataAvail();
                    this.insetsControlChanged(_arg0, _arg1);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    ImeTracker.Token _arg2 = data.readTypedObject(ImeTracker.Token.CREATOR);
                    data.enforceNoDataAvail();
                    this.showInsets(_arg0, _arg1, _arg2);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    ImeTracker.Token _arg2 = data.readTypedObject(ImeTracker.Token.CREATOR);
                    data.enforceNoDataAvail();
                    this.hideInsets(_arg0, _arg1, _arg2);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.moved(_arg0, _arg1);
                    break;
                }
                case 7: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.dispatchAppVisibility(_arg0);
                    break;
                }
                case 8: {
                    this.dispatchGetNewSurface();
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.closeSystemDialogs(_arg0);
                    break;
                }
                case 10: {
                    float _arg0 = data.readFloat();
                    float _arg1 = data.readFloat();
                    float _arg2 = data.readFloat();
                    float _arg3 = data.readFloat();
                    float _arg4 = data.readFloat();
                    boolean _arg5 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.dispatchWallpaperOffsets(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    Bundle _arg4 = data.readTypedObject(Bundle.CREATOR);
                    boolean _arg5 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.dispatchWallpaperCommand(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                case 12: {
                    DragEvent _arg0 = data.readTypedObject(DragEvent.CREATOR);
                    data.enforceNoDataAvail();
                    this.dispatchDragEvent(_arg0);
                    break;
                }
                case 13: {
                    this.dispatchWindowShown();
                    break;
                }
                case 14: {
                    IResultReceiver _arg0 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.requestAppKeyboardShortcuts(_arg0, _arg1);
                    break;
                }
                case 15: {
                    IScrollCaptureResponseListener _arg0 = IScrollCaptureResponseListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.requestScrollCapture(_arg0);
                    break;
                }
                case 16: {
                    ParcelFileDescriptor _arg0 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    data.enforceNoDataAvail();
                    this.dumpWindow(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 15;
        }

        private static class Proxy
        implements IWindow {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void executeCommand(String command, String parameters, ParcelFileDescriptor descriptor) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(command);
                    _data.writeString(parameters);
                    _data.writeTypedObject(descriptor, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resized(ClientWindowFrames frames, boolean reportDraw, MergedConfiguration newMergedConfiguration, InsetsState insetsState, boolean forceLayout, boolean alwaysConsumeSystemBars, int displayId, int syncSeqId, boolean dragResizing, ActivityWindowInfo activityWindowInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(frames, 0);
                    _data.writeBoolean(reportDraw);
                    _data.writeTypedObject(newMergedConfiguration, 0);
                    _data.writeTypedObject(insetsState, 0);
                    _data.writeBoolean(forceLayout);
                    _data.writeBoolean(alwaysConsumeSystemBars);
                    _data.writeInt(displayId);
                    _data.writeInt(syncSeqId);
                    _data.writeBoolean(dragResizing);
                    _data.writeTypedObject(activityWindowInfo, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void insetsControlChanged(InsetsState insetsState, InsetsSourceControl.Array activeControls) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(insetsState, 0);
                    _data.writeTypedObject(activeControls, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showInsets(int types, boolean fromIme, ImeTracker.Token statsToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(types);
                    _data.writeBoolean(fromIme);
                    _data.writeTypedObject(statsToken, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideInsets(int types, boolean fromIme, ImeTracker.Token statsToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(types);
                    _data.writeBoolean(fromIme);
                    _data.writeTypedObject(statsToken, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void moved(int newX, int newY) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(newX);
                    _data.writeInt(newY);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchAppVisibility(boolean visible) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(visible);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void dispatchGetNewSurface() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void closeSystemDialogs(String reason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(reason);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchWallpaperOffsets(float x, float y, float xStep, float yStep, float zoom, boolean sync) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(x);
                    _data.writeFloat(y);
                    _data.writeFloat(xStep);
                    _data.writeFloat(yStep);
                    _data.writeFloat(zoom);
                    _data.writeBoolean(sync);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchWallpaperCommand(String action, int x, int y, int z, Bundle extras, boolean sync) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(action);
                    _data.writeInt(x);
                    _data.writeInt(y);
                    _data.writeInt(z);
                    _data.writeTypedObject(extras, 0);
                    _data.writeBoolean(sync);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchDragEvent(DragEvent event) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(event, 0);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void dispatchWindowShown() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestAppKeyboardShortcuts(IResultReceiver receiver, int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(receiver);
                    _data.writeInt(deviceId);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestScrollCapture(IScrollCaptureResponseListener callbacks) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callbacks);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dumpWindow(ParcelFileDescriptor pfd) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(pfd, 0);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWindow {
        @Override
        public void executeCommand(String command, String parameters, ParcelFileDescriptor descriptor) throws RemoteException {
        }

        @Override
        public void resized(ClientWindowFrames frames, boolean reportDraw, MergedConfiguration newMergedConfiguration, InsetsState insetsState, boolean forceLayout, boolean alwaysConsumeSystemBars, int displayId, int syncSeqId, boolean dragResizing, ActivityWindowInfo activityWindowInfo) throws RemoteException {
        }

        @Override
        public void insetsControlChanged(InsetsState insetsState, InsetsSourceControl.Array activeControls) throws RemoteException {
        }

        @Override
        public void showInsets(int types, boolean fromIme, ImeTracker.Token statsToken) throws RemoteException {
        }

        @Override
        public void hideInsets(int types, boolean fromIme, ImeTracker.Token statsToken) throws RemoteException {
        }

        @Override
        public void moved(int newX, int newY) throws RemoteException {
        }

        @Override
        public void dispatchAppVisibility(boolean visible) throws RemoteException {
        }

        @Override
        public void dispatchGetNewSurface() throws RemoteException {
        }

        @Override
        public void closeSystemDialogs(String reason) throws RemoteException {
        }

        @Override
        public void dispatchWallpaperOffsets(float x, float y, float xStep, float yStep, float zoom, boolean sync) throws RemoteException {
        }

        @Override
        public void dispatchWallpaperCommand(String action, int x, int y, int z, Bundle extras, boolean sync) throws RemoteException {
        }

        @Override
        public void dispatchDragEvent(DragEvent event) throws RemoteException {
        }

        @Override
        public void dispatchWindowShown() throws RemoteException {
        }

        @Override
        public void requestAppKeyboardShortcuts(IResultReceiver receiver, int deviceId) throws RemoteException {
        }

        @Override
        public void requestScrollCapture(IScrollCaptureResponseListener callbacks) throws RemoteException {
        }

        @Override
        public void dumpWindow(ParcelFileDescriptor pfd) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

